/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.util;

import com.ibm.xml.xci.adapters.xlxp.scanner.XCIScanner;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.util.Stack;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ScannerPool {
    private static final int DEFAULT_STACK_LIMIT = 1000;
    private static final int SCANNER_STACK_UPPER_LIMIT = 1000;
    private static final int SCANNER_STACK_LOWER_LIMIT = 1000;
    private int SPOTS_RESERVED_V;
    private int SPOTS_RESERVED_NV;
    private final int SCANNER_STACK_INCREMENT;
    private final int SCANNER_STACK_THRESHOLD;
    private final Stack<XCIScanner> SCANNERS_V = new Stack();
    private final Stack<XCIScanner> SCANNERS_NV = new Stack();
    private int scanners_v_request = 0;
    private int scanners_nv_request = 0;
    private int scanner_v_cap;
    private int scanner_nv_cap;

    public ScannerPool(int n2, int n3) {
        this.SCANNER_STACK_INCREMENT = n2;
        this.SCANNER_STACK_THRESHOLD = n3;
        this.scanner_v_cap = 1000;
        this.scanner_nv_cap = 1000;
        this.SPOTS_RESERVED_V = 0;
        this.SPOTS_RESERVED_NV = 0;
    }

    public ScannerPool() {
        this(100, 40);
    }

    public boolean allReserved(boolean bl) {
        if (bl) {
            return this.SPOTS_RESERVED_V >= this.scanner_v_cap;
        }
        return this.SPOTS_RESERVED_NV >= this.scanner_nv_cap;
    }

    public void reserveSpot(boolean bl) {
        if (bl) {
            ++this.SPOTS_RESERVED_V;
        } else {
            ++this.SPOTS_RESERVED_NV;
        }
    }

    public final XCIScanner getScanner(boolean bl) {
        if (bl) {
            if (!this.SCANNERS_V.empty()) {
                return this.SCANNERS_V.pop();
            }
        } else if (!this.SCANNERS_NV.empty()) {
            return this.SCANNERS_NV.pop();
        }
        return null;
    }

    public void returnScanner(XCIScanner xCIScanner) {
        if (xCIScanner.validating()) {
            if (this.SCANNERS_V.size() + 1 <= this.scanner_v_cap) {
                this.SCANNERS_V.push(xCIScanner);
            }
        } else if (this.SCANNERS_NV.size() + 1 <= this.scanner_nv_cap) {
            this.SCANNERS_NV.push(xCIScanner);
        }
    }

    private void decreaseVolume(boolean bl) {
        int n2;
        if (bl) {
            this.scanners_v_request = this.scanners_v_request < 0 ? --this.scanners_v_request : -1;
            n2 = this.scanners_v_request;
        } else {
            this.scanners_nv_request = this.scanners_nv_request < 0 ? --this.scanners_nv_request : -1;
            n2 = this.scanners_nv_request;
        }
        if (n2 <= -1 * this.SCANNER_STACK_THRESHOLD) {
            this.shrink(bl);
        }
    }

    private void increaseVolume(boolean bl) {
        int n2;
        if (bl) {
            this.scanners_v_request = this.scanners_v_request > 0 ? ++this.scanners_v_request : 1;
            n2 = this.scanners_v_request;
        } else {
            this.scanners_nv_request = this.scanners_nv_request > 0 ? ++this.scanners_nv_request : 1;
            n2 = this.scanners_nv_request;
        }
        if (n2 >= this.SCANNER_STACK_THRESHOLD) {
            this.grow(bl);
        }
    }

    private void grow(boolean bl) {
        if (bl) {
            if (this.scanner_v_cap + this.SCANNER_STACK_INCREMENT <= 1000) {
                this.scanner_v_cap += this.SCANNER_STACK_INCREMENT;
                this.scanners_v_request = 0;
            }
        } else if (this.scanner_nv_cap + this.SCANNER_STACK_INCREMENT <= 1000) {
            this.scanner_nv_cap += this.SCANNER_STACK_INCREMENT;
            this.scanners_nv_request = 0;
        }
    }

    private void shrink(boolean bl) {
        int n2 = 0;
        if (bl) {
            if (this.scanner_v_cap - this.SCANNER_STACK_INCREMENT >= 1000) {
                this.scanner_v_cap -= this.SCANNER_STACK_INCREMENT;
                n2 = this.SCANNERS_V.size() - this.scanner_v_cap;
                this.scanners_v_request = 0;
            }
        } else if (this.scanner_nv_cap - this.SCANNER_STACK_INCREMENT >= 1000) {
            this.scanner_nv_cap -= this.SCANNER_STACK_INCREMENT;
            n2 = this.SCANNERS_NV.size() - this.scanner_nv_cap;
            this.scanners_nv_request = 0;
        }
        this.releaseScanners(bl, n2);
    }

    private void releaseScanners(boolean bl, int n2) {
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                this.SCANNERS_V.pop();
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                this.SCANNERS_NV.pop();
            }
        }
    }

    public String toString() {
        String string2 = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[+++ Scanner Pool +++]");
        stringBuilder.append(string2);
        stringBuilder.append("Scanner V Cap: " + this.scanner_v_cap);
        stringBuilder.append(string2);
        stringBuilder.append("Scanner NV Cap: " + this.scanner_nv_cap);
        stringBuilder.append(string2);
        stringBuilder.append("Scanner Stack Increment: " + this.SCANNER_STACK_INCREMENT);
        stringBuilder.append(string2);
        stringBuilder.append("Scanner stack Upper Limit: 1000");
        stringBuilder.append(string2);
        stringBuilder.append("Scanner stack Lower Limit: 1000");
        stringBuilder.append(string2);
        stringBuilder.append("Scanner stack Threshold: " + this.SCANNER_STACK_THRESHOLD);
        stringBuilder.append(string2);
        stringBuilder.append("Scanner V Size : " + this.SCANNERS_V.size());
        stringBuilder.append(string2);
        stringBuilder.append("Scanner NV Size : " + this.SCANNERS_NV.size());
        return stringBuilder.toString();
    }
}

