/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.util;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class MutationMap {
    private static final Logger logger = LoggerUtil.getLogger(MutationMap.class);
    private final int MAP_INITIAL_CAPACITY = 100;
    ArrayList<MutationMapItem> listMutations = new ArrayList(100);

    public MutationMap() {
        this.listMutations.clear();
    }

    public boolean pushItem(MutationMapItem mutationMapItem) {
        boolean bl = LoggerUtil.isAnyTracingEnabled();
        if (bl && logger.isLoggable(Level.FINER)) {
            DOMCachedNode dOMCachedNode = (DOMCachedNode)mutationMapItem.getContent();
            logger.logp(Level.FINER, logger.getName(), "pushItem", "pushing a new item into the mutation map:" + dOMCachedNode);
        }
        if (this.listMutations.size() == 0) {
            this.listMutations.add(mutationMapItem);
            return true;
        }
        int n2 = 0;
        int n3 = this.listMutations.size() - 1;
        int n4 = -1;
        DOMCachedNode dOMCachedNode = (DOMCachedNode)mutationMapItem.getContent();
        MutationMapItem mutationMapItem2 = this.listMutations.get(n3);
        DOMCachedNode dOMCachedNode2 = (DOMCachedNode)mutationMapItem2.getContent();
        if (dOMCachedNode2 == dOMCachedNode) {
            return true;
        }
        if (dOMCachedNode2.itemIsBeforeNode(dOMCachedNode)) {
            this.listMutations.add(n3 + 1, mutationMapItem);
            return true;
        }
        dOMCachedNode2 = null;
        mutationMapItem2 = null;
        n4 = -1;
        do {
            int n5;
            if ((n5 = (n2 + n3) / 2) == n4) {
                ++n5;
                ++n2;
            }
            if ((dOMCachedNode2 = (DOMCachedNode)(mutationMapItem2 = this.listMutations.get(n5)).getContent()) == dOMCachedNode) {
                return true;
            }
            if (dOMCachedNode2.itemIsBeforeNode(dOMCachedNode)) {
                n4 = n5;
                n2 = n5;
                continue;
            }
            n3 = n5;
        } while (n2 < n3);
        if (bl && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "pushItem", "pushing the new item into index" + (n4 + 1));
        }
        this.listMutations.add(n4 + 1, mutationMapItem);
        return true;
    }

    public int size() {
        return this.listMutations.size();
    }

    public Iterator<MutationMapItem> getMutationList() {
        return this.listMutations.iterator();
    }

    public void release() {
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static class MutationMapItem {
        public static int NODE_KIND = 0;
        public static int OFFSET_KIND = 1;
        public Object content;
        public int kind;

        public MutationMapItem(int n2, Object object2) {
            this.kind = n2;
            this.content = object2;
        }

        public int getKind() {
            return this.kind;
        }

        public Object getContent() {
            return this.content;
        }
    }
}

