/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.util;

import com.ibm.xml.xci.adapters.xlxp.util.UniqueIntegerHashCounter;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferReferrer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class BufferedResourceManager {
    private static BufferedResourceManager fSingletonManager;
    private UniqueIntegerHashCounter hashMap = new UniqueIntegerHashCounter();
    private DataBufferReferrer fBufferReferrer;
    private DataBufferFactory fBufferReferrerFactory;

    public static BufferedResourceManager getBufferedResourceManager(DataBufferFactory dataBufferFactory) {
        if (fSingletonManager == null) {
            fSingletonManager = new BufferedResourceManager(dataBufferFactory);
        }
        return fSingletonManager;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void addBufferReferrals(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.hashMap.incrementKey(nArray[i]);
        }
    }

    public void removeBufferReferrals(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.hashMap.decrementKey(nArray[i]);
        }
    }

    private BufferedResourceManager(DataBufferFactory dataBufferFactory) {
        this.fBufferReferrerFactory = dataBufferFactory;
        this.fBufferReferrer = new DataBufferReferrer(){

            public boolean hasReferenceTo(DataBuffer dataBuffer) {
                return BufferedResourceManager.this.hashMap.getValue(dataBuffer.id) > 0;
            }

            public void removeReferencesAndUnregister() {
                BufferedResourceManager.this.unregisterReferrer();
            }
        };
        this.fBufferReferrerFactory.addReferrer(this.fBufferReferrer);
        this.fBufferReferrer.active = true;
    }

    private void unregisterReferrer() {
        if (this.fBufferReferrer == null) {
            return;
        }
        this.fBufferReferrer.active = false;
        if (this.fBufferReferrerFactory != null) {
            this.fBufferReferrerFactory.removeReferrer(this.fBufferReferrer);
            this.fBufferReferrerFactory = null;
        }
        this.fBufferReferrer = null;
    }
}

