/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.scanner;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.adapters.xlxp.XLXPCursorFactory;
import com.ibm.xml.xci.adapters.xlxp.XLXPDocumentInfo;
import com.ibm.xml.xci.adapters.xlxp.scanner.DelegatingSubtreeScanner;
import com.ibm.xml.xci.adapters.xlxp.util.XLXPSharedResources;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.xlxp.NamespaceContextAdapter;
import com.ibm.xml.xci.xlxp.Scanner;
import com.ibm.xml.xlxp.internal.s1.api.sax.impl.SAX2ParsedEntityFactory;
import com.ibm.xml.xlxp.internal.s1.api.util.SimplePositionHelper;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.XDecimal;
import com.ibm.xml.xlxp.internal.s1.grammar.Attribute;
import com.ibm.xml.xlxp.internal.s1.grammar.Element;
import com.ibm.xml.xlxp.internal.s1.grammar.ElementType;
import com.ibm.xml.xlxp.internal.s1.grammar.Grammar;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.DTDScanner;
import com.ibm.xml.xlxp.internal.s1.scan.DTDSupport;
import com.ibm.xml.xlxp.internal.s1.scan.DocumentScanner;
import com.ibm.xml.xlxp.internal.s1.scan.msg.MessageProvider;
import com.ibm.xml.xlxp.internal.s1.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferReferrer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DelegatingDataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DocumentPosition;
import com.ibm.xml.xlxp.internal.s1.scan.util.EntityDeclPool;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntityFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.PositionHelper;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.SymbolTable;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSModel;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.Location;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XCIScanner
extends VMContext
implements Scanner {
    private static final Logger logger = LoggerUtil.getLogger(XCIScanner.class);
    private XCIDTDScanner fDTDScanner;
    boolean fStandalone;
    private SAX2ParsedEntityFactory fEntityFactory;
    private XLXPCursorFactory fCursorFactory;
    protected final NamespaceContextAdapter nscontext;
    protected final XLXPDocumentInfo documentInfo;
    public XCIScanner resourceOwner;
    public XLXPSharedResources sharedResources;
    public boolean wasReleased;
    public boolean isZombieParent;
    public int weakReferenceIndex = -1;
    public int referenceCount = 0;
    private PositionHelper fPositionHelper;
    private DocumentPosition fDocumentPosition;
    private Location fLocation;
    protected String fPublicId;
    protected String fSystemId;
    public DataBuffer firstBuffer;
    protected DataBufferReferrer fBufferReferrer;
    protected DataBufferFactory fBufferReferrerFactory;
    protected boolean fProcessingText = false;
    private boolean fExposeEncoding;
    private final int features;

    public XCIScanner(XLXPSharedResources xLXPSharedResources, int n2) {
        this(xLXPSharedResources.getEntityFactory(), xLXPSharedResources.getBufferFactory(), xLXPSharedResources.getSymbolTable(), xLXPSharedResources.getCursorFactory(), n2);
        this.sharedResources = xLXPSharedResources;
    }

    public XCIScanner(SAX2ParsedEntityFactory sAX2ParsedEntityFactory, DataBufferFactory dataBufferFactory, SymbolTable symbolTable, XLXPCursorFactory xLXPCursorFactory, int n2) {
        super((DataBufferFactory)new DelegatingDataBufferFactory(dataBufferFactory), symbolTable, n2);
        this.fEntityFactory = sAX2ParsedEntityFactory;
        this.setDTDSupport(new XCIDTDSupport(this));
        this.nscontext = new NamespaceContextAdapter(this, this.getSymbolTable());
        this.fCursorFactory = xLXPCursorFactory;
        this.documentInfo = new XLXPDocumentInfo();
        this.features = n2;
    }

    public int features() {
        return this.features;
    }

    public ParsedEntity getCurrentEntity() {
        return this.fCurrentEntity;
    }

    public void setDocument(InputSource inputSource) {
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(inputSource);
        this.setDocumentEntity(parsedEntity);
        this.fPublicId = inputSource.getPublicId();
        this.fSystemId = inputSource.getSystemId();
        this.documentInfo().setURI(this.fSystemId);
    }

    public void setExposeEncoding(boolean bl) {
        this.fExposeEncoding = bl;
    }

    public void setBufferFactory(DataBufferFactory dataBufferFactory) {
        DataBufferFactory dataBufferFactory2 = this.getBufferFactory();
        if (dataBufferFactory2 instanceof DelegatingDataBufferFactory) {
            if (dataBufferFactory instanceof DelegatingDataBufferFactory) {
                dataBufferFactory = ((DelegatingDataBufferFactory)dataBufferFactory).factory;
            }
            ((DelegatingDataBufferFactory)dataBufferFactory2).factory = dataBufferFactory;
        }
    }

    public int currentEvent() {
        return this.fCurrentEvent;
    }

    public DataBuffer getCurrentStartDataBuffer() {
        return this.fCurrentEventFirstBuffer;
    }

    public int getCurrentStartOffset() {
        return this.fCurrentEventStartOffset;
    }

    public DataBuffer getCurrentEndDataBuffer() {
        return this.fCurrentEntity.buffer;
    }

    public int getCurrentEndOffset() {
        return this.fCurrentEntity.offset;
    }

    public boolean loadMore() {
        boolean bl;
        boolean bl2 = LoggerUtil.isAnyTracingEnabled();
        if (bl2 && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "loadMore", "About to load more data.");
        }
        this.fCurrentEntity.setMark();
        while (bl = this.fCurrentEntity.loadMore() != 0) {
        }
        if (!bl && this.fCurrentEntity.error != null) {
            String string2;
            String string3 = string2 = this.fCurrentEntity.error.exception == null ? this.fCurrentEntity.error.formatErrorMessage() : this.fCurrentEntity.error.exception.toString();
            if (bl2 && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "loadMore", "Loading failed, error string=" + string2);
            }
        }
        this.fCurrentEntity.resetToMark();
        if (this.fCurrentEntity.error != null) {
            this.fCurrentEntity.buffer.next = null;
        }
        return bl;
    }

    public int getSingleCh() {
        return this.singleCh;
    }

    public XSModel getXSModel() {
        Grammar grammar = this.getIR();
        return grammar != null ? grammar.xsModel : null;
    }

    public XSElementDeclaration getElementDeclaration() {
        if (this.ir == null) {
            return null;
        }
        return this.eDecl == null ? null : this.eDecl.xsElementDeclaration;
    }

    public XSTypeDefinition getTypeDefinition() {
        if (this.ir == null) {
            return null;
        }
        if (this.eType == null) {
            return null;
        }
        switch (this.fCurrentEvent) {
            case 2: 
            case 3: 
            case 4: {
                return this.eType.xsTypeDefinition;
            }
        }
        return null;
    }

    public XSAttributeDeclaration getAttributeDeclaration(int n2) {
        if (this.ir == null || this.eType == null) {
            return null;
        }
        return this.aDecls[n2] != null ? this.aDecls[n2].xsAttributeDeclaration : null;
    }

    public Element getNativeElementDeclaration() {
        return this.eDecl;
    }

    public ElementType getNativeTypeDefinition() {
        return this.eType;
    }

    public Object getNativeElementValue() {
        return this.currentElementActualValue();
    }

    public Object getNativeAttributeValue(int n2) {
        return this.actualAttributeValue(n2);
    }

    public XMLString getFixedAttrValue(int n2) {
        Attribute attribute2 = this.aDecls[n2];
        ValidatedInfo validatedInfo = attribute2.vcValue;
        switch (validatedInfo.typeValidator.builtInKind) {
            case 4: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 42: {
                return ((XDecimal)validatedInfo.actualValue).rawData;
            }
            case 1: 
            case 2: {
                return (XMLString)validatedInfo.actualValue;
            }
        }
        XMLString xMLString = new XMLString();
        this.fSymbolTable.addSymbolSetValues(validatedInfo.actualValue.toString(), xMLString);
        return xMLString;
    }

    public final boolean produceStartDocumentEvent() {
        boolean bl = super.produceStartDocumentEvent();
        this.documentInfo.setXMLVersion(this.fIsXML10);
        this.documentInfo.setXMLEncoding(this.fExposeEncoding && this.encName.length != 0 ? this.encName.toString() : null);
        return bl;
    }

    protected boolean produceRootElementEvent(boolean bl) {
        this.documentInfo.setUnparsedEntity(this.fDTDScanner != null ? this.fDTDScanner.getUnparsedEntities() : null);
        return super.produceRootElementEvent(bl);
    }

    public final boolean produceCharacterEvent() {
        return super.produceCharacterEvent();
    }

    public final boolean producePredefinedEntityEvent() {
        return super.producePredefinedEntityEvent();
    }

    public boolean produceCDATASectionEvent() {
        return super.produceCDATASectionEvent();
    }

    public boolean produceDoctypeEvent() {
        super.produceDoctypeEvent();
        return true;
    }

    public boolean produceStartEntityEvent() {
        super.produceStartEntityEvent();
        return true;
    }

    public boolean produceEndEntityEvent() {
        super.produceEndEntityEvent();
        return !this.fProcessingText;
    }

    public boolean produceEntityReferenceEvent() {
        super.produceEntityReferenceEvent();
        return true;
    }

    public boolean produceFatalErrorEvent() {
        super.produceFatalErrorEvent();
        Location location = this.getLocation();
        XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(this.getErrorMessage());
        xCIDynamicErrorException.setSourceLocation(XCIErrorHelper.locationTransformer(location));
        SessionContext sessionContext = this.sharedResources.getCursorFactory().getSessionContext();
        XCIErrorHelper.pushInstanceException(sessionContext, xCIDynamicErrorException, (short)3);
        throw xCIDynamicErrorException;
    }

    public Location getLocation() {
        if (this.fLocation == null) {
            this.fDocumentPosition = new DocumentPosition();
            this.fLocation = new LocationImpl();
        }
        if (this.fPositionHelper == null) {
            this.fPositionHelper = new SimplePositionHelper();
        }
        this.fPositionHelper.setCurrentExternalEntity(this.fCurrentEntity);
        this.fPositionHelper.getCurrentPosition(this.fDocumentPosition);
        return this.fLocation;
    }

    public boolean produceRecoverableErrorEvent() {
        Location location = this.getLocation();
        XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(this.getErrorMessage());
        xCIDynamicErrorException.setSourceLocation(XCIErrorHelper.locationTransformer(location));
        SessionContext sessionContext = this.sharedResources.getCursorFactory().getSessionContext();
        boolean bl = XCIErrorHelper.pushInstanceException(sessionContext, xCIDynamicErrorException, (short)2);
        if (!bl) {
            throw xCIDynamicErrorException;
        }
        int n2 = this.fCurrentEvent;
        super.produceRecoverableErrorEvent();
        this.fCurrentEvent = n2;
        return true;
    }

    public boolean produceWarningEvent() {
        Location location = this.getLocation();
        XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(this.getErrorMessage());
        xCIDynamicErrorException.setSourceLocation(XCIErrorHelper.locationTransformer(location));
        SessionContext sessionContext = this.sharedResources.getCursorFactory().getSessionContext();
        boolean bl = XCIErrorHelper.pushInstanceException(sessionContext, xCIDynamicErrorException, (short)1);
        if (!bl) {
            throw xCIDynamicErrorException;
        }
        int n2 = this.fCurrentEvent;
        super.produceWarningEvent();
        this.fCurrentEvent = n2;
        return true;
    }

    protected String getErrorMessage() {
        MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(this.errorURI);
        return messageProvider.createMessage(null, this.errorCode, this.errorParamStrings);
    }

    public final void reset(boolean bl) {
        super.reset(bl);
        this.fCurrentEvent = 0;
        if (this.fDTDScanner != null) {
            this.fDTDScanner.reset(bl);
        } else {
            this.fStandalone = false;
        }
        this.fSymbolTable.reset(bl);
        this.fSymbolTable.updateSymbolMapHolder();
        this.fProcessingText = false;
    }

    public XCIScanner checkReferencesGC() {
        if (this.resourceOwner == null) {
            this.decrementReference();
            if (!this.isOwnerReferenced(this)) {
                this.unregisterReferrer();
                this.fCursorFactory.returnSharedResources(this.sharedResources);
                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "checkReferencesGC", "about to re-use scanner which is an owner: " + this.toString());
                }
                return this;
            }
            this.isZombieParent = true;
            return null;
        }
        this.resourceOwner.decrementReference();
        if (!this.isOwnerReferenced(this.resourceOwner)) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "checkReferencesGC", "about to return my owner, who was lingering: " + this.resourceOwner.toString());
            }
            this.returnOwner(this.resourceOwner);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "checkReferencesGC", "about to re-use scanner which is NOT an owner: " + this.toString());
        }
        return this;
    }

    public void checkReferences() {
        if (this.resourceOwner == null) {
            this.decrementReference();
            if (!this.isOwnerReferenced(this)) {
                this.returnOwner(this);
            } else {
                this.wasReleased = true;
                this.isZombieParent = true;
            }
        } else {
            this.resourceOwner.decrementReference();
            if (!this.isOwnerReferenced(this.resourceOwner)) {
                this.returnOwner(this.resourceOwner);
            }
            this.returnScannerToStack();
        }
    }

    public boolean isOwnerReferenced(Scanner scanner) {
        return ((XCIScanner)scanner).referenceCount > 0;
    }

    public void decrementReference() {
        --this.referenceCount;
        if (this.referenceCount < 0) {
            FFDCUtil.log(XCIErrorHelper.createInternalException("XCIScanner's references are below zero, check internals."), this);
        }
    }

    public void increaseReference() {
        ++this.referenceCount;
    }

    public void returnOwner(Scanner scanner) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "returnOwner", "returning owner: " + scanner.toString());
        }
        ((XCIScanner)scanner).unregisterReferrer();
        ((XCIScanner)scanner).returnScannerToStack();
    }

    public void returnScannerToStack() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "returnOwner", "returning scanner to stack: " + this.toString());
        }
        this.resetScanner();
        this.fCursorFactory.returnScanner(this, this.weakReferenceIndex);
    }

    public void resetScanner() {
        this.wasReleased = true;
        this.reset(true);
    }

    public void registerReferrer() {
        this.fBufferReferrer = new XCIScannerReferrer();
        this.firstBuffer = this.getCurrentStartDataBuffer();
        if (this.fBufferReferrerFactory != this.firstBuffer.factory) {
            if (this.fBufferReferrerFactory != null) {
                this.fBufferReferrerFactory.removeReferrer(this.fBufferReferrer);
            }
            this.fBufferReferrerFactory = this.firstBuffer.factory;
            this.fBufferReferrerFactory.addReferrer(this.fBufferReferrer);
        }
        this.fBufferReferrer.active = true;
    }

    public void unregisterReferrer() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "unregisterReferrer", "unregistering the buffer referrer for this scanner, number of refs=" + this.referenceCount);
        }
        if (this.fBufferReferrer == null) {
            return;
        }
        if (this.firstBuffer != null) {
            this.firstBuffer = null;
            this.fBufferReferrer.active = false;
        }
        if (this.fBufferReferrerFactory != null) {
            this.fBufferReferrerFactory.removeReferrer(this.fBufferReferrer);
            this.fBufferReferrerFactory = null;
        }
        this.fBufferReferrer = null;
    }

    public final boolean isMarkupNext() {
        boolean bl = true;
        switch (this.fCurrentEntity.checkForMarkup()) {
            case 0: {
                bl = false;
                break;
            }
            case 4: {
                this.fCurrentEntity.setMark();
                this.fCurrentEntity.skipTwoBytes();
                if (this.fCurrentEntity.currentByte() == 91) {
                    bl = false;
                }
                this.fCurrentEntity.resetToMark();
            }
        }
        return bl;
    }

    public final void setProcessingText(boolean bl) {
        this.fProcessingText = bl;
    }

    public QName elementQName() {
        return this.elementQName;
    }

    public XMLString elementValue() {
        return this.elementValue;
    }

    public XMLString piTarget() {
        return this.piTarget;
    }

    public NamespaceContextAdapter nscontext() {
        return this.nscontext;
    }

    public XMLString content() {
        return this.content;
    }

    public boolean nilled() {
        return this.nilled;
    }

    public boolean leafNilled() {
        return this.leafNilled;
    }

    public int singleCh() {
        return this.singleCh;
    }

    public XLXPDocumentInfo documentInfo() {
        return this.documentInfo;
    }

    public Scanner skipSubtree() {
        if (this.isSimpleSubtree()) {
            return this;
        }
        return this.breadCrumbScanner();
    }

    protected boolean isSimpleSubtree() {
        if (this.currentEvent() == 3) {
            return true;
        }
        XSTypeDefinition xSTypeDefinition = this.getTypeDefinition();
        return xSTypeDefinition != null && xSTypeDefinition.getTypeCategory() == 16;
    }

    public Scanner breadCrumbScanner() {
        XMLString xMLString = this.getSubtreeContent();
        if (xMLString == null) {
            return this;
        }
        XCIScannerFragment xCIScannerFragment = (XCIScannerFragment)this.saveFragment();
        this.nextEvent();
        DelegatingSubtreeScanner delegatingSubtreeScanner = new DelegatingSubtreeScanner(xMLString, this.features, this.fIsXML10, this.fCurrentEntity.lineBreaksNormalized);
        delegatingSubtreeScanner.loadFragment(xCIScannerFragment);
        delegatingSubtreeScanner.setOwner(this);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "breadCrumbScanner", "skipping the subtree:" + xMLString.toString());
        }
        return delegatingSubtreeScanner;
    }

    public XMLString getSubtreeContent() {
        assert (this.currentEvent() == 2);
        XMLString xMLString = new XMLString();
        if (this.skipContent(xMLString, false)) {
            return xMLString;
        }
        xMLString.unregister();
        return null;
    }

    public Object saveFragment() {
        XCIScannerFragment xCIScannerFragment = new XCIScannerFragment();
        xCIScannerFragment.sVMContextFragment = (VMContext.VMContextFragment)super.saveFragment();
        xCIScannerFragment.sDocumentInfo = this.documentInfo;
        xCIScannerFragment.sDTDScanner = this.fDTDScanner;
        xCIScannerFragment.sEntityResolver = this.fEntityFactory.getEntityResolver();
        xCIScannerFragment.publicID = this.fPublicId;
        xCIScannerFragment.systemID = this.fSystemId;
        return xCIScannerFragment;
    }

    public boolean loadFragment(Object object2) {
        XCIScannerFragment xCIScannerFragment = (XCIScannerFragment)object2;
        super.loadFragment(xCIScannerFragment.sVMContextFragment);
        this.documentInfo.load(xCIScannerFragment.sDocumentInfo);
        this.fDTDScanner = xCIScannerFragment.sDTDScanner;
        this.fEntityFactory.setEntityResolver(xCIScannerFragment.sEntityResolver);
        this.fSystemId = xCIScannerFragment.systemID;
        this.fPublicId = xCIScannerFragment.publicID;
        return true;
    }

    public Scanner getOwner() {
        return this.resourceOwner;
    }

    public void setOwner(Scanner scanner) {
        this.resourceOwner = (XCIScanner)scanner;
    }

    public int entityDepth() {
        return this.fDTDSupport.entityDepth();
    }

    public boolean wasReleased() {
        return this.wasReleased;
    }

    public boolean isZombie() {
        return this.isZombieParent;
    }

    public void setWeakReferenceIndex(int n2) {
        this.weakReferenceIndex = n2;
    }

    public void setSharedResources(XLXPSharedResources xLXPSharedResources) {
        this.sharedResources = xLXPSharedResources;
        this.fCursorFactory = xLXPSharedResources.getCursorFactory();
        this.setBufferFactory(xLXPSharedResources.getBufferFactory());
        this.fSymbolTable = xLXPSharedResources.getSymbolTable();
        this.fEntityFactory = xLXPSharedResources.getEntityFactory();
    }

    public Scanner getDelegate() {
        return null;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private final class LocationImpl
    implements Location {
        private LocationImpl() {
        }

        public int getLineNumber() {
            return ((XCIScanner)XCIScanner.this).fDocumentPosition.lineNumber;
        }

        public int getColumnNumber() {
            return ((XCIScanner)XCIScanner.this).fDocumentPosition.columnNumber;
        }

        public int getCharacterOffset() {
            return ((XCIScanner)XCIScanner.this).fDocumentPosition.byteOffset;
        }

        public String getPublicId() {
            return XCIScanner.this.fPublicId;
        }

        public String getSystemId() {
            return XCIScanner.this.fSystemId;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    final class XCIScannerFragment {
        public XLXPDocumentInfo sDocumentInfo;
        public XCIDTDScanner sDTDScanner;
        public EntityResolver sEntityResolver;
        public String publicID;
        public String systemID;
        public VMContext.VMContextFragment sVMContextFragment;

        public void reset() {
            this.sVMContextFragment.reset();
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    final class XCIScannerReferrer
    extends DataBufferReferrer {
        XCIScannerReferrer() {
        }

        public boolean hasReferenceTo(DataBuffer dataBuffer) {
            if (XCIScanner.this.firstBuffer == dataBuffer) {
                return true;
            }
            if (XCIScanner.this.firstBuffer.next == null) {
                return false;
            }
            DataBuffer dataBuffer2 = XCIScanner.this.firstBuffer.next;
            while (dataBuffer2 != dataBuffer) {
                if (dataBuffer2 == null) {
                    return false;
                }
                dataBuffer2 = dataBuffer2.next;
            }
            return true;
        }

        public void removeReferencesAndUnregister() {
            XCIScanner.this.unregisterReferrer();
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class XCIDTDScanner
    extends DTDScanner {
        private XLXPDocumentInfo.UnparsedEntity fEntity;

        public XCIDTDScanner(DocumentScanner documentScanner, SymbolTable symbolTable, ParsedEntityFactory parsedEntityFactory) {
            super(documentScanner, symbolTable, parsedEntityFactory);
        }

        protected EntityDeclPool.EntityDecl lookupEntity(XMLString xMLString) {
            return this.fEntityManager.lookupEntity(xMLString);
        }

        protected void unparsedEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, XMLString xMLString4) {
            EntityDeclPool.EntityDecl entityDecl = this.lookupEntity(xMLString);
            super.unparsedEntityDecl(xMLString, xMLString2, xMLString3, xMLString4);
            if (entityDecl == null) {
                this.fEntity = new XLXPDocumentInfo.UnparsedEntity(xMLString.toString(), xMLString2 == null ? null : xMLString2.toString(), xMLString3.toString(), xMLString4.toString(), this.fEntity);
            }
        }

        public void reset(boolean bl) {
            super.reset(bl);
            this.fEntity = null;
        }

        public XLXPDocumentInfo.UnparsedEntity getUnparsedEntities() {
            return this.fEntity;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private final class XCIDTDSupport
    extends DTDSupport {
        private ParsedEntity fDocumentEntity;

        public XCIDTDSupport(XCIScanner xCIScanner2) {
            super(xCIScanner2);
        }

        public boolean scanDoctypeDecl() {
            XCIScanner.this.fDTDScanner = new XCIDTDScanner(this.fScanner, XCIScanner.this.fSymbolTable, XCIScanner.this.fEntityFactory);
            XCIScanner.this.setDTDSupport(XCIScanner.this.fDTDScanner);
            XCIScanner.this.fDTDScanner.setDocumentEntity(this.fDocumentEntity);
            if (XCIScanner.this.fStandalone) {
                XCIScanner.this.fDTDScanner.setStandalone();
            }
            return XCIScanner.this.fDTDScanner.scanDoctypeDecl();
        }

        public void setDocumentEntity(ParsedEntity parsedEntity) {
            this.fDocumentEntity = parsedEntity;
        }

        public void setStandalone() {
            XCIScanner.this.fStandalone = true;
        }
    }
}

