/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.scanner;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.adapters.xlxp.XLXPDocumentInfo;
import com.ibm.xml.xci.adapters.xlxp.scanner.XCIScanner;
import com.ibm.xml.xci.adapters.xlxp.util.XLXPSharedResources;
import com.ibm.xml.xci.xlxp.NamespaceContextAdapter;
import com.ibm.xml.xci.xlxp.Scanner;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.SymbolTable;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.InputSource;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class DelegatingSubtreeScanner
implements Scanner {
    private static final Logger logger = LoggerUtil.getLogger(DelegatingSubtreeScanner.class);
    private Scanner delegate;
    private Object subtreeInfo;
    private Scanner resourceOwner;
    private final int features;
    private boolean isXML10;
    private boolean lineBreaksNormalized;
    private int weakReferenceIndex;
    private XMLString subtreeContent;

    public DelegatingSubtreeScanner(XMLString xMLString, int n2, boolean bl, boolean bl2) {
        this.isXML10 = bl;
        this.lineBreaksNormalized = bl2;
        this.subtreeContent = xMLString;
        this.features = n2;
        this.delegate = null;
    }

    public Scanner getDelegate() {
        return this.delegate;
    }

    private void activate() {
        if (this.delegate != null) {
            return;
        }
        XLXPSharedResources xLXPSharedResources = ((XCIScanner)this.resourceOwner).sharedResources;
        ParsedEntity parsedEntity = xLXPSharedResources.getEntityFactory().createParsedEntityFromXMLString(this.subtreeContent, null, this.isXML10);
        this.subtreeContent.unregister();
        this.subtreeContent = null;
        parsedEntity.lineBreaksNormalized = this.lineBreaksNormalized;
        parsedEntity.isFragment = true;
        ((XCIScanner.XCIScannerFragment)this.subtreeInfo).sVMContextFragment.sDocumentScannerFragment.sFragmentEntity = parsedEntity;
        this.delegate = xLXPSharedResources.getCursorFactory().getScanner(this.features, xLXPSharedResources);
        this.delegate.loadFragment(this.subtreeInfo);
        this.delegate.setWeakReferenceIndex(this.weakReferenceIndex);
        this.delegate.setOwner(this.resourceOwner);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            String string2 = ((XCIScanner.XCIScannerFragment)this.subtreeInfo).sVMContextFragment.sDocumentScannerFragment.sElementQName.toString();
            logger.logp(Level.FINER, logger.getName(), "activate", "activated a new scanner to parse the subtree of:" + string2);
        }
    }

    public int attributeCount() {
        return this.delegate.attributeCount();
    }

    public QName attributeName(int n2) {
        return this.delegate.attributeName(n2);
    }

    public boolean attributeSpecified(int n2) {
        return this.delegate.attributeSpecified(n2);
    }

    public XMLString attributeValue(int n2) {
        return this.delegate.attributeValue(n2);
    }

    public XMLString content() {
        return this.delegate.content();
    }

    public int currentEvent() {
        this.activate();
        return this.delegate.currentEvent();
    }

    public XLXPDocumentInfo documentInfo() {
        return this.delegate.documentInfo();
    }

    public QName elementQName() {
        return this.delegate.elementQName();
    }

    public XMLString elementValue() {
        return this.delegate.elementValue();
    }

    public XSAttributeDeclaration getAttributeDeclaration(int n2) {
        return this.delegate.getAttributeDeclaration(n2);
    }

    public XSElementDeclaration getElementDeclaration() {
        return this.delegate.getElementDeclaration();
    }

    public DataBuffer getCurrentEndDataBuffer() {
        return this.delegate.getCurrentEndDataBuffer();
    }

    public int getCurrentEndOffset() {
        return this.delegate.getCurrentEndOffset();
    }

    public DataBuffer getCurrentStartDataBuffer() {
        return this.delegate.getCurrentStartDataBuffer();
    }

    public int getCurrentStartOffset() {
        return this.delegate.getCurrentStartOffset();
    }

    public XMLString getElementString() {
        return this.delegate.getElementString();
    }

    public XMLString getFixedAttrValue(int n2) {
        return this.delegate.getFixedAttrValue(n2);
    }

    public SymbolTable getSymbolTable() {
        return this.delegate.getSymbolTable();
    }

    public XSTypeDefinition getTypeDefinition() {
        return this.delegate.getTypeDefinition();
    }

    public boolean isMarkupNext() {
        return this.delegate.isMarkupNext();
    }

    public boolean leafNilled() {
        return this.delegate.leafNilled();
    }

    public boolean loadMore() {
        this.activate();
        return this.delegate.loadMore();
    }

    public boolean loadFragment(Object object2) {
        this.subtreeInfo = object2;
        return true;
    }

    public int nextEvent() {
        return this.delegate.nextEvent();
    }

    public boolean nilled() {
        return this.delegate.nilled();
    }

    public int nsDeclCount() {
        return this.delegate.nsDeclCount();
    }

    public String nsDeclPrefix(int n2) {
        return this.delegate.nsDeclPrefix(n2);
    }

    public String nsDeclURI(int n2) {
        return this.delegate.nsDeclURI(n2);
    }

    public NamespaceContextAdapter nscontext() {
        return this.delegate.nscontext();
    }

    public XMLString piTarget() {
        return this.delegate.piTarget();
    }

    public void registerReferrer() {
        this.delegate.registerReferrer();
    }

    public void resetScanner() {
        this.delegate.resetScanner();
    }

    public Object saveFragment() {
        return null;
    }

    public void setDocument(InputSource inputSource) {
        this.delegate.setDocument(inputSource);
    }

    public void setExposeEncoding(boolean bl) {
        this.delegate.setExposeEncoding(bl);
    }

    public void setProcessingText(boolean bl) {
        this.delegate.setProcessingText(bl);
    }

    public int singleCh() {
        return this.delegate.singleCh();
    }

    public Scanner skipSubtree() {
        this.activate();
        return this.delegate.skipSubtree();
    }

    public void unregisterReferrer() {
        this.delegate.unregisterReferrer();
    }

    public boolean validating() {
        return this.delegate.validating();
    }

    public Scanner getOwner() {
        return this.resourceOwner;
    }

    public void setOwner(Scanner scanner) {
        while (scanner.getOwner() != null) {
            scanner = scanner.getOwner();
        }
        this.resourceOwner = scanner;
        this.resourceOwner.increaseReference();
    }

    public int entityDepth() {
        this.activate();
        return this.delegate.entityDepth();
    }

    public void increaseReference() {
        this.delegate.increaseReference();
    }

    public void decrementReference() {
        this.delegate.decrementReference();
    }

    public Scanner checkReferencesGC() {
        if (this.delegate == null) {
            this.releaseNonActive();
            return null;
        }
        return this.delegate.checkReferencesGC();
    }

    public void checkReferences() {
        if (this.delegate == null) {
            this.releaseNonActive();
        } else {
            this.delegate.checkReferences();
        }
    }

    private void releaseNonActive() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            String string2 = ((XCIScanner.XCIScannerFragment)this.subtreeInfo).sVMContextFragment.sDocumentScannerFragment.sElementQName.toString();
            logger.logp(Level.FINER, logger.getName(), "releaseNonActive", "releasing the non-activated subtree scanner for element:" + string2);
        }
        this.resourceOwner.decrementReference();
        if (this.subtreeContent != null) {
            this.subtreeContent.unregister();
            this.subtreeContent = null;
        }
        if (this.subtreeInfo instanceof XCIScanner.XCIScannerFragment) {
            ((XCIScanner.XCIScannerFragment)this.subtreeInfo).reset();
        }
        ((XCIScanner)this.resourceOwner).sharedResources.getCursorFactory().weakReferenceManager.releaseEntry(this.weakReferenceIndex);
        if (!this.resourceOwner.isOwnerReferenced(this.resourceOwner)) {
            this.resourceOwner.returnOwner(this.resourceOwner);
        }
    }

    public void setWeakReferenceIndex(int n2) {
        if (this.delegate == null) {
            this.weakReferenceIndex = n2;
            return;
        }
        this.delegate.setWeakReferenceIndex(n2);
    }

    public boolean wasReleased() {
        if (this.delegate == null) {
            return false;
        }
        return this.delegate.wasReleased();
    }

    public boolean isZombie() {
        if (this.delegate == null) {
            return false;
        }
        return this.delegate.isZombie();
    }

    public void returnOwner(Scanner scanner) {
        this.delegate.returnOwner(scanner);
    }

    public boolean isOwnerReferenced(Scanner scanner) {
        return this.delegate.isOwnerReferenced(scanner);
    }

    public XMLString getSubtreeContent() {
        return this.subtreeContent;
    }
}

