/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp.mediator;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.adapters.xlxp.XLXPCursor;
import com.ibm.xml.xci.adapters.xlxp.scanner.DelegatingSubtreeScanner;
import com.ibm.xml.xci.adapters.xlxp.util.MutationMap;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.UserData;
import com.ibm.xml.xci.dp.cache.dom.UserDataFactory;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingCursorMediator;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import com.ibm.xml.xci.dp.util.copy.SerializerCDataDelegate;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.serializer.XMLUtf8DirectStreamCursor;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.UTF8Support;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XLXPCacheMediator
extends StreamingCursorMediator {
    private static final Logger logger = LoggerUtil.getLogger(XLXPCacheMediator.class);
    protected final XLXPCursor adapter;
    protected boolean isPreserveNamespaceDecls;
    protected final ItemCopier fullCopier;
    protected final ItemCopier subtreeCopier;
    final boolean fastSerialization;
    private final int DEFAULT_CONTENT_SIZE = 100;
    private char[][] fConvertedChars;
    private int[] fConvertedCharsOffset;
    private MutationMap mutMap;

    public XLXPCacheMediator(Cursor cursor2, Cursor.Profile profile) {
        this(cursor2, profile, false);
    }

    public XLXPCacheMediator(Cursor cursor2, Cursor.Profile profile, boolean bl) {
        super(cursor2, profile);
        this.fastSerialization = bl;
        this.adapter = (XLXPCursor)cursor2;
        this.fullCopier = new ByteCopier(true);
        this.subtreeCopier = new ByteCopier(false);
        this.adapter.registerReferrer();
    }

    public void reportMutation(DOMCachedNode dOMCachedNode) {
        if (!this.fastSerialization) {
            return;
        }
        if (this.mutMap == null) {
            this.mutMap = new MutationMap();
        }
        if (dOMCachedNode.itemKind() != 1 && dOMCachedNode.itemKind() != 9) {
            dOMCachedNode = dOMCachedNode.getCachedParent();
        }
        if (dOMCachedNode == null) {
            return;
        }
        MutationMap.MutationMapItem mutationMapItem = new MutationMap.MutationMapItem(MutationMap.MutationMapItem.NODE_KIND, dOMCachedNode);
        this.mutMap.pushItem(mutationMapItem);
        dOMCachedNode.setState(BitMaskHelper.stateSet(dOMCachedNode.getState(), 0x100000));
    }

    public int copyNode(DOMCachedNode dOMCachedNode, Cursor.Area area, AddContentInterface addContentInterface, boolean bl) {
        int n2;
        OffsetData offsetData = (OffsetData)((Object)dOMCachedNode.getUserData());
        if (!offsetData.endOffsetKnown() && !bl) {
            dOMCachedNode.getCachedFollowingSibling();
            offsetData = (OffsetData)((Object)dOMCachedNode.getUserData());
            assert (offsetData.endOffsetKnown());
        }
        if (offsetData.endOffsetKnown()) {
            n2 = 1;
        } else {
            XLXPCursor xLXPCursor = (XLXPCursor)((StreamingCursorMediator.XCIData)((Object)dOMCachedNode.getUserData())).getXCI();
            DataBuffer dataBuffer = xLXPCursor.loadAllBuffers(offsetData.getFirstDataBuffer());
            offsetData.setEndOffset(dataBuffer.endOffset);
            offsetData.setLastDataBuffer(dataBuffer);
            n2 = 2;
        }
        if (addContentInterface instanceof XMLUtf8DirectStreamCursor) {
            if (this.mutMap != null) {
                this.addMutatedContent(dOMCachedNode, addContentInterface, area, offsetData, true);
            } else {
                XLXPCacheMediator.addContentAsBytes(addContentInterface, area, offsetData);
            }
        } else if (this.mutMap != null) {
            this.addMutatedContent(dOMCachedNode, addContentInterface, area, offsetData, false);
        } else {
            this.addContentAsChars(addContentInterface, area, offsetData);
        }
        return n2;
    }

    public void addContentAsChars(AddContentInterface addContentInterface, Cursor.Area area, OffsetData offsetData) {
        if (this.fConvertedChars == null) {
            this.fConvertedChars = new char[1][];
            this.fConvertedChars[0] = new char[1600];
            this.fConvertedCharsOffset = new int[1];
        }
        this.fConvertedCharsOffset[0] = 0;
        CharConversionError charConversionError = this.getContent(offsetData, this.fConvertedChars, this.fConvertedCharsOffset);
        if (charConversionError != null) {
            XCIDynamicErrorException xCIDynamicErrorException = XCIErrorHelper.createInternalException(charConversionError.exception);
            FFDCUtil.log(xCIDynamicErrorException, this);
            throw xCIDynamicErrorException;
        }
        addContentInterface.addContent(area, this.fConvertedChars[0], 0, this.fConvertedCharsOffset[0]);
        addContentInterface.toEndOfDocument();
    }

    public void addMutatedContent(DOMCachedNode dOMCachedNode, AddContentInterface addContentInterface, Cursor.Area area, OffsetData offsetData, boolean bl) {
        boolean bl2;
        MutationMap.MutationMapItem mutationMapItem;
        Iterator<MutationMap.MutationMapItem> iterator = this.mutMap.getMutationList();
        MutationMap.MutationMapItem mutationMapItem2 = mutationMapItem = iterator.hasNext() ? iterator.next() : null;
        assert (mutationMapItem != null) : "Item inside the mutation map was null!";
        DOMCachedNode dOMCachedNode2 = (DOMCachedNode)mutationMapItem.getContent();
        if (dOMCachedNode2.itemKind() == 9 || dOMCachedNode2 == dOMCachedNode) {
            Copier.copy(dOMCachedNode2.fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), (Cursor)((Object)addContentInterface), area);
            addContentInterface.flushContent();
            return;
        }
        XCIOffsetAllData xCIOffsetAllData = new XCIOffsetAllData();
        OffsetData offsetData2 = (OffsetData)((Object)dOMCachedNode.getUserData());
        OffsetData offsetData3 = (OffsetData)((Object)dOMCachedNode2.getUserData());
        boolean bl3 = bl2 = dOMCachedNode.getBuiltParent() == dOMCachedNode.getCache().getBuiltRootNode();
        if (offsetData2 == null || offsetData3 == null || !bl2) {
            Copier.copy(dOMCachedNode.fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), (Cursor)((Object)addContentInterface), area);
            addContentInterface.flushContent();
            return;
        }
        xCIOffsetAllData.setFirstDataBuffer(offsetData2.getFirstDataBuffer());
        xCIOffsetAllData.setStartOffset(offsetData2.getStartOffset());
        xCIOffsetAllData.setLastDataBuffer(offsetData3.getFirstDataBuffer());
        xCIOffsetAllData.setEndOffset(offsetData3.getStartOffset());
        while (true) {
            if (xCIOffsetAllData.getFirstDataBuffer() != xCIOffsetAllData.getLastDataBuffer() || xCIOffsetAllData.getStartOffset() <= xCIOffsetAllData.getEndOffset()) {
                if (bl) {
                    XLXPCacheMediator.addContentAsBytes(addContentInterface, area, xCIOffsetAllData);
                } else {
                    this.addContentAsChars(addContentInterface, area, xCIOffsetAllData);
                }
            }
            Copier.copy(dOMCachedNode2.fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), (Cursor)((Object)addContentInterface), area);
            addContentInterface.flushContent();
            if (!offsetData3.endOffsetKnown()) {
                dOMCachedNode2.getCachedFollowingSibling();
                offsetData3 = (OffsetData)((Object)dOMCachedNode2.getUserData());
                assert (offsetData.endOffsetKnown());
            }
            xCIOffsetAllData.setFirstDataBuffer(offsetData3.getLastDataBuffer());
            xCIOffsetAllData.setStartOffset(offsetData3.getEndOffset());
            do {
                MutationMap.MutationMapItem mutationMapItem3 = mutationMapItem = iterator.hasNext() ? iterator.next() : null;
            } while (mutationMapItem != null && (dOMCachedNode2 = (DOMCachedNode)mutationMapItem.getContent()).isParentChainMutationMapQueue(true));
            if (mutationMapItem == null) break;
            offsetData3 = (OffsetData)((Object)dOMCachedNode2.getUserData());
            if (offsetData3 == null) {
                Copier.copy(dOMCachedNode2.fork(false, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), (Cursor)((Object)addContentInterface), area);
                addContentInterface.flushContent();
                return;
            }
            xCIOffsetAllData.setLastDataBuffer(offsetData3.getFirstDataBuffer());
            xCIOffsetAllData.setEndOffset(offsetData3.getStartOffset());
        }
        xCIOffsetAllData.setLastDataBuffer(offsetData2.getLastDataBuffer());
        xCIOffsetAllData.setEndOffset(offsetData2.getEndOffset());
        if (bl) {
            XLXPCacheMediator.addContentAsBytes(addContentInterface, area, xCIOffsetAllData);
        } else {
            this.addContentAsChars(addContentInterface, area, xCIOffsetAllData);
        }
    }

    public static void addContentAsBytes(AddContentInterface addContentInterface, Cursor.Area area, OffsetData offsetData) {
        if (offsetData.getFirstDataBuffer() == offsetData.getLastDataBuffer()) {
            addContentInterface.addContent(area, offsetData.getFirstDataBuffer().bytes, offsetData.getStartOffset(), offsetData.getEndOffset() - offsetData.getStartOffset());
        } else {
            DataBuffer dataBuffer = offsetData.getFirstDataBuffer();
            addContentInterface.addContent(area, dataBuffer.bytes, offsetData.getStartOffset(), dataBuffer.endOffset - offsetData.getStartOffset());
            dataBuffer = dataBuffer.next;
            while (dataBuffer != offsetData.getLastDataBuffer()) {
                if (dataBuffer == null) {
                    return;
                }
                addContentInterface.addContent(area, dataBuffer.bytes, dataBuffer.startOffset, dataBuffer.endOffset);
                dataBuffer = dataBuffer.next;
            }
            addContentInterface.addContent(area, dataBuffer.bytes, dataBuffer.startOffset, offsetData.getEndOffset());
        }
    }

    private CharConversionError getContent(OffsetData offsetData, char[][] cArray, int[] nArray) {
        return UTF8Support.convertBytesToChars(offsetData.getFirstDataBuffer(), offsetData.getLastDataBuffer(), offsetData.getStartOffset(), offsetData.getEndOffset(), cArray, nArray);
    }

    protected boolean isFullCopyOrSer(DOMCachedNode dOMCachedNode) {
        return dOMCachedNode == dOMCachedNode.getBuiltRoot() || dOMCachedNode.getBuiltParent() == dOMCachedNode.getBuiltRoot();
    }

    public boolean buildChildren(DOMCachedNode dOMCachedNode, NodeTest nodeTest) {
        XLXPCursor xLXPCursor = (XLXPCursor)((StreamingCursorMediator.XCIData)((Object)dOMCachedNode.getUserData())).getXCI();
        if (xLXPCursor.isFragment) {
            int n2 = dOMCachedNode.getState();
            if (super.buildChildren(dOMCachedNode, nodeTest)) {
                return true;
            }
        } else if (super.buildChildren(dOMCachedNode, nodeTest)) {
            return true;
        }
        OffsetData offsetData = (OffsetData)((Object)dOMCachedNode.getUserData());
        offsetData.setEndOffset(xLXPCursor.getEndOffset());
        offsetData.setLastDataBuffer(xLXPCursor.getEndDataBuffer());
        if (xLXPCursor.isFragment) {
            // empty if block
        }
        return false;
    }

    private boolean isFragmentAllowed(XLXPCursor xLXPCursor, UserData userData) {
        return userData.isSerializing || !xLXPCursor.isFragment;
    }

    public boolean buildNext(DOMCachedNode dOMCachedNode) {
        int n2 = dOMCachedNode.getState();
        UserData userData = dOMCachedNode.getUserData();
        if (!(userData instanceof StreamingCursorMediator.XCIData)) {
            logger.logp(Level.SEVERE, logger.getName(), "buildNext", "about to hit a ClassCastException!\npreviousNode=" + dOMCachedNode.toStringLazy() + "\nCache manager = " + dOMCachedNode.getCache() + " | Mediator (default) = " + dOMCachedNode.getCache().mediator() + " | Mediator (for node) = " + dOMCachedNode.getMediatorData());
        }
        XLXPCursor xLXPCursor = (XLXPCursor)((StreamingCursorMediator.XCIData)((Object)userData)).getXCI();
        if (dOMCachedNode.itemKind() != 1 || !this.isFragmentAllowed(xLXPCursor, userData) || LazyLoadingHelper.isFirstChildBuilt(n2)) {
            this.visitSubtree(dOMCachedNode, n2, (n2 & 0x800) != 2048);
            return this.doBuildNext(dOMCachedNode);
        }
        if (xLXPCursor.scanner.currentEvent() == 4) {
            return this.doBuildNext(dOMCachedNode);
        }
        this.visitNamespaceAndAttributes(dOMCachedNode);
        n2 = dOMCachedNode.getState();
        xLXPCursor.setLazy(true);
        XLXPCursor xLXPCursor2 = (XLXPCursor)xLXPCursor.fork(true, Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION);
        if (xLXPCursor2 == xLXPCursor) {
            this.visitSubtree(dOMCachedNode, n2, (n2 & 0x800) != 2048);
            return this.doBuildNext(dOMCachedNode);
        }
        boolean bl = dOMCachedNode.getSubtreeID() == null;
        dOMCachedNode.buildSubtreeID();
        return this.doBuildNext(dOMCachedNode, xLXPCursor, xLXPCursor2, bl);
    }

    private void visitNamespaceAndAttributes(DOMCachedNode dOMCachedNode) {
        int n2 = dOMCachedNode.getState();
        boolean bl = (n2 & 0x800) != 2048;
        this.visitNamespaceNodes(dOMCachedNode, n2, bl);
        n2 = dOMCachedNode.getState();
        bl = (n2 & 1) != 1;
        this.visitAttributes(dOMCachedNode, n2, bl);
    }

    protected boolean doBuildNext(DOMCachedNode dOMCachedNode, Cursor cursor2, Cursor cursor3, boolean bl) {
        OffsetData offsetData = (OffsetData)((Object)dOMCachedNode.getUserData());
        offsetData.setEndOffset(((XLXPCursor)cursor2).getEndOffset());
        offsetData.setLastDataBuffer(((XLXPCursor)cursor2).getEndDataBuffer());
        if (cursor2.toNext()) {
            DOMCachedNode dOMCachedNode2 = this.makeNode(cursor2, dOMCachedNode.getCache(), dOMCachedNode.getCachedParent(), dOMCachedNode);
            ((StreamingCursorMediator.XCIData)((Object)dOMCachedNode2.getUserData())).setXCI(cursor2);
            if (bl) {
                dOMCachedNode2.resetSubtreeID();
            }
            this.restorePreviousCursorContext((XCIOffsetDataImpl)offsetData, (XLXPCursor)cursor3);
            return true;
        }
        cursor2.release();
        this.restorePreviousCursorContext((XCIOffsetDataImpl)offsetData, (XLXPCursor)cursor3);
        if (cursor2 == this.source) {
            // empty if block
        }
        return false;
    }

    private void restorePreviousCursorContext(XCIOffsetDataImpl xCIOffsetDataImpl, XLXPCursor xLXPCursor) {
        OffsetData offsetData;
        xCIOffsetDataImpl.setXCI(xLXPCursor);
        DelegatingSubtreeScanner delegatingSubtreeScanner = (DelegatingSubtreeScanner)xLXPCursor.getScanner();
        xCIOffsetDataImpl.subtreeOffset = offsetData = this.makeSubtreeOffset(delegatingSubtreeScanner.getSubtreeContent());
    }

    public boolean doBuildNext(DOMCachedNode dOMCachedNode) {
        XLXPCursor xLXPCursor = (XLXPCursor)((StreamingCursorMediator.XCIData)((Object)dOMCachedNode.getUserData())).getXCI();
        OffsetData offsetData = (OffsetData)((Object)dOMCachedNode.getUserData());
        offsetData.setEndOffset(xLXPCursor.getEndOffset());
        offsetData.setLastDataBuffer(xLXPCursor.getEndDataBuffer());
        return super.doBuildNext(dOMCachedNode);
    }

    protected DOMCachedNode makeNode(Cursor cursor2, CacheManager cacheManager, DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        DOMCachedNode dOMCachedNode3 = super.makeNode(cursor2, cacheManager, dOMCachedNode, dOMCachedNode2);
        XLXPCursor xLXPCursor = (XLXPCursor)cursor2;
        OffsetData offsetData = (OffsetData)((Object)dOMCachedNode3.getUserData());
        offsetData.setStartOffset(xLXPCursor.getStartOffset());
        offsetData.setFirstDataBuffer(xLXPCursor.getStartDataBuffer());
        return dOMCachedNode3;
    }

    public VolatileCData serialize(Cursor cursor2, Map map2) {
        DOMCachedNode dOMCachedNode;
        XLXPCursor xLXPCursor;
        if (this.fastSerialization && (xLXPCursor = (XLXPCursor)((StreamingCursorMediator.XCIData)((Object)(dOMCachedNode = (DOMCachedNode)cursor2.unwrap()).getUserData())).getXCI()) != null && xLXPCursor.allowFastSerialization(map2)) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "serialize", "About to provide fast serialization");
            }
            return new SerializerCDataDelegate(cursor2.fork(false), map2, this.isFullCopyOrSer(dOMCachedNode) ? this.fullCopier : this.subtreeCopier);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "serialize", "Could NOT (or didnt want to) provide fast serialization");
        }
        return super.serialize(cursor2, map2);
    }

    public boolean fastSerializationEnabled() {
        return this.fastSerialization;
    }

    public ItemCopier getItemCopier(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "getItemCopier", "requesting a new itemCopier for node: " + dOMCachedNode + " | isFullCopyOrSet?" + this.isFullCopyOrSer(dOMCachedNode));
        }
        return this.isFullCopyOrSer(dOMCachedNode) ? this.fullCopier : this.subtreeCopier;
    }

    public UserDataFactory getUserDataFactory(int n2) {
        if (n2 == 0) {
            return XCIOffsetDataImpl.FACTORY;
        }
        return new UserDataFactory(){

            public UserData create() {
                return new XCIOffsetAllData();
            }
        };
    }

    public void processParameters(Map map2) {
        super.processParameters(map2);
        this.isPreserveNamespaceDecls = MiscHelpers.isPreservedNamespaceDecls(map2);
    }

    protected OffsetData makeSubtreeOffset(XMLString xMLString) {
        OffsetDataImpl offsetDataImpl = new OffsetDataImpl();
        offsetDataImpl.setFirstDataBuffer(xMLString.firstBuffer);
        offsetDataImpl.setStartOffset(xMLString.startOffset);
        offsetDataImpl.setEndOffset(xMLString.endOffset);
        if (xMLString.lastBuffer == null) {
            offsetDataImpl.setLastDataBuffer(xMLString.firstBuffer);
        } else {
            offsetDataImpl.setLastDataBuffer(xMLString.lastBuffer);
        }
        return offsetDataImpl;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    protected static final class OffsetDataImpl
    implements OffsetData {
        protected int startOffset;
        protected int endOffset;
        protected DataBuffer firstBuffer;
        protected DataBuffer lastBuffer;

        OffsetDataImpl() {
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public DataBuffer getFirstDataBuffer() {
            return this.firstBuffer;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public void setEndOffset(int n2) {
            this.endOffset = n2;
        }

        public void setFirstDataBuffer(DataBuffer dataBuffer) {
            this.firstBuffer = dataBuffer;
        }

        public void setStartOffset(int n2) {
            this.startOffset = n2;
        }

        public DataBuffer getLastDataBuffer() {
            return this.lastBuffer;
        }

        public void setLastDataBuffer(DataBuffer dataBuffer) {
            this.lastBuffer = dataBuffer;
        }

        public boolean endOffsetKnown() {
            return this.lastBuffer != null;
        }

        public boolean startOffsetKnown() {
            return this.firstBuffer != null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class XCIOffsetAllData
    extends StreamingCursorMediator.XCIAllData
    implements StreamingCursorMediator.XCIData,
    OffsetData {
        protected int startOffset;
        protected int endOffset;
        protected DataBuffer firstBuffer;
        protected DataBuffer lastBuffer;

        XCIOffsetAllData() {
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public DataBuffer getFirstDataBuffer() {
            return this.firstBuffer;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public void setEndOffset(int n2) {
            this.endOffset = n2;
        }

        public void setFirstDataBuffer(DataBuffer dataBuffer) {
            this.firstBuffer = dataBuffer;
        }

        public void setStartOffset(int n2) {
            this.startOffset = n2;
        }

        public DataBuffer getLastDataBuffer() {
            return this.lastBuffer;
        }

        public void setLastDataBuffer(DataBuffer dataBuffer) {
            this.lastBuffer = dataBuffer;
        }

        public boolean endOffsetKnown() {
            return this.lastBuffer != null;
        }

        public boolean startOffsetKnown() {
            return this.firstBuffer != null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    protected static final class XCIOffsetDataImpl
    extends StreamingCursorMediator.XCIOriginalNodeDataImpl
    implements OffsetData {
        public static UserDataFactory FACTORY = new UserDataFactory(){

            public UserData create() {
                return new XCIOffsetDataImpl();
            }
        };
        protected int startOffset;
        protected int endOffset;
        protected DataBuffer firstBuffer;
        protected DataBuffer lastBuffer;
        public OffsetData subtreeOffset;

        protected XCIOffsetDataImpl() {
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public DataBuffer getFirstDataBuffer() {
            return this.firstBuffer;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public void setEndOffset(int n2) {
            this.endOffset = n2;
        }

        public void setFirstDataBuffer(DataBuffer dataBuffer) {
            this.firstBuffer = dataBuffer;
        }

        public void setStartOffset(int n2) {
            this.startOffset = n2;
        }

        public DataBuffer getLastDataBuffer() {
            return this.lastBuffer;
        }

        public void setLastDataBuffer(DataBuffer dataBuffer) {
            this.lastBuffer = dataBuffer;
        }

        public boolean endOffsetKnown() {
            return this.lastBuffer != null;
        }

        public boolean startOffsetKnown() {
            return this.firstBuffer != null;
        }

        public Object getMediatorData() {
            return this.mediatorData;
        }

        public void setMediatorData(Object object2) {
            this.mediatorData = object2;
        }

        public int addContent(Cursor.Area area, AddContentInterface addContentInterface) {
            if (this.firstBuffer == null || this.lastBuffer == null) {
                return 3;
            }
            XLXPCacheMediator.addContentAsBytes(addContentInterface, area, this);
            return 1;
        }

        public int addSubtreeContent(DOMCachedNode dOMCachedNode, Cursor.Area area, AddContentInterface addContentInterface) {
            if (this.firstBuffer == null) {
                return 3;
            }
            if (this.subtreeOffset == null) {
                XLXPCursor xLXPCursor = (XLXPCursor)this.getXCI();
                if (xLXPCursor != null && xLXPCursor.isFragment || LazyLoadingHelper.isFirstChildBuilt(dOMCachedNode.getState())) {
                    return 3;
                }
                dOMCachedNode.getCachedFollowingSibling();
                if (this.subtreeOffset == null) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, logger.getName(), "addSubtreeContent", "subtree was null even after we skipped the node!");
                    }
                    return 3;
                }
            }
            XLXPCacheMediator.addContentAsBytes(addContentInterface, area, this.subtreeOffset);
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "addSubtreeContent", "successfully copied the subtree contents of " + dOMCachedNode.toStringLazy());
            }
            return 4;
        }

        public String toString() {
            return "[offset range: " + this.startOffset + "-" + this.endOffset + "] : " + super.toString();
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static interface OffsetData {
        public int getStartOffset();

        public void setStartOffset(int var1);

        public int getEndOffset();

        public void setEndOffset(int var1);

        public DataBuffer getFirstDataBuffer();

        public void setFirstDataBuffer(DataBuffer var1);

        public DataBuffer getLastDataBuffer();

        public void setLastDataBuffer(DataBuffer var1);

        public boolean startOffsetKnown();

        public boolean endOffsetKnown();
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    protected final class ByteCopier
    implements ItemCopier {
        private final boolean full;

        protected ByteCopier(boolean bl) {
            this.full = bl;
        }

        public int copyNode(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
            short s;
            DOMCachedNode dOMCachedNode;
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                String string2 = null;
                if (cursor2.unwrap() instanceof DOMCachedNode) {
                    dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
                    string2 = dOMCachedNode.toStringLazy();
                }
                logger.logp(Level.FINER, logger.getName(), "copyNode", "copyNode from XLXPCacheMediator for source: " + string2);
            }
            if ((s = cursor2.itemKind()) != 4 && s != 2) {
                dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
                return XLXPCacheMediator.this.copyNode(dOMCachedNode, area, (AddContentInterface)((Object)cursor3), this.full);
            }
            return 3;
        }

        public Cursor.Profile sourceProfile() {
            return Copier.SOURCE_FEATURES;
        }

        public Cursor.Profile targetProfile(Cursor.Area area) {
            return Copier.TARGET_FEATURES;
        }
    }
}

