/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.DefaultResult;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.adapters.xlxp.XLXPCursor;
import com.ibm.xml.xci.adapters.xlxp.mediator.XLXPCacheMediator;
import com.ibm.xml.xci.adapters.xlxp.msg.XLXPXCIAdapterMessageProvider;
import com.ibm.xml.xci.adapters.xlxp.scanner.XCIScanner;
import com.ibm.xml.xci.adapters.xlxp.util.ScannerPool;
import com.ibm.xml.xci.adapters.xlxp.util.WeakReferenceManager;
import com.ibm.xml.xci.adapters.xlxp.util.XLXPSharedResources;
import com.ibm.xml.xci.dp.base.AbstractCursorFactory;
import com.ibm.xml.xci.dp.cache.CacheFactory;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.util.RequestInfoUtil;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.serializer.Serialize;
import com.ibm.xml.xci.type.SchemaResolver;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xlxp.internal.s1.grammar.Grammar;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.Version;
import com.ibm.xml.xlxp.internal.s1.scan.util.SymbolMapHolder;
import com.ibm.xml.xml4j.api.s1.xs.XSModel;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XLXPCursorFactory
extends AbstractCursorFactory {
    private static final Logger logger = LoggerUtil.getLogger(XLXPCursorFactory.class);
    private static final String NON_VALIDATING_MERGER_CONTEXT_KEY = "com.ibm.xml.xci.adapters.xlxp.XLXPCursorFactory.MergerContext.NON_VALIDATING";
    private static final String VALIDATING_MERGER_CONTEXT_KEY = "com.ibm.xml.xci.adapters.xlxp.XLXPCursorFactory.MergerContext.VALIDATING";
    public final SymbolMapHolder symbolMapHolder = new SymbolMapHolder();
    private final ScannerPool scannerPool = new ScannerPool();
    public final WeakReferenceManager weakReferenceManager = new WeakReferenceManager();
    public Stack<XLXPSharedResources> sharedResourcesPool;

    public XLXPCursorFactory(SessionContext sessionContext) {
        super(sessionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MergerContext getGrammars(SessionContext sessionContext, TypeRegistry typeRegistry, boolean bl) {
        if (typeRegistry == null) {
            return null;
        }
        TypeRegistry typeRegistry2 = typeRegistry;
        synchronized (typeRegistry2) {
            String string2 = bl ? VALIDATING_MERGER_CONTEXT_KEY : NON_VALIDATING_MERGER_CONTEXT_KEY;
            MergerContext mergerContext = (MergerContext)sessionContext.getUserData(string2);
            if (mergerContext == null) {
                mergerContext = new MergerContext(typeRegistry, bl);
                sessionContext.setUserData(string2, mergerContext);
            }
            mergerContext.convertGrammar();
            return mergerContext;
        }
    }

    public synchronized void returnScanner(XCIScanner xCIScanner, int n2) {
        if (xCIScanner.resourceOwner == null) {
            this.returnSharedResources(xCIScanner.sharedResources);
        }
        this.scannerPool.returnScanner(xCIScanner);
        if (n2 >= 0 && n2 < WeakReferenceManager.REFERENCE_ARRAY_SIZE) {
            this.weakReferenceManager.releaseEntry(n2);
        }
    }

    public String debugScannerPool() {
        return this.scannerPool.toString();
    }

    protected Cursor document(InputSource inputSource, RequestInfo requestInfo) {
        SessionContext sessionContext = this.getSessionContext();
        TypeRegistry typeRegistry = this.getSessionContext().getTypeRegistry();
        MergerContext mergerContext = this.getGrammars(sessionContext, typeRegistry, false);
        Boolean bl = (Boolean)RequestInfoUtil.getParameter(requestInfo, "http://www.ibm.com/xml/xci/instance/lax-assessment");
        if (bl == null) {
            bl = (Boolean)this.getSessionContext().getOption("http://www.ibm.com/xml/xci/instance/lax-assessment");
        }
        boolean bl2 = bl != null && bl != false;
        Boolean bl3 = (Boolean)this.getSessionContext().getOption("http://www.ibm.com/xml/xci/bo/bo-bc-mode");
        boolean bl4 = bl3 != null && bl3 != false;
        int n2 = 1 | (bl2 ? 64 : 0) | (bl4 ? 128 : 0) | 0x20 | 8;
        XLXPCursor xLXPCursor = this.createCursor(n2);
        xLXPCursor.scanner.setOwner(null);
        xLXPCursor.scanner.setExposeEncoding(RequestInfoUtil.hasHint(requestInfo, "ENCODING_DECL"));
        if (mergerContext != null) {
            ((XCIScanner)xLXPCursor.scanner).setIR(mergerContext.getGrammar());
            mergerContext.setDynamicSchemaResolverOnScanner((XCIScanner)xLXPCursor.scanner);
        } else {
            ((XCIScanner)xLXPCursor.scanner).setIR(null);
        }
        xLXPCursor.setProfile(requestInfo.getNeededFeatures(), requestInfo.getNeededFeatures());
        xLXPCursor.setupDocumentInfo(typeRegistry, this.getErrorHandler(requestInfo));
        xLXPCursor.setDocument(inputSource);
        boolean bl5 = RequestInfoUtil.hasHint(requestInfo, "EAGER_BUFFER_LOAD");
        boolean bl6 = RequestInfoUtil.hasHint(requestInfo, "CACHE");
        boolean bl7 = RequestInfoUtil.hasHint(requestInfo, "LAZY");
        boolean bl8 = RequestInfoUtil.hasHint(requestInfo, "FAST_SERIALIZATION");
        if (bl5) {
            xLXPCursor.loadAllBuffers(xLXPCursor.scanner.getCurrentStartDataBuffer());
        }
        if (bl6 && bl7 || bl8) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "document", "making an optimal object cache for this document call.");
            }
            return this.makeOptimalCache(xLXPCursor, requestInfo, bl8);
        }
        if (bl6) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "document", "making a regular object cache for this document call.");
            }
            return CacheFactory.make(xLXPCursor, requestInfo);
        }
        return this.proxy(xLXPCursor, requestInfo.getNeededFeatures(), false, requestInfo.getParameters(), requestInfo.getHints());
    }

    private Cursor makeOptimalCache(Cursor cursor2, RequestInfo requestInfo, boolean bl) {
        XLXPCacheMediator xLXPCacheMediator = new XLXPCacheMediator(cursor2, requestInfo.getNeededFeatures(), bl);
        Map<String, Object> map2 = requestInfo.getParameters();
        if (map2 != null && MiscHelpers.getBoolean("SDOX_WRAPPER", map2, false)) {
            return CacheFactory.makeDummyCache(xLXPCacheMediator);
        }
        return CacheFactory.make(xLXPCacheMediator, requestInfo);
    }

    protected XLXPCursor createCursor(int n2) {
        XCIScanner xCIScanner = this.getScanner(n2, null);
        xCIScanner.wasReleased = false;
        xCIScanner.isZombieParent = false;
        XLXPCursor xLXPCursor = new XLXPCursor(this, xCIScanner);
        this.weakReferenceManager.register(xLXPCursor);
        return xLXPCursor;
    }

    public synchronized XCIScanner getScanner(int n2, XLXPSharedResources xLXPSharedResources) {
        boolean bl = true;
        if (xLXPSharedResources == null) {
            xLXPSharedResources = this.fetchSharedResources();
        }
        XCIScanner xCIScanner = this.scannerPool.getScanner((n2 & 4) != 0);
        if (xCIScanner == null && (xCIScanner = (XCIScanner)this.weakReferenceManager.fetch()) == null) {
            bl = false;
            xCIScanner = new XCIScanner(xLXPSharedResources, n2);
        }
        if (xCIScanner.features() != n2) {
            bl = false;
            xCIScanner = new XCIScanner(xLXPSharedResources, n2);
        }
        if (bl) {
            xCIScanner.setSharedResources(xLXPSharedResources);
        }
        xCIScanner.referenceCount = 1;
        return xCIScanner;
    }

    protected Cursor document(InputStream inputStream, RequestInfo requestInfo) {
        return this.document(new InputSource(inputStream), requestInfo);
    }

    protected Cursor document(Reader reader, RequestInfo requestInfo) {
        return this.document(new InputSource(reader), requestInfo);
    }

    protected Cursor document(Writer writer, RequestInfo requestInfo) {
        return this.proxy(Serialize.getTargetCursor((CursorFactory)this, writer, requestInfo.getParameters()), requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), requestInfo.getHints());
    }

    protected Cursor document(OutputStream outputStream, RequestInfo requestInfo) {
        return this.proxy(Serialize.getTargetCursor((CursorFactory)this, outputStream, requestInfo.getParameters()), requestInfo.getNeededFeatures(), requestInfo.isSelfOnly(), requestInfo.getParameters(), requestInfo.getHints());
    }

    public String getMediaType() {
        return "text/xml";
    }

    public Cursor document(Source source, RequestInfo requestInfo) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, logger.getName(), "document", "document call in XLXPCursorFactory with a Source obj");
        }
        if (source == null) {
            return this.document(requestInfo);
        }
        if (source instanceof StreamSource) {
            InputSource inputSource;
            StreamSource streamSource = (StreamSource)source;
            String string2 = source.getSystemId();
            Reader reader = streamSource.getReader();
            if (reader != null) {
                inputSource = new InputSource(reader);
                inputSource.setSystemId(string2);
            } else {
                InputStream inputStream = streamSource.getInputStream();
                if (inputStream != null) {
                    inputSource = new InputSource(inputStream);
                    inputSource.setSystemId(string2);
                } else if (string2 != null) {
                    inputSource = new InputSource(string2);
                } else {
                    throw new XCIIllegalArgumentException(XLXPXCIAdapterMessageProvider.createMessage(null, 0));
                }
            }
            inputSource.setPublicId(streamSource.getPublicId());
            inputSource.setEncoding(requestInfo.getEncoding());
            return this.document(inputSource, requestInfo);
        }
        throw new XCIIllegalArgumentException(XLXPXCIAdapterMessageProvider.createMessage(null, 1, source.getClass().getName()));
    }

    public Cursor document(Result result2, RequestInfo requestInfo) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, logger.getName(), "document", "document call in XLXPCursorFactory with a Result obj");
        }
        if (result2 instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result2;
            if (streamResult.getOutputStream() != null) {
                return this.document(streamResult.getOutputStream(), requestInfo);
            }
            if (streamResult.getWriter() != null) {
                return this.document(streamResult.getWriter(), requestInfo);
            }
        } else if (result2 instanceof DefaultResult) {
            return super.document(requestInfo);
        }
        FFDCUtil.log(XCIErrorHelper.createInternalException("XLXPCursorFactory.document could not be completed"), this);
        return null;
    }

    public static String getXLXPVersion() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("XLXP - Scanner version: ");
        stringBuilder.append(Version.getVersion());
        stringBuilder.append(", Time Stamp: ");
        stringBuilder.append(Version.getBuildTimeStamp());
        stringBuilder.append("\nRuntime version: ");
        stringBuilder.append(com.ibm.xml.xlxp.internal.s1.runtime.Version.getVersion());
        stringBuilder.append(", Time Stamp: ");
        stringBuilder.append(com.ibm.xml.xlxp.internal.s1.runtime.Version.getBuildTimeStamp());
        return stringBuilder.toString();
    }

    public XLXPSharedResources fetchSharedResources() {
        if (this.sharedResourcesPool == null || this.sharedResourcesPool.isEmpty()) {
            return new XLXPSharedResources(this);
        }
        XLXPSharedResources xLXPSharedResources = this.sharedResourcesPool.pop();
        xLXPSharedResources.getBufferFactory().reset(true);
        return xLXPSharedResources;
    }

    public void returnSharedResources(XLXPSharedResources xLXPSharedResources) {
        if (this.sharedResourcesPool == null) {
            this.sharedResourcesPool = new Stack();
        }
        xLXPSharedResources.getBufferFactory().unregisterReferrers();
        this.sharedResourcesPool.push(xLXPSharedResources);
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class MergerContext
    extends com.ibm.xml.xlxp.internal.s1.converter.MergerContext {
        private final TypeRegistry tr;

        public MergerContext(TypeRegistry typeRegistry, boolean bl) {
            super(bl);
            this.tr = typeRegistry;
        }

        public void setGrammarVersionOnScanner(VMContext vMContext, int n2) {
            vMContext.setGrammarVersion(n2);
        }

        public int getGrammarVersionFromScanner(VMContext vMContext) {
            return vMContext.getGrammarVersion();
        }

        public void setDynamicSchemaResolverOnScanner(VMContext vMContext) {
            vMContext.setDynamicSchemaResolver(this.merger);
        }

        public Grammar getGrammar() {
            return this.grammar;
        }

        public XSModel getXSModel() {
            if (this.tr == null) {
                XCIIllegalArgumentException xCIIllegalArgumentException = new XCIIllegalArgumentException(XLXPXCIAdapterMessageProvider.createMessage(null, 3));
                FFDCUtil.log(xCIIllegalArgumentException, this);
                throw xCIIllegalArgumentException;
            }
            return this.tr.getXSModel();
        }

        private boolean dynamicallyLoadSchemas(String string2, String string3, short s, TypeRegistry typeRegistry) {
            SchemaResolver schemaResolver = typeRegistry.getSchemaResolver();
            if (schemaResolver == null) {
                return false;
            }
            SchemaResolver.SchemaComponentType schemaComponentType = null;
            switch (s) {
                case 2: {
                    schemaComponentType = SchemaResolver.SchemaComponentType.ELEMENT;
                    break;
                }
                case 1: {
                    schemaComponentType = SchemaResolver.SchemaComponentType.ATTRIBUTE;
                    break;
                }
                case 3: {
                    schemaComponentType = SchemaResolver.SchemaComponentType.TYPE;
                }
            }
            List list = Collections.EMPTY_LIST;
            List<? extends Source> list2 = schemaResolver.resolve(TypeRegistry.createSchemaIdentifier(string2, string3, schemaComponentType, list, null));
            if (list2 == null || list2.size() == 0) {
                return false;
            }
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder("*** Returning schema documents from SchemaResolver. ***\n");
                for (Source source : list2) {
                    stringBuilder.append(source.getSystemId());
                    stringBuilder.append('\n');
                }
                logger.logp(Level.FINEST, logger.getName(), "dynamicallyLoadSchemas", stringBuilder.toString());
            }
            typeRegistry.load(list2);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleUnknownComponent(VMContext vMContext, String string2, String string3, short s) {
            if (this.tr == null) {
                return false;
            }
            TypeRegistry typeRegistry = this.tr;
            synchronized (typeRegistry) {
                if (!this.dynamicallyLoadSchemas(string2, string3, s, this.tr)) {
                    return false;
                }
                MergerContext.threadDebug("mergeGrammar about to be called");
                boolean bl = this.mergeGrammar(vMContext);
                MergerContext.threadDebug("mergeGrammar", bl);
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUntilUpdateComplete() {
            if (this.tr != null) {
                TypeRegistry typeRegistry = this.tr;
                synchronized (typeRegistry) {
                    MergerContext.threadDebug("waiting for update completion");
                }
            }
        }
    }
}

