/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.xlxp;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.DocumentInfo;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.adapters.xlxp.XLXPCursorFactory;
import com.ibm.xml.xci.adapters.xlxp.XLXPDocumentInfo;
import com.ibm.xml.xci.adapters.xlxp.msg.XLXPXCIAdapterMessageProvider;
import com.ibm.xml.xci.adapters.xlxp.scanner.DelegatingSubtreeScanner;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.errors.XCIIllegalContextItemException;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xci.xlxp.Scanner;
import com.ibm.xml.xci.xlxp.cdata.XLXPCDataFactory;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xml4j.api.s1.xs.XSAttributeDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSComplexTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.DOMErrorHandler;
import org.xml.sax.InputSource;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XLXPCursor
extends AbstractCursor {
    private static final Logger logger = LoggerUtil.getLogger(XLXPCursor.class);
    protected static final int ATTRIBUTE_SEQUENCE = 0;
    protected static final int NODE_SEQUENCE = 1;
    protected static final int ATTRIBUTE_SELF = 2;
    protected static final int NODE_SELF = 3;
    protected static final int NAMESPACE_SEQUENCE = 4;
    protected static final int NAMESPACE_SELF = 5;
    protected static final Cursor.Profile XLXP_PROFILE_LIMIT = Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION.union(Cursor.Profile.TO_SELF);
    protected Cursor.Profile currentProfile;
    protected Cursor.Profile profileLimit;
    public final Scanner scanner;
    protected int state;
    protected int attrIdx;
    protected int nsdeclIdx;
    private VolatileCData fItemName;
    protected XSTypeDefinition xstype;
    protected XSTypeDefinition simpleContainingElementTypeDefinition;
    protected boolean atNextEvent;
    protected int cursorDepth;
    private String fEmptyString = null;
    protected final char[] fSurrogatePair;
    protected boolean lazyState;
    public boolean isFragment;
    private XLXPCDataFactory cdataFactory;

    public XLXPCursor(XLXPCursorFactory xLXPCursorFactory, Scanner scanner, Cursor.Profile profile, Cursor.Profile profile2) {
        super(xLXPCursorFactory);
        this.scanner = scanner;
        this.setProfile(profile, profile2);
        this.fSurrogatePair = ArrayAllocator.newCharArray(2);
        this.cdataFactory = new XLXPCDataFactory();
    }

    public XLXPCursor(XLXPCursorFactory xLXPCursorFactory, Scanner scanner) {
        this(xLXPCursorFactory, scanner, XLXP_PROFILE_LIMIT, XLXP_PROFILE_LIMIT);
    }

    public String emptyString() {
        if (this.fEmptyString == null) {
            this.fEmptyString = this.scanner.getSymbolTable().addSymbol("");
        }
        return this.fEmptyString;
    }

    public void setProfile(Cursor.Profile profile, Cursor.Profile profile2) {
        if (profile2.containedIn(XLXP_PROFILE_LIMIT)) {
            this.profileLimit = profile2;
        }
        if (profile.containedIn(this.profileLimit)) {
            this.currentProfile = profile;
        }
    }

    protected void reset() {
        this.fItemName = null;
        this.xstype = null;
    }

    protected void setupDocumentInfo(TypeRegistry typeRegistry, DOMErrorHandler dOMErrorHandler) {
        XLXPDocumentInfo xLXPDocumentInfo = this.scanner.documentInfo();
        xLXPDocumentInfo.setTypeRegistry(typeRegistry);
        xLXPDocumentInfo.setErrorHandler(dOMErrorHandler);
    }

    protected final void skipSubtree() {
        assert (this.scanner.currentEvent() == 2);
        int n2 = 1;
        block4: while (n2 != 0 || this.scanner.currentEvent() != 4) {
            switch (this.scanner.nextEvent()) {
                case 2: {
                    ++n2;
                    continue block4;
                }
                case 4: {
                    --n2;
                    continue block4;
                }
            }
        }
        assert (this.scanner.currentEvent() == 4);
    }

    public int getStartOffset() {
        return this.scanner.getCurrentStartOffset();
    }

    public DataBuffer getStartDataBuffer() {
        return this.scanner.getCurrentStartDataBuffer();
    }

    public int getEndOffset() {
        return this.scanner.getCurrentEndOffset();
    }

    public DataBuffer getEndDataBuffer() {
        return this.scanner.getCurrentEndDataBuffer();
    }

    public final boolean loadMore() {
        return this.scanner.loadMore();
    }

    public void registerReferrer() {
        this.scanner.registerReferrer();
    }

    public void unregisterReferrer() {
        this.scanner.unregisterReferrer();
    }

    public Cursor.Profile profile() {
        return this.currentProfile;
    }

    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    public Cursor.Profile futureProfile() {
        return this.profileLimit;
    }

    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        assert (bl) : "Trying to call XLXPCursor's fork with mustNavigate set to false !";
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "fork", "forking the XLXPCursor, lazyState=" + this.lazyState);
        }
        if (!this.lazyState) {
            ++this.cursorDepth;
            return this;
        }
        this.lazyState = false;
        Scanner scanner = this.scanner.skipSubtree();
        if (!(scanner instanceof DelegatingSubtreeScanner)) {
            ++this.cursorDepth;
            return this;
        }
        return this.subtreeCursor(scanner);
    }

    protected XLXPCursor subtreeCursor(Scanner scanner) {
        XLXPCursor xLXPCursor = new XLXPCursor((XLXPCursorFactory)this.factory, scanner);
        xLXPCursor.state = 1;
        xLXPCursor.atNextEvent = false;
        xLXPCursor.cursorDepth = 1;
        xLXPCursor.isFragment = true;
        ((XLXPCursorFactory)this.factory).weakReferenceManager.register(xLXPCursor);
        return xLXPCursor;
    }

    public void release() {
        assert (null == this.forkReleaseInstanceTracker || this.forkReleaseInstanceTracker.checkAndRecordRelease(false, this));
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "release", "releasing the XLXPCursor.  depth = " + this.cursorDepth);
        }
        switch (this.scanner.currentEvent()) {
            case 4: {
                this.simpleContainingElementTypeDefinition = null;
                break;
            }
            case 18: {
                this.simpleContainingElementTypeDefinition = null;
                break;
            }
        }
        if (this.cursorDepth <= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Called XLXPCursor.release too many times.");
            stringBuilder.append("\nStack Trace = ");
            stringBuilder.append(XCIErrorHelper.getStackTrace(10));
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "release", stringBuilder.toString());
            }
            FFDCUtil.log(XCIErrorHelper.createInternalException("Called XLXPCursor.release too many times"), this);
        }
        if (this.cursorDepth > 0) {
            --this.cursorDepth;
        }
        if (this.cursorDepth == 0) {
            this.scanner.checkReferences();
        }
        this.state = 1;
        this.reset();
    }

    public String debugScannerPool() {
        return ((XLXPCursorFactory)this.factory).debugScannerPool();
    }

    public void setDocument(InputSource inputSource) {
        this.scanner.setDocument(inputSource);
        this.scanner.nextEvent();
        assert (this.scanner.currentEvent() == 1);
        this.state = 1;
        this.atNextEvent = false;
        this.cursorDepth = 1;
    }

    public DocumentInfo itemDocumentInfo() {
        return this.scanner.documentInfo();
    }

    public short itemKind() {
        switch (this.scanner.currentEvent()) {
            case 1: {
                return 9;
            }
            case 2: 
            case 3: {
                switch (this.state) {
                    case 0: 
                    case 2: {
                        return 2;
                    }
                    case 4: 
                    case 5: {
                        return 4;
                    }
                }
                return 1;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 15: {
                return 3;
            }
            case 10: {
                return 7;
            }
            case 11: {
                return 8;
            }
            case 4: 
            case 14: 
            case 18: {
                return -1;
            }
            case 16: 
            case 17: {
                return -1;
            }
        }
        XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(XLXPXCIAdapterMessageProvider.createMessage(null, 4, this.scanner.currentEvent(), "itemKind()"));
        FFDCUtil.log(xCIDynamicErrorException, this);
        throw xCIDynamicErrorException;
    }

    public VolatileCData itemName() {
        if (this.fItemName == null) {
            block0 : switch (this.scanner.currentEvent()) {
                case 2: 
                case 3: {
                    switch (this.state) {
                        case 0: 
                        case 2: {
                            this.fItemName = this.cdataFactory.createXLXPQNameCData(this.scanner.attributeName(this.attrIdx), TypeRegistry.XSQNAME);
                            break block0;
                        }
                        case 4: 
                        case 5: {
                            String string2 = this.scanner.nsDeclPrefix(this.nsdeclIdx);
                            if (string2 != null && string2.length() > 0) {
                                this.fItemName = this.cdataFactory.createNamespaceCData(string2);
                                break block0;
                            }
                            this.fItemName = this.cdataFactory.createNamespaceCData(this.emptyString());
                            break block0;
                        }
                    }
                    this.fItemName = this.cdataFactory.createXLXPQNameCData(this.scanner.elementQName(), TypeRegistry.XSQNAME);
                    break;
                }
                case 10: {
                    this.fItemName = this.factory.data(null, this.scanner.piTarget().toString(), null);
                    break;
                }
                default: {
                    return this.factory.data(TypeRegistry.XSQNAME);
                }
            }
        }
        return this.fItemName;
    }

    public ExtendedNamespaceContext itemNamespaceContext() {
        return this.scanner.nscontext();
    }

    public ExtendedNamespaceContext itemNamespaceContext(boolean bl) {
        return this.scanner.nscontext();
    }

    private XSTypeDefinition itemActualXSType() {
        if (this.xstype == null) {
            switch (this.scanner.currentEvent()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 13: 
                case 14: 
                case 15: {
                    if (this.simpleContainingElementTypeDefinition != null) {
                        this.xstype = this.simpleContainingElementTypeDefinition;
                        break;
                    }
                }
                default: {
                    return this.itemXSType();
                }
            }
        }
        return this.xstype;
    }

    public XSTypeDefinition itemXSType() {
        if (this.xstype == null) {
            switch (this.scanner.currentEvent()) {
                case 2: 
                case 3: {
                    if (this.state == 2 || this.state == 0) {
                        XSAttributeDeclaration xSAttributeDeclaration = this.scanner.getAttributeDeclaration(this.attrIdx);
                        this.xstype = xSAttributeDeclaration == null ? TypeRegistry.XSUNTYPEDATOMIC : xSAttributeDeclaration.getTypeDefinition();
                        break;
                    }
                    if (this.state == 5 || this.state == 4) {
                        this.xstype = null;
                        break;
                    }
                    this.xstype = this.scanner.getTypeDefinition();
                    if (this.xstype != null) break;
                    this.xstype = TypeRegistry.XSUNTYPED;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 13: 
                case 14: 
                case 15: {
                    this.xstype = TypeRegistry.XSUNTYPEDATOMIC;
                    break;
                }
                case 1: 
                case 10: 
                case 11: {
                    this.xstype = null;
                    break;
                }
                default: {
                    XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(XLXPXCIAdapterMessageProvider.createMessage(null, 4, this.scanner.currentEvent(), "itemXSType()"));
                    FFDCUtil.log(xCIDynamicErrorException, this);
                    throw xCIDynamicErrorException;
                }
            }
        }
        return this.xstype;
    }

    public XSElementDeclaration itemXSElementDeclaration() {
        int n2 = this.scanner.currentEvent();
        if (!(n2 != 2 && n2 != 3 || this.state != 3 && this.state != 1)) {
            return this.scanner.getElementDeclaration();
        }
        return null;
    }

    public XSAttributeDeclaration itemXSAttributeDeclaration() {
        int n2 = this.scanner.currentEvent();
        if (!(n2 != 2 && n2 != 3 || this.state != 2 && this.state != 0)) {
            return this.scanner.getAttributeDeclaration(this.attrIdx);
        }
        return null;
    }

    public VolatileCData itemValue() {
        switch (this.scanner.currentEvent()) {
            case 10: 
            case 11: {
                return this.getXMLStringCData(this.scanner.content(), TypeRegistry.XSSTRING, null);
            }
            case 5: 
            case 6: 
            case 7: {
                if (this.scanner.isMarkupNext()) {
                    return this.getXMLStringCData(this.scanner.content(), (XSSimpleTypeDefinition)this.itemActualXSType(), this.scanner.nscontext());
                }
            }
            case 8: 
            case 9: {
                return this.factory.data((CharSequence)this.getText(), (XSSimpleTypeDefinition)this.itemActualXSType(), false);
            }
            case 2: 
            case 3: {
                if (this.state == 0 || this.state == 2) {
                    if (this.scanner.attributeSpecified(this.attrIdx)) {
                        return this.getXMLStringCData(this.scanner.attributeValue(this.attrIdx), (XSSimpleTypeDefinition)this.itemXSType(), this.scanner.nscontext());
                    }
                    return this.getXMLStringCData(this.scanner.getFixedAttrValue(this.attrIdx), (XSSimpleTypeDefinition)this.itemXSType(), this.scanner.nscontext());
                }
                if (this.state == 4 || this.state == 5) {
                    String string2 = this.scanner.nsDeclURI(this.nsdeclIdx);
                    return new StringCData(string2, TypeRegistry.XSSTRING);
                }
                return this.elementTypedValue();
            }
            case 1: {
                return this.factory.data((CharSequence)this.getDocumentText(), TypeRegistry.XSUNTYPEDATOMIC, false);
            }
        }
        XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(XLXPXCIAdapterMessageProvider.createMessage(null, 4, this.scanner.currentEvent(), "itemValue()"));
        FFDCUtil.log(xCIDynamicErrorException, this);
        throw xCIDynamicErrorException;
    }

    public VolatileCData itemTypedValue() {
        switch (this.scanner.currentEvent()) {
            case 5: 
            case 6: 
            case 7: {
                if (this.scanner.isMarkupNext()) {
                    return this.getXMLStringCData(this.scanner.content(), TypeRegistry.XSUNTYPEDATOMIC, this.scanner.nscontext());
                }
            }
            case 8: 
            case 9: {
                return this.factory.data((CharSequence)this.getText(), TypeRegistry.XSUNTYPEDATOMIC, false);
            }
        }
        return this.itemValue();
    }

    protected Chars itemSValue() {
        switch (this.scanner.currentEvent()) {
            case 10: 
            case 11: {
                return this.getXMLStringCData(this.scanner.content(), TypeRegistry.XSSTRING, null);
            }
            case 5: 
            case 6: 
            case 7: {
                if (this.scanner.isMarkupNext()) {
                    return this.getXMLStringCData(this.scanner.content(), TypeRegistry.XSSTRING, this.scanner.nscontext());
                }
            }
            case 8: 
            case 9: {
                return this.factory.data((CharSequence)this.getText(), TypeRegistry.XSSTRING, false);
            }
            case 2: 
            case 3: {
                if (this.state == 0 || this.state == 2) {
                    if (this.scanner.attributeSpecified(this.attrIdx)) {
                        return this.getXMLStringCData(this.scanner.attributeValue(this.attrIdx), TypeRegistry.XSSTRING, this.scanner.nscontext());
                    }
                    return this.getXMLStringCData(this.scanner.getFixedAttrValue(this.attrIdx), TypeRegistry.XSSTRING, this.scanner.nscontext());
                }
                if (this.state == 4 || this.state == 5) {
                    String string2 = this.scanner.nsDeclURI(this.nsdeclIdx);
                    return new StringCData(string2, TypeRegistry.XSSTRING);
                }
                if (this.scanner.currentEvent() == 3) {
                    if (this.scanner.elementValue() != null) {
                        return this.getXMLStringCData(this.scanner.content(), TypeRegistry.XSSTRING, this.scanner.nscontext());
                    }
                    return this.factory().data((CharSequence)"", TypeRegistry.XSSTRING, false);
                }
                return this.factory().data((CharSequence)this.getElementText(), TypeRegistry.XSSTRING, false);
            }
            case 1: {
                return this.factory.data((CharSequence)this.getDocumentText(), TypeRegistry.XSSTRING, false);
            }
        }
        XCIDynamicErrorException xCIDynamicErrorException = new XCIDynamicErrorException(XLXPXCIAdapterMessageProvider.createMessage(null, 4, this.scanner.currentEvent(), "itemSValue()"));
        FFDCUtil.log(xCIDynamicErrorException, this);
        throw xCIDynamicErrorException;
    }

    public boolean itemNilled() {
        switch (this.scanner.currentEvent()) {
            case 2: {
                return this.scanner.nilled();
            }
            case 3: {
                return this.scanner.leafNilled();
            }
        }
        return false;
    }

    public boolean toAttributes(NodeTest nodeTest) {
        if (this.state != 1 && this.state != 3) {
            return false;
        }
        switch (this.scanner.currentEvent()) {
            case 2: 
            case 3: {
                if (this.scanner.attributeCount() <= 0) break;
                this.state = 0;
                this.attrIdx = 0;
                this.reset();
                return true;
            }
        }
        return false;
    }

    public boolean toNamespaceDecls() {
        if (this.state != 1 && this.state != 3) {
            return false;
        }
        switch (this.scanner.currentEvent()) {
            case 2: 
            case 3: {
                if (this.scanner.nsDeclCount() <= 0) break;
                this.state = 4;
                this.nsdeclIdx = 0;
                this.reset();
                return true;
            }
        }
        return false;
    }

    public boolean toChildren(NodeTest nodeTest) {
        int n2 = this.scanner.currentEvent();
        if (n2 == 1 || n2 == 2) {
            if (this.state != 1 && this.state != 3) {
                return false;
            }
            XSTypeDefinition xSTypeDefinition = this.scanner.getTypeDefinition();
            int n3 = this.scanner.nextEvent();
            if (n3 == 4 || n3 == 18) {
                return false;
            }
            if (xSTypeDefinition != null && xSTypeDefinition.getTypeCategory() == 16) {
                this.simpleContainingElementTypeDefinition = xSTypeDefinition;
            }
            this.state = 1;
            this.reset();
            return true;
        }
        return false;
    }

    public boolean toNext() {
        switch (this.state) {
            case 2: 
            case 3: 
            case 5: {
                return false;
            }
            case 0: {
                if (this.scanner.attributeCount() > this.attrIdx + 1) {
                    ++this.attrIdx;
                    this.reset();
                    return true;
                }
                return false;
            }
            case 4: {
                if (this.scanner.nsDeclCount() > this.nsdeclIdx + 1) {
                    ++this.nsdeclIdx;
                    this.reset();
                    return true;
                }
                return false;
            }
            case 1: {
                if (this.scanner.currentEvent() == 2) {
                    this.skipSubtree();
                } else if (this.scanner.currentEvent() == 18) {
                    if (this.atNextEvent) {
                        this.atNextEvent = false;
                    }
                    return false;
                }
                boolean bl = this.isTextEvent();
                this.scanner.nextEvent();
                if (bl && this.isTextEvent()) {
                    do {
                        this.scanner.nextEvent();
                    } while (!this.isTextEvent());
                }
                switch (this.scanner.currentEvent()) {
                    case 18: {
                        this.atNextEvent = true;
                    }
                    case 4: {
                        return false;
                    }
                }
                this.reset();
                return true;
            }
        }
        return false;
    }

    public boolean toSelf() {
        switch (this.state) {
            case 0: 
            case 2: {
                this.state = 2;
                break;
            }
            case 4: 
            case 5: {
                this.state = 5;
                break;
            }
            case 1: 
            case 3: {
                this.state = 3;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private String getDocumentText() {
        assert (this.scanner.currentEvent() == 1);
        StringBuilder stringBuilder = new StringBuilder();
        block5: while (true) {
            switch (this.scanner.nextEvent()) {
                case 5: 
                case 6: 
                case 7: {
                    stringBuilder.append(this.scanner.content().toString());
                    continue block5;
                }
                case 8: 
                case 9: {
                    if (this.scanner.singleCh() < 65536) {
                        stringBuilder.append(String.valueOf((char)this.scanner.singleCh()));
                        continue block5;
                    }
                    int n2 = this.scanner.singleCh() - 65536;
                    this.fSurrogatePair[0] = (char)(55296 + (n2 >> 10));
                    this.fSurrogatePair[1] = (char)(56320 + (n2 & 0x3FF));
                    stringBuilder.append(new String(this.fSurrogatePair));
                    continue block5;
                }
                case 18: {
                    return stringBuilder.toString();
                }
            }
        }
    }

    protected String getText() {
        assert (this.isTextEvent());
        StringBuilder stringBuilder = new StringBuilder();
        this.scanner.setProcessingText(true);
        while (true) {
            switch (this.scanner.currentEvent()) {
                case 5: 
                case 6: 
                case 7: {
                    stringBuilder.append(this.scanner.content().toString());
                    break;
                }
                case 8: 
                case 9: {
                    if (this.scanner.singleCh() < 65536) {
                        stringBuilder.append(String.valueOf((char)this.scanner.singleCh()));
                        break;
                    }
                    int n2 = this.scanner.singleCh() - 65536;
                    this.fSurrogatePair[0] = (char)(55296 + (n2 >> 10));
                    this.fSurrogatePair[1] = (char)(56320 + (n2 & 0x3FF));
                    stringBuilder.append(new String(this.fSurrogatePair));
                }
            }
            if (this.scanner.isMarkupNext()) break;
            this.scanner.nextEvent();
        }
        this.scanner.setProcessingText(false);
        return stringBuilder.toString();
    }

    protected XMLString getSimpleElementText() {
        assert (this.scanner.currentEvent() == 2);
        int n2 = 1;
        int n3 = 1;
        block4: while (n3 != 0) {
            switch (this.scanner.nextEvent()) {
                case 2: {
                    n2 = ++n3;
                    continue block4;
                }
                case 4: {
                    --n3;
                    continue block4;
                }
            }
        }
        if (n2 == 1) {
            return this.scanner.getElementString();
        }
        return null;
    }

    protected String getElementText() {
        assert (this.scanner.currentEvent() == 2);
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 1;
        block6: while (n2 != 0) {
            switch (this.scanner.nextEvent()) {
                case 5: 
                case 6: 
                case 7: {
                    stringBuilder.append(this.scanner.content().toString());
                    continue block6;
                }
                case 8: 
                case 9: {
                    if (this.scanner.singleCh() < 65536) {
                        stringBuilder.append(String.valueOf((char)this.scanner.singleCh()));
                        continue block6;
                    }
                    int n3 = this.scanner.singleCh() - 65536;
                    this.fSurrogatePair[0] = (char)(55296 + (n3 >> 10));
                    this.fSurrogatePair[1] = (char)(56320 + (n3 & 0x3FF));
                    stringBuilder.append(new String(this.fSurrogatePair));
                    continue block6;
                }
                case 2: {
                    ++n2;
                    continue block6;
                }
                case 4: {
                    --n2;
                    continue block6;
                }
            }
        }
        return stringBuilder.toString();
    }

    private VolatileCData elementTypedValue() {
        XSTypeDefinition xSTypeDefinition = this.scanner.getTypeDefinition();
        XSSimpleTypeDefinition xSSimpleTypeDefinition = TypeRegistry.XSUNTYPEDATOMIC;
        if (xSTypeDefinition != null) {
            if (xSTypeDefinition.getTypeCategory() == 16) {
                xSSimpleTypeDefinition = (XSSimpleTypeDefinition)xSTypeDefinition;
            } else {
                short s = ((XSComplexTypeDefinition)xSTypeDefinition).getContentType();
                if (s == 1) {
                    xSSimpleTypeDefinition = ((XSComplexTypeDefinition)xSTypeDefinition).getSimpleType();
                } else {
                    if (s == 2) {
                        throw new XCIIllegalContextItemException("ER_ELEMCONTENT_VALUE", null);
                    }
                    if (s == 0) {
                        return null;
                    }
                }
            }
        }
        if (xSSimpleTypeDefinition != TypeRegistry.XSUNTYPEDATOMIC) {
            XMLString xMLString = this.getSimpleElementText();
            return xMLString != null ? this.getXMLStringCData(xMLString, xSSimpleTypeDefinition, this.scanner.nscontext()) : null;
        }
        return this.factory.data((CharSequence)this.getElementText(), xSSimpleTypeDefinition, false);
    }

    private boolean isTextEvent() {
        int n2 = this.scanner.currentEvent();
        return n2 > 4 && n2 < 10 || n2 == 13 || n2 == 15;
    }

    public void setLazy(boolean bl) {
        this.lazyState = bl;
    }

    public boolean allowFastSerialization(Map map2) {
        boolean bl;
        boolean bl2 = bl = this.scanner.entityDepth() <= 1;
        if (!bl) {
            return bl;
        }
        if (map2 != null && map2.size() > 0) {
            Object v = map2.get("{http://ibm.com/xml/xci/serializer}fast-ser");
            if (v != null) {
                return (Boolean)v != false;
            }
            int n2 = map2.size();
            if (n2 > 2) {
                return false;
            }
            for (String string2 : map2.keySet()) {
                String string3;
                if ("omit-xml-declaration".equals(string2) || "encoding".equals(string2) && (string3 = (String)map2.get(string2)) != null && string3.equalsIgnoreCase("UTF-8")) continue;
                return false;
            }
        }
        return bl;
    }

    public VolatileCData getXMLStringCData(XMLString xMLString, XSSimpleTypeDefinition xSSimpleTypeDefinition, NamespaceContext namespaceContext) {
        int n2 = this.state == 0 || this.state == 2 ? this.attrIdx : -1;
        return this.cdataFactory.createXMLStringCData(xMLString, xSSimpleTypeDefinition, this.scanner, this.factory.getSessionContext().getErrorHandler(), n2);
    }

    public DataBuffer loadAllBuffers(DataBuffer dataBuffer) {
        this.loadMore();
        while (dataBuffer.next != null) {
            if (dataBuffer.next == null) {
                return dataBuffer;
            }
            dataBuffer = dataBuffer.next;
        }
        return dataBuffer;
    }

    public Cursor.ItemValueOrigin itemAttributeValueOrigin() {
        if (this.itemKind() != 2) {
            return null;
        }
        if (this.scanner.attributeSpecified(this.attrIdx)) {
            return Cursor.ItemValueOrigin.SPECIFIED;
        }
        return Cursor.ItemValueOrigin.XSDDEFAULTED;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
        return this;
    }
}

