/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.dom;

import com.ibm.xml.xci.adapters.dom.DOMAdapter;
import org.w3c.dom.Node;

public class NodeVectorLazy {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private int m_blocksize;
    private Node[] m_map;
    private int m_firstFree = 0;
    private int m_mapSize;
    private boolean _isLazy = false;
    private boolean _isForwardOrderedAndUnique;

    public NodeVectorLazy() {
        this.m_mapSize = this.m_blocksize = 32;
        this.m_map = new Node[this.m_blocksize];
        this._isForwardOrderedAndUnique = true;
        this._isLazy = false;
    }

    public NodeVectorLazy(int n2) {
        this.m_blocksize = n2;
        this.m_mapSize = n2;
        this.m_map = new Node[n2];
        this._isForwardOrderedAndUnique = true;
        this._isLazy = false;
    }

    public NodeVectorLazy(int n2, int n3) {
        this.m_blocksize = n3;
        this.m_mapSize = n2;
        this.m_map = new Node[n2];
        this._isForwardOrderedAndUnique = true;
        this._isLazy = false;
    }

    public NodeVectorLazy(NodeVectorLazy nodeVectorLazy) {
        this.m_map = new Node[nodeVectorLazy.m_mapSize];
        this.m_mapSize = nodeVectorLazy.m_mapSize;
        this.m_firstFree = nodeVectorLazy.m_firstFree;
        this.m_blocksize = nodeVectorLazy.m_blocksize;
        System.arraycopy(nodeVectorLazy.m_map, 0, this.m_map, 0, this.m_firstFree);
        this._isLazy = nodeVectorLazy._isLazy;
        this._isForwardOrderedAndUnique = nodeVectorLazy._isForwardOrderedAndUnique;
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final void setSize(int n2) {
        this.m_firstFree = n2;
    }

    public final void addElement(Node node2) {
        short s;
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + 1);
            this.m_map = nodeArray;
        }
        if (this._isForwardOrderedAndUnique && this.m_firstFree > 0 && 0 == ((s = DOMAdapter.compareDocumentPosition(this.m_map[this.m_firstFree - 1], node2)) & 4)) {
            this._isForwardOrderedAndUnique = false;
        }
        this.m_map[this.m_firstFree] = node2;
        ++this.m_firstFree;
    }

    public final void insertElementAt(Node node2, int n2) {
        long l;
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + 1);
            this.m_map = nodeArray;
        }
        if (n2 <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n2, this.m_map, n2 + 1, this.m_firstFree - n2);
            short s = DOMAdapter.compareDocumentPosition(this.m_map[n2 + 1], node2);
            if (0 != (s & 4)) {
                this._isForwardOrderedAndUnique = false;
            }
        }
        if (this._isForwardOrderedAndUnique && n2 > 0 && 0L != ((l = (long)DOMAdapter.compareDocumentPosition(this.m_map[n2 - 1], node2)) & 2L)) {
            this._isForwardOrderedAndUnique = false;
        }
        this.m_map[n2] = node2;
        ++this.m_firstFree;
    }

    public final void removeAllElements() {
        for (int i = 0; i < this.m_firstFree; ++i) {
            this.m_map[i] = null;
        }
        this.m_firstFree = 0;
        this._isForwardOrderedAndUnique = true;
    }

    public final boolean removeElement(Node node2) {
        for (int i = 0; i < this.m_firstFree; ++i) {
            if (!this.m_map[i].isSameNode(node2)) continue;
            if (i + 1 < this.m_firstFree) {
                System.arraycopy(this.m_map, i + 1, this.m_map, i - 1, this.m_firstFree - i);
            } else {
                this.m_map[i] = null;
            }
            --this.m_firstFree;
            return true;
        }
        return false;
    }

    public final void removeElementAt(int n2) {
        if (n2 > this.m_firstFree) {
            System.arraycopy(this.m_map, n2 + 1, this.m_map, n2, this.m_firstFree);
        } else {
            this.m_map[n2] = null;
        }
        --this.m_firstFree;
    }

    public final void reverseElements() {
        int n2 = this.m_firstFree;
        int n3 = n2 - 1;
        int n4 = n2 >> 1;
        int n5 = 0;
        while (n5 < n4) {
            Node node2 = this.m_map[n3];
            this.m_map[n3] = this.m_map[n5];
            this.m_map[n5] = node2;
            ++n5;
            --n3;
        }
    }

    public final void setElementAt(Node node2, int n2) {
        this.m_map[n2] = node2;
    }

    public final Node elementAt(int n2) {
        return this.m_map[n2];
    }

    public final boolean contains(Node node2) {
        for (int i = 0; i < this.m_firstFree; ++i) {
            if (!this.m_map[i].isSameNode(node2)) continue;
            return true;
        }
        return false;
    }

    public final int indexOf(Node node2, int n2) {
        for (int i = n2; i < this.m_firstFree; ++i) {
            if (!this.m_map[i].isSameNode(node2)) continue;
            return i;
        }
        return -1;
    }

    public final int indexOf(Node node2) {
        for (int i = 0; i < this.m_firstFree; ++i) {
            if (!this.m_map[i].isSameNode(node2)) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(Node node2) {
        for (int i = this.m_firstFree - 1; i >= 0; --i) {
            if (!this.m_map[i].isSameNode(node2)) continue;
            return i;
        }
        return -1;
    }

    public Object clone() throws CloneNotSupportedException {
        return new NodeVectorLazy(this);
    }

    public boolean isForwardOrderedAndUnique() {
        return this._isForwardOrderedAndUnique;
    }

    public void setForwardOrderedAndUnique(boolean bl) {
        if (!this._isForwardOrderedAndUnique) {
            this.sortAndEliminateDups();
            this._isForwardOrderedAndUnique = true;
        }
    }

    public boolean isLazy() {
        return this._isLazy;
    }

    public void setLazy(boolean bl) {
        this._isLazy = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.elementAt(i));
        }
        return stringBuilder.toString();
    }

    public final void sortAndEliminateDups() {
        NodeVectorLazy.quicksort(this.m_map, 0, this.size() - 1);
        int n2 = this.eliminateDupsFromSorted(this.m_map);
        this.m_firstFree -= n2;
        this._isForwardOrderedAndUnique = true;
    }

    private int eliminateDupsFromSorted(Node[] nodeArray) {
        int n2 = 0;
        for (int i = 1; i < this.size(); ++i) {
            if (nodeArray[i - 1].isSameNode(nodeArray[i])) {
                ++n2;
            }
            if (n2 <= 0) continue;
            nodeArray[i - n2] = nodeArray[i];
        }
        return n2;
    }

    private static void quicksort(Node[] nodeArray, int n2, int n3) {
        NodeVectorLazy.quicksort2(nodeArray, n2, n3);
    }

    private static void quicksort2(Node[] nodeArray, int n2, int n3) {
        if (n2 < n3) {
            int n4 = NodeVectorLazy.partition(nodeArray, n2, n3);
            NodeVectorLazy.quicksort2(nodeArray, n2, n4);
            NodeVectorLazy.quicksort2(nodeArray, n4 + 1, n3);
        }
    }

    private static int partition(Node[] nodeArray, int n2, int n3) {
        Node node2 = nodeArray[n2 + n3 >>> 1];
        int n4 = n2 - 1;
        int n5 = n3 + 1;
        while (true) {
            short s;
            if (0 != ((s = DOMAdapter.compareDocumentPosition(node2, nodeArray[--n5])) & 4)) {
                continue;
            }
            while (0 != ((s = DOMAdapter.compareDocumentPosition(node2, nodeArray[++n4])) & 2)) {
            }
            if (n4 >= n5) break;
            Node node3 = nodeArray[n4];
            nodeArray[n4] = nodeArray[n5];
            nodeArray[n5] = node3;
        }
        return n5;
    }

    private static void quicksort1(Node[] nodeArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        if (n4 >= n5) {
            return;
        }
        if (n4 == n5 - 1) {
            short s = DOMAdapter.compareDocumentPosition(nodeArray[n4], nodeArray[n5]);
            if (0 != (s & 2)) {
                Node node2 = nodeArray[n4];
                nodeArray[n4] = nodeArray[n5];
                nodeArray[n5] = node2;
            }
            return;
        }
        Node node3 = nodeArray[(n4 + n5) / 2];
        nodeArray[(n4 + n5) / 2] = nodeArray[n5];
        nodeArray[n5] = node3;
        while (n4 < n5) {
            short s = DOMAdapter.compareDocumentPosition(nodeArray[n4], node3);
            while (0 != (s & 4) && n4 < n5) {
                ++n4;
            }
            s = DOMAdapter.compareDocumentPosition(node3, nodeArray[n5]);
            while (0 != (s & 4) && n4 < n5) {
                --n5;
            }
            if (n4 >= n5) continue;
            Node node4 = nodeArray[n4];
            nodeArray[n4] = nodeArray[n5];
            nodeArray[n5] = node4;
        }
        nodeArray[n3] = nodeArray[n5];
        nodeArray[n5] = node3;
        NodeVectorLazy.quicksort1(nodeArray, n2, n4 - 1);
        NodeVectorLazy.quicksort1(nodeArray, n5 + 1, n3);
    }
}

