/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.dom;

import com.ibm.xml.jaxp.util.JAXPFactoryHelper;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.adapters.dom.DOMErrorHandler;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMUtils {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\n\n\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String NAMESPACE_GROWTH = "http://apache.org/xml/features/namespace-growth";
    private static final String TOLERATE_DUPLICATES = "http://apache.org/xml/features/internal/tolerate-duplicates";
    private static DocumentBuilderFactory fDocumentBuilderFactory;
    private static ThreadLocal<DocumentBuilderReference> fNonvalidatingBuilders;
    private static ThreadLocal<DOMImplementationReference> fValidatingDOMImplementations;
    private static ThreadLocal<DOMImplementationReference> fNonValidatingDOMImplementations;

    private DOMUtils() {
    }

    private static synchronized DocumentBuilderFactory getBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = fDocumentBuilderFactory;
        if (documentBuilderFactory == null) {
            documentBuilderFactory = JAXPFactoryHelper.newDocumentBuilderFactory();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            fDocumentBuilderFactory = documentBuilderFactory;
        }
        return documentBuilderFactory;
    }

    private static DocumentBuilder makeDocumentBuilder(boolean bl) {
        return DOMUtils.makeDocumentBuilder(bl, null);
    }

    private static synchronized DocumentBuilder makeDocumentBuilder(boolean bl, SessionContext sessionContext) {
        DocumentBuilderFactory documentBuilderFactory = DOMUtils.getBuilderFactory();
        DocumentBuilder documentBuilder = null;
        documentBuilderFactory.setAttribute("http://apache.org/xml/properties/dom/document-class-name", bl ? "com.ibm.xml.xml4j.internal.s1.dom.PSVIDocumentImpl" : null);
        if (!bl) {
            documentBuilderFactory.setSchema(null);
            documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", null);
            documentBuilderFactory.setAttribute(NAMESPACE_GROWTH, false);
            documentBuilderFactory.setAttribute(TOLERATE_DUPLICATES, false);
            TypeRegistry.setSchemaResolver(documentBuilderFactory, null);
        } else if (sessionContext == null) {
            documentBuilderFactory.setSchema(null);
            documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            documentBuilderFactory.setAttribute(NAMESPACE_GROWTH, false);
            documentBuilderFactory.setAttribute(TOLERATE_DUPLICATES, false);
            TypeRegistry.setSchemaResolver(documentBuilderFactory, null);
        } else {
            documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", null);
            documentBuilderFactory.setSchema(sessionContext.getTypeRegistry().getSchema());
            Boolean bl2 = (Boolean)sessionContext.getOption("http://www.ibm.com/xml/xci/instance/lax-assessment");
            boolean bl3 = bl2 != null && bl2 != false;
            documentBuilderFactory.setAttribute(NAMESPACE_GROWTH, bl3);
            Boolean bl4 = (Boolean)sessionContext.getOption("http://www.ibm.com/xml/xci/bo/bo-bc-mode");
            boolean bl5 = bl4 != null && bl4 != false;
            documentBuilderFactory.setAttribute(TOLERATE_DUPLICATES, bl5);
            TypeRegistry.setSchemaResolver(documentBuilderFactory, sessionContext.getTypeRegistry().getSchemaResolver());
        }
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new DOMErrorHandler());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_ADAPTER_INTERNAL_ERR", new String[]{parserConfigurationException.getMessage()}));
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            // empty catch block
        }
        return documentBuilder;
    }

    private static boolean requestAllowsValidation(RequestInfo requestInfo) {
        String[] stringArray;
        boolean bl;
        Cursor.Profile profile = requestInfo.getNeededFeatures();
        boolean bl2 = bl = Cursor.Profile.ALWAYS_VALID.containedIn(profile) || Cursor.Profile.SET_PSVI.containedIn(profile);
        if (!bl && (stringArray = requestInfo.getHints()) != null) {
            for (int i = 0; !bl && i < stringArray.length; ++i) {
                bl = "VALIDATING".equals(stringArray[i]);
            }
        }
        return bl;
    }

    private static DocumentBuilderReference getBuilderRef(RequestInfo requestInfo, SessionContext sessionContext) {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderReference documentBuilderReference = null;
        boolean bl = DOMUtils.requestAllowsValidation(requestInfo);
        if (bl) {
            documentBuilder = DOMUtils.makeDocumentBuilder(bl, sessionContext);
            documentBuilderReference = new DocumentBuilderReference(documentBuilder);
        } else {
            documentBuilderReference = fNonvalidatingBuilders.get();
            DocumentBuilder documentBuilder2 = documentBuilder = documentBuilderReference != null ? documentBuilderReference.reserve() : null;
            if (documentBuilder == null) {
                documentBuilder = DOMUtils.makeDocumentBuilder(bl);
                documentBuilderReference = new DocumentBuilderReference(documentBuilder);
                fNonvalidatingBuilders.set(documentBuilderReference);
            }
        }
        return documentBuilderReference;
    }

    private static DOMImplementationReference getDOMImplementationRef(RequestInfo requestInfo) {
        boolean bl = DOMUtils.requestAllowsValidation(requestInfo);
        DOMImplementation dOMImplementation = null;
        DOMImplementationReference dOMImplementationReference = null;
        if (bl) {
            dOMImplementationReference = fValidatingDOMImplementations.get();
            dOMImplementation = dOMImplementationReference != null ? dOMImplementationReference.reserve() : null;
        } else {
            dOMImplementationReference = fNonValidatingDOMImplementations.get();
            DOMImplementation dOMImplementation2 = dOMImplementation = dOMImplementationReference != null ? dOMImplementationReference.reserve() : null;
        }
        if (dOMImplementation == null) {
            try {
                if (bl) {
                    dOMImplementation = JAXPFactoryHelper.getDOMImplementation("psvi");
                    dOMImplementationReference = new DOMImplementationReference(dOMImplementation);
                    fValidatingDOMImplementations.set(dOMImplementationReference);
                } else {
                    dOMImplementation = JAXPFactoryHelper.getDOMImplementation("");
                    dOMImplementationReference = new DOMImplementationReference(dOMImplementation);
                    fNonValidatingDOMImplementations.set(dOMImplementationReference);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return dOMImplementationReference;
    }

    public static Document parse(InputSource inputSource, RequestInfo requestInfo, SessionContext sessionContext) {
        DocumentBuilderReference documentBuilderReference = DOMUtils.getBuilderRef(requestInfo, sessionContext);
        DocumentBuilder documentBuilder = (DocumentBuilder)documentBuilderReference.get();
        Document document2 = null;
        try {
            document2 = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_ADAPTER_INTERNAL_ERR", new String[]{sAXException.getMessage()}));
        }
        catch (IOException iOException) {
            throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_ADAPTER_INTERNAL_ERR", new String[]{iOException.getMessage()}));
        }
        finally {
            if (documentBuilderReference != null) {
                documentBuilderReference.release();
            }
        }
        return document2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document makeDocument(RequestInfo requestInfo, SessionContext sessionContext) {
        Document document2;
        DOMImplementationReference dOMImplementationReference = null;
        try {
            dOMImplementationReference = DOMUtils.getDOMImplementationRef(requestInfo);
            DOMImplementation dOMImplementation = (DOMImplementation)dOMImplementationReference.get();
            document2 = dOMImplementation.createDocument(null, null, null);
            Map<String, Object> map2 = requestInfo.getParameters();
            if (map2 != null && map2.containsKey("http://xml.ibm.com/xci/mutation/base-uri")) {
                String string2 = (String)map2.get("http://xml.ibm.com/xci/mutation/base-uri");
                document2.setDocumentURI(string2);
            }
            if (dOMImplementation.hasFeature("XMLVersion", "1.1")) {
                document2.setXmlVersion("1.1");
            }
        }
        finally {
            if (dOMImplementationReference != null) {
                dOMImplementationReference.release();
            }
        }
        return document2;
    }

    public static DocumentFragment makeDocumentFragment(RequestInfo requestInfo, SessionContext sessionContext) {
        Document document2 = DOMUtils.makeDocument(requestInfo, sessionContext);
        DocumentFragment documentFragment = document2.createDocumentFragment();
        return documentFragment;
    }

    static {
        fNonvalidatingBuilders = new ThreadLocal();
        fValidatingDOMImplementations = new ThreadLocal();
        fNonValidatingDOMImplementations = new ThreadLocal();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DOMImplementationReference
    extends SoftReference<DOMImplementation> {
        private boolean fInUse = true;

        public DOMImplementationReference(DOMImplementation dOMImplementation) {
            super(dOMImplementation);
        }

        public DOMImplementation reserve() {
            if (!this.fInUse) {
                this.fInUse = true;
                return (DOMImplementation)this.get();
            }
            return null;
        }

        public void release() {
            this.fInUse = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DocumentBuilderReference
    extends SoftReference<DocumentBuilder> {
        private boolean fInUse = true;

        public DocumentBuilderReference(DocumentBuilder documentBuilder) {
            super(documentBuilder);
        }

        public DocumentBuilder reserve() {
            if (!this.fInUse) {
                this.fInUse = true;
                return (DocumentBuilder)this.get();
            }
            return null;
        }

        public void release() {
            this.fInUse = false;
        }
    }
}

