/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.adapters.dom;

import com.ibm.xml.xci.DocumentInfo;
import com.ibm.xml.xci.type.TypeRegistry;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DOMDocumentInfo
extends DocumentInfo {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\n\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final TypeRegistry fTypes;
    private final Document fDocNode;
    private final boolean fOverrideDocumentURI;
    private final String fOverridingDocumentURI;
    private DOMErrorHandler fErrorHandler = null;

    public DOMDocumentInfo(Document document2, TypeRegistry typeRegistry) {
        this.fTypes = typeRegistry;
        this.fDocNode = document2;
        this.fOverrideDocumentURI = false;
        this.fOverridingDocumentURI = null;
    }

    public DOMDocumentInfo(Document document2, TypeRegistry typeRegistry, String string2) {
        this.fTypes = typeRegistry;
        this.fDocNode = document2;
        this.fOverrideDocumentURI = true;
        this.fOverridingDocumentURI = string2;
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.fTypes;
    }

    @Override
    public String getURI() {
        return this.fOverrideDocumentURI ? this.fOverridingDocumentURI : this.fDocNode.getDocumentURI();
    }

    @Override
    public String getUnparsedEntityPublicId(String string2) {
        NamedNodeMap namedNodeMap;
        Entity entity2 = null;
        DocumentType documentType = this.fDocNode.getDoctype();
        if (documentType != null && (namedNodeMap = documentType.getEntities()) != null) {
            entity2 = (Entity)namedNodeMap.getNamedItem(string2);
        }
        return entity2 != null ? entity2.getPublicId() : null;
    }

    @Override
    public String getUnparsedEntitySystemId(String string2) {
        NamedNodeMap namedNodeMap;
        Entity entity2 = null;
        DocumentType documentType = this.fDocNode.getDoctype();
        if (documentType != null && (namedNodeMap = documentType.getEntities()) != null) {
            entity2 = (Entity)namedNodeMap.getNamedItem(string2);
        }
        return entity2 != null ? entity2.getSystemId() : null;
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        int n2;
        Object object2;
        DocumentType documentType = this.fDocNode.getDoctype();
        if (documentType != null && (object2 = documentType.getEntities()) != null && (n2 = object2.getLength()) > 0) {
            return new Iterator<String>((NamedNodeMap)object2){
                private int index = 0;
                final /* synthetic */ NamedNodeMap val$entities;
                {
                    this.val$entities = namedNodeMap;
                }

                @Override
                public boolean hasNext() {
                    return this.index < n2;
                }

                @Override
                public String next() {
                    if (this.index < n2) {
                        Entity entity2 = (Entity)this.val$entities.item(this.index++);
                        return entity2.getNodeName();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        object2 = Collections.EMPTY_LIST;
        return object2.iterator();
    }

    @Override
    public DocumentInfo.VersionInfo getXMLVersionInfo() {
        String string2 = this.fDocNode.getXmlVersion();
        return "1.1".equals(string2) ? DocumentInfo.VersionInfo.ONEONE : DocumentInfo.VersionInfo.ONEZERO;
    }

    @Override
    public String getXMLEncoding() {
        return this.fDocNode.getXmlEncoding();
    }

    @Override
    public DOMErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    void setErrorHandler(DOMErrorHandler dOMErrorHandler) {
        this.fErrorHandler = dOMErrorHandler;
    }
}

