/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.Hints;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.dp.util.InstrumentationHandler;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.util.CursorFactoryRegistration;
import com.ibm.xml.xci.res.XCIMessages;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XCIRegistry {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static XCIRegistry master = null;
    private final List<CursorFactoryRegistration> dataProviderFactories = new Vector<CursorFactoryRegistration>();
    private static final String REGISTRATION_PROPERTIES_FILENAME = XCIRegistry.class.getPackage().getName() + ".factories.properties";
    private static final String PROP_CLASS = "class";
    private static final Logger logger = LoggerUtil.getLogger(XCIRegistry.class);
    private static final HashSet<String> builtInAdapters = new HashSet();
    private static final String PROP_CONTENTTYPE = "contentType";
    private static final String PROP_OBJECTMATCH = "objectmatch";
    private static final String PROP_FEATURESLIMIT = "featureslimit";
    private static final String PROP_HINTS = "hints";
    private static final String PROP_PRIORITY = "priority";
    private static final String PROP_PREPARER = "preparer";
    private static final String PROP_LANGUAGES = "languages";
    private static final String PROP_VERSIONSTRING = "versionstring";
    private static Map<Class, XCIRegistry> registryMap;
    private static final String SUFFIX = ".properties";
    private static final Cursor.Profile UPDATE_FEATURES;
    private static final boolean THROW_ON_LOAD_FAILURE = true;
    private static final boolean LOAD_AS_RESOURCE_BUNDLE = true;

    public static synchronized XCIRegistry getInstance() {
        if (master == null) {
            master = new XCIRegistry();
        }
        return master;
    }

    static synchronized XCIRegistry getInstance(ClassLoader classLoader, boolean bl) {
        Object object2;
        if (!bl && master == null) {
            master = new XCIRegistry();
            if (master.getDataProviderCount() == 0) {
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_NOADAPTERS", null));
            }
            for (String string2 : builtInAdapters) {
                if (master.getDataProviderID(string2) != -1) continue;
                object2 = new IllegalArgumentException("Could not load the built-in adapter[" + string2 + SUFFIX + "]");
                FFDCUtil.log((Throwable)object2, XCIRegistry.class);
            }
        }
        if (classLoader == null) {
            return master;
        }
        if (registryMap.containsKey(classLoader.getClass())) {
            return registryMap.get(classLoader.getClass());
        }
        XCIRegistry xCIRegistry = new XCIRegistry(classLoader);
        if (xCIRegistry.getDataProviderCount() == 0) {
            registryMap.put(classLoader.getClass(), master);
            return master;
        }
        for (int i = 0; i < master.getDataProviderCount(); ++i) {
            object2 = master.getCursorFactoryRegistration(i);
            if (!bl && ((CursorFactoryRegistration)object2).getClassName() != null && xCIRegistry.getDataProviderID(((CursorFactoryRegistration)object2).getClassName()) < 0) {
                xCIRegistry.registerDataProvider((CursorFactoryRegistration)object2);
                continue;
            }
            if (((CursorFactoryRegistration)object2).getClassName() != null || super.getPreparerID(((CursorFactoryRegistration)object2).getPreparerClass()) >= 0) continue;
            xCIRegistry.registerDataProvider((CursorFactoryRegistration)object2);
        }
        registryMap.put(classLoader.getClass(), xCIRegistry);
        return xCIRegistry;
    }

    public static XCIRegistry newEmptyInstance() {
        return new XCIRegistry();
    }

    public XCIRegistry() {
        this(XCIRegistry.class.getClassLoader());
    }

    private XCIRegistry(ClassLoader classLoader) {
        try {
            String string2 = REGISTRATION_PROPERTIES_FILENAME.substring(0, REGISTRATION_PROPERTIES_FILENAME.length() - SUFFIX.length());
            string2 = string2.replace('.', '/').concat(SUFFIX);
            Enumeration<URL> enumeration = classLoader != null ? classLoader.getResources(string2) : ClassLoader.getSystemResources(string2);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                InputStream inputStream = uRL.openStream();
                if (inputStream != null) {
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    Enumeration<Object> enumeration2 = properties.keys();
                    while (enumeration2.hasMoreElements()) {
                        String string3 = (String)enumeration2.nextElement();
                        String string4 = properties.getProperty(string3);
                        if (string4 == null || "".equals(string4)) {
                            if (!LoggerUtil.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) continue;
                            logger.logp(Level.FINER, logger.getName(), "XCIRegistry", "Warning: Missing classname for factory: " + string3 + ".  It will be ignored.\n");
                            continue;
                        }
                        if (this.getDataProviderID(string3) >= 0 || this.getPreparerID(string3) >= 0) continue;
                        this.registerFactoryFromProperties(string4, classLoader);
                    }
                    continue;
                }
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CANNOT_OPEN_FACTORIES", null));
            }
            this.registerSDOX(classLoader);
        }
        catch (IOException iOException) {
            throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CANNOT_OPEN_FACTORIES", null), iOException);
        }
    }

    private void registerFactoryFromProperties(String string2, ClassLoader classLoader) {
        Properties properties = null;
        try {
            properties = XCIRegistry.loadProperties(string2, classLoader);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XCIDynamicErrorException(illegalArgumentException);
        }
        if (null != properties) {
            String string3 = this.processClass(properties);
            String[] stringArray = this.processContentType(properties);
            String[] stringArray2 = this.processObjectClassNames(properties);
            Cursor.Profile profile = this.processFeaturesLimit(properties);
            String[] stringArray3 = this.processStringList(PROP_HINTS, properties);
            String[] stringArray4 = this.processStringList(PROP_LANGUAGES, properties);
            short s = this.processPriority(properties);
            Class<?> clazz = this.processPreparer(properties, classLoader);
            String string4 = this.processVersionString(properties);
            CursorFactoryRegistration cursorFactoryRegistration = new CursorFactoryRegistration(classLoader, string3, stringArray, stringArray2, profile, stringArray3, s, clazz, stringArray4, string4);
            this.registerDataProvider(cursorFactoryRegistration);
        }
    }

    void registerDataProvider(CursorFactoryRegistration cursorFactoryRegistration) {
        this.dataProviderFactories.add(cursorFactoryRegistration);
    }

    private Class<?> processPreparer(Properties properties, ClassLoader classLoader) {
        block3: {
            String string2 = properties.getProperty(PROP_PREPARER);
            if (string2 != null) {
                try {
                    Class<?> clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!LoggerUtil.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) break block3;
                    logger.logp(Level.FINER, logger.getName(), "XCIRegistry", "Warning: Preparer class not found: " + string2 + " \n");
                }
            }
        }
        return null;
    }

    private String processClass(Properties properties) {
        String string2 = properties.getProperty(PROP_CLASS);
        return string2;
    }

    private short processPriority(Properties properties) {
        String string2 = properties.getProperty(PROP_PRIORITY);
        short s = string2 != null ? Short.parseShort(string2) : (short)0;
        return s;
    }

    private String[] processStringList(String string2, Properties properties) {
        String[] stringArray = null;
        String string3 = properties.getProperty(string2);
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "|", false);
            int n2 = stringTokenizer.countTokens();
            stringArray = new String[n2];
            int n3 = 0;
            while (stringTokenizer.hasMoreElements()) {
                String string4;
                stringArray[n3] = string4 = ((String)stringTokenizer.nextElement()).trim();
                ++n3;
            }
        }
        return stringArray;
    }

    private Cursor.Profile processFeaturesLimit(Properties properties) {
        Cursor.Profile profile = null;
        String string2 = properties.getProperty(PROP_FEATURESLIMIT);
        if (string2 == null) {
            return Cursor.RANDOM_ACCESS;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|", false);
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string3 = null;
            try {
                string3 = ((String)stringTokenizer.nextElement()).trim();
                Field field = Cursor.Profile.class.getField(string3);
                profile = profile == null ? (Cursor.Profile)field.get(null) : profile.union((Cursor.Profile)field.get(null));
            }
            catch (SecurityException securityException) {
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CANNOT_PROCESS_FEATURELIST", new String[]{string3}), securityException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CANNOT_PROCESS_FEATURELIST", new String[]{string3}), noSuchFieldException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CANNOT_PROCESS_FEATURELIST", new String[]{string3}), illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CANNOT_PROCESS_FEATURELIST", new String[]{string3}), illegalAccessException);
            }
            ++n2;
        }
        return profile;
    }

    private String[] processObjectClassNames(Properties properties) {
        String[] stringArray;
        String string2 = properties.getProperty(PROP_OBJECTMATCH);
        if (null != string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|", false);
            int n2 = stringTokenizer.countTokens();
            stringArray = new String[n2];
            int n3 = 0;
            while (stringTokenizer.hasMoreElements()) {
                String string3;
                stringArray[n3] = string3 = ((String)stringTokenizer.nextElement()).trim();
                ++n3;
            }
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    private String[] processContentType(Properties properties) {
        String[] stringArray;
        String string2 = properties.getProperty(PROP_CONTENTTYPE);
        if (null != string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|", false);
            int n2 = stringTokenizer.countTokens();
            stringArray = new String[n2];
            int n3 = 0;
            while (stringTokenizer.hasMoreElements()) {
                String string3;
                stringArray[n3] = string3 = ((String)stringTokenizer.nextElement()).trim();
                ++n3;
            }
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    private String processVersionString(Properties properties) {
        String string2 = properties.getProperty(PROP_VERSIONSTRING);
        return string2;
    }

    int findBestScoreIndex(Class<?> clazz, RequestInfo requestInfo, String string2) {
        int n2;
        int n3 = this.dataProviderFactories.size();
        int[] nArray = new int[n3];
        Cursor.Profile profile = requestInfo.getNeededFeatures();
        for (n2 = 0; n2 < n3; ++n2) {
            String[] stringArray;
            Cursor.Profile profile2;
            String[] stringArray2;
            Object object2;
            int n4;
            CursorFactoryRegistration cursorFactoryRegistration = this.dataProviderFactories.get(n2);
            if (cursorFactoryRegistration.getClassName() == null) continue;
            Class<?>[] classArray = cursorFactoryRegistration.getSourceClasses();
            if (null != classArray) {
                boolean bl = false;
                for (n4 = 0; n4 < classArray.length; ++n4) {
                    object2 = classArray[n4];
                    if (null == object2 || null == clazz) continue;
                    if (object2.isAssignableFrom(clazz)) {
                        bl = true;
                        break;
                    }
                    if (clazz != Result.class && clazz != Source.class || !clazz.isAssignableFrom((Class<?>)object2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    nArray[n2] = -1;
                    continue;
                }
                int n5 = n2;
                nArray[n5] = nArray[n5] + 1;
            }
            if (null != string2 && null != (stringArray2 = cursorFactoryRegistration.getcontentType())) {
                for (n4 = 0; n4 < stringArray2.length; ++n4) {
                    object2 = stringArray2[n4];
                }
            }
            if ((profile2 = cursorFactoryRegistration.getFeatureLimit()) != null) {
                if (profile.equals(profile2)) {
                    int n6 = n2;
                    nArray[n6] = nArray[n6] + 2;
                } else if (profile.containedIn(profile2)) {
                    int n7 = n2;
                    nArray[n7] = nArray[n7] + 1;
                } else {
                    Cursor.Profile profile3 = profile.difference(profile2);
                    if (profile3.overlap(UPDATE_FEATURES)) {
                        int n8 = n2;
                        nArray[n8] = nArray[n8] - 2;
                    }
                }
            }
            if ((stringArray = requestInfo.getHints()) == null || (object2 = cursorFactoryRegistration.getHints()) == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                for (int j = 0; j < ((String[])object2).length; ++j) {
                    String string4 = object2[j];
                    if (!string3.equals(string4)) continue;
                    int n9 = n2;
                    nArray[n9] = nArray[n9] + Hints.getWeight(string3);
                }
            }
        }
        n2 = 0;
        int n10 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
            n10 = i;
        }
        return n10;
    }

    CursorFactoryRegistration getCursorFactoryRegistration(int n2) {
        return this.dataProviderFactories.get(n2);
    }

    public int getDataProviderID(String string2) {
        int n2 = this.dataProviderFactories.size();
        for (int i = 0; i < n2; ++i) {
            CursorFactoryRegistration cursorFactoryRegistration = this.dataProviderFactories.get(i);
            if (cursorFactoryRegistration.getClassName() == null || !cursorFactoryRegistration.getClassName().equals(string2)) continue;
            return i;
        }
        return -1;
    }

    private int getPreparerID(Class<?> clazz) {
        int n2 = this.dataProviderFactories.size();
        for (int i = 0; i < n2; ++i) {
            CursorFactoryRegistration cursorFactoryRegistration = this.dataProviderFactories.get(i);
            if (cursorFactoryRegistration.getClassName() != null || cursorFactoryRegistration.getPreparerClass() != clazz) continue;
            return i;
        }
        return -1;
    }

    private int getPreparerID(String string2) {
        int n2 = this.dataProviderFactories.size();
        for (int i = 0; i < n2; ++i) {
            CursorFactoryRegistration cursorFactoryRegistration = this.dataProviderFactories.get(i);
            if (cursorFactoryRegistration.getClassName() != null || !cursorFactoryRegistration.getPreparerClass().getName().equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public int getDataProviderCount() {
        return this.dataProviderFactories.size();
    }

    void printRegisteredDataProviderString() {
        for (int i = 0; i < this.dataProviderFactories.size(); ++i) {
            System.out.println(this.dataProviderFactories.get(i));
        }
    }

    int getNumRegisteredDataProviderFactories() {
        return this.dataProviderFactories.size();
    }

    private void registerSDOX(ClassLoader classLoader) {
        block8: {
            if (this.getDataProviderID("com.ibm.websphere.sdox.SDOCursorFactory") < 0) {
                try {
                    final Class<?> clazz = Class.forName("com.ibm.ws.bootstrap.ExtClassLoader");
                    final Method method = (Method)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                return clazz.getDeclaredMethod("getInstance", new Class[0]);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, logger.getName(), "registerSDOX", "Could not find the getInstance method : " + noSuchMethodException.getMessage());
                                }
                                throw new XCIDynamicErrorException(noSuchMethodException);
                            }
                        }
                    });
                    final ClassLoader classLoader2 = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() {
                            try {
                                return (ClassLoader)method.invoke(null, null);
                            }
                            catch (Exception exception) {
                                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, logger.getName(), "registerSDOX", "Could not invoke class loader : " + exception.getMessage());
                                }
                                throw new XCIDynamicErrorException(exception);
                            }
                        }
                    });
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                classLoader2.loadClass("com.ibm.websphere.sdox.SDOCursorFactory");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, logger.getName(), "registerSDOX", "Could not load class com.ibm.websphere.sdox.SDOCursorFactory : " + classNotFoundException.getMessage());
                                }
                                throw new XCIDynamicErrorException(classNotFoundException);
                            }
                            return null;
                        }
                    });
                    CursorFactoryRegistration cursorFactoryRegistration = new CursorFactoryRegistration(classLoader2, "com.ibm.websphere.sdox.SDOCursorFactory", null, null, null, null, 1, Class.forName("com.ibm.xml.xci.spi.config.AxisPreparerDelegator", true, classLoader2), null, null);
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, logger.getName(), "registerSDOX", "SDOCursoryFactory was successfully loaded with the WAS Bootstrap ClassLoader and is being registered");
                    }
                    this.registerDataProvider(cursorFactoryRegistration);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, logger.getName(), "registerSDOX", "Could not load the SDOCursorFactory using com.ibm.ws.bootstrap.ExtClassLoader", classNotFoundException);
                    }
                    break block8;
                }
                catch (Exception exception) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, logger.getName(), "registerSDOX", "Could not load the SDOCursorFactory using com.ibm.ws.bootstrap.ExtClassLoader", exception);
                    }
                    break block8;
                }
            }
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, logger.getName(), "registerSDOX", "SDOCursoryFactory is registered via properties file lookup.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String string2, ClassLoader classLoader) {
        assert (string2 != null);
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        if (string2.endsWith(SUFFIX)) {
            string2 = string2.substring(0, string2.length() - SUFFIX.length());
        }
        Properties properties = null;
        InputStream inputStream = null;
        try {
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            string2 = string2.replace('/', '.');
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string2, Locale.getDefault(), classLoader);
            properties = new Properties();
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                String string4 = resourceBundle.getString(string3);
                properties.put(string3, string4);
            }
        }
        catch (Exception exception) {
            properties = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (properties == null) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, logger.getName(), "loadProperties", "Warning: Could not load properties file: " + string2 + " using classloader: " + classLoader.getClass().getName());
            }
        } else if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINE, logger.getName(), "loadProperties", "Loaded properties file: " + string2 + " using classloader: " + classLoader.getClass().getName() + "\nProperties: " + properties.toString());
        }
        return properties;
    }

    static {
        builtInAdapters.add("com.ibm.xml.xci.adapters.dom.DOMCursorFactory");
        builtInAdapters.add("com.ibm.xml.xci.adapters.xlxp.XLXPCursorFactory");
        builtInAdapters.add("com.ibm.xml.xci.serializer.SerializerCursorFactory");
        builtInAdapters.add("com.ibm.xml.xci.dp.cache.dom.CacheCursorFactory");
        builtInAdapters.add("com.ibm.xltxe.rnm1.xtq.xci.dtm.ref.DTMManagerDefault");
        registryMap = Collections.synchronizedMap(new WeakHashMap());
        InstrumentationHandler.getExternalLogger();
        UPDATE_FEATURES = Cursor.RANDOM_UPDATE.difference(Cursor.RANDOM_ACCESS);
    }
}

