/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.commandline.SearchPathSourceResolver;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.FlattenStreamOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xltxe.rnm1.xylem.parser.ParserException;
import com.ibm.xltxe.rnm1.xylem.parser.ParserSource;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VirtualDataTypeMap {
    private static final Logger s_logger = LoggerUtil.getLogger(VirtualDataTypeMap.class);
    private static final String s_className = VirtualDataTypeMap.class.getName();
    private HashMap m_mappings = new HashMap();
    private Collection m_importDirectives = new ArrayList();
    private FlattenStreamOptimizer streamFlattener = new FlattenStreamOptimizer();

    public void addVDTMapping(String string2, ADTMapping aDTMapping, boolean bl) {
        Object v;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "addVDTMapping", "adding VDTmap from " + string2);
        }
        if ((v = this.m_mappings.get(string2)) == aDTMapping) {
            return;
        }
        if (v != null && bl && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "addVDTMapping", "vdtmap with name " + string2 + " already exists");
        }
        this.m_mappings.put(string2, aDTMapping);
    }

    public void addVDTMapping(String string2, ADTMapping aDTMapping) {
        this.addVDTMapping(string2, aDTMapping, true);
    }

    public boolean hasVDTMapping(String string2) {
        return this.m_mappings.containsKey(string2);
    }

    public Set vdtMappingNames() {
        return this.m_mappings.keySet();
    }

    public ADTMapping getVDTMapping(String string2) {
        return (ADTMapping)this.m_mappings.get(string2);
    }

    public void addVDT(Module module, String string2, Type type2, LambdaInstruction lambdaInstruction, Map map2) throws ParserException {
        if (this.hasVDTMapping(string2)) {
            throw new ParserException("map-datatype already supplied for " + string2);
        }
        ADTMapping aDTMapping = new ADTMapping();
        this.addVDTMapping(string2, aDTMapping);
        aDTMapping.m_targetType = type2;
        Binding[] bindingArray = lambdaInstruction.getParameters();
        if (bindingArray.length != 1) {
            throw new ParserException("mapping function should have a single parameter");
        }
        TupleInstruction tupleInstruction = new TupleInstruction(new Instruction[]{lambdaInstruction.getBody()});
        Function function2 = this.typecheckAndReduceVDTCode(module, tupleInstruction, bindingArray);
        aDTMapping.m_matchVariable = function2.getParameters()[0];
        aDTMapping.m_matchCode = function2.getBody();
        for (String string3 : map2.keySet()) {
            LambdaInstruction[] lambdaInstructionArray = (LambdaInstruction[])map2.get(string3);
            if (lambdaInstructionArray.length != 2) {
                throw new ParserException("a variant mapping must have two functions to construct and deconstruct an object");
            }
            ConstructorMapping constructorMapping = new ConstructorMapping();
            function2 = this.typecheckAndReduceVDTCode(module, lambdaInstructionArray[0].getBody(), lambdaInstructionArray[0].getParameters());
            constructorMapping.m_constructParameters = function2.getParameters();
            constructorMapping.m_constructCode = function2.getBody();
            Binding[] bindingArray2 = lambdaInstructionArray[1].getParameters();
            if (bindingArray2.length != 1) {
                throw new ParserException("deconstructor function should have a single parameter");
            }
            function2 = this.typecheckAndReduceVDTCode(module, lambdaInstructionArray[1].getBody(), lambdaInstructionArray[1].getParameters());
            if (!(function2.getReturnType() instanceof TupleType)) {
                throw new ParserException("return type must be a tuple :" + function2.toString() + ":" + function2.getBody());
            }
            constructorMapping.m_deconstructVariable = function2.getParameters()[0];
            constructorMapping.m_deconstructCode = function2.getBody();
            aDTMapping.m_constructors.put(string3, constructorMapping);
        }
    }

    protected void applyFlattener(Function function2, Module module) {
    }

    private Function typecheckAndReduceVDTCode(Module module, Instruction instruction2, Binding[] bindingArray) throws ParserException {
        Function function2 = new Function(OptimizerUtilities.generateIntermediateIdentifier(), bindingArray, instruction2);
        this.applyFlattener(function2, module);
        try {
            function2.typeCheck(module, null, new LinkedList());
        }
        catch (TypeCheckException typeCheckException) {
            System.out.println("======BROKE!======\n" + function2);
            typeCheckException.printStackTrace();
            throw new ParserException(typeCheckException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("======BROKE nullpointer!======\n" + function2);
            nullPointerException.printStackTrace();
            throw new ParserException(nullPointerException.getMessage());
        }
        function2.standardizeTypes(true);
        function2.reduce();
        this.streamFlattener.optimizeFunction(function2);
        return function2;
    }

    public void addImportDirectives(Collection collection2) {
        this.m_importDirectives.addAll(collection2);
    }

    public Collection getImportDirectives() {
        return this.m_importDirectives;
    }

    public static void main(String[] stringArray) {
        try {
            ParserSource parserSource = new ParserSource(new File(stringArray[0]).toURL());
            Parser parser = new Parser(new SearchPathSourceResolver(new LinkedList()), parserSource, new ModuleSignatureStore(new LinkedList<URL>()));
            VirtualDataTypeMap virtualDataTypeMap = parser.parseVDTMap();
            System.out.println(virtualDataTypeMap);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addAll(VirtualDataTypeMap virtualDataTypeMap) {
        for (Map.Entry entry : virtualDataTypeMap.m_mappings.entrySet()) {
            String string2 = (String)entry.getKey();
            ADTMapping aDTMapping = (ADTMapping)entry.getValue();
            this.addVDTMapping(string2, aDTMapping);
        }
    }

    public Type getTargetType(String string2) {
        if (!this.hasVDTMapping(string2)) {
            return null;
        }
        return this.getVDTMapping((String)string2).m_targetType;
    }

    public HashMap getTypeMap() {
        HashMap<NamedType, Type> hashMap = new HashMap<NamedType, Type>();
        for (String string2 : this.m_mappings.keySet()) {
            hashMap.put(new NamedType(string2), this.getTargetType(string2));
        }
        return hashMap;
    }

    public static class ConstructorMapping {
        public Instruction m_constructCode;
        public Binding[] m_constructParameters;
        public Instruction m_deconstructCode;
        public Binding m_deconstructVariable;
    }

    public static class ADTMapping {
        public HashMap m_constructors = new HashMap();
        public Instruction m_matchCode;
        public Binding m_matchVariable;
        public Type m_targetType;
    }
}

