/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgOperation;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.PrimitiveNumericalType;
import com.ibm.xltxe.rnm1.xylem.utils.OverflowException;
import java.io.ObjectStreamException;
import java.math.BigInteger;

public final class LongType
extends PrimitiveNumericalType {
    private static final long serialVersionUID = -2404025752571691365L;
    public static final LongType s_longType = new LongType();

    private LongType() {
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper fcgCodeGenHelper) {
        return FcgType.LONG;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return "long";
    }

    @Override
    public Class getJavaType(IntegerSettings integerSettings) {
        return Long.TYPE;
    }

    @Override
    public Object evaluateOperation(IntegerSettings integerSettings, Object object2, Object object3, int n2) {
        Long l;
        Long l2 = (Long)object2;
        Long l3 = (Long)object3;
        switch (n2) {
            case 0: {
                l = new Long(l2 + l3);
                break;
            }
            case 1: {
                l = new Long(l2 - l3);
                break;
            }
            case 2: {
                l = new Long(l2 * l3);
                break;
            }
            case 3: {
                l = new Long(l2 / l3);
                break;
            }
            case 4: {
                l = new Long(l2 % l3);
                break;
            }
            case 10: {
                l = new Long(l2 & l3);
                break;
            }
            case 11: {
                l = new Long(l2 | l3);
                break;
            }
            case 12: {
                l = new Long(l2 ^ l3);
                break;
            }
            case 16: {
                l = new Long(-l2.longValue());
                break;
            }
            case 17: 
            case 18: {
                return l2;
            }
            default: {
                return super.evaluateComparisonOperation(object2, object3, n2);
            }
        }
        if (integerSettings.getOverflowDetection()) {
            switch (n2) {
                case 0: 
                case 1: {
                    int n3 = Long.signum(l2);
                    if (n3 != Long.signum(n2 == 1 ? -l3.longValue() : l3) || n3 == Long.signum(l)) break;
                    throw new OverflowException();
                }
                case 2: {
                    int n4 = Long.numberOfLeadingZeros(Math.abs(l2)) + Long.numberOfLeadingZeros(Math.abs(l3));
                    if (n4 >= 63 && (n4 != 63 && n4 != 64 || BigInteger.valueOf(l2).multiply(BigInteger.valueOf(l3)).equals(BigInteger.valueOf(l)))) break;
                    throw new OverflowException();
                }
                case 3: {
                    if (l2 != Long.MIN_VALUE || l3 != -1L) break;
                    throw new OverflowException();
                }
                case 16: {
                    if (l2 != Long.MIN_VALUE) break;
                    throw new OverflowException();
                }
            }
        }
        return l;
    }

    @Override
    public void generateLoadLiteralValue(FinalCodeGenerator finalCodeGenerator, Object object2) {
        finalCodeGenerator.loadLiteral(object2 != null ? (Long)object2 : 0L);
    }

    @Override
    public FcgType generateCodeForOperation(FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList, FcgOperation fcgOperation) {
        boolean bl = fcgCodeGenHelper.getSettings().getOverflowDetection() && (fcgOperation == FcgBinOp.PLUS || fcgOperation == FcgBinOp.SUBTRACT || fcgOperation == FcgBinOp.MULTIPLY || fcgOperation == FcgBinOp.DIVIDE || fcgOperation == FcgUnaryOp.NEGATIVE);
        boolean bl2 = fcgOperation instanceof FcgBinOp;
        FcgVariable fcgVariable = null;
        FcgVariable fcgVariable2 = null;
        if (bl) {
            if (bl2) {
                fcgVariable2 = fcgInstructionList.defineVar(FcgType.LONG, fcgCodeGenHelper.generateNewLocalVariableName(), true);
            }
            fcgVariable = fcgInstructionList.defineVar(FcgType.LONG, fcgCodeGenHelper.generateNewLocalVariableName(), true);
            fcgInstructionList.loadVar(fcgVariable);
            if (bl2) {
                fcgInstructionList.loadVar(fcgVariable2);
            }
        }
        FcgType fcgType = super.generateCodeForOperation(fcgCodeGenHelper, fcgInstructionList, fcgOperation);
        if (bl) {
            FcgVariable fcgVariable3 = fcgInstructionList.defineVar(FcgType.LONG, fcgCodeGenHelper.generateNewLocalVariableName(), true);
            if (fcgOperation == FcgBinOp.PLUS || fcgOperation == FcgBinOp.SUBTRACT) {
                fcgInstructionList.loadVar(fcgVariable);
                fcgInstructionList.invokeClassMethod(FcgType.LONG_OBJECT, "signum", (FcgType)FcgType.INT, new FcgType[]{FcgType.LONG});
                FcgVariable fcgVariable4 = fcgInstructionList.defineVar(FcgType.INT, fcgCodeGenHelper.generateNewLocalVariableName(), true);
                fcgInstructionList.loadVar(fcgVariable4);
                fcgInstructionList.loadVar(fcgVariable2);
                if (fcgOperation == FcgBinOp.SUBTRACT) {
                    fcgInstructionList.unaryOperationExpr(FcgUnaryOp.NEGATIVE);
                }
                fcgInstructionList.invokeClassMethod(FcgType.LONG_OBJECT, "signum", (FcgType)FcgType.INT, new FcgType[]{FcgType.LONG});
                fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                fcgInstructionList.beginIf();
                fcgInstructionList.loadVar(fcgVariable4);
                fcgInstructionList.loadVar(fcgVariable3);
                fcgInstructionList.invokeClassMethod(FcgType.LONG_OBJECT, "signum", (FcgType)FcgType.INT, new FcgType[]{FcgType.LONG});
                fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_NE);
                fcgInstructionList.beginIf();
                fcgInstructionList.createObjectExpr((FcgType)FcgType.OVERFLOW_EXCEPTION, 0);
                fcgInstructionList.throwObject();
                fcgInstructionList.endIf();
                fcgInstructionList.endIf();
            } else if (fcgOperation == FcgBinOp.MULTIPLY) {
                FcgClassReferenceType fcgClassReferenceType = fcgCodeGenHelper.getClassReferenceType(Math.class.getName());
                fcgInstructionList.loadVar(fcgVariable);
                fcgInstructionList.invokeClassMethod(fcgClassReferenceType, "abs", (FcgType)FcgType.LONG, new FcgType[]{FcgType.LONG});
                fcgInstructionList.invokeClassMethod(FcgType.LONG_OBJECT, "numberOfLeadingZeros", (FcgType)FcgType.INT, new FcgType[]{FcgType.LONG});
                fcgInstructionList.loadVar(fcgVariable2);
                fcgInstructionList.invokeClassMethod(fcgClassReferenceType, "abs", (FcgType)FcgType.LONG, new FcgType[]{FcgType.LONG});
                fcgInstructionList.invokeClassMethod(FcgType.LONG_OBJECT, "numberOfLeadingZeros", (FcgType)FcgType.INT, new FcgType[]{FcgType.LONG});
                fcgInstructionList.binaryOperationExpr(FcgBinOp.PLUS);
                FcgVariable fcgVariable5 = fcgInstructionList.defineVar(FcgType.INT, fcgCodeGenHelper.generateNewLocalVariableName(), true);
                fcgInstructionList.loadVar(fcgVariable5);
                fcgInstructionList.loadLiteral(63);
                fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_LT);
                fcgInstructionList.loadVar(fcgVariable5);
                fcgInstructionList.loadLiteral(63);
                fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                fcgInstructionList.loadVar(fcgVariable5);
                fcgInstructionList.loadLiteral(64);
                fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                fcgInstructionList.binaryOperationExpr(FcgBinOp.LOGICAL_OR);
                fcgInstructionList.loadVar(fcgVariable);
                fcgInstructionList.invokeClassMethod(FcgType.BIG_INTEGER, "valueOf", (FcgType)FcgType.BIG_INTEGER, new FcgType[]{FcgType.LONG});
                fcgInstructionList.loadVar(fcgVariable2);
                fcgInstructionList.invokeClassMethod(FcgType.BIG_INTEGER, "valueOf", (FcgType)FcgType.BIG_INTEGER, new FcgType[]{FcgType.LONG});
                fcgInstructionList.invokeInstanceMethod(FcgType.BIG_INTEGER, "multiply", (FcgType)FcgType.BIG_INTEGER, new FcgType[]{FcgType.BIG_INTEGER});
                fcgInstructionList.loadVar(fcgVariable3);
                fcgInstructionList.invokeClassMethod(FcgType.BIG_INTEGER, "valueOf", (FcgType)FcgType.BIG_INTEGER, new FcgType[]{FcgType.LONG});
                fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_NE);
                fcgInstructionList.binaryOperationExpr(FcgBinOp.LOGICAL_AND);
                fcgInstructionList.binaryOperationExpr(FcgBinOp.LOGICAL_OR);
                fcgInstructionList.beginIf();
                fcgInstructionList.createObjectExpr((FcgType)FcgType.OVERFLOW_EXCEPTION, 0);
                fcgInstructionList.throwObject();
                fcgInstructionList.endIf();
            } else if (fcgOperation == FcgBinOp.DIVIDE) {
                fcgInstructionList.loadVar(fcgVariable);
                fcgInstructionList.loadLiteral(Long.MIN_VALUE);
                fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                fcgInstructionList.loadVar(fcgVariable2);
                fcgInstructionList.loadLiteral(-1);
                fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                fcgInstructionList.binaryOperationExpr(FcgBinOp.LOGICAL_AND);
                fcgInstructionList.beginIf();
                fcgInstructionList.createObjectExpr((FcgType)FcgType.OVERFLOW_EXCEPTION, 0);
                fcgInstructionList.throwObject();
                fcgInstructionList.endIf();
            } else if (fcgOperation == FcgUnaryOp.NEGATIVE) {
                fcgInstructionList.loadVar(fcgVariable);
                fcgInstructionList.loadLiteral(Long.MIN_VALUE);
                fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                fcgInstructionList.beginIf();
                fcgInstructionList.createObjectExpr((FcgType)FcgType.OVERFLOW_EXCEPTION, 0);
                fcgInstructionList.throwObject();
                fcgInstructionList.endIf();
            }
            return fcgInstructionList.loadVar(fcgVariable3);
        }
        return fcgType;
    }

    private Object readResolve() throws ObjectStreamException {
        return s_longType;
    }

    @Override
    public String getDefaultValue() {
        return "0";
    }
}

