/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgCodeGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.JavaClassImporter;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.JavaClassInformation;
import com.ibm.xltxe.rnm1.xylem.types.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaObjectType
extends Type {
    private static final long serialVersionUID = -5224774453403727058L;
    public static final JavaObjectType s_javaStringType = new JavaObjectType("java.lang.String");
    public static final JavaObjectType s_javaHashMapType = new JavaObjectType("java.util.HashMap");
    private static final Logger s_logger = LoggerUtil.getLogger(JavaObjectType.class);
    private static final String s_className = JavaObjectType.class.getName();
    protected String m_className;
    private static HashMap s_primitiveMap = new HashMap();

    public JavaObjectType() {
    }

    @Override
    public Type expandTypeAliases(Module module) {
        return this;
    }

    public String getClassName() {
        return this.m_className;
    }

    public JavaObjectType(String string2) {
        this.m_className = string2;
    }

    public String toString() {
        return this.m_className;
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper fcgCodeGenHelper) {
        String string2 = this.getJavaType(fcgCodeGenHelper.getSettings()).getName();
        string2 = this.fixupInnerClassName(fcgCodeGenHelper, string2);
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGenHelper.getClassReferenceType(string2);
        return fcgClassReferenceType;
    }

    private String fixupInnerClassName(FcgCodeGen fcgCodeGen, String string2) {
        int n2 = string2.indexOf(36);
        if (n2 > 0) {
            String string3 = string2.substring(0, n2);
            String string4 = this.fixupInnerClassName(fcgCodeGen, string2.substring(n2 + 1, string2.length()));
            FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getInnerClassReferenceType(string3, string4);
            string2 = fcgClassReferenceType.getTypeName();
        }
        return string2;
    }

    @Override
    public Class getJavaType(IntegerSettings integerSettings) {
        String string2 = this.getClassName();
        Class clazz = (Class)s_primitiveMap.get(string2);
        while (clazz == null) {
            try {
                clazz = ObjectFactory.findProviderClass(string2, ObjectFactory.findClassLoader(), true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                int n2 = string2.lastIndexOf(46);
                if (n2 != -1) {
                    string2 = string2.substring(0, n2) + "$" + string2.substring(n2 + 1, string2.length());
                    continue;
                }
                throw new XylemError("ERR_SYSTEM", "Could not find class for " + this.getClassName());
            }
        }
        return clazz;
    }

    public boolean equals(Object object2) {
        if (object2 == null) {
            return false;
        }
        if (object2 instanceof JavaObjectType) {
            return this.m_className.equals(((JavaObjectType)object2).m_className);
        }
        return this.m_className.equals(object2.toString());
    }

    public int hashCode() {
        return this.m_className.hashCode();
    }

    protected Object clone() throws CloneNotSupportedException {
        return this;
    }

    public JavaClassInformation getInformation(Module module) {
        try {
            return JavaClassImporter.retrieveJavaClassInformation(this.m_className, module);
        }
        catch (Exception exception) {
            FFDCUtil.log(exception, this);
            s_logger.logrb(Level.WARNING, s_className, "getInformation", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "ERR_SYSTEM", new Object[]{"class " + this.m_className + " not found on classpath, assuming opaque"});
            return new JavaClassInformation();
        }
    }

    @Override
    public String prettyPrint() {
        return "(java " + this.m_className + ")";
    }

    @Override
    public Type duplicateType(Map map2) {
        return this;
    }

    @Override
    public String getDefaultValue() {
        return "null";
    }

    @Override
    public Object evaluateVariableFork(Object object2) {
        return XCIConstruction.evalForkIfNeeded(object2);
    }

    @Override
    public void evaluateVariableRelease(Function function2, Instruction instruction2, Object object2) {
        XCIConstruction.evalReleaseIfNeeded(object2);
    }

    static {
        s_primitiveMap.put("boolean", Boolean.TYPE);
        s_primitiveMap.put("byte", Byte.TYPE);
        s_primitiveMap.put("char", Character.TYPE);
        s_primitiveMap.put("short", Short.TYPE);
        s_primitiveMap.put("int", Integer.TYPE);
        s_primitiveMap.put("long", Long.TYPE);
        s_primitiveMap.put("float", Float.TYPE);
        s_primitiveMap.put("double", Double.TYPE);
    }
}

