/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;

public class JavaArrayType
extends JavaObjectType {
    private static final long serialVersionUID = 1332408608454188820L;
    protected Type m_elementType;
    protected int m_dimensions;

    public JavaArrayType(Type type2, int n2) {
        this.m_elementType = type2;
        this.m_dimensions = n2;
    }

    @Override
    public Type expandTypeAliases(Module module) {
        return new JavaArrayType(this.m_elementType.expandTypeAliases(module), this.m_dimensions);
    }

    public void setElementType(Type type2) {
        this.m_elementType = type2;
    }

    @Override
    public Class getJavaType(IntegerSettings integerSettings) {
        return Array.newInstance(this.getElementType().getJavaType(integerSettings), new int[this.m_dimensions]).getClass();
    }

    @Override
    public boolean equals(Object object2) {
        return object2 != null && object2 instanceof JavaArrayType && ((JavaArrayType)object2).m_elementType.equals(this.m_elementType) && ((JavaArrayType)object2).m_dimensions == this.m_dimensions;
    }

    @Override
    public Type duplicateType(Map map2) {
        Type type2 = (Type)map2.get(this);
        if (type2 != null) {
            return type2;
        }
        return new JavaArrayType(this.m_elementType.duplicateType(map2), this.m_dimensions);
    }

    @Override
    public Type replaceType(Map map2) {
        Type type2 = (Type)map2.get(this);
        if (type2 != null) {
            return type2;
        }
        return new JavaArrayType(this.m_elementType.replaceType(map2), this.m_dimensions);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_dimensions; ++i) {
            stringBuffer.append("[]");
        }
        return this.m_elementType.toString() + stringBuffer;
    }

    public Type getElementType() {
        return this.m_elementType;
    }

    @Override
    public Type resolveType(TypeEnvironment typeEnvironment) {
        Type type2 = this.m_elementType.resolveType(typeEnvironment);
        if (type2 == null) {
            return null;
        }
        return new JavaArrayType(type2, this.m_dimensions);
    }

    @Override
    public Type resolveTypeAsMuchAsPossible(TypeEnvironment typeEnvironment, Set set2) {
        return new JavaArrayType(this.m_elementType.resolveTypeAsMuchAsPossible(typeEnvironment, set2), this.m_dimensions);
    }

    @Override
    public boolean isFullySpecified() {
        return this.m_elementType.isFullySpecified();
    }

    @Override
    public String prettyPrint() {
        return "(java-array " + this.m_elementType.prettyPrint() + " " + this.m_dimensions + ")";
    }

    @Override
    public int hashCode() {
        return 100 * this.m_elementType.hashCode();
    }

    @Override
    public int getChildTypeCount() {
        return 1;
    }

    @Override
    public Type getChildType(int n2) {
        return n2 == 0 ? this.m_elementType : null;
    }

    @Override
    public void setChildType(int n2, Type type2) {
        if (n2 == 0) {
            this.m_elementType = type2;
        }
    }

    @Override
    public String getDefaultValue() {
        return "null";
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper fcgCodeGenHelper) {
        FcgType fcgType = this.m_elementType.getFCGType(fcgCodeGenHelper);
        FcgType fcgType2 = fcgCodeGenHelper.getArrayType(fcgType);
        return fcgType2;
    }
}

