/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgOperation;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import com.ibm.xltxe.rnm1.xylem.types.PrimitiveNumericalType;
import java.io.ObjectStreamException;
import java.math.BigInteger;

public final class IntegerType
extends PrimitiveNumericalType {
    private static final long serialVersionUID = 3975236334493524777L;
    public static final IntegerType s_integerType = new IntegerType();

    private IntegerType() {
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper fcgCodeGenHelper) {
        if (fcgCodeGenHelper.getSettings().getArbitraryPrecision()) {
            return FcgType.BIG_INTEGER;
        }
        return FcgType.LONG;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return "integer";
    }

    @Override
    public Class getJavaType(IntegerSettings integerSettings) {
        if (integerSettings.getArbitraryPrecision()) {
            return BigInteger.class;
        }
        return Long.TYPE;
    }

    @Override
    public Object evaluateOperation(IntegerSettings integerSettings, Object object2, Object object3, int n2) {
        if (integerSettings.getArbitraryPrecision()) {
            return BigIntegerType.s_bigIntegerType.evaluateOperation(integerSettings, object2, object3, n2);
        }
        return LongType.s_longType.evaluateOperation(integerSettings, object2, object3, n2);
    }

    @Override
    public FcgType generateCodeForOperation(FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList, FcgOperation fcgOperation) {
        if (fcgCodeGenHelper.getSettings().getArbitraryPrecision()) {
            return BigIntegerType.s_bigIntegerType.generateCodeForOperation(fcgCodeGenHelper, fcgInstructionList, fcgOperation);
        }
        return LongType.s_longType.generateCodeForOperation(fcgCodeGenHelper, fcgInstructionList, fcgOperation);
    }

    @Override
    public void generateLoadLiteralValue(FinalCodeGenerator finalCodeGenerator, Object object2) {
        throw new RuntimeException("Not supported.");
    }

    private Object readResolve() throws ObjectStreamException {
        return s_integerType;
    }

    @Override
    public String getDefaultValue() {
        return "0";
    }

    public static Object convertToInteger(IntegerSettings integerSettings, Long l) {
        if (integerSettings.getArbitraryPrecision()) {
            return BigInteger.valueOf(l);
        }
        return l;
    }
}

