/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.PrimitiveNumericalType;
import java.io.ObjectStreamException;

public final class FloatType
extends PrimitiveNumericalType {
    private static final long serialVersionUID = -910053815345277840L;
    public static final FloatType s_floatType = new FloatType();
    private static short[] s_branchOpcode = new short[]{0, 0, 0, 0, 0, 158, 155, 156, 157, 154};

    private FloatType() {
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper fcgCodeGenHelper) {
        return FcgType.FLOAT;
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return "float";
    }

    @Override
    public Class getJavaType(IntegerSettings integerSettings) {
        return Float.TYPE;
    }

    @Override
    public Object evaluateOperation(IntegerSettings integerSettings, Object object2, Object object3, int n2) {
        switch (n2) {
            case 0: {
                return new Float(((Float)object2).floatValue() + ((Float)object3).floatValue());
            }
            case 1: {
                return new Float(((Float)object2).floatValue() - ((Float)object3).floatValue());
            }
            case 2: {
                return new Float(((Float)object2).floatValue() * ((Float)object3).floatValue());
            }
            case 3: {
                return new Float(((Float)object2).floatValue() / ((Float)object3).floatValue());
            }
            case 4: {
                return new Float(((Float)object2).floatValue() % ((Float)object3).floatValue());
            }
            case 5: {
                return ((Float)object2).floatValue() > ((Float)object3).floatValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return ((Float)object2).floatValue() >= ((Float)object3).floatValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return ((Float)object2).floatValue() < ((Float)object3).floatValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return ((Float)object2).floatValue() <= ((Float)object3).floatValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return ((Float)object2).floatValue() == ((Float)object3).floatValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return new Float(-((Float)object2).floatValue());
            }
            case 17: {
                return Float.valueOf((float)Math.floor(((Float)object2).doubleValue()));
            }
            case 18: {
                return Float.valueOf((float)Math.ceil(((Float)object2).doubleValue()));
            }
        }
        throw new UnsupportedOperationException("The " + PrimitiveNumericalType.getOperator(n2) + " operator is not supported on float.");
    }

    @Override
    public void generateLoadLiteralValue(FinalCodeGenerator finalCodeGenerator, Object object2) {
        finalCodeGenerator.loadLiteral(object2 != null ? ((Float)object2).floatValue() : 0.0f);
    }

    private Object readResolve() throws ObjectStreamException {
        return s_floatType;
    }

    @Override
    public String getDefaultValue() {
        return "0.0";
    }
}

