/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.PrimitiveNumericalType;
import java.io.ObjectStreamException;

public final class DoubleType
extends PrimitiveNumericalType {
    private static final long serialVersionUID = -3363106463616654709L;
    public static final DoubleType s_doubleType = new DoubleType();
    private static short[] s_branchOpcode = new short[]{0, 0, 0, 0, 0, 158, 155, 156, 157, 154};

    private DoubleType() {
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper fcgCodeGenHelper) {
        return FcgType.DOUBLE;
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return "double";
    }

    @Override
    public Class getJavaType(IntegerSettings integerSettings) {
        return Double.TYPE;
    }

    @Override
    public Object evaluateOperation(IntegerSettings integerSettings, Object object2, Object object3, int n2) {
        switch (n2) {
            case 0: {
                return new Double((Double)object2 + (Double)object3);
            }
            case 1: {
                return new Double((Double)object2 - (Double)object3);
            }
            case 2: {
                return new Double((Double)object2 * (Double)object3);
            }
            case 3: {
                return new Double((Double)object2 / (Double)object3);
            }
            case 4: {
                return new Double((Double)object2 % (Double)object3);
            }
            case 5: {
                return (Double)object2 > (Double)object3 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return (Double)object2 >= (Double)object3 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return (Double)object2 < (Double)object3 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return (Double)object2 <= (Double)object3 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return ((Double)object2).doubleValue() == ((Double)object3).doubleValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return new Double(-((Double)object2).doubleValue());
            }
            case 17: {
                return Math.floor((Double)object2);
            }
            case 18: {
                return Math.ceil((Double)object2);
            }
        }
        throw new UnsupportedOperationException("The " + PrimitiveNumericalType.getOperator(n2) + " operator is not supported on double.");
    }

    @Override
    public void generateLoadLiteralValue(FinalCodeGenerator finalCodeGenerator, Object object2) {
        finalCodeGenerator.loadLiteral(object2 != null ? (Double)object2 : 0.0);
    }

    private Object readResolve() throws ObjectStreamException {
        return s_doubleType;
    }

    @Override
    public String getDefaultValue() {
        return "0.0";
    }
}

