/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgOperation;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.SingletonType;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public final class DecimalType
extends SingletonType
implements INumericalType {
    private static final long serialVersionUID = -8135514283342527595L;
    public static final DecimalType s_decimalType = new DecimalType();
    public static final int DECIMAL_PRECISION = 18;

    private DecimalType() {
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return "java.math.BigDecimal";
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper fcgCodeGenHelper) {
        return FcgType.BIG_DECIMAL;
    }

    @Override
    public Class getJavaType(IntegerSettings integerSettings) {
        return BigDecimal.class;
    }

    @Override
    public Object evaluateOperation(IntegerSettings integerSettings, Object object2, Object object3, int n2) {
        BigDecimal bigDecimal = (BigDecimal)object2;
        BigDecimal bigDecimal2 = (BigDecimal)object3;
        switch (n2) {
            case 0: {
                return bigDecimal.add(bigDecimal2);
            }
            case 1: {
                return bigDecimal.subtract(bigDecimal2);
            }
            case 2: {
                return bigDecimal.multiply(bigDecimal2);
            }
            case 3: {
                BigDecimal[] bigDecimalArray = bigDecimal.divideAndRemainder(bigDecimal2);
                return bigDecimalArray[0].add(bigDecimalArray[1].divide(bigDecimal2, new MathContext(18, RoundingMode.HALF_UP))).stripTrailingZeros();
            }
            case 4: {
                return bigDecimal.remainder(bigDecimal2);
            }
            case 9: {
                return bigDecimal.compareTo(bigDecimal2) == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: 
            case 11: 
            case 12: {
                throw new UnsupportedOperationException("Bitwise operators not supported on BigDecimal");
            }
            case 16: {
                return bigDecimal.negate();
            }
            case 17: {
                return bigDecimal.setScale(0, 3);
            }
            case 18: {
                return bigDecimal.setScale(0, 2);
            }
        }
        return IntType.s_intType.evaluateComparisonOperation(object2, object3, n2);
    }

    @Override
    public FcgType generateCodeForOperation(FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList, FcgOperation fcgOperation) {
        if (fcgOperation.equals(FcgBinOp.PLUS)) {
            return fcgInstructionList.invokeInstanceMethod(FcgType.BIG_DECIMAL, "add", (FcgType)FcgType.BIG_DECIMAL, 1);
        }
        if (fcgOperation.equals(FcgBinOp.SUBTRACT)) {
            return fcgInstructionList.invokeInstanceMethod(FcgType.BIG_DECIMAL, "subtract", (FcgType)FcgType.BIG_DECIMAL, 1);
        }
        if (fcgOperation.equals(FcgBinOp.MULTIPLY)) {
            return fcgInstructionList.invokeInstanceMethod(FcgType.BIG_DECIMAL, "multiply", (FcgType)FcgType.BIG_DECIMAL, 1);
        }
        if (fcgOperation.equals(FcgBinOp.DIVIDE)) {
            FcgVariable fcgVariable = fcgInstructionList.defineVar(FcgType.BIG_DECIMAL, fcgCodeGenHelper.generateNewLocalVariableName(), true);
            fcgInstructionList.loadVar(fcgVariable);
            FcgClassReferenceType fcgClassReferenceType = fcgCodeGenHelper.getClassReferenceType("java.math.MathContext");
            FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGenHelper.getClassReferenceType("java.math.RoundingMode");
            fcgInstructionList.invokeInstanceMethod(FcgType.BIG_DECIMAL, "divideAndRemainder", fcgCodeGenHelper.getArrayType(FcgType.BIG_DECIMAL), 1);
            FcgVariable fcgVariable2 = fcgInstructionList.defineVar(fcgCodeGenHelper.getArrayType(FcgType.BIG_DECIMAL), fcgCodeGenHelper.generateNewLocalVariableName(), true);
            fcgInstructionList.loadVar(fcgVariable2);
            fcgInstructionList.loadLiteral(0);
            fcgInstructionList.loadArrayElement(FcgType.BIG_DECIMAL);
            fcgInstructionList.loadVar(fcgVariable2);
            fcgInstructionList.loadLiteral(1);
            fcgInstructionList.loadArrayElement(FcgType.BIG_DECIMAL);
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadLiteral(18);
            fcgInstructionList.loadClassField(fcgClassReferenceType2, "HALF_UP", fcgClassReferenceType2);
            fcgInstructionList.createObjectExpr((FcgType)fcgClassReferenceType, 2);
            fcgInstructionList.invokeInstanceMethod(FcgType.BIG_DECIMAL, "divide", (FcgType)FcgType.BIG_DECIMAL, 2);
            fcgInstructionList.invokeInstanceMethod(FcgType.BIG_DECIMAL, "add", (FcgType)FcgType.BIG_DECIMAL, 1);
            return fcgInstructionList.invokeInstanceMethod(FcgType.BIG_DECIMAL, "stripTrailingZeros", (FcgType)FcgType.BIG_DECIMAL, 0);
        }
        if (fcgOperation.equals(FcgBinOp.MODULO)) {
            return fcgInstructionList.invokeInstanceMethod(FcgType.BIG_DECIMAL, "remainder", (FcgType)FcgType.BIG_DECIMAL, 1);
        }
        if (fcgOperation.equals(FcgUnaryOp.NEGATIVE)) {
            return fcgInstructionList.invokeInstanceMethod(FcgType.BIG_DECIMAL, "negate", (FcgType)FcgType.BIG_DECIMAL, 0);
        }
        if (fcgOperation.equals(FcgBinOp.LOGICAL_AND) || fcgOperation.equals(FcgBinOp.LOGICAL_OR) || fcgOperation.equals(FcgBinOp.LOGICAL_XOR)) {
            throw new UnsupportedOperationException("Bitwise operators not supported on BigDecimal");
        }
        fcgInstructionList.invokeInstanceMethod(FcgType.BIG_DECIMAL, "compareTo", (FcgType)FcgType.INT, 1);
        fcgInstructionList.loadLiteral(0);
        return fcgInstructionList.binaryOperationExpr((FcgBinOp)fcgOperation);
    }

    @Override
    public void generateLoadLiteralValue(FinalCodeGenerator finalCodeGenerator, Object object2) {
        finalCodeGenerator.loadLiteral(object2 != null ? (BigDecimal)object2 : new BigDecimal(0));
    }

    private Object readResolve() throws ObjectStreamException {
        return s_decimalType;
    }

    @Override
    public String getDefaultValue() {
        return "new java.math.BigDecimal(0.0)";
    }
}

