/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgOperation;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.SingletonType;
import java.io.ObjectStreamException;
import java.math.BigInteger;

public final class BigIntegerType
extends SingletonType
implements INumericalType {
    private static final long serialVersionUID = 667048260768868471L;
    public static final BigIntegerType s_bigIntegerType = new BigIntegerType();
    private static String[] s_arithmeticMethodNames = new String[]{"add", "subtract", "multiply", "divide", "mod", null, null, null, null, null, "and", "or", "xor"};

    private BigIntegerType() {
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    public String toString() {
        return "java.math.BigInteger";
    }

    @Override
    public FcgType getFCGType(FcgCodeGenHelper fcgCodeGenHelper) {
        return FcgType.BIG_INTEGER;
    }

    @Override
    public Class getJavaType(IntegerSettings integerSettings) {
        return BigInteger.class;
    }

    @Override
    public Object evaluateOperation(IntegerSettings integerSettings, Object object2, Object object3, int n2) {
        BigInteger bigInteger = (BigInteger)object2;
        BigInteger bigInteger2 = (BigInteger)object3;
        switch (n2) {
            case 0: {
                return bigInteger.add(bigInteger2);
            }
            case 1: {
                return bigInteger.subtract(bigInteger2);
            }
            case 2: {
                return bigInteger.multiply(bigInteger2);
            }
            case 3: {
                return bigInteger.divide(bigInteger2);
            }
            case 4: {
                return bigInteger.remainder(bigInteger2);
            }
            case 10: {
                return bigInteger.and(bigInteger2);
            }
            case 11: {
                return bigInteger.or(bigInteger2);
            }
            case 12: {
                return bigInteger.xor(bigInteger2);
            }
            case 16: {
                return bigInteger.negate();
            }
            case 17: 
            case 18: {
                return bigInteger;
            }
        }
        return IntType.s_intType.evaluateComparisonOperation(object2, object3, n2);
    }

    @Override
    public void generateLoadLiteralValue(FinalCodeGenerator finalCodeGenerator, Object object2) {
        finalCodeGenerator.loadLiteral(object2 != null ? (BigInteger)object2 : BigInteger.ZERO);
    }

    private Object readResolve() throws ObjectStreamException {
        return s_bigIntegerType;
    }

    @Override
    public String getDefaultValue() {
        return "new BigInteger(\"0\")";
    }

    @Override
    public FcgType generateCodeForOperation(FcgCodeGenHelper fcgCodeGenHelper, FcgInstructionList fcgInstructionList, FcgOperation fcgOperation) {
        FcgType fcgType = fcgOperation instanceof FcgBinOp ? fcgInstructionList.binaryOperationExpr((FcgBinOp)fcgOperation) : fcgInstructionList.unaryOperationExpr((FcgUnaryOp)fcgOperation);
        return fcgType;
    }
}

