/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.types;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGeneration;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.CompoundType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;

public abstract class AbstractDataType
extends CompoundType {
    public Constructor[] m_constructors;

    public AbstractDataType() {
    }

    protected AbstractDataType(String string2, Constructor[] constructorArray) {
        super(string2);
        if (constructorArray != null) {
            this.setConstructors(constructorArray);
        }
    }

    public String getImplementationName(FcgCodeGenHelper fcgCodeGenHelper) {
        return fcgCodeGenHelper.getClassName() + "$" + fcgCodeGenHelper.getSafeName(this.getName());
    }

    public String toString() {
        return this.getName();
    }

    public String debugToString() {
        String string2 = "(" + this.getName();
        for (int i = 0; i < this.m_constructors.length; ++i) {
            Constructor constructor = this.m_constructors[i];
            string2 = string2 + " (" + constructor.m_name + ")";
        }
        return string2 + ")";
    }

    public int getChildTypeCount() {
        int n2 = 0;
        for (int i = 0; i < this.m_constructors.length; ++i) {
            n2 += this.m_constructors[i].m_parameters.length;
        }
        return n2;
    }

    public Type getChildType(int n2) {
        for (int i = 0; i < this.m_constructors.length; ++i) {
            Constructor constructor = this.m_constructors[i];
            for (int j = 0; j < constructor.m_parameters.length; ++j) {
                if (n2 == 0) {
                    return constructor.m_parameters[j].getBindingType();
                }
                --n2;
            }
        }
        return null;
    }

    public void setChildType(int n2, Type type2) {
        for (int i = 0; i < this.m_constructors.length; ++i) {
            Constructor constructor = this.m_constructors[i];
            for (int j = 0; j < constructor.m_parameters.length; ++j) {
                if (n2 == 0) {
                    constructor.m_parameters[j].setType(type2);
                    return;
                }
                --n2;
            }
        }
    }

    public void setConstructors(Constructor[] constructorArray) {
        if (this.m_constructors != null && this.m_constructors.length != 0) {
            throw new Error("Tried to overwrite existing (" + this.m_constructors.length + ") constructors in " + this.getName() + " (don't do that!)");
        }
        this.m_constructors = constructorArray;
        for (int i = 0; i < this.m_constructors.length; ++i) {
            this.m_constructors[i].m_adt = this;
        }
    }

    public Constructor getConstructor(String string2) {
        for (int i = 0; i < this.m_constructors.length; ++i) {
            if (!this.m_constructors[i].getName().equals(string2)) continue;
            return this.m_constructors[i];
        }
        return null;
    }

    public int getConstructorCount() {
        return this.m_constructors == null ? 0 : this.m_constructors.length;
    }

    public Constructor getConstructor(int n2) {
        return this.m_constructors[n2];
    }

    public abstract FcgVariable generateConstructorTypeDeconstructionCode(FcgCodeGenHelper var1, String var2, FcgInstructionList var3);

    public abstract void generateConstructorDeconstructionCode(FcgCodeGenHelper var1, String var2, CodeGenerationTracker var3, FcgVariable[] var4, Constructor var5, FcgInstructionList var6);

    public abstract CodeGenerationTracker generateConstructorDeconstructionCode(FcgCodeGenHelper var1, String var2, CodeGenerationTracker var3, Binding[] var4, Constructor var5, Instruction var6, Binding var7, FcgInstructionList var8);

    public abstract CodeGenerationTracker generateConstructorDeconstructionCodeForSome(FcgCodeGenHelper var1, FcgInstructionList var2, String var3, CodeGenerationTracker var4, Binding[] var5, Constructor var6, Instruction var7, Binding var8, boolean[] var9);

    public abstract FcgType generateConstructorConstructionCode(FcgCodeGenHelper var1, CodeGenerationTracker var2, Constructor var3, Instruction[] var4, NamedType var5, FcgInstructionList var6);

    public abstract void generateCode(FcgCodeGenHelper var1);

    public abstract void toString(PrettyPrinter var1, int var2);

    public void addComment(String string2) {
    }

    @Override
    public boolean refersToType(Type type2, ITypeStore iTypeStore, HashSet hashSet) {
        for (int i = 0; i < this.m_constructors.length; ++i) {
            Constructor constructor = this.m_constructors[i];
            for (int j = 0; j < constructor.m_parameters.length; ++j) {
                if (!constructor.m_parameters[j].getBindingType().refersToType(type2, iTypeStore, hashSet)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Constructor
    implements Serializable {
        private static final long serialVersionUID = -18502971452733861L;
        protected String m_name;
        public Binding[] m_parameters;
        protected AbstractDataType m_adt;
        public String[] m_defaultValues;

        public Constructor(String string2, Binding[] bindingArray) {
            this.m_name = string2;
            this.m_parameters = bindingArray;
        }

        public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
            writeObjectFileHelper.writeString(this.m_name);
            writeObjectFileHelper.writeTypeSpecificBindingSet(this.m_parameters);
            writeObjectFileHelper.writeObject(this.m_adt);
            writeObjectFileHelper.writeInt(this.m_defaultValues == null ? 0 : this.m_defaultValues.length);
            if (this.m_defaultValues != null) {
                for (int i = 0; i < this.m_defaultValues.length; ++i) {
                    writeObjectFileHelper.writeBoolean(this.m_defaultValues[i] != null);
                    if (this.m_defaultValues[i] == null) continue;
                    writeObjectFileHelper.writeString(this.m_defaultValues[i]);
                }
            }
        }

        public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
            this.m_name = readObjectFileHelper.readString();
            this.m_parameters = readObjectFileHelper.readTypeSpecificBindingSet();
            this.m_adt = (AbstractDataType)readObjectFileHelper.readObject();
            int n2 = readObjectFileHelper.readInt();
            if (n2 > 0) {
                this.m_defaultValues = new String[n2];
                for (int i = 0; i < this.m_defaultValues.length; ++i) {
                    if (!readObjectFileHelper.readBoolean()) continue;
                    this.m_defaultValues[i] = readObjectFileHelper.readString();
                }
            }
        }

        public String getName() {
            return this.m_name;
        }

        public Object[] getParameterNames() {
            Object[] objectArray = new Object[this.m_parameters.length];
            for (int i = 0; i < this.m_parameters.length; ++i) {
                objectArray[i] = this.m_parameters[i].getName();
            }
            return objectArray;
        }

        public Type[] getParameterTypes() {
            Type[] typeArray = new Type[this.m_parameters.length];
            for (int i = 0; i < this.m_parameters.length; ++i) {
                typeArray[i] = this.m_parameters[i].getBindingType();
            }
            return typeArray;
        }

        public boolean isForkReleaseManaged(CodeGenerationTracker codeGenerationTracker) {
            boolean bl = false;
            for (int i = 0; i < this.m_parameters.length; ++i) {
                bl |= this.m_parameters[i].getBindingType().isForkReleaseManaged(codeGenerationTracker);
            }
            return bl;
        }

        public AbstractDataType getAbstractDataType() {
            return this.m_adt;
        }

        public int getIndex() {
            for (int i = 0; i < this.m_adt.m_constructors.length; ++i) {
                if (this.m_adt.m_constructors[i] != this) continue;
                return i;
            }
            return -1;
        }

        public int findBinding(Binding binding) {
            for (int i = 0; i < this.m_parameters.length; ++i) {
                if (this.m_parameters[i] != binding) continue;
                return i;
            }
            return -1;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            stringBuffer.append(this.m_name);
            stringBuffer.append("@");
            stringBuffer.append(this.m_adt);
            stringBuffer.append(" ");
            for (int i = 0; i < this.m_parameters.length; ++i) {
                stringBuffer.append(this.m_parameters[i]);
                if (i >= this.m_parameters.length - 1) continue;
                stringBuffer.append(" ");
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public void toString(PrettyPrinter prettyPrinter, int n2) {
            prettyPrinter.printFormOpen(this.m_name, n2);
            for (int i = 0; i < this.m_parameters.length; ++i) {
                prettyPrinter.printIdentifier(this.m_parameters[i], n2 + 1);
                prettyPrinter.print("@");
                prettyPrinter.print(this.m_parameters[i].getBindingType().prettyPrint());
            }
            prettyPrinter.printFormClose(n2);
        }

        public String prettyPrint() {
            StringBuffer stringBuffer = new StringBuffer();
            Type[] typeArray = this.getParameterTypes();
            stringBuffer.append(this.m_adt.getModuleName());
            stringBuffer.append('.');
            stringBuffer.append(this.m_name);
            stringBuffer.append("(");
            for (int i = 0; i < typeArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(typeArray[i].prettyPrint());
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public String getConstructorQualifiedFieldName(int n2, CodeGeneration codeGeneration) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("m_");
            stringBuffer.append(codeGeneration.getSafeName(this.getName()));
            stringBuffer.append("_");
            stringBuffer.append(Binding.generateVariableName(this.m_parameters[n2], codeGeneration));
            return stringBuffer.toString();
        }
    }
}

