/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.parser;

import com.ibm.xltxe.rnm1.xylem.parser.ParserException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;

public class ParserSource {
    protected PushbackReader m_reader;
    protected int m_lineNumber = 1;
    private boolean m_prev_was_CR;
    private boolean m_CR_seen;
    protected int m_offset = 0;
    protected URL m_currentURL = null;

    public ParserSource() {
        this.m_currentURL = null;
    }

    public ParserSource(URL uRL) throws ParserException {
        this.m_currentURL = uRL;
        this.m_reader = new PushbackReader(this.getInputStreamReader(this.m_currentURL), 256);
    }

    public ParserSource(Reader reader, URL uRL) {
        this.m_currentURL = uRL;
        this.m_reader = new PushbackReader(reader, 256);
    }

    public ParserSource(Reader reader) {
        this(reader, null);
    }

    private final InputStreamReader getInputStreamReader(URL uRL) throws ParserException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            return new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new InputStreamReader(inputStream);
        }
        catch (Exception exception) {
            throw new ParserException("Error reading URL " + uRL, exception);
        }
    }

    public void unread(char c) throws ParserException {
        try {
            this.m_reader.unread(c);
            --this.m_offset;
        }
        catch (IOException iOException) {
            throw new ParserException("I/O error", iOException);
        }
    }

    public char read() throws ParserException {
        int n2;
        try {
            n2 = this.m_reader.read();
            ++this.m_offset;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new ParserException("I/O error", iOException);
        }
        switch (n2) {
            case -1: {
                throw new ParserException("Unexpected end of file");
            }
            case 13: {
                this.m_CR_seen = true;
                if (this.m_prev_was_CR) break;
                this.m_offset = 0;
                ++this.m_lineNumber;
                this.m_prev_was_CR = true;
                break;
            }
            case 10: {
                this.m_offset = 0;
                if (!this.m_CR_seen) {
                    ++this.m_lineNumber;
                    this.m_offset = 0;
                }
                this.m_prev_was_CR = false;
                break;
            }
            default: {
                this.m_prev_was_CR = false;
            }
        }
        return (char)n2;
    }
}

