/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.parser;

import com.ibm.xltxe.rnm1.xylem.AbstractTypeStore;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Functor;
import com.ibm.xltxe.rnm1.xylem.FunctorApplicationDirective;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StaticMethodInvocationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.parser.CoreFormHandler;
import com.ibm.xltxe.rnm1.xylem.parser.CoreTypeHandler;
import com.ibm.xltxe.rnm1.xylem.parser.IFormHandler;
import com.ibm.xltxe.rnm1.xylem.parser.ITypeHandler;
import com.ibm.xltxe.rnm1.xylem.parser.ParserException;
import com.ibm.xltxe.rnm1.xylem.parser.ParserSource;
import com.ibm.xltxe.rnm1.xylem.parser.SourceResolver;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.ConstructorDataType;
import com.ibm.xltxe.rnm1.xylem.types.JavaArrayType;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.types.LazyStreamType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.NullableType;
import com.ibm.xltxe.rnm1.xylem.types.PromiseType;
import com.ibm.xltxe.rnm1.xylem.types.SlotType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TagType;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.types.UnionType;
import com.ibm.xltxe.rnm1.xylem.types.VirtualDataTypeMap;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class Parser {
    protected HashMap m_formHandlers = new HashMap();
    protected HashMap m_typeHandlers = new HashMap();
    protected URL m_baseURL = null;
    protected ArrayList m_typeFixups = new ArrayList();
    protected ArrayList m_parsedLibrary = new ArrayList();
    protected ModuleSignatureStore m_knownModuleSignatures;
    protected HashMap m_typeVariables;
    protected HashMap m_importedJavaStaticMethods = new HashMap();
    protected ParserSource m_currentSource;
    protected ArrayList m_sourceStack = new ArrayList();
    protected SourceResolver m_sourceResolver;
    protected static final boolean REQUIRED = true;
    static final String s_hextable = "0123456789abcdef";

    public Parser(SourceResolver sourceResolver, ParserSource parserSource) {
        this(sourceResolver, parserSource, new ModuleSignatureStore(new LinkedList<URL>()));
    }

    public Parser(SourceResolver sourceResolver, ParserSource parserSource, ModuleSignatureStore moduleSignatureStore) {
        this.m_knownModuleSignatures = moduleSignatureStore;
        new CoreFormHandler().registerForms(this);
        new CoreTypeHandler().registerTypes(this);
        this.m_currentSource = parserSource;
        this.m_sourceResolver = sourceResolver;
        this.m_baseURL = parserSource.m_currentURL;
    }

    public void registerForm(String string2, IFormHandler iFormHandler) {
        this.m_formHandlers.put(string2, iFormHandler);
    }

    public void registerModuleSignature(String string2, ModuleSignature moduleSignature) {
        this.m_knownModuleSignatures.registerModuleSignature(string2, moduleSignature);
    }

    public void registerType(String string2, ITypeHandler iTypeHandler) {
        this.m_typeHandlers.put(string2, iTypeHandler);
    }

    protected void unread(char c) throws ParserException {
        this.m_currentSource.unread(c);
    }

    protected char read() throws ParserException {
        char c = this.m_currentSource.read();
        return c;
    }

    public char readStripComments() throws ParserException {
        char c = this.read();
        if (c == ';') {
            while ((c = this.read()) != '\n') {
            }
        }
        return c;
    }

    public int getOffsetInLine() {
        return this.m_currentSource.m_offset;
    }

    public int getLineNumber() {
        return this.m_currentSource.m_lineNumber;
    }

    public URL getCurrentURL() {
        return this.m_currentSource.m_currentURL;
    }

    public void parseOpenParen() throws ParserException {
        char c;
        while (Character.isWhitespace(c = this.readStripComments())) {
        }
        if (c != '(') {
            throw new ParserException("Expected ( but found " + c, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
    }

    public boolean parseOpenParenOrEnd() throws ParserException {
        char c;
        while (Character.isWhitespace(c = this.readStripComments())) {
        }
        if (c != '(') {
            if (c == ')') {
                return false;
            }
            throw new ParserException("Expected ( or ) but found " + c, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        return true;
    }

    public String parseFormProlog() throws ParserException {
        this.parseOpenParen();
        return this.parseIdentifier(true);
    }

    public String parseFormPrologOrEnd() throws ParserException {
        if (!this.parseOpenParenOrEnd()) {
            return null;
        }
        return this.parseIdentifier(true);
    }

    public void parseCloseParen() throws ParserException {
        char c;
        while (Character.isWhitespace(c = this.readStripComments())) {
        }
        if (c != ')') {
            throw new ParserException("Expected ) but found " + c, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
    }

    public Instruction parseForm(ITypeStore iTypeStore) throws ParserException {
        return this.parseForm(this.parseFormProlog(), iTypeStore);
    }

    public Instruction parseForm(String string2, ITypeStore iTypeStore) throws ParserException {
        Instruction instruction2;
        IFormHandler iFormHandler = (IFormHandler)this.m_formHandlers.get(string2);
        if (iFormHandler == null) {
            StaticMethodSpec staticMethodSpec = (StaticMethodSpec)this.m_importedJavaStaticMethods.get(string2);
            if (staticMethodSpec != null) {
                instruction2 = new StaticMethodInvocationInstruction(staticMethodSpec.m_class, staticMethodSpec.m_methodName, this.parseRemainingExpressions(iTypeStore), staticMethodSpec.m_returnType);
                if (instruction2.getChildInstructionCount() != staticMethodSpec.m_parameterTypes.length) {
                    throw new ParserException("Invalid number of parameters to static Java method", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                }
            } else {
                instruction2 = new FunctionCallInstruction(string2, this.parseRemainingExpressions(iTypeStore));
            }
        } else {
            instruction2 = iFormHandler.parseForm(string2, this, iTypeStore);
        }
        if (this.getCurrentURL() != null) {
            instruction2.setSourceFilename(this.getCurrentURL());
        }
        instruction2.setSourceLineNumber(this.getLineNumber());
        return instruction2;
    }

    public String parseIdentifier() throws ParserException {
        return this.parseIdentifier(true);
    }

    public String parseIdentifier(boolean bl) throws ParserException {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            char c;
            if (Character.isWhitespace(c = this.readStripComments()) || c == '@') {
                String string3 = stringBuffer.toString();
                if (string3.length() == 0) {
                    if (c != '@') continue;
                    string2 = "@";
                    break;
                }
                if (c == '@') {
                    this.unread('@');
                }
                string2 = string3;
                break;
            }
            if (c == ')' || c == '(') {
                this.unread(c);
                if (stringBuffer.length() == 0) {
                    if (bl) {
                        throw new ParserException("Unexpected \"" + c + "\"", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    string2 = null;
                    break;
                }
                string2 = stringBuffer.toString();
                break;
            }
            stringBuffer.append(c);
        }
        return string2;
    }

    protected Type[] parseRemainingTypes(ITypeStore iTypeStore) throws ParserException {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        while (true) {
            Type type2;
            if ((type2 = this.parseTypeName(iTypeStore, false)) == null) {
                Type[] typeArray = new Type[arrayList.size()];
                arrayList.toArray(typeArray);
                return typeArray;
            }
            arrayList.add(type2);
        }
    }

    protected Type[] parseUnionType(ITypeStore iTypeStore, boolean bl) throws ParserException {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        while (true) {
            Type type2;
            if ((type2 = this.parseUnionTypeName(iTypeStore, true)) == null) {
                Type[] typeArray = new Type[arrayList.size()];
                arrayList.toArray(typeArray);
                return typeArray;
            }
            arrayList.add(type2);
        }
    }

    protected Type parseUnionTypeName(ITypeStore iTypeStore, boolean bl) throws ParserException {
        String string2;
        char c;
        while (Character.isSpaceChar(c = this.readStripComments()) || c == '\n' || c == '\r' || c == '\t') {
        }
        if (c == ')') {
            return null;
        }
        if (c != '(') {
            this.unread(c);
        }
        if ((string2 = this.parseIdentifier(bl)) == null) {
            return null;
        }
        return this._parseTypeName(iTypeStore, string2);
    }

    public Type parseTypeName(ITypeStore iTypeStore) throws ParserException {
        return this.parseTypeName(iTypeStore, true);
    }

    public Type parseTypeName(ITypeStore iTypeStore, boolean bl) throws ParserException {
        char c;
        while (Character.isSpaceChar(c = this.readStripComments()) || c == '\n' || c == '\r' || c == '\t') {
        }
        if (c == '(') {
            Type type2;
            String string2 = this.parseIdentifier(true);
            if (string2.equals("slot")) {
                type2 = new SlotType(this.parseTypeName(iTypeStore));
            } else if (string2.equals("promise")) {
                type2 = new PromiseType(this.parseTypeName(iTypeStore));
            } else if (string2.equals("tag")) {
                type2 = new TagType(this.parseIdentifier(), this.parseTypeName(iTypeStore));
            } else if (string2.equals("nullable")) {
                type2 = new NullableType(this.parseTypeName(iTypeStore));
            } else if (string2.equals("lazy-stream")) {
                type2 = new LazyStreamType(this.parseTypeName(iTypeStore));
            } else if (string2.equals("->")) {
                this.parseOpenParen();
                Type[] typeArray = this.parseRemainingTypes(iTypeStore);
                this.parseCloseParen();
                type2 = new LambdaType(typeArray, this.parseTypeName(iTypeStore), true);
            } else if (string2.equals("!->")) {
                this.parseOpenParen();
                Type[] typeArray = this.parseRemainingTypes(iTypeStore);
                this.parseCloseParen();
                type2 = new LambdaType(typeArray, this.parseTypeName(iTypeStore), false);
            } else if (string2.equals("tuple")) {
                type2 = new TupleType(this.parseRemainingTypes(iTypeStore));
            } else if (string2.equals("union")) {
                type2 = new UnionType(this.parseUnionType(iTypeStore, true));
            } else if (string2.equals("java-array")) {
                type2 = this.parseTypeName(iTypeStore);
                int n2 = this.parseInteger();
                type2 = new JavaArrayType(type2, n2);
            } else if (string2.equals("java")) {
                type2 = new JavaObjectType(this.parseIdentifier());
            } else {
                Type[] typeArray = this.parseRemainingTypes(iTypeStore);
                type2 = new NamedType(string2, iTypeStore.getName(), typeArray);
            }
            this.parseCloseParen();
            c = this.readStripComments();
            if (c == '[') {
                c = this.readStripComments();
                if (c == ']') {
                    return new StreamType(type2);
                }
                this.unread(c);
            } else {
                this.unread(c);
            }
            return type2;
        }
        this.unread(c);
        String string3 = this.parseIdentifier(bl);
        if (string3 == null) {
            return null;
        }
        return this._parseTypeName(iTypeStore, string3);
    }

    public Instruction[] parseRemainingExpressions(ITypeStore iTypeStore) throws ParserException {
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        while (true) {
            Instruction instruction2;
            if ((instruction2 = this.parseExpression(iTypeStore, false)) == null) {
                Instruction[] instructionArray = new Instruction[arrayList.size()];
                arrayList.toArray(instructionArray);
                return instructionArray;
            }
            arrayList.add(instruction2);
        }
    }

    public Object[] parseRemainingIdentifiers() throws ParserException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2;
        while ((string2 = this.parseIdentifier(false)) != null) {
            arrayList.add(string2);
        }
        return arrayList.toArray();
    }

    public Type _parseTypeName(ITypeStore iTypeStore, String string2) throws ParserException {
        Type type2;
        boolean bl = false;
        if (string2.endsWith("[]")) {
            string2 = string2.substring(0, string2.length() - 2);
            bl = true;
        }
        if (string2.startsWith("?")) {
            if (this.m_typeVariables == null) {
                throw new ParserException("Type variables not allowed here", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            type2 = (Type)this.m_typeVariables.get(string2.substring(1));
            if (type2 == null) {
                type2 = new TypeVariable();
                this.m_typeVariables.put(string2.substring(1), type2);
            }
        } else {
            ITypeHandler iTypeHandler = (ITypeHandler)this.m_typeHandlers.get(string2);
            if (iTypeHandler == null) {
                type2 = iTypeStore.lookupTypeAlias(string2);
                if (type2 == null) {
                    type2 = new NamedType(string2);
                }
            } else {
                type2 = iTypeHandler.parseType(string2, this);
            }
            if (type2 == null) {
                throw new ParserException("Unknown type name: " + string2, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
        }
        return bl ? new StreamType(type2) : type2;
    }

    public Instruction parseExpression(ITypeStore iTypeStore) throws ParserException {
        return this.parseExpression(iTypeStore, true);
    }

    public Instruction parseExpression(ITypeStore iTypeStore, boolean bl) throws ParserException {
        char c;
        while (Character.isWhitespace(c = this.readStripComments())) {
        }
        if (c == '(') {
            this.unread(c);
            return this.parseForm(iTypeStore);
        }
        if (c == ')') {
            if (bl) {
                throw new ParserException("Unexpected ')'", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            return null;
        }
        if (c == '\"') {
            StreamInstruction streamInstruction = StreamInstruction.charStreamLiteral(this.parseStringLiteral());
            streamInstruction.setSourceFilename(this.m_currentSource.m_currentURL);
            streamInstruction.setSourceLineNumber(this.m_currentSource.m_lineNumber);
            return streamInstruction;
        }
        if (c == '\'') {
            char c2 = this.read();
            if (c2 == '\\') {
                c2 = this.resolveEscapeSequence();
            }
            if (this.read() != '\'') {
                throw new ParserException("Malformed character literal", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            return LiteralInstruction.charLiteral(c2);
        }
        if (Character.isDigit(c) || c == '-' || c == '.') {
            this.unread(c);
            return this.parseNumber();
        }
        this.unread(c);
        Object object2 = this.parseName(bl);
        if (!bl && object2 == null) {
            return null;
        }
        if (object2.equals("true")) {
            return LiteralInstruction.booleanTrueLiteral();
        }
        if (object2.equals("false")) {
            return LiteralInstruction.booleanFalseLiteral();
        }
        if (object2.equals("unit")) {
            return LiteralInstruction.unitLiteral();
        }
        if (object2.equals("floatNaN")) {
            return LiteralInstruction.floatLiteral(Float.NaN);
        }
        if (object2.equals("floatPosINF")) {
            return LiteralInstruction.floatLiteral(Float.POSITIVE_INFINITY);
        }
        if (object2.equals("floatNegINF")) {
            return LiteralInstruction.floatLiteral(Float.NEGATIVE_INFINITY);
        }
        if (object2.equals("doubleNaN")) {
            return LiteralInstruction.doubleLiteral(Double.NaN);
        }
        if (object2.equals("doublePosINF")) {
            return LiteralInstruction.doubleLiteral(Double.POSITIVE_INFINITY);
        }
        if (object2.equals("doubleNegINF")) {
            return LiteralInstruction.doubleLiteral(Double.NEGATIVE_INFINITY);
        }
        IdentifierInstruction identifierInstruction = new IdentifierInstruction(object2);
        if (this.getCurrentURL() != null) {
            identifierInstruction.setSourceFilename(this.getCurrentURL());
        }
        identifierInstruction.setSourceLineNumber(this.getLineNumber());
        return identifierInstruction;
    }

    long hex2long(String string2) {
        int n2 = string2.length();
        String string3 = string2.toLowerCase();
        if (!string3.startsWith("0x")) {
            throw new NumberFormatException("Expected long hex value, saw: " + string2);
        }
        if (n2 > 19) {
            throw new NumberFormatException("Too many digits in long hex value: " + string2);
        }
        long l = 0L;
        for (int i = 2; i < n2 - 1; ++i) {
            int n3 = s_hextable.indexOf(string3.charAt(i));
            if (n3 < 0) {
                throw new NumberFormatException("Bad digit in long hex value: " + string2);
            }
            l = l << 4 | (long)n3;
        }
        return l;
    }

    int hex2int(String string2) {
        int n2 = string2.length();
        String string3 = string2.toLowerCase();
        if (!string3.startsWith("0x")) {
            throw new NumberFormatException("Expected hex value, saw: " + string2);
        }
        if (n2 > 10) {
            throw new NumberFormatException("Too many digits in hex value: " + string2);
        }
        int n3 = 0;
        for (int i = 2; i < n2; ++i) {
            n3 = n3 << 4 | s_hextable.indexOf(string3.charAt(i)) - 1;
        }
        return n3;
    }

    public Instruction parseNumber() throws ParserException {
        String string2 = this.parseIdentifier(true);
        try {
            if (string2.endsWith("f")) {
                return LiteralInstruction.floatLiteral(Float.parseFloat(string2.substring(0, string2.length() - 1)));
            }
            if (string2.endsWith("d")) {
                return LiteralInstruction.doubleLiteral(Double.parseDouble(string2.substring(0, string2.length() - 1)));
            }
            if (string2.endsWith("l")) {
                return LiteralInstruction.longLiteral(string2.startsWith("0x") | string2.startsWith("0X") ? this.hex2long(string2) : Long.parseLong(string2.substring(0, string2.length() - 1)));
            }
            if (string2.indexOf(46) == -1) {
                return LiteralInstruction.integerLiteral(string2.startsWith("0x") | string2.startsWith("0X") ? this.hex2int(string2) : Integer.parseInt(string2));
            }
            return LiteralInstruction.doubleLiteral(Double.parseDouble(string2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParserException("Could not parse number: " + string2, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
    }

    public int parseInteger() throws ParserException {
        String string2 = this.parseIdentifier(true);
        return Integer.parseInt(string2);
    }

    public Object parseName() throws ParserException {
        return this.parseName(true);
    }

    public Object parseName(boolean bl) throws ParserException {
        String string2 = this.parseIdentifier(bl);
        if (null != string2 && string2.length() > 0 && string2.charAt(0) == '#') {
            return new Integer(Integer.parseInt(string2.substring(1)));
        }
        return string2;
    }

    public final char resolveEscapeSequence() throws ParserException {
        char c = this.read();
        switch (c) {
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case '\'': {
                return '\'';
            }
            case '\"': {
                return '\"';
            }
            case '\\': {
                return '\\';
            }
            case 'u': {
                char c2 = '\u0000';
                for (int i = 0; i < 4; ++i) {
                    char c3 = Character.toUpperCase(this.read());
                    if (c3 >= '0' && c3 <= '9') {
                        c2 = (char)((c2 << 4) + c3 - 48);
                        continue;
                    }
                    if (c3 >= 'A' && c3 <= 'F') {
                        c2 = (char)((c2 << 4) + 10 + c3 - 65);
                        continue;
                    }
                    throw new ParserException("A character that is not a hexadecimal digit was encountered in a Unicode escape sequence " + c, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                }
                return c2;
            }
        }
        throw new ParserException("Unknown escape sequence \\" + c, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
    }

    public String parseStringLiteralFull() throws ParserException {
        char c = this.read();
        if (c == '\"') {
            return this.parseStringLiteral();
        }
        throw new ParserException("String Literal must begin with \", read: " + c, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
    }

    public String parseStringLiteral() throws ParserException {
        StringBuffer stringBuffer = new StringBuffer();
        char c;
        while ((c = this.read()) != '\"') {
            if (c == '\\') {
                c = this.resolveEscapeSequence();
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public boolean parseBooleanLiteral() throws ParserException {
        String string2 = this.parseIdentifier(true);
        if (string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        throw new ParserException("Expected true or false; got " + string2, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
    }

    protected void parseADT(ITypeStore iTypeStore) throws ParserException {
        AbstractDataType.Constructor[] constructorArray;
        String string2 = this.parseIdentifier(true);
        if (iTypeStore.lookupCompoundType(string2) != null) {
            throw new ParserException("Duplicate type definition for " + string2, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        ArrayList<AbstractDataType.Constructor> arrayList = new ArrayList<AbstractDataType.Constructor>();
        while ((constructorArray = this.parseFormPrologOrEnd()) != null) {
            Binding[] bindingArray;
            Object object2;
            ArrayList<Binding[]> arrayList2 = new ArrayList<Binding[]>();
            while ((object2 = this.parseName(false)) != null) {
                bindingArray = new Binding(object2);
                char c = this.readStripComments();
                if (c != '@') {
                    throw new ParserException("Abstract data type constructor parameters must have types");
                }
                bindingArray.setType(this.parseTypeName(iTypeStore));
                arrayList2.add(bindingArray);
            }
            this.parseCloseParen();
            bindingArray = new Binding[arrayList2.size()];
            arrayList2.toArray(bindingArray);
            arrayList.add(new AbstractDataType.Constructor((String)constructorArray, bindingArray));
        }
        constructorArray = new AbstractDataType.Constructor[arrayList.size()];
        arrayList.toArray(constructorArray);
        iTypeStore.addAbstractDataType(this.makeAbstractDataType(string2, constructorArray));
    }

    protected AbstractDataType makeAbstractDataType(String string2, AbstractDataType.Constructor[] constructorArray) {
        return new ConstructorDataType(string2, constructorArray);
    }

    protected void parseTypeAlias(ITypeStore iTypeStore) throws ParserException {
        String string2 = this.parseIdentifier(true);
        Type type2 = this.parseTypeName(iTypeStore);
        if (type2 != null) {
            if (iTypeStore.lookupCompoundType(string2) != null || iTypeStore.lookupTypeAlias(string2) != null) {
                throw new ParserException("The new type name \"" + string2 + "\" specified in a type-alias was previously" + " defined.", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
        } else {
            throw new ParserException("The existing type name specified in a type-alias is unknown.", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        iTypeStore.addTypeAlias(string2, type2);
        this.parseCloseParen();
    }

    protected void parseJavaStaticMethodImport(ITypeStore iTypeStore) throws ParserException {
        StaticMethodSpec staticMethodSpec = new StaticMethodSpec();
        staticMethodSpec.m_name = this.parseIdentifier(true);
        staticMethodSpec.m_class = this.parseIdentifier(true);
        staticMethodSpec.m_methodName = this.parseIdentifier(true);
        staticMethodSpec.m_returnType = this.parseTypeName(iTypeStore);
        staticMethodSpec.m_parameterTypes = this.parseRemainingTypes(iTypeStore);
        this.m_importedJavaStaticMethods.put(staticMethodSpec.m_name, staticMethodSpec);
    }

    protected void parseFunction(Module module) throws ParserException {
        Binding[] bindingArray;
        Object object2;
        String string2;
        Object object3;
        char c;
        this.m_typeVariables = new HashMap();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (Character.isWhitespace(c = this.readStripComments())) {
        }
        this.unread(c);
        if (c != '(') {
            object3 = this.parseIdentifier();
            if (((String)object3).equals("memoize")) {
                bl = true;
            } else if (((String)object3).equals("impure")) {
                bl2 = true;
            } else if (((String)object3).equals("inline")) {
                bl3 = true;
            } else {
                throw new ParserException("Invalid function attribute " + (String)object3, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
        }
        if (module.getFunction(string2 = this.parseFormProlog()) != null) {
            object3 = module.getFunction(string2);
            if (null == ((Function)object3).m_definitionURL && 0 == ((Function)object3).m_definitionLineNumber) {
                throw new ParserException("Duplicate function definition for " + string2, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            throw new ParserException("Duplicate function definition for " + string2 + "\n" + "  First defined at " + ((Function)object3).m_definitionURL + " line " + ((Function)object3).m_definitionLineNumber, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        char c2 = this.readStripComments();
        Type type2 = null;
        if (c2 == '@') {
            type2 = this.parseTypeName(module);
        } else {
            this.unread(c2);
        }
        ArrayList<Binding[]> arrayList = new ArrayList<Binding[]>();
        while ((object2 = this.parseName(false)) != null) {
            bindingArray = new Binding(object2);
            c2 = this.readStripComments();
            if (c2 != '@') {
                this.unread(c2);
            } else {
                bindingArray.setType(this.parseTypeName(module));
            }
            arrayList.add(bindingArray);
        }
        this.parseCloseParen();
        bindingArray = new Binding[arrayList.size()];
        arrayList.toArray(bindingArray);
        Instruction instruction2 = this.parseExpression(module);
        Function function2 = new Function(string2, bindingArray, instruction2, this.getCurrentURL(), this.getLineNumber());
        if (type2 != null) {
            function2.setReturnType(type2);
        }
        module.addFunction(function2);
        if (bl) {
            function2.setMemoizeResult(true);
        }
        if (bl2) {
            function2.setImpurity(true);
        }
        if (bl3) {
            function2.setInlineHint(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleSignature parseExternalModuleSignature(ParserSource parserSource) throws ParserException {
        this.m_sourceStack.add(this.m_currentSource);
        try {
            this.m_currentSource = parserSource;
            if (!"module-signature".equals(this.parseFormProlog())) {
                throw new ParserException("Expected module-signature form at root level", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            ModuleSignature moduleSignature = this.parseModuleSignature();
            return moduleSignature;
        }
        finally {
            this.m_currentSource = (ParserSource)this.m_sourceStack.remove(this.m_sourceStack.size() - 1);
        }
    }

    protected ModuleSignature parseModuleSignature() throws ParserException {
        this.m_typeVariables = new HashMap();
        String string2 = this.parseIdentifier(true);
        if (this.m_knownModuleSignatures.lookupModuleSignature(string2) != null) {
            throw new ParserException("Duplicate module signature definition for " + string2, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        ModuleSignature moduleSignature = new ModuleSignature(string2);
        while (true) {
            String string3;
            String string4;
            if ((string4 = this.parseFormPrologOrEnd()) == null) {
                this.m_knownModuleSignatures.registerModuleSignature(string2, moduleSignature);
                return moduleSignature;
            }
            if (string4.equals("declare-function")) {
                Object object2;
                string3 = this.parseIdentifier(true);
                if (!this.parseIdentifier(true).equals("@")) {
                    throw new ParserException("function signature must include return type", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                }
                Type type2 = this.parseTypeName(moduleSignature);
                ArrayList<Type> arrayList = new ArrayList<Type>();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                while ((object2 = this.parseName(false)) != null) {
                    char c = this.readStripComments();
                    if (c != '@') {
                        throw new ParserException("parameters in function signature must include types", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    arrayList2.add(object2);
                    arrayList.add(this.parseTypeName(moduleSignature));
                }
                Type[] typeArray = new Type[arrayList.size()];
                arrayList.toArray(typeArray);
                Object[] objectArray = new Object[arrayList2.size()];
                arrayList2.toArray(objectArray);
                moduleSignature.addFunctionSignature(new FunctionSignature(string3, objectArray, typeArray, type2));
            } else if (string4.equals("declare-datatype")) {
                string3 = this.parseIdentifier(true);
            } else {
                if (string4.equals("define-datatype")) {
                    this.parseADT(moduleSignature);
                    continue;
                }
                if (string4.equals("type-alias")) {
                    this.parseTypeAlias(moduleSignature);
                    continue;
                }
                throw new ParserException("Unrecognized keyword: " + string4, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            this.parseCloseParen();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseLibrary(Module module, String string2) throws ParserException {
        ParserSource parserSource = this.m_sourceResolver.resolve(this.m_currentSource, string2);
        URL uRL = parserSource.m_currentURL;
        if (uRL == null) {
            throw new ParserException("An error occurred resolving library " + string2);
        }
        if (this.m_parsedLibrary.contains(uRL)) {
            return;
        }
        this.m_parsedLibrary.add(uRL);
        this.m_sourceStack.add(this.m_currentSource);
        try {
            this.m_currentSource = parserSource;
            String string3 = this.parseFormProlog();
            if (!"library".equals(string3)) {
                throw new ParserException("Expected library form at root level of (" + string2 + "), found " + string3, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            while (true) {
                String string4;
                String string5;
                if ((string5 = this.parseFormPrologOrEnd()) == null) {
                    return;
                }
                if (string5.equals("import-library")) {
                    string4 = this.parseIdentifier(true);
                    this.parseLibrary(module, string4);
                } else if (string5.equals("import-java-static-method")) {
                    this.parseJavaStaticMethodImport(module);
                } else if (string5.equals("declare-datatype")) {
                    string4 = this.parseIdentifier(true);
                } else if (string5.equals("function")) {
                    this.parseFunction(module);
                } else {
                    if (string5.equals("vdtmap")) {
                        this.parseVDTMap(module);
                        continue;
                    }
                    if (string5.equals("define-datatype")) {
                        this.parseADT(module);
                        continue;
                    }
                    if (!string5.equals("type-alias")) throw new ParserException("Unexpected form " + string5 + " in library form", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    this.parseTypeAlias(module);
                    continue;
                }
                this.parseCloseParen();
                continue;
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ParserException("I/O error", exception);
        }
        finally {
            this.m_currentSource = (ParserSource)this.m_sourceStack.remove(this.m_sourceStack.size() - 1);
        }
    }

    public VirtualDataTypeMap parseVDTMap() throws ParserException {
        String string2;
        AbstractTypeStore abstractTypeStore = new AbstractTypeStore();
        VirtualDataTypeMap virtualDataTypeMap = new VirtualDataTypeMap();
        if (!this.parseFormProlog().equals("vdtmap")) {
            throw new ParserException("Virtual data type maps must start with vdtmap", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        while ((string2 = this.parseFormPrologOrEnd()) != null) {
            if (!string2.equals("map-datatype")) {
                throw new ParserException("Virtual data type maps can only contain map-datatype directives", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            String string3 = this.parseIdentifier();
            if (virtualDataTypeMap.hasVDTMapping(string3)) {
                throw new ParserException("map-datatype already supplied for " + string3, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            Type type2 = this.parseTypeName(abstractTypeStore);
            VirtualDataTypeMap.ADTMapping aDTMapping = new VirtualDataTypeMap.ADTMapping();
            virtualDataTypeMap.addVDTMapping(string3, aDTMapping);
            aDTMapping.m_targetType = type2;
            while ((string2 = this.parseFormPrologOrEnd()) != null) {
                if (string2.equals("map-match")) {
                    if (aDTMapping.m_matchCode != null) {
                        throw new ParserException("map-match already supplied", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    aDTMapping.m_matchVariable = new Binding(this.parseName());
                    aDTMapping.m_matchCode = this.parseExpression(abstractTypeStore);
                    this.parseCloseParen();
                    continue;
                }
                if (string2.equals("map-constructor")) {
                    String string4 = this.parseIdentifier();
                    VirtualDataTypeMap.ConstructorMapping constructorMapping = new VirtualDataTypeMap.ConstructorMapping();
                    if (aDTMapping.m_constructors.containsKey(string4)) {
                        throw new ParserException("map-constructor already supplied for " + string4, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    while ((string2 = this.parseFormPrologOrEnd()) != null) {
                        if (string2.equals("construct")) {
                            if (constructorMapping.m_constructCode != null) {
                                throw new ParserException("construct already supplied", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                            }
                            this.parseOpenParen();
                            constructorMapping.m_constructParameters = Binding.getBindings(this.parseRemainingIdentifiers());
                            this.parseCloseParen();
                            constructorMapping.m_constructCode = this.parseExpression(abstractTypeStore);
                            this.parseCloseParen();
                            continue;
                        }
                        if (string2.equals("deconstruct")) {
                            if (constructorMapping.m_deconstructVariable != null) {
                                throw new ParserException("deconstruct already supplied");
                            }
                            constructorMapping.m_deconstructVariable = new Binding(this.parseName());
                            continue;
                        }
                        throw new ParserException("Unrecognized form: " + string2);
                    }
                    aDTMapping.m_constructors.put(string4, constructorMapping);
                    continue;
                }
                throw new ParserException("Unrecognized form: " + string2, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
        }
        return virtualDataTypeMap;
    }

    protected void parseVDTMap(Module module) throws ParserException {
        String string2;
        while ((string2 = this.parseFormPrologOrEnd()) != null) {
            if (!string2.equals("map-datatype")) {
                throw new ParserException("Virtual data type maps can only contain map-datatype directives");
            }
            String string3 = this.parseIdentifier();
            if (module.getVDTMap().hasVDTMapping(string3)) {
                throw new ParserException("map-datatype already supplied for " + string3);
            }
            Type type2 = this.parseTypeName(module);
            VirtualDataTypeMap.ADTMapping aDTMapping = new VirtualDataTypeMap.ADTMapping();
            module.getVDTMap().addVDTMapping(string3, aDTMapping);
            aDTMapping.m_targetType = type2;
            while ((string2 = this.parseFormPrologOrEnd()) != null) {
                Object object2;
                Object object3;
                if (string2.equals("map-match")) {
                    if (aDTMapping.m_matchCode != null) {
                        throw new ParserException("map-match already supplied");
                    }
                    aDTMapping.m_matchVariable = new Binding(this.parseName());
                    object3 = new TupleInstruction(new Instruction[]{this.parseExpression(module)});
                    object2 = new Function(OptimizerUtilities.generateIntermediateIdentifier(), new Binding[]{new Binding(aDTMapping.m_matchVariable)}, (Instruction)object3);
                    try {
                        ((Function)object2).typeCheck(module, null, new LinkedList());
                    }
                    catch (TypeCheckException typeCheckException) {
                        throw new ParserException("match code in " + string3 + " vdtmapping does not typecheck!", typeCheckException);
                    }
                    ((Function)object2).reduce();
                    aDTMapping.m_matchCode = ((Function)object2).getBody();
                    this.parseCloseParen();
                    continue;
                }
                if (string2.equals("map-constructor")) {
                    object3 = this.parseIdentifier();
                    object2 = new VirtualDataTypeMap.ConstructorMapping();
                    if (aDTMapping.m_constructors.containsKey(object3)) {
                        throw new ParserException("map-constructor already supplied for " + (String)object3);
                    }
                    while ((string2 = this.parseFormPrologOrEnd()) != null) {
                        Object object4;
                        Instruction instruction2;
                        if (string2.equals("construct")) {
                            if (((VirtualDataTypeMap.ConstructorMapping)object2).m_constructCode != null) {
                                throw new ParserException("construct already supplied");
                            }
                            this.parseOpenParen();
                            ((VirtualDataTypeMap.ConstructorMapping)object2).m_constructParameters = Binding.getBindings(this.parseRemainingIdentifiers());
                            this.parseCloseParen();
                            instruction2 = this.parseExpression(module);
                            object4 = new Binding[((VirtualDataTypeMap.ConstructorMapping)object2).m_constructParameters.length];
                            for (int i = 0; i < ((VirtualDataTypeMap.ConstructorMapping)object2).m_constructParameters.length; ++i) {
                                object4[i] = new Binding(((VirtualDataTypeMap.ConstructorMapping)object2).m_constructParameters[i]);
                            }
                            Function function2 = new Function(OptimizerUtilities.generateIntermediateIdentifier(), (Binding[])object4, instruction2);
                            try {
                                function2.typeCheck(module, null, new LinkedList());
                            }
                            catch (TypeCheckException typeCheckException) {
                                throw new ParserException("construct code in " + string3 + " vdtmapping does not typecheck!", typeCheckException);
                            }
                            function2.reduce();
                            ((VirtualDataTypeMap.ConstructorMapping)object2).m_constructCode = function2.getBody();
                            this.parseCloseParen();
                            continue;
                        }
                        if (string2.equals("deconstruct")) {
                            if (((VirtualDataTypeMap.ConstructorMapping)object2).m_deconstructVariable != null) {
                                throw new ParserException("deconstruct already supplied");
                            }
                            ((VirtualDataTypeMap.ConstructorMapping)object2).m_deconstructVariable = new Binding(this.parseName());
                            instruction2 = new TupleInstruction(this.parseRemainingExpressions(module));
                            object4 = new Function(OptimizerUtilities.generateIntermediateIdentifier(), new Binding[]{new Binding((Object)((VirtualDataTypeMap.ConstructorMapping)object2).m_deconstructVariable, aDTMapping.m_targetType, new TypeEnvironment(module))}, instruction2);
                            try {
                                ((Function)object4).typeCheck(module, null, new LinkedList());
                            }
                            catch (TypeCheckException typeCheckException) {
                                typeCheckException.printStackTrace();
                                throw new ParserException("deconstruct code in " + string3 + " vdtmapping does not typecheck!", typeCheckException);
                            }
                            ((Function)object4).reduce();
                            ((VirtualDataTypeMap.ConstructorMapping)object2).m_deconstructCode = ((Function)object4).getBody();
                            continue;
                        }
                        throw new ParserException("Unrecognized form: " + string2);
                    }
                    aDTMapping.m_constructors.put(object3, object2);
                    continue;
                }
                throw new ParserException("Unrecognized form: " + string2);
            }
        }
    }

    protected void parseModule(Module module, boolean bl) throws ParserException {
        String string2;
        while ((string2 = this.parseFormPrologOrEnd()) != null) {
            Object[] objectArray;
            Object object2;
            ModuleSignature moduleSignature;
            Object object3;
            String string3;
            if (string2.equals("main")) {
                this.m_typeVariables = new HashMap();
                module.addFunction(new Function("main", new Binding[0], this.parseExpression(module), this.getCurrentURL(), this.getLineNumber()));
                this.parseCloseParen();
                break;
            }
            if (string2.equals("import-library")) {
                string3 = this.parseIdentifier(true);
                this.parseLibrary(module, string3);
            } else if (string2.equals("import-module")) {
                string3 = this.parseIdentifier(true);
                object3 = this.resolveModuleSignature(string3);
                module.addModuleImportDirective(new TopLevelModuleImportDirective(string3, (ModuleSignature)object3, string3));
            } else if (string2.equals("apply-functor")) {
                string3 = this.parseIdentifier(true);
                if (!this.parseIdentifier(true).equals("@")) {
                    throw new ParserException("apply-functor must have signature specified", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                }
                object3 = this.parseIdentifier(true);
                moduleSignature = this.resolveModuleSignature((String)object3);
                object2 = this.parseIdentifier(true);
                objectArray = this.parseRemainingIdentifiers();
                module.addModuleImportDirective(new FunctorApplicationDirective(string3, moduleSignature, (String)object2, objectArray));
            } else if (string2.equals("import-java-static-method")) {
                this.parseJavaStaticMethodImport(module);
            } else if (string2.equals("declare-datatype")) {
                string3 = this.parseIdentifier(true);
            } else if (string2.equals("function")) {
                this.parseFunction(module);
            } else {
                if (string2.equals("vdtmap")) {
                    this.parseVDTMap(module);
                    continue;
                }
                if (string2.equals("module")) {
                    string3 = this.parseIdentifier(true);
                    if (!this.parseIdentifier(true).equals("@")) {
                        throw new ParserException("module must have signature specified", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    object3 = this.parseIdentifier(true);
                    moduleSignature = this.resolveModuleSignature((String)object3);
                    object2 = new Module(string3, module, moduleSignature);
                    this.parseModule((Module)object2, false);
                    module.addModule((Module)object2);
                    continue;
                }
                if (string2.equals("functor")) {
                    Serializable serializable;
                    string3 = this.parseFormProlog();
                    if (!this.parseIdentifier(true).equals("@")) {
                        throw new ParserException("functor must have signature specified", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    object3 = this.parseIdentifier(true);
                    moduleSignature = this.resolveModuleSignature((String)object3);
                    object2 = this.parseRemainingIdentifiers();
                    this.parseCloseParen();
                    objectArray = new ModuleSignature[((Object[])object2).length / 3];
                    Object[] objectArray2 = new Object[((Object[])object2).length / 3];
                    for (int i = 0; i < ((Object[])object2).length; i += 3) {
                        if (!object2[i + 1].equals("@")) {
                            throw new ParserException("parameters to functor must include types", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                        }
                        serializable = this.resolveModuleSignature(object2[i + 2].toString());
                        objectArray2[i / 3] = object2[i];
                        objectArray[i / 3] = serializable;
                    }
                    Module module2 = new Module(string3, module, moduleSignature);
                    this.parseModule(module2, false);
                    serializable = new Functor(string3, module2, (ModuleSignature[])objectArray, (String[])objectArray2, moduleSignature);
                    module.addFunctor((Functor)serializable);
                    continue;
                }
                if (string2.equals("define-datatype")) {
                    this.parseADT(module);
                    continue;
                }
                if (string2.equals("type-alias")) {
                    this.parseTypeAlias(module);
                    continue;
                }
                throw new ParserException("Unexpected form " + string2 + " in program form", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            this.parseCloseParen();
        }
    }

    public Module parseModule() throws ParserException {
        return this.parseModule(null);
    }

    public Module parseModule(ModuleSignature moduleSignature) throws ParserException {
        boolean bl;
        this.m_parsedLibrary.add(this.m_baseURL);
        String string2 = this.parseFormProlog();
        boolean bl2 = bl = moduleSignature == null;
        if (!"module".equals(string2)) {
            return this.parseProgramOrModuleFragment(false, string2);
        }
        String string3 = this.parseIdentifier(true);
        if (moduleSignature == null) {
            moduleSignature = new ModuleSignature("");
        }
        Module module = new Module(string3, null, moduleSignature);
        this.parseModule(module, false);
        Parser.resolveFixups(module, this.m_typeFixups);
        this.m_typeFixups.clear();
        return module;
    }

    public static void resolveFixups(Module module, ArrayList arrayList) throws ParserException {
    }

    public ModuleSignature resolveModuleSignature(String string2) throws ParserException {
        try {
            ModuleSignature moduleSignature = this.m_knownModuleSignatures.resolveModuleSignature(string2);
            if (moduleSignature == null) {
                throw new RuntimeException();
            }
            return moduleSignature;
        }
        catch (Exception exception) {
            throw new ParserException("Unable to resolve module signature " + string2 + " in \n" + this.m_knownModuleSignatures, exception);
        }
    }

    public Module parseModuleFragment() throws ParserException {
        return this.parseProgramOrModuleFragment(true, null);
    }

    public Program parseProgram() throws ParserException {
        return (Program)this.parseProgramOrModuleFragment(false, null);
    }

    public Module parseProgramOrModuleFragment(boolean bl, String string2) throws ParserException {
        Module module;
        ModuleSignature moduleSignature;
        boolean bl2 = true;
        while (true) {
            if (!bl2 || null == string2) {
                this.m_parsedLibrary.add(this.m_baseURL);
                string2 = this.parseFormProlog();
            }
            bl2 = false;
            if (!string2.equals("module-signature")) break;
            this.parseModuleSignature();
        }
        boolean bl3 = "library".equals(string2);
        if (!bl3 && !"program".equals(string2)) {
            throw new ParserException("Expected program or library form at root level", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        String string3 = null;
        if (!bl3) {
            string3 = this.parseIdentifier(false);
        }
        if (!bl3) {
            char c = this.read();
            if (c != '@') {
                moduleSignature = new ModuleSignature("");
                if (bl) {
                    moduleSignature.addFunctionSignature(new FunctionSignature("main", new Object[0], new Type[0], null));
                }
                this.unread(c);
            } else {
                String string4 = this.parseIdentifier(true);
                moduleSignature = this.resolveModuleSignature(string4);
            }
        } else {
            moduleSignature = new ModuleSignature("");
        }
        Module module2 = module = bl ? new Module("", null) : new Program(moduleSignature);
        if (null != string3) {
            module.setName(string3);
        }
        this.parseModule(module, bl3);
        return module;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.m_sourceStack.toArray();
        int n2 = objectArray.length + 1;
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2 - 1);
        objectArray2[n2 - 1] = this.m_currentSource;
        for (int i = n2 - 1; 0 <= i; --i) {
            if (i == n2 - 1) {
                stringBuffer.append("at   ");
            } else {
                stringBuffer.append("from ");
            }
            ParserSource parserSource = (ParserSource)objectArray2[i];
            URL uRL = parserSource.m_currentURL;
            if (uRL != null) {
                String string2 = parserSource.m_currentURL.toString();
                int n3 = string2.lastIndexOf(47);
                if (0 < n3) {
                    string2 = string2.substring(n3);
                }
                stringBuffer.append(string2);
            }
            stringBuffer.append(" at line ");
            stringBuffer.append(parserSource.m_lineNumber);
            stringBuffer.append(" at offset ");
            stringBuffer.append(parserSource.m_offset);
            stringBuffer.append('\n');
        }
        String string3 = stringBuffer.toString();
        return string3;
    }

    public static class StaticMethodSpec {
        String m_name;
        String m_class;
        String m_methodName;
        Type m_returnType;
        Type[] m_parameterTypes;
    }
}

