/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.parser;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.IMatchDestructable;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.instructions.AbsoluteValueInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.AndInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ArbitraryIntegerPrecisionInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.AssertTypeInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.AssignmentInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.AutomatonInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.BeginInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.BuildLazyStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.BuildMultiStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.CostCenterInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.DeepEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.DelayInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ForceInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.GetNonNullValueInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.HexEscapeInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IsJavaNullInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IsNullValueInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.JavaArrayLookupInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.JavaDowncastInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.JavaMethodInvocationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LazyStreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LengthInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetOnceInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LocalizeMessageInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LoopInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.Match2Instruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NaNInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NegateInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NewJavaObjectInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NonNullValueInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NotInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NumericalComparisonInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.OnceInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.OrInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ParallelForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveArithmeticInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveToStringInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ProcessStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PureInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.RangeInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ReadJavaConstantInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ReadJavaFieldInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ReadSlotInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.RoundInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.SlotInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.SortStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StaticMemberInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StaticMethodInvocationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamRepeatInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.SubstreamAfterInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.SubstreamBeforeInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.SubstreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TagInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TestStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TryCatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TypeMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.UnionInjectInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.UntagInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.parser.IFormHandler;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xltxe.rnm1.xylem.parser.ParserException;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.DecimalType;
import com.ibm.xltxe.rnm1.xylem.types.ICollectionType;
import com.ibm.xltxe.rnm1.xylem.types.PrimitiveNumericalType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xml.ras.LoggerUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CoreFormHandler
implements IFormHandler {
    private static final Logger s_logger = LoggerUtil.getLogger(CoreFormHandler.class);
    private static final String s_className = CoreFormHandler.class.getName();
    private static BasicForm[] s_basicForms = new BasicForm[]{new BasicForm("cost-center", 2, CostCenterInstruction.class), new BasicForm("delay", 1, DelayInstruction.class), new BasicForm("force", 1, ForceInstruction.class), new BasicForm("pure", 1, PureInstruction.class), new BasicForm("length", 1, LengthInstruction.class), new BasicForm("once!", 1, OnceInstruction.class), new BasicForm("not", 1, NotInstruction.class), new BasicForm("negate", 1, NegateInstruction.class), new BasicForm("abs", 1, AbsoluteValueInstruction.class), new BasicForm("round", 1, RoundInstruction.class), new BasicForm("range", 2, RangeInstruction.class), new BasicForm("eq?", 2, PrimitiveEqualityInstruction.class), new BasicForm("nan?", 1, NaNInstruction.class), new BasicForm("equals?", 2, DeepEqualityInstruction.class), new BasicForm("hex-escape", 1, HexEscapeInstruction.class), new BasicForm("stream-element", 2, StreamElementInstruction.class), new BasicForm("non-null-value", 1, NonNullValueInstruction.class), new BasicForm("is-null-value", 1, IsNullValueInstruction.class), new BasicForm("is-java-null", 1, IsJavaNullInstruction.class), new BasicForm("get-non-null-value", 1, GetNonNullValueInstruction.class), new BasicForm("arbitrary-integer-precision?", 2, ArbitraryIntegerPrecisionInstruction.class)};

    public static int getBasicFormSize() {
        return s_basicForms.length;
    }

    public static Class getBasicFormClass(int n2) {
        return CoreFormHandler.s_basicForms[n2].m_class;
    }

    public static String getBasicFormName(int n2) {
        return CoreFormHandler.s_basicForms[n2].m_name;
    }

    @Override
    public Instruction parseForm(String string2, Parser parser, ITypeStore iTypeStore) throws ParserException {
        Object object2;
        int n2;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "parseForm", "processing " + string2);
        }
        for (n2 = 0; n2 < s_basicForms.length; n2 += 1) {
            object2 = s_basicForms[n2];
            if (!((BasicForm)object2).m_name.equals(string2)) continue;
            Class[] classArray = new Class[((BasicForm)object2).m_parameters];
            Instruction[] instructionArray = new Instruction[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                classArray[i] = Instruction.class;
                instructionArray[i] = parser.parseExpression(iTypeStore);
            }
            parser.parseCloseParen();
            try {
                return (Instruction)((BasicForm)object2).m_class.getConstructor(classArray).newInstance(instructionArray);
            }
            catch (Exception exception) {
                throw new ParserException("Internal error", exception);
            }
        }
        if (string2.equals("let")) {
            Object object3 = parser.parseName();
            object2 = parser.parseExpression(iTypeStore);
            Instruction instruction2 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new LetInstruction(object3, (Instruction)object2, instruction2);
        }
        if (string2.equals("let!")) {
            Object object4 = parser.parseName();
            object2 = parser.parseExpression(iTypeStore);
            Instruction instruction3 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new LetOnceInstruction(object4, (Instruction)object2, instruction3);
        }
        if (string2.equals("lazy-stream-element")) {
            Instruction instruction4 = parser.parseExpression(iTypeStore);
            object2 = parser.parseExpression(iTypeStore);
            Object object5 = parser.parseName();
            Instruction instruction5 = parser.parseExpression(iTypeStore);
            Instruction instruction6 = parser.parseExpression(iTypeStore, false);
            if (instruction6 != null) {
                parser.parseCloseParen();
            }
            return new LazyStreamElementInstruction(instruction4, (Instruction)object2, object5, instruction5, instruction6);
        }
        if (string2.equals("let*")) {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            object2 = new LinkedList();
            parser.parseOpenParen();
            while (parser.parseOpenParenOrEnd()) {
                linkedList.add(parser.parseName());
                ((LinkedList)object2).add(parser.parseExpression(iTypeStore));
                parser.parseCloseParen();
            }
            Instruction instruction7 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            Instruction[] instructionArray = new Instruction[linkedList.size()];
            Binding[] bindingArray = new Binding[((LinkedList)object2).size()];
            int n3 = 0;
            while (!((AbstractCollection)object2).isEmpty()) {
                instructionArray[n3] = (Instruction)((LinkedList)object2).removeLast();
                bindingArray[n3] = new Binding(linkedList.removeLast());
                ++n3;
            }
            return OptimizerUtilities.replaceDeconstructionBindings(instructionArray, bindingArray, instruction7);
        }
        if (string2.equals("set!")) {
            Instruction instruction8 = parser.parseExpression(iTypeStore);
            object2 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new AssignmentInstruction(instruction8, (Instruction)object2);
        }
        if (string2.equals("get!")) {
            Instruction instruction9 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new ReadSlotInstruction(instruction9);
        }
        if (string2.equals("char-stream-to-java-string")) {
            Instruction instruction10 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new CharStreamToJavaStringInstruction(instruction10);
        }
        if (string2.equals("try")) {
            Instruction instruction11 = parser.parseExpression(iTypeStore);
            object2 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new TryCatchInstruction(instruction11, (Instruction)object2);
        }
        if (string2.equals("union-inject")) {
            Type type2 = parser.parseTypeName(iTypeStore);
            int n4 = Integer.parseInt(parser.parseIdentifier());
            int n5 = Integer.parseInt(parser.parseIdentifier());
            Instruction instruction12 = parser.parseExpression(iTypeStore);
            return new UnionInjectInstruction(type2, n4, n5, instruction12);
        }
        if (string2.equals("stream")) {
            Type type3 = parser.parseTypeName(iTypeStore);
            object2 = parser.parseRemainingExpressions(iTypeStore);
            return new StreamInstruction(type3, (Instruction[])object2);
        }
        if (string2.equals("begin")) {
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            return new BeginInstruction(instructionArray);
        }
        if (string2.equals("tuple")) {
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            return new TupleInstruction(instructionArray);
        }
        if (string2.equals("stream-s")) {
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            object2 = new TypeVariable();
            StreamType streamType = new StreamType((Type)object2);
            for (int i = 0; i < instructionArray.length; ++i) {
                instructionArray[i] = new AssertTypeInstruction(instructionArray[i], streamType);
                instructionArray[i].setSourceFilename(parser.getCurrentURL());
                instructionArray[i].setSourceLineNumber(parser.getLineNumber());
            }
            return new StreamInstruction((Type)object2, instructionArray);
        }
        if (string2.equals("stream-e")) {
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            object2 = new TypeVariable();
            for (int i = 0; i < instructionArray.length; ++i) {
                instructionArray[i] = new AssertTypeInstruction(instructionArray[i], (Type)object2);
                instructionArray[i].setSourceFilename(parser.getCurrentURL());
                instructionArray[i].setSourceLineNumber(parser.getLineNumber());
            }
            return new StreamInstruction((Type)object2, instructionArray);
        }
        if (string2.equals("construct")) {
            String string3 = parser.parseIdentifier();
            object2 = parser.parseRemainingExpressions(iTypeStore);
            return new ConstructorInstantiationInstruction(string3, (Instruction[])object2);
        }
        if (string2.equals("sort")) {
            List<Instruction> list = Arrays.asList(parser.parseRemainingExpressions(iTypeStore));
            object2 = list.get(0);
            list = list.subList(1, list.size());
            Instruction[] instructionArray = list.subList(0, list.size() / 2).toArray(new Instruction[0]);
            Instruction[] instructionArray2 = list.subList(list.size() / 2, list.size()).toArray(new Instruction[0]);
            return new SortStreamInstruction((Instruction)object2, instructionArray, instructionArray2);
        }
        if (string2.equals("call-module-function")) {
            String string4 = parser.parseIdentifier();
            object2 = parser.parseIdentifier();
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            return new ModuleFunctionCallInstruction(string4, (String)object2, instructionArray);
        }
        if (string2.equals("localize-message")) {
            Instruction instruction13 = parser.parseExpression(iTypeStore);
            object2 = parser.parseExpression(iTypeStore);
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            return new LocalizeMessageInstruction(instruction13, (Instruction)object2, instructionArray);
        }
        if (string2.equals("apply") || string2.equals("apply!")) {
            n2 = string2.equals("apply") ? 1 : 0;
            object2 = parser.parseExpression(iTypeStore);
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            return new ApplyInstruction((Instruction)object2, instructionArray, n2 != 0);
        }
        if (string2.equals("lookup-java-array")) {
            Instruction instruction14 = parser.parseExpression(iTypeStore);
            object2 = parser.parseRemainingExpressions(iTypeStore);
            return new JavaArrayLookupInstruction(instruction14, (Instruction[])object2);
        }
        if (string2.equals("new-java-object")) {
            Type type4 = parser.parseTypeName(iTypeStore);
            object2 = parser.parseRemainingExpressions(iTypeStore);
            return new NewJavaObjectInstruction((Instruction[])object2, type4);
        }
        if (string2.equals("java-downcast")) {
            Type type5 = parser.parseTypeName(iTypeStore);
            object2 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new JavaDowncastInstruction((Instruction)object2, type5);
        }
        if (string2.equals("read-java-field")) {
            Instruction instruction15 = parser.parseExpression(iTypeStore);
            object2 = parser.parseIdentifier();
            parser.parseCloseParen();
            return new ReadJavaFieldInstruction(instruction15, (String)object2);
        }
        if (string2.equals("read-java-constant")) {
            Instruction instruction16 = parser.parseExpression(iTypeStore);
            object2 = parser.parseIdentifier();
            parser.parseCloseParen();
            return new ReadJavaConstantInstruction(instruction16, (String)object2);
        }
        if (string2.equals("java-method-invoke") || string2.equals("static-method-invoke")) {
            n2 = parser.read();
            object2 = null;
            if (n2 == 64) {
                object2 = parser.parseTypeName(iTypeStore);
            } else {
                parser.unread((char)n2);
            }
            Instruction instruction17 = null;
            if (string2.equals("java-method-invoke")) {
                instruction17 = parser.parseExpression(iTypeStore);
            }
            String string5 = parser.parseIdentifier();
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            if (string2.equals("java-method-invoke")) {
                return new JavaMethodInvocationInstruction(string5, instruction17, instructionArray, (Type)object2);
            }
            return new StaticMethodInvocationInstruction(string5, instructionArray, (Type)object2);
        }
        if (string2.equals("java-static-field-ref")) {
            n2 = parser.read();
            object2 = null;
            if (n2 == 64) {
                object2 = parser.parseTypeName(iTypeStore);
            } else {
                parser.unread((char)n2);
            }
            while (Character.isWhitespace((char)(n2 = parser.readStripComments()))) {
            }
            String string6 = parser.parseStringLiteral();
            while (Character.isWhitespace((char)(n2 = parser.readStripComments()))) {
            }
            String string7 = parser.parseStringLiteral();
            parser.parseCloseParen();
            return new StaticMemberInstruction(string6, string7, (Type)object2);
        }
        if (string2.equals("and")) {
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            return new AndInstruction(instructionArray);
        }
        if (string2.equals("or")) {
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            return new OrInstruction(instructionArray);
        }
        if (string2.equals("assert-type")) {
            Type type6 = parser.parseTypeName(iTypeStore);
            object2 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new AssertTypeInstruction((Instruction)object2, type6);
        }
        if (string2.equals("primitive-cast")) {
            Type type7 = parser.parseTypeName(iTypeStore);
            object2 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new JavaDowncastInstruction((Instruction)object2, type7);
        }
        if (string2.equals("java-null")) {
            Type type8 = parser.parseTypeName(iTypeStore);
            parser.parseCloseParen();
            return LiteralInstruction.nullLiteral(type8);
        }
        if (string2.equals("stream-repeat")) {
            Instruction instruction18 = parser.parseExpression(iTypeStore);
            object2 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new StreamRepeatInstruction(instruction18, (Instruction)object2);
        }
        if (string2.equals("stream-repeat-stream")) {
            Instruction instruction19 = parser.parseExpression(iTypeStore);
            object2 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new StreamRepeatInstruction(instruction19, (Instruction)object2);
        }
        if (string2.equals("slot!")) {
            Instruction instruction20 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new SlotInstruction(instruction20);
        }
        if (string2.equals("tag")) {
            String string8 = parser.parseIdentifier();
            object2 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new TagInstruction(string8, (Instruction)object2);
        }
        if (string2.equals("untag")) {
            String string9 = parser.parseIdentifier();
            object2 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new UntagInstruction(string9, (Instruction)object2);
        }
        if (string2.equals("foreach") || string2.equals("foreach-c")) {
            Object object6 = parser.parseName();
            object2 = null;
            if (object6.equals("@")) {
                object2 = (ICollectionType)((Object)parser.parseTypeName(iTypeStore));
                object6 = parser.parseName();
            }
            Instruction instruction21 = parser.parseExpression(iTypeStore);
            Object object7 = null;
            if (string2.equals("foreach-c")) {
                object7 = parser.parseName();
            }
            Instruction instruction22 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return object2 == null ? new ForEachInstruction(instruction21, object6, object7, instruction22) : new ForEachInstruction(instruction21, object6, object7, instruction22, (ICollectionType)object2);
        }
        if (string2.equals("parallel-foreach")) {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            object2 = new LinkedList();
            Type type9 = null;
            char c = parser.read();
            if (c == '@') {
                type9 = parser.parseTypeName(iTypeStore);
            } else {
                parser.unread(c);
            }
            parser.parseOpenParen();
            while (parser.parseOpenParenOrEnd()) {
                linkedList.add(parser.parseName());
                ((LinkedList)object2).add(parser.parseExpression(iTypeStore));
                parser.parseCloseParen();
            }
            Instruction instruction23 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            Instruction[] instructionArray = ((LinkedList)object2).toArray(new Instruction[0]);
            Object[] objectArray = linkedList.toArray(new Object[0]);
            ParallelForEachInstruction parallelForEachInstruction = new ParallelForEachInstruction(instructionArray, objectArray, instruction23, type9);
            return parallelForEachInstruction;
        }
        if (string2.equals("big-integer")) {
            String string10 = parser.parseIdentifier();
            parser.parseCloseParen();
            return new LiteralInstruction(BigIntegerType.s_bigIntegerType, new BigInteger(string10));
        }
        if (string2.equals("big-decimal")) {
            String string11 = parser.parseIdentifier();
            parser.parseCloseParen();
            return new LiteralInstruction(DecimalType.s_decimalType, new BigDecimal(string11));
        }
        if (string2.equals("substream-after")) {
            Instruction instruction24 = parser.parseExpression(iTypeStore);
            object2 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new SubstreamAfterInstruction(instruction24, (Instruction)object2);
        }
        if (string2.equals("substream")) {
            Instruction instruction25 = parser.parseExpression(iTypeStore);
            object2 = parser.parseExpression(iTypeStore);
            Instruction instruction26 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new SubstreamInstruction(instruction25, (Instruction)object2, instruction26, true);
        }
        if (string2.equals("substream-1")) {
            Instruction instruction27 = parser.parseExpression(iTypeStore);
            object2 = parser.parseExpression(iTypeStore);
            Instruction instruction28 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new SubstreamInstruction(instruction27, (Instruction)object2, instruction28, false);
        }
        if (string2.equals("substream-before")) {
            Instruction instruction29 = parser.parseExpression(iTypeStore);
            object2 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new SubstreamBeforeInstruction(instruction29, (Instruction)object2);
        }
        if (string2.equals("primitive-to-string")) {
            Instruction instruction30 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new PrimitiveToStringInstruction(instruction30);
        }
        if (string2.equals("process-stream") || string2.equals("process-stream-c") || string2.equals("process-stream-i") || string2.equals("process-stream-ic") || string2.equals("test-stream") || string2.equals("test-stream-c")) {
            n2 = string2.startsWith("process-stream-i") ? 1 : 0;
            boolean bl = string2.startsWith("test-stream");
            boolean bl2 = string2.charAt(string2.length() - 1) == 'c';
            Type type10 = null;
            Instruction instruction31 = parser.parseExpression(iTypeStore);
            if (instruction31 instanceof IdentifierInstruction && ((IdentifierInstruction)instruction31).getVariable().equals("@")) {
                type10 = parser.parseTypeName(iTypeStore);
                instruction31 = parser.parseExpression(iTypeStore);
            }
            Instruction instruction32 = parser.parseExpression(iTypeStore);
            Object object8 = parser.parseName();
            Object object9 = parser.parseName();
            Object object10 = null;
            if (bl2) {
                object10 = parser.parseName();
            }
            Instruction instruction33 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            if (bl) {
                if (type10 == null) {
                    return new TestStreamInstruction(instruction31, instruction32, object8, object9, object10, instruction33);
                }
                try {
                    return new TestStreamInstruction(instruction31, instruction32, object8, object9, object10, instruction33, (ICollectionType)((Object)type10));
                }
                catch (ClassCastException classCastException) {
                    throw new ParserException(type10.getClass().getSimpleName() + " is not a ICollectionType!: " + type10, parser.getCurrentURL(), parser.getLineNumber(), parser.getOffsetInLine());
                }
            }
            return new ProcessStreamInstruction(n2 != 0, instruction31, instruction32, object8, object9, object10, instruction33, type10);
        }
        if (string2.equals("choose")) {
            ChooseInstruction.Case[] caseArray;
            ArrayList<ChooseInstruction.Case> arrayList = new ArrayList<ChooseInstruction.Case>();
            object2 = null;
            while (parser.parseOpenParenOrEnd()) {
                caseArray = parser.parseIdentifier();
                if (caseArray.equals("otherwise")) {
                    object2 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    parser.parseCloseParen();
                    break;
                }
                if (caseArray.equals("when")) {
                    Instruction instruction34 = parser.parseExpression(iTypeStore);
                    Instruction instruction35 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    arrayList.add(new ChooseInstruction.Case(instruction34, instruction35));
                    continue;
                }
                throw new ParserException("Unexpected token: " + (String)caseArray, parser.getCurrentURL(), parser.getLineNumber(), parser.getOffsetInLine());
            }
            caseArray = new ChooseInstruction.Case[arrayList.size()];
            arrayList.toArray(caseArray);
            return new ChooseInstruction(caseArray, (Instruction)object2);
        }
        if (string2.equals("match")) {
            MatchInstruction.Match[] matchArray;
            Instruction instruction36 = parser.parseExpression(iTypeStore);
            object2 = new ArrayList();
            Instruction instruction37 = null;
            while (parser.parseOpenParenOrEnd()) {
                matchArray = parser.parseIdentifier();
                if (matchArray.equals("else") || matchArray.equals("otherwise")) {
                    instruction37 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    parser.parseCloseParen();
                    break;
                }
                if (matchArray.equals("case")) {
                    Instruction instruction38;
                    int n6;
                    Object[] objectArray;
                    NaryPrimopInstruction naryPrimopInstruction;
                    Instruction instruction39 = parser.parseExpression(iTypeStore);
                    Instruction instruction40 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    if (instruction39 instanceof LiteralInstruction) {
                        ((ArrayList)object2).add(new MatchInstruction.LiteralMatch((LiteralInstruction)instruction39, instruction40));
                        continue;
                    }
                    if (instruction39 instanceof FunctionCallInstruction) {
                        naryPrimopInstruction = (FunctionCallInstruction)instruction39;
                        objectArray = new Object[((FunctionCallInstruction)naryPrimopInstruction).m_parameters.length];
                        for (n6 = 0; n6 < objectArray.length; ++n6) {
                            instruction38 = ((FunctionCallInstruction)naryPrimopInstruction).m_parameters[n6];
                            if (!(instruction38 instanceof IdentifierInstruction)) {
                                throw new ParserException("Constructor match can only contain identifiers", parser.getCurrentURL(), parser.getLineNumber(), parser.getOffsetInLine());
                            }
                            objectArray[n6] = ((IdentifierInstruction)instruction38).getVariable();
                        }
                        ((ArrayList)object2).add(new MatchInstruction.DeconstructionMatch(((FunctionCallInstruction)naryPrimopInstruction).getFunction(), objectArray, instruction40));
                        continue;
                    }
                    if (instruction39 instanceof TupleInstruction) {
                        if (!((ArrayList)object2).isEmpty()) {
                            throw new ParserException("Cannot mix tuple case with other cases in match", parser.getCurrentURL(), parser.getLineNumber());
                        }
                        naryPrimopInstruction = (TupleInstruction)instruction39;
                        objectArray = new Object[((TupleInstruction)naryPrimopInstruction).m_parameters.length];
                        for (n6 = 0; n6 < objectArray.length; ++n6) {
                            instruction38 = ((TupleInstruction)naryPrimopInstruction).m_parameters[n6];
                            if (!(instruction38 instanceof IdentifierInstruction)) {
                                throw new ParserException("Tuple match can only contain identifiers", parser.getCurrentURL(), parser.getLineNumber());
                            }
                            objectArray[n6] = ((IdentifierInstruction)instruction38).getVariable();
                        }
                        parser.parseCloseParen();
                        return new TupleMatchInstruction(instruction36, objectArray, instruction40);
                    }
                    throw new ParserException("Unexpected condition " + instruction39, parser.getCurrentURL(), parser.getLineNumber());
                }
                throw new ParserException("Unexpected token: " + (String)matchArray, parser.getCurrentURL(), parser.getLineNumber());
            }
            matchArray = new MatchInstruction.Match[((ArrayList)object2).size()];
            ((ArrayList)object2).toArray(matchArray);
            return new MatchInstruction(instruction36, matchArray, instruction37);
        }
        if (string2.equals("match2")) {
            Match2Instruction.Match[] matchArray;
            Instruction instruction41 = parser.parseExpression(iTypeStore);
            object2 = new ArrayList();
            Instruction instruction42 = null;
            while (parser.parseOpenParenOrEnd()) {
                matchArray = parser.parseIdentifier();
                if (matchArray.equals("else") || matchArray.equals("otherwise")) {
                    instruction42 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    parser.parseCloseParen();
                    break;
                }
                if (matchArray.equals("case")) {
                    Instruction instruction43 = parser.parseExpression(iTypeStore);
                    if (!(instruction43 instanceof IMatchDestructable)) {
                        throw new ParserException("Invalid pattern in match2", parser.getCurrentURL(), parser.getLineNumber());
                    }
                    Instruction instruction44 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    ((ArrayList)object2).add(new Match2Instruction.Match(instruction43, instruction44));
                    continue;
                }
                throw new ParserException("Unexpected token: " + (String)matchArray, parser.getCurrentURL(), parser.getLineNumber());
            }
            matchArray = new Match2Instruction.Match[((ArrayList)object2).size()];
            ((ArrayList)object2).toArray(matchArray);
            return new Match2Instruction(instruction41, matchArray, instruction42);
        }
        if (string2.equals("type-match")) {
            TypeMatchInstruction.Match[] matchArray;
            Instruction instruction45 = parser.parseExpression(iTypeStore);
            object2 = new ArrayList();
            Instruction instruction46 = null;
            while (parser.parseOpenParenOrEnd()) {
                matchArray = parser.parseIdentifier();
                if (matchArray.equals("else") || matchArray.equals("otherwise")) {
                    instruction46 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    parser.parseCloseParen();
                    break;
                }
                if (matchArray.equals("case")) {
                    Type type11 = parser.parseTypeName(iTypeStore);
                    Object object11 = parser.parseName();
                    Instruction instruction47 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    ((ArrayList)object2).add(new TypeMatchInstruction.Match(type11, object11, instruction47));
                    continue;
                }
                throw new ParserException("Unexpected token: " + (String)matchArray, parser.getCurrentURL(), parser.getLineNumber());
            }
            matchArray = new TypeMatchInstruction.Match[((ArrayList)object2).size()];
            ((ArrayList)object2).toArray(matchArray);
            return new TypeMatchInstruction(instruction45, matchArray, instruction46);
        }
        if (string2.equals("tuple-match")) {
            Instruction instruction48 = parser.parseExpression(iTypeStore);
            parser.parseOpenParen();
            object2 = parser.parseRemainingIdentifiers();
            parser.parseCloseParen();
            Instruction instruction49 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new TupleMatchInstruction(instruction48, (Object[])object2, instruction49);
        }
        if (string2.equals("build-lazy-stream")) {
            parser.parseOpenParen();
            Object[] objectArray = parser.parseRemainingIdentifiers();
            parser.parseCloseParen();
            object2 = new Instruction[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                object2[i] = parser.parseExpression(iTypeStore);
            }
            Instruction instruction50 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new BuildLazyStreamInstruction((Instruction[])object2, objectArray, instruction50);
        }
        if (string2.equals("build-multi-stream")) {
            parser.parseOpenParen();
            Object[] objectArray = parser.parseRemainingIdentifiers();
            parser.parseCloseParen();
            object2 = new Instruction[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                object2[i] = parser.parseExpression(iTypeStore);
            }
            Instruction instruction51 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new BuildMultiStreamInstruction((Instruction[])object2, objectArray, instruction51);
        }
        if (string2.equals("lambda") || string2.equals("lambda!")) {
            Binding[] bindingArray;
            n2 = string2.equals("lambda") ? 1 : 0;
            parser.parseOpenParen();
            ArrayList<Binding[]> arrayList = new ArrayList<Binding[]>();
            while ((object2 = parser.parseName(false)) != null) {
                bindingArray = new Binding(object2);
                char c = parser.readStripComments();
                if (c != '@') {
                    parser.unread(c);
                } else {
                    bindingArray.setType(parser.parseTypeName(iTypeStore));
                }
                arrayList.add(bindingArray);
            }
            parser.parseCloseParen();
            bindingArray = new Binding[arrayList.size()];
            arrayList.toArray(bindingArray);
            Instruction instruction52 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new LambdaInstruction(instruction52, bindingArray, n2 != 0);
        }
        if (string2.equals("loop") || string2.equals("loop!")) {
            n2 = string2.equals("loop");
            object2 = parser.parseName(true);
            LinkedList<Object> linkedList = new LinkedList<Object>();
            LinkedList<Instruction> linkedList2 = new LinkedList<Instruction>();
            parser.parseOpenParen();
            while (parser.parseOpenParenOrEnd()) {
                linkedList.add(parser.parseName());
                linkedList2.add(parser.parseExpression(iTypeStore));
                parser.parseCloseParen();
            }
            Instruction instruction53 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            Instruction[] instructionArray = new Instruction[linkedList.size()];
            Binding[] bindingArray = new Binding[linkedList2.size()];
            int n7 = 0;
            while (!linkedList2.isEmpty()) {
                instructionArray[n7] = (Instruction)linkedList2.removeFirst();
                bindingArray[n7] = new Binding(linkedList.removeFirst());
                ++n7;
            }
            return new LoopInstruction(object2, instruction53, bindingArray, instructionArray, n2 != 0);
        }
        if (string2.equals("automaton") || string2.equals("automaton-i") || string2.equals("automaton-c") || string2.equals("automaton-ic")) {
            AutomatonInstruction.Match[] matchArray;
            n2 = string2.equals("automaton-i");
            object2 = parser.parseExpression(iTypeStore);
            ICollectionType iCollectionType = null;
            if (object2 instanceof IdentifierInstruction && ((IdentifierInstruction)object2).getVariable().equals("@")) {
                iCollectionType = (ICollectionType)((Object)parser.parseTypeName(iTypeStore));
                object2 = parser.parseExpression(iTypeStore);
            }
            Instruction instruction54 = parser.parseExpression(iTypeStore);
            Type type12 = parser.parseTypeName(iTypeStore);
            Object object12 = null;
            if (string2.equals("automaton-c") || string2.equals("automaton-ic")) {
                object12 = parser.parseName();
            }
            ArrayList<AutomatonInstruction.Match> arrayList = new ArrayList<AutomatonInstruction.Match>();
            Instruction instruction55 = null;
            Object object13 = null;
            Object object14 = null;
            while (parser.parseOpenParenOrEnd()) {
                matchArray = parser.parseIdentifier();
                if (matchArray.equals("else") || matchArray.equals("otherwise")) {
                    object13 = parser.parseName();
                    object14 = parser.parseName();
                    instruction55 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    parser.parseCloseParen();
                    break;
                }
                if (matchArray.equals("state")) {
                    int n8 = parser.parseInteger();
                    Instruction instruction56 = parser.parseExpression(iTypeStore);
                    Instruction instruction57 = parser.parseExpression(iTypeStore);
                    Instruction instruction58 = parser.parseExpression(iTypeStore);
                    parser.parseCloseParen();
                    if (instruction56 instanceof LiteralInstruction) {
                        arrayList.add(new AutomatonInstruction.LiteralMatch(n8, (LiteralInstruction)instruction56, instruction57, instruction58));
                        continue;
                    }
                    if (instruction56 instanceof FunctionCallInstruction) {
                        FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction56;
                        AutomatonInstruction.BindingOrLiteral[] bindingOrLiteralArray = new AutomatonInstruction.BindingOrLiteral[functionCallInstruction.m_parameters.length];
                        for (int i = 0; i < bindingOrLiteralArray.length; ++i) {
                            Instruction instruction59 = functionCallInstruction.m_parameters[i];
                            if (instruction59 instanceof IdentifierInstruction) {
                                bindingOrLiteralArray[i] = new AutomatonInstruction.BindingOrLiteral(((IdentifierInstruction)instruction59).getVariable());
                                continue;
                            }
                            if (instruction59 instanceof LiteralInstruction) {
                                bindingOrLiteralArray[i] = new AutomatonInstruction.BindingOrLiteral((LiteralInstruction)instruction59);
                                continue;
                            }
                            if (instruction59 instanceof StreamInstruction) {
                                StreamInstruction streamInstruction = (StreamInstruction)instruction59;
                                int n9 = streamInstruction.getChildInstructionCount();
                                LiteralInstruction[] literalInstructionArray = new LiteralInstruction[n9];
                                for (int j = 0; j < n9; ++j) {
                                    Instruction instruction60 = streamInstruction.getChildInstruction(j);
                                    if (!(instruction60 instanceof LiteralInstruction)) {
                                        throw new ParserException("Illegal non-literal part of stream (" + instruction60 + ") in constructor match");
                                    }
                                    literalInstructionArray[j] = (LiteralInstruction)instruction60;
                                }
                                bindingOrLiteralArray[i] = new AutomatonInstruction.BindingOrLiteral(literalInstructionArray);
                                continue;
                            }
                            throw new ParserException("Illegal expression (" + instruction59.getClass() + ") in constructor match");
                        }
                        arrayList.add(new AutomatonInstruction.DeconstructionMatch(n8, functionCallInstruction.getFunction(), bindingOrLiteralArray, instruction57, instruction58));
                        continue;
                    }
                    if (instruction56 instanceof IdentifierInstruction) {
                        arrayList.add(new AutomatonInstruction.LiteralWildcardMatch(n8, ((IdentifierInstruction)instruction56).getVariable(), instruction57, instruction58));
                        continue;
                    }
                    throw new ParserException("Unexpected condition " + instruction56);
                }
                throw new ParserException("Unexpected token: " + (String)matchArray, parser.getCurrentURL(), parser.getLineNumber());
            }
            matchArray = new AutomatonInstruction.Match[arrayList.size()];
            arrayList.toArray(matchArray);
            return iCollectionType == null ? new AutomatonInstruction((Instruction)object2, instruction54, matchArray, instruction55, type12, object13, object14, object12, n2 != 0) : new AutomatonInstruction((Instruction)object2, instruction54, matchArray, instruction55, type12, object13, object14, object12, n2 != 0, iCollectionType);
        }
        for (n2 = 0; n2 < PrimitiveNumericalType.getOperatorSize(); n2 += 1) {
            object2 = PrimitiveNumericalType.getOperator(n2);
            if (!((String)object2).equals(string2)) continue;
            Instruction instruction61 = parser.parseExpression(iTypeStore);
            Instruction instruction62 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return PrimitiveNumericalType.isComparisonOperator(n2) ? new NumericalComparisonInstruction(instruction61, instruction62, n2) : new PrimitiveArithmeticInstruction(instruction61, instruction62, n2);
        }
        return null;
    }

    @Override
    public void registerForms(Parser parser) {
        int n2;
        parser.registerForm("let", this);
        parser.registerForm("let!", this);
        parser.registerForm("set!", this);
        parser.registerForm("get!", this);
        parser.registerForm("slot!", this);
        parser.registerForm("begin", this);
        parser.registerForm("stream", this);
        parser.registerForm("stream-s", this);
        parser.registerForm("stream-e", this);
        parser.registerForm("assert-type", this);
        parser.registerForm("primitive-cast", this);
        parser.registerForm("stream-element", this);
        parser.registerForm("stream-repeat", this);
        parser.registerForm("foreach", this);
        parser.registerForm("foreach-c", this);
        parser.registerForm("parallel-foreach", this);
        parser.registerForm("automaton", this);
        parser.registerForm("automaton-i", this);
        parser.registerForm("automaton-c", this);
        parser.registerForm("automaton-ic", this);
        parser.registerForm("construct", this);
        parser.registerForm("call-module-function", this);
        parser.registerForm("primitive-to-string", this);
        parser.registerForm("choose", this);
        parser.registerForm("match", this);
        parser.registerForm("match2", this);
        parser.registerForm("substream-after", this);
        parser.registerForm("substream-before", this);
        parser.registerForm("and", this);
        parser.registerForm("or", this);
        parser.registerForm("tuple", this);
        parser.registerForm("tuple-match", this);
        parser.registerForm("process-stream", this);
        parser.registerForm("process-stream-i", this);
        parser.registerForm("process-stream-c", this);
        parser.registerForm("process-stream-ic", this);
        parser.registerForm("type-match", this);
        parser.registerForm("let*", this);
        parser.registerForm("substream", this);
        parser.registerForm("substream-1", this);
        parser.registerForm("build-multi-stream", this);
        parser.registerForm("build-lazy-stream", this);
        parser.registerForm("lazy-stream-element", this);
        parser.registerForm("loop", this);
        parser.registerForm("lambda", this);
        parser.registerForm("apply", this);
        parser.registerForm("test-stream", this);
        parser.registerForm("test-stream-c", this);
        parser.registerForm("localize-message", this);
        parser.registerForm("char-stream-to-java-string", this);
        parser.registerForm("big-integer", this);
        parser.registerForm("big-decimal", this);
        parser.registerForm("static-method-invoke", this);
        parser.registerForm("java-method-invoke", this);
        parser.registerForm("java-static-field-ref", this);
        parser.registerForm("new-java-object", this);
        parser.registerForm("java-null", this);
        parser.registerForm("java-downcast", this);
        parser.registerForm("read-java-field", this);
        parser.registerForm("read-java-constant", this);
        parser.registerForm("lookup-java-array", this);
        parser.registerForm("sort", this);
        parser.registerForm("try", this);
        parser.registerForm("tag", this);
        parser.registerForm("untag", this);
        parser.registerForm("union-inject", this);
        for (n2 = 0; n2 < PrimitiveNumericalType.getOperatorSize(); ++n2) {
            parser.registerForm(PrimitiveNumericalType.getOperator(n2), this);
        }
        for (n2 = 0; n2 < s_basicForms.length; ++n2) {
            parser.registerForm(CoreFormHandler.s_basicForms[n2].m_name, this);
        }
    }

    public static class BasicForm {
        public String m_name;
        public int m_parameters;
        public Class m_class;

        BasicForm(String string2, int n2, Class clazz) {
            this.m_name = string2;
            this.m_parameters = n2;
            this.m_class = clazz;
        }
    }
}

