/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.parser;

import com.ibm.xltxe.rnm1.xylem.parser.ParserException;
import com.ibm.xltxe.rnm1.xylem.parser.ParserSource;
import com.ibm.xltxe.rnm1.xylem.parser.SourceResolver;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassLoaderSourceResolver
extends SourceResolver {
    protected ClassLoader m_classLoader;
    private static final Logger s_logger = LoggerUtil.getLogger(ClassLoaderSourceResolver.class);
    private static final String s_className = ClassLoaderSourceResolver.class.getName();

    public ClassLoaderSourceResolver() {
        this(null);
    }

    public ClassLoaderSourceResolver(ClassLoader classLoader) {
        this.m_classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
    }

    @Override
    public ParserSource resolve(ParserSource parserSource, String string2) throws ParserException {
        URL uRL;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "resolve", "resolving '" + string2 + "' cl=" + this.m_classLoader);
        }
        if (null == this.m_classLoader) {
            uRL = this.getClass().getResource(string2);
            if (null == uRL) {
                uRL = ClassLoader.getSystemResource(string2);
            }
        } else {
            uRL = this.m_classLoader.getResource(string2);
        }
        if (null == uRL) {
            String string3 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Resource not found '" + string2 + "'"});
            XylemError xylemError = new XylemError(string3);
            FFDCUtil.log(xylemError, this);
            s_logger.logp(Level.SEVERE, s_className, "resolve", string3);
            throw xylemError;
        }
        return new ParserSource(uRL);
    }
}

