/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;

public class StreamElementEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction instruction2, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        StreamElementInstruction streamElementInstruction = (StreamElementInstruction)instruction2;
        partialInformationCollector.partiallyEvaluate(streamElementInstruction.getOperand1(), letChainManager);
        partialInformationCollector.partiallyEvaluate(streamElementInstruction.getOperand2(), letChainManager);
        Instruction instruction3 = letChainManager.lookupBinding(streamElementInstruction.getOperand1());
        Instruction instruction4 = letChainManager.lookupBinding(streamElementInstruction.getOperand2());
        if (!(instruction4 instanceof LiteralInstruction)) {
            return PartialEvaluationResult.s_emptyResult;
        }
        if (!(instruction3 instanceof StreamInstruction)) {
            return PartialEvaluationResult.s_emptyResult;
        }
        StreamInstruction streamInstruction = (StreamInstruction)instruction3;
        int n2 = (Integer)((LiteralInstruction)instruction4).getValue();
        Type type2 = streamInstruction.getType(partialInformationCollector.getCurrentTypeEnvironment(), partialInformationCollector.getCurrentBindingEnvironment());
        if (streamInstruction.isString()) {
            String string2 = streamInstruction.getStringContent();
            if (string2.length() <= n2) {
                throw new ArrayIndexOutOfBoundsException("index=" + n2 + " str='" + string2 + "'");
            }
            return new PartialEvaluationResult(LiteralInstruction.charLiteral(string2.charAt(n2)));
        }
        for (int i = 0; i <= n2; ++i) {
            Instruction instruction5 = streamInstruction.getElements()[i];
            Type type3 = instruction5.getType(partialInformationCollector.getCurrentTypeEnvironment(), partialInformationCollector.getCurrentBindingEnvironment());
            if (type2.equals(type3, partialInformationCollector.getCurrentTypeEnvironment())) {
                return PartialEvaluationResult.s_emptyResult;
            }
            if (type3.getStreamType().equals(type2)) continue;
            return PartialEvaluationResult.s_emptyResult;
        }
        Instruction instruction6 = streamInstruction.getElements()[n2];
        return new PartialEvaluationResult(instruction6);
    }
}

