/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IdentifierConsolidator;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.FlattenStreamOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.DefaultEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PartialInformationCollector {
    private static final Logger s_logger = LoggerUtil.getLogger(PartialInformationCollector.class);
    private static final String s_className = PartialInformationCollector.class.getName();
    protected Map m_evaluators;
    protected PartialEvaluator m_defaultEvaluator;
    protected Instruction m_baseInstruction;
    protected DeadLetEliminatorOptimizer m_deadLetEliminator;
    protected FlattenStreamOptimizer m_fso;
    protected LetChainManager m_baseLetChainManager;
    public LinkedList m_callStack;
    public HashSet m_completedFunctions;
    protected HashSet m_overflowFunctions;
    protected Function m_currentFunction;
    protected IntegerSettings m_integerSettings;
    protected IdentifierConsolidator m_identifierConsolidator = null;
    protected int m_evaluationStackDepth = 0;
    protected int m_evaluationStackLimit = 250;
    public boolean m_allowFunctionRecursion = true;
    public boolean m_requestRedo = false;
    static final int s_retryLimit = 10;
    private LinkedList m_emptyLinkedList = new LinkedList();

    public PartialInformationCollector(Instruction instruction2, Map map2, Function function2, IntegerSettings integerSettings) {
        this(instruction2, map2, new DefaultEvaluator(), function2, integerSettings);
    }

    public PartialInformationCollector(Instruction instruction2, Map map2, PartialEvaluator partialEvaluator, Function function2, IntegerSettings integerSettings) {
        this(instruction2, map2, partialEvaluator, function2, integerSettings, new DeadLetEliminatorOptimizer(), new FlattenStreamOptimizer(), new HashSet());
    }

    protected PartialInformationCollector(Instruction instruction2, Map map2, PartialEvaluator partialEvaluator, Function function2, IntegerSettings integerSettings, DeadLetEliminatorOptimizer deadLetEliminatorOptimizer, FlattenStreamOptimizer flattenStreamOptimizer, HashSet hashSet) {
        this.m_evaluators = map2;
        this.m_defaultEvaluator = partialEvaluator;
        this.m_baseInstruction = instruction2;
        this.m_baseLetChainManager = new LetChainManager(instruction2, function2);
        this.m_callStack = new LinkedList();
        this.m_completedFunctions = new HashSet();
        this.m_currentFunction = function2;
        this.m_integerSettings = integerSettings;
        this.m_deadLetEliminator = deadLetEliminatorOptimizer;
        this.m_fso = flattenStreamOptimizer;
        this.m_overflowFunctions = hashSet;
    }

    public PartialInformationCollector getFunctionSubcollector(Function function2) {
        PartialInformationCollector partialInformationCollector = this.createSubcollector(function2, this.m_integerSettings);
        this.shareState(partialInformationCollector);
        return partialInformationCollector;
    }

    public PartialInformationCollector createSubcollector(Function function2, IntegerSettings integerSettings) {
        return new PartialInformationCollector(function2.getBody(), this.m_evaluators, this.m_defaultEvaluator, function2, integerSettings, this.m_deadLetEliminator, this.m_fso, this.m_overflowFunctions);
    }

    public void shareState(PartialInformationCollector partialInformationCollector) {
        partialInformationCollector.m_identifierConsolidator = this.m_identifierConsolidator;
        partialInformationCollector.m_callStack = this.m_callStack;
        partialInformationCollector.m_completedFunctions = this.m_completedFunctions;
        partialInformationCollector.m_evaluationStackDepth = this.m_evaluationStackDepth;
    }

    public void partiallyEvaluateFunction(Function function2) {
        String string2 = function2.getName();
        if (this.m_completedFunctions.contains(string2)) {
            return;
        }
        if (this.m_callStack.contains(string2)) {
            return;
        }
        if (this.m_evaluationStackDepth > this.m_evaluationStackLimit) {
            if (this.m_callStack.size() == 1) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "partiallyEvaluateFunction", "Function " + this.m_currentFunction.getName() + " is too big for stack limit, even when being evaluated alone; requesting called function " + string2 + " be evaluated separately");
                }
                this.m_overflowFunctions.add(function2);
            } else {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "partiallyEvaluateFunction", "Preventing stack overflow in partial evaluator by postponing " + string2);
                }
                this.m_overflowFunctions.add(this.m_currentFunction);
            }
        } else {
            PartialEvaluationResult partialEvaluationResult;
            Object object2;
            try {
                while (true) {
                    this.m_callStack.addLast(string2);
                    object2 = this.getFunctionSubcollector(function2);
                    partialEvaluationResult = ((PartialInformationCollector)object2).doPartialEvaluationInternal();
                    Instruction instruction2 = partialEvaluationResult.getReplacement();
                    if (instruction2 == null) {
                        instruction2 = function2.getBody();
                    } else {
                        instruction2 = this.m_deadLetEliminator.optimize(instruction2, function2);
                        instruction2 = instruction2.removeAliases(new HashMap());
                    }
                    function2.setBody(instruction2);
                    this.m_fso.optimizeFunction(function2);
                    this.m_deadLetEliminator.optimizeFunction(function2);
                    if (this.m_identifierConsolidator != null) {
                        this.m_identifierConsolidator.processFunction(function2);
                    }
                    this.m_callStack.removeLast();
                    this.m_completedFunctions.add(string2);
                    if (((PartialInformationCollector)object2).m_evaluationStackDepth != this.m_evaluationStackDepth && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                        s_logger.logp(Level.FINE, s_className, "partiallyEvaluateFunction", "PIC evaluation depth not equal to evaluation stack depth: " + ((PartialInformationCollector)object2).m_evaluationStackDepth + " from " + this.m_evaluationStackDepth);
                    }
                    if (((PartialInformationCollector)object2).m_requestRedo) {
                        if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINE)) continue;
                        s_logger.logp(Level.FINE, s_className, "partiallyEvaluateFunction", "Redoing function " + function2.getName());
                        continue;
                    }
                    break;
                }
            }
            catch (PartialEvaluationStackOverflow partialEvaluationStackOverflow) {
                if (partialEvaluationStackOverflow.m_depth / 2 > this.m_evaluationStackDepth) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                        s_logger.logp(Level.FINE, s_className, "partiallyEvaluateFunction", "StackOverflow during optimization of '" + partialEvaluationStackOverflow.m_fName + "' at depth " + partialEvaluationStackOverflow.m_depth + "\n" + "\tpostponing evaluation of tree starting with " + string2 + " at depth " + this.m_evaluationStackDepth);
                    }
                    this.m_overflowFunctions.add(this.m_currentFunction);
                    return;
                }
                throw partialEvaluationStackOverflow;
            }
            catch (StackOverflowError stackOverflowError) {
                throw new PartialEvaluationStackOverflow(this.m_evaluationStackDepth, string2);
            }
            object2 = function2.getTypeEnvironment().getModule();
            ((Module)object2).setPartialInformation(function2.getName(), partialEvaluationResult.getPartialInformation());
        }
    }

    public PartialEvaluationResult runEvaluators(Instruction object2, LetInstruction letInstruction, LetChainManager letChainManager) {
        Object object3;
        Object object4;
        Object object5;
        PartialEvaluationResult partialEvaluationResult;
        ++this.m_evaluationStackDepth;
        Object object6 = null;
        int n2 = 0;
        while (true) {
            if (object2 == null || object2 instanceof IdentifierInstruction || object2 instanceof LiteralInstruction) {
                throw new IllegalArgumentException("argument " + object2);
            }
            if (this.m_allowFunctionRecursion && object2 instanceof FunctionCallInstruction) {
                this.partiallyEvaluateFunction(this.m_currentFunction.getTypeEnvironment().getModule().getFunction(((FunctionCallInstruction)object2).getFunction()));
            }
            Collection collection2 = this.getEvaluators(object2.getClass());
            partialEvaluationResult = null;
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext() && (partialEvaluationResult = ((PartialEvaluator)(object5 = (PartialEvaluator)iterator.next())).extractPartialInformation((Instruction)object2, this, letInstruction, letChainManager)).getReplacement() == null) {
            }
            object5 = partialEvaluationResult.getReplacement();
            if (object5 instanceof LetInstruction) {
                throw new UnsupportedOperationException();
            }
            if (object5 != null) {
                this.typeCheckReplacement((Instruction)object2, (Instruction)object5, letChainManager, letInstruction);
            }
            if (!partialEvaluationResult.isIncremental()) break;
            ++n2;
            object6 = object5;
            if (object5 instanceof IdentifierInstruction) {
                object4 = letChainManager.lookupBinding((Instruction)object5);
                if (object4 == null) {
                    --this.m_evaluationStackDepth;
                    return partialEvaluationResult;
                }
                object3 = letChainManager.findBinding(((IdentifierInstruction)object5).getVariable()).getLet();
                if (object3 != null && object3.m_partialInformation != null) {
                    --this.m_evaluationStackDepth;
                    return partialEvaluationResult;
                }
                object5 = object4;
            }
            if (object5 instanceof LiteralInstruction) {
                --this.m_evaluationStackDepth;
                return partialEvaluationResult;
            }
            if (n2 == 10) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "runEvaluators", "Retry limit hit; stopping: " + object5);
                }
                --this.m_evaluationStackDepth;
                return partialEvaluationResult;
            }
            object2 = object5;
        }
        object4 = new Boolean(object5 != null);
        object3 = new Instruction[]{object6};
        if (object3[0] != null && !((Boolean)object4).booleanValue()) {
            partialEvaluationResult = new PartialEvaluationResult((Instruction)object6, false, partialEvaluationResult.getPartialInformation());
        }
        --this.m_evaluationStackDepth;
        return partialEvaluationResult;
    }

    public Collection getEvaluators(Class clazz) {
        ArrayList<PartialEvaluator> arrayList = this.getInstalledEvaluators(clazz);
        if (arrayList == null || arrayList.size() == 0) {
            arrayList = new ArrayList<PartialEvaluator>();
            arrayList.add(this.m_defaultEvaluator);
        }
        return arrayList;
    }

    public Collection getInstalledEvaluators(Class clazz) {
        Collection collection2 = (Collection)this.m_evaluators.get(clazz);
        return collection2;
    }

    public PartialEvaluationResult runDefaultEvaluator(Instruction instruction2, LetInstruction letInstruction, LetChainManager letChainManager) {
        return this.m_defaultEvaluator.extractPartialInformation(instruction2, this, letInstruction, letChainManager);
    }

    public void doPartialEvaluationFromFunction(Function function2) {
        this.partiallyEvaluateFunction(function2);
        this.processOverflowFunctions();
    }

    protected void processOverflowFunctions() {
        while (!this.m_overflowFunctions.isEmpty()) {
            for (Function function2 : this.m_overflowFunctions) {
                this.m_completedFunctions.remove(function2.getName());
            }
            Iterator iterator = this.m_overflowFunctions.iterator();
            this.m_overflowFunctions = new HashSet();
            while (iterator.hasNext()) {
                Function function2;
                function2 = (Function)iterator.next();
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "processOverflowFunctions", "Partially evaluating overflow function " + function2.getName());
                }
                this.partiallyEvaluateFunction(function2);
            }
        }
    }

    public PartialEvaluationResult doPartialEvaluation() {
        PartialEvaluationResult partialEvaluationResult = this.doPartialEvaluationInternal();
        this.processOverflowFunctions();
        return partialEvaluationResult;
    }

    protected PartialEvaluationResult doPartialEvaluationInternal() {
        if (this.m_baseLetChainManager.m_targetInstruction instanceof LiteralInstruction) {
            return PartialEvaluationResult.s_emptyResult;
        }
        if (this.m_baseLetChainManager.m_targetInstruction instanceof IdentifierInstruction) {
            this.partiallyEvaluate(this.m_baseLetChainManager.m_targetInstruction, this.m_baseLetChainManager);
            LetInstruction letInstruction = this.m_baseLetChainManager.m_outerLet == null ? null : this.m_baseLetChainManager.m_outerLet;
            return new PartialEvaluationResult(letInstruction);
        }
        PartialEvaluationResult partialEvaluationResult = this.runEvaluators(this.m_baseLetChainManager.m_targetInstruction, null, this.m_baseLetChainManager);
        Instruction instruction2 = partialEvaluationResult.getReplacement();
        if (instruction2 instanceof LiteralInstruction) {
            return partialEvaluationResult;
        }
        return new PartialEvaluationResult(this.m_baseLetChainManager.graftFinalBody(instruction2), partialEvaluationResult.isIncremental(), partialEvaluationResult.getPartialInformation());
    }

    private static String arrayToString(Object[] objectArray) {
        String string2 = "[";
        if (objectArray.length > 0) {
            string2 = null == objectArray[0] ? string2 + "null" : string2 + objectArray[0].toString();
        }
        for (int i = 1; i < objectArray.length; ++i) {
            string2 = null == objectArray[i] ? string2 + ", null" : string2 + ", " + objectArray[i].toString();
        }
        string2 = string2 + "]";
        return string2;
    }

    public static HashMap setupDeconstructionBindingReplacement(Instruction[] instructionArray, IBinding[] iBindingArray, Instruction instruction2, LetChainManager letChainManager, LetInstruction letInstruction) {
        if (instructionArray.length > iBindingArray.length) {
            System.out.println("replaceDeconstructionBindings(" + PartialInformationCollector.arrayToString(instructionArray) + ", " + PartialInformationCollector.arrayToString(iBindingArray) + ")");
            new Exception().printStackTrace();
        }
        HashMap<Object, Instruction> hashMap = new HashMap<Object, Instruction>();
        for (int i = 0; i < instructionArray.length; ++i) {
            Instruction instruction3 = instructionArray[i];
            if (instruction3 == null) continue;
            hashMap.put(iBindingArray[i].getName(), instruction3);
        }
        return hashMap;
    }

    public PartialEvaluationResult partiallyEvaluateBody(Instruction instruction2, Instruction instruction3, int n2, LetChainManager letChainManager) {
        LetChainManager letChainManager2 = new LetChainManager(instruction2, letChainManager, letChainManager.m_currentFunction, instruction3, n2);
        Instruction instruction4 = instruction2;
        instruction2 = letChainManager2.m_targetInstruction;
        if (instruction2 instanceof IdentifierInstruction) {
            Instruction instruction5;
            Set set2 = this.partiallyEvaluate(instruction2, letChainManager2);
            Instruction instruction6 = instruction5 = letChainManager2.m_outerLet == null ? instruction4 : letChainManager2.m_outerLet;
            if (instruction5 != instruction4) {
                return new PartialEvaluationResult(instruction5, set2);
            }
            return new PartialEvaluationResult(set2);
        }
        if (instruction2 instanceof LiteralInstruction) {
            return PartialEvaluationResult.s_emptyResult;
        }
        PartialEvaluationResult partialEvaluationResult = this.runEvaluators(letChainManager2.m_targetInstruction, null, letChainManager2);
        Instruction instruction7 = partialEvaluationResult.getReplacement();
        if (instruction7 instanceof LiteralInstruction) {
            return new PartialEvaluationResult(instruction7, partialEvaluationResult.getPartialInformation());
        }
        return new PartialEvaluationResult(letChainManager2.graftFinalBody(instruction7), partialEvaluationResult.getPartialInformation());
    }

    public Set partiallyEvaluate(Instruction instruction2, LetChainManager letChainManager) {
        if (!(instruction2 instanceof IdentifierInstruction)) {
            if (instruction2 instanceof LiteralInstruction) {
                return Collections.EMPTY_SET;
            }
            throw new IllegalArgumentException("Should not occur in reduced code: (" + instruction2.getClass() + ")" + instruction2);
        }
        IBinding iBinding = letChainManager.findBinding(((IdentifierInstruction)instruction2).getVariable());
        if (iBinding == null) {
            System.err.println(">> binding " + instruction2);
            System.err.println(letChainManager.getCurrentFunction());
            throw new RuntimeException();
        }
        if (iBinding.getLet() == null) {
            return Collections.EMPTY_SET;
        }
        LetInstruction letInstruction = iBinding.getLet();
        Set set2 = letInstruction.m_partialInformation;
        if (set2 != null) {
            return set2;
        }
        Instruction instruction3 = letInstruction.getValue();
        if (instruction3 instanceof LiteralInstruction) {
            return Collections.EMPTY_SET;
        }
        if (instruction3 instanceof IdentifierInstruction) {
            set2 = this.partiallyEvaluate(instruction3, letChainManager);
            return set2;
        }
        if (instruction3 == null) {
            throw new XylemError("ERR_SYSTEM", "null value for binding " + iBinding + " " + letChainManager.getCurrentFunction());
        }
        PartialEvaluationResult partialEvaluationResult = this.runEvaluators(instruction3, letInstruction, letChainManager);
        letInstruction.m_partialInformation = set2 = partialEvaluationResult.getPartialInformation();
        Instruction instruction4 = partialEvaluationResult.getReplacement();
        if (instruction4 != null) {
            this.replaceLetValue(iBinding.getLet(), instruction4);
            if (instruction4 instanceof IdentifierInstruction && (set2 == null || set2.isEmpty())) {
                letInstruction.m_partialInformation = set2 = this.partiallyEvaluate(instruction4, letChainManager);
            }
        }
        return set2;
    }

    protected void replaceLetValue(LetInstruction letInstruction, Instruction instruction2) {
        letInstruction.setValue(instruction2);
    }

    protected void typeCheckReplacement(Instruction instruction2, Instruction instruction3, LetChainManager letChainManager, LetInstruction letInstruction) {
        instruction3.typeCheckReduced(this.getCurrentTypeEnvironment(), this.getCurrentBindingEnvironment(), this.m_emptyLinkedList);
    }

    public Type resolveType(Instruction instruction2) {
        BindingEnvironment bindingEnvironment;
        TypeEnvironment typeEnvironment = this.m_currentFunction.getTypeEnvironment();
        Type type2 = instruction2.getType(typeEnvironment, bindingEnvironment = this.m_currentFunction.getBindingEnvironment());
        if (type2 == null) {
            throw new RuntimeException();
        }
        return type2.resolveType(typeEnvironment);
    }

    public Module getCurrentModule() {
        return this.m_currentFunction.getTypeEnvironment().getModule();
    }

    public IntegerSettings getIntegerSettings() {
        return this.m_integerSettings;
    }

    public TypeEnvironment getCurrentTypeEnvironment() {
        return this.m_currentFunction.getTypeEnvironment();
    }

    public BindingEnvironment getCurrentBindingEnvironment() {
        return this.m_currentFunction.getBindingEnvironment();
    }

    public void setIdentifierConsolidator(IdentifierConsolidator identifierConsolidator) {
        this.m_identifierConsolidator = identifierConsolidator;
    }

    public LetChainManager getBaseLetChainManager() {
        return this.m_baseLetChainManager;
    }

    private static class PartialEvaluationStackOverflow
    extends RuntimeException {
        int m_depth;
        String m_fName;

        PartialEvaluationStackOverflow(int n2, String string2) {
            this.m_depth = n2;
            this.m_fName = string2;
        }
    }
}

