/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class PartialEvaluator {
    public abstract PartialEvaluationResult extractPartialInformation(Instruction var1, PartialInformationCollector var2, LetInstruction var3, LetChainManager var4);

    public Class[] getSupportedInstructionClasses() {
        return new Class[0];
    }

    public static final Object extractLiteralValue(PartialInformationCollector partialInformationCollector, Instruction instruction2, LetChainManager letChainManager) {
        if (instruction2 == null) {
            return null;
        }
        if (instruction2 instanceof LiteralInstruction) {
            return ((LiteralInstruction)instruction2).getValue();
        }
        if (instruction2 instanceof IdentifierInstruction) {
            return PartialEvaluator.extractLiteralValue(partialInformationCollector, letChainManager.lookupBinding(instruction2), letChainManager);
        }
        return null;
    }

    public static final Integer extractIntegerValue(PartialInformationCollector partialInformationCollector, Instruction instruction2, LetChainManager letChainManager) {
        Object object2 = PartialEvaluator.extractLiteralValue(partialInformationCollector, instruction2, letChainManager);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        return null;
    }

    public static final Object[] extractStreamOfLiteralsValue(PartialInformationCollector partialInformationCollector, Instruction instruction2, LetChainManager letChainManager) {
        if (instruction2 == null) {
            return null;
        }
        if (instruction2 instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction2;
            int n2 = streamInstruction.getChildInstructionCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                Instruction instruction3 = streamInstruction.getChildInstruction(i);
                if (!(instruction3 instanceof LiteralInstruction)) {
                    return null;
                }
                objectArray[i] = ((LiteralInstruction)instruction3).getValue();
            }
            return objectArray;
        }
        if (instruction2 instanceof IdentifierInstruction) {
            return PartialEvaluator.extractStreamOfLiteralsValue(partialInformationCollector, letChainManager.lookupBinding(instruction2), letChainManager);
        }
        return null;
    }

    public static final LiteralInstruction.KnownValue extractKnownValue(PartialInformationCollector partialInformationCollector, Instruction instruction2, LetChainManager letChainManager) {
        if (instruction2 == null) {
            return null;
        }
        if (instruction2 instanceof LiteralInstruction) {
            return new LiteralInstruction.KnownValue(((LiteralInstruction)instruction2).getValue());
        }
        if (instruction2 instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction2;
            int n2 = streamInstruction.getChildInstructionCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                Instruction instruction3 = streamInstruction.getChildInstruction(i);
                if (!(instruction3 instanceof LiteralInstruction)) {
                    return null;
                }
                objectArray[i] = ((LiteralInstruction)instruction3).getValue();
            }
            return new LiteralInstruction.KnownValue(objectArray);
        }
        if (instruction2 instanceof IdentifierInstruction) {
            return PartialEvaluator.extractKnownValue(partialInformationCollector, letChainManager.lookupBinding(instruction2), letChainManager);
        }
        return null;
    }

    public static final Iterator accumulateStream(StreamInstruction streamInstruction, PartialInformationCollector partialInformationCollector, LetChainManager letChainManager) {
        AccumulatedStreamIterator accumulatedStreamIterator = new AccumulatedStreamIterator();
        PartialEvaluator.accumulateStreamInner(streamInstruction, accumulatedStreamIterator.m_list, partialInformationCollector, letChainManager);
        return accumulatedStreamIterator;
    }

    private static final void accumulateStreamInner(StreamInstruction streamInstruction, List list, PartialInformationCollector partialInformationCollector, LetChainManager letChainManager) {
        if (streamInstruction.isStoredAsString()) {
            String string2 = streamInstruction.getStringContent();
            if (string2.length() > 0) {
                list.add(string2);
            }
        } else {
            int n2 = streamInstruction.getChildInstructionCount();
            for (int i = 0; i < n2; ++i) {
                Instruction instruction2 = streamInstruction.getChildInstruction(i);
                partialInformationCollector.partiallyEvaluate(instruction2, letChainManager);
                Instruction instruction3 = letChainManager.lookupBinding(instruction2);
                if (instruction3 instanceof StreamInstruction) {
                    PartialEvaluator.accumulateStreamInner((StreamInstruction)instruction3, list, partialInformationCollector, letChainManager);
                    continue;
                }
                list.add(NavigationUtilities.resolveIdentifierAliases(instruction2, partialInformationCollector.getCurrentBindingEnvironment()));
            }
        }
    }

    public static final void accumulateStream(StreamInstruction streamInstruction, List list, PartialInformationCollector partialInformationCollector, LetChainManager letChainManager) {
        int n2 = streamInstruction.getChildInstructionCount();
        for (int i = 0; i < n2; ++i) {
            Instruction instruction2 = streamInstruction.getChildInstruction(i);
            partialInformationCollector.partiallyEvaluate(instruction2, letChainManager);
            Instruction instruction3 = letChainManager.lookupBinding(instruction2);
            if (instruction3 instanceof StreamInstruction) {
                PartialEvaluator.accumulateStream((StreamInstruction)instruction3, list, partialInformationCollector, letChainManager);
                continue;
            }
            list.add(NavigationUtilities.resolveIdentifierAliases(instruction2, partialInformationCollector.getCurrentBindingEnvironment()));
        }
    }

    public static final Instruction moveToBottom(Instruction instruction2, Object object2, Instruction instruction3) {
        return PartialEvaluator.moveToBottom(instruction2, object2, instruction3, null);
    }

    public static final Instruction moveToBottom(Instruction instruction2, Object object2, Instruction instruction3, BindingEnvironment bindingEnvironment) {
        LetInstruction letInstruction;
        Instruction instruction4 = instruction2;
        LetInstruction letInstruction2 = null;
        while (instruction4 instanceof LetInstruction) {
            letInstruction2 = (LetInstruction)instruction4;
            instruction4 = letInstruction2.getBody();
        }
        if (letInstruction2 != null) {
            letInstruction = new LetInstruction(object2, instruction4, instruction3);
            letInstruction2.setBody(letInstruction);
            instruction3 = instruction2;
        } else {
            letInstruction = new LetInstruction(object2, instruction4, instruction3);
            instruction3 = letInstruction;
        }
        if (bindingEnvironment != null) {
            bindingEnvironment.setVariableBinding(letInstruction);
        }
        return instruction3;
    }

    private static final class AccumulatedStreamIterator
    implements Iterator {
        ArrayList m_list = new ArrayList();
        String m_subPartStream;
        int m_part = 0;
        int m_subPart = 0;

        private AccumulatedStreamIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.m_part < this.m_list.size() || this.m_subPartStream != null && this.m_subPart < this.m_subPartStream.length();
        }

        public Object next() {
            Object e;
            if (this.m_subPartStream != null) {
                if (this.m_subPart < this.m_subPartStream.length()) {
                    return LiteralInstruction.charLiteral(this.m_subPartStream.charAt(this.m_subPart++));
                }
                this.m_subPartStream = null;
            }
            if ((e = this.m_list.get(this.m_part++)) instanceof String) {
                this.m_subPartStream = (String)e;
                this.m_subPart = 1;
                return LiteralInstruction.charLiteral(this.m_subPartStream.charAt(0));
            }
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

