/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IdentifierConsolidator;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NotInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.ADTMatchEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.EvaluatorDiscoveringPartialInformationCollector;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.FLD2ForEachEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.ForEachEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.FunctionCallEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.MatchEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class PartialEvaluationOptimizer
extends Optimizer {
    protected HashMap m_evaluators = new HashMap(499);
    protected HashSet m_functions = new HashSet();
    protected HashSet m_functionsIfStaticArg = new HashSet();
    public HashSet m_entryPoints = new HashSet();
    public IdentifierConsolidator m_ic;
    private IntegerSettings m_is;

    public PartialEvaluationOptimizer(Set set2, IntegerSettings integerSettings) {
        this.m_entryPoints.addAll(set2);
        this.m_is = integerSettings;
        this.baseSetup();
    }

    public PartialEvaluationOptimizer(IntegerSettings integerSettings) {
        this.m_entryPoints.add("main");
        this.m_is = integerSettings;
        this.baseSetup();
    }

    protected void baseSetup() {
        this.addEvaluator(ForEachInstruction.class, new ForEachEvaluator());
        this.addEvaluator(ForEachInstruction.class, new FLD2ForEachEvaluator());
        this.addEvaluator(MatchInstruction.class, new ADTMatchEvaluator());
        this.addEvaluator(MatchInstruction.class, new MatchEvaluator());
        this.setupFunctionCallEvaluators();
    }

    public PartialInformationCollector createInitialFuncInfoCollector(Instruction instruction2, Map map2, Function function2) {
        return new EvaluatorDiscoveringPartialInformationCollector(instruction2, map2, function2, this.m_is);
    }

    @Override
    public Instruction optimize(Instruction instruction2) {
        PartialInformationCollector partialInformationCollector = this.createInitialFuncInfoCollector(instruction2, this.m_evaluators, this.m_currentFunction);
        partialInformationCollector.m_identifierConsolidator = this.m_ic;
        Instruction instruction3 = partialInformationCollector.doPartialEvaluation().getReplacement();
        if (instruction3 == null) {
            instruction3 = instruction2;
        } else {
            instruction3 = instruction3.removeAliases(new HashMap());
            Function function2 = this.getCurrentFunction();
            instruction3.typeCheckReduced(function2.getTypeEnvironment(), function2.getBindingEnvironment(), new LinkedList());
        }
        return instruction3;
    }

    protected void addEvaluator(Class clazz, PartialEvaluator partialEvaluator) {
        ArrayList<PartialEvaluator> arrayList = (ArrayList<PartialEvaluator>)this.m_evaluators.get(clazz);
        if (arrayList == null) {
            arrayList = new ArrayList<PartialEvaluator>();
            this.m_evaluators.put(clazz, arrayList);
        }
        arrayList.add(partialEvaluator);
    }

    public void addEvaluator(PartialEvaluator partialEvaluator) {
        Class[] classArray = partialEvaluator.getSupportedInstructionClasses();
        for (int i = 0; i < classArray.length; ++i) {
            this.addEvaluator(classArray[i], partialEvaluator);
        }
    }

    @Override
    public void optimizeFunction(Function function2) {
        if (this.m_entryPoints.contains(function2.getName())) {
            PartialInformationCollector partialInformationCollector = this.createInitialFuncInfoCollector(function2.getBody(), this.m_evaluators, function2);
            partialInformationCollector.m_identifierConsolidator = this.m_ic;
            partialInformationCollector.doPartialEvaluationFromFunction(function2);
        }
    }

    protected void setupFunctionCallEvaluators() {
        this.addEvaluator(FunctionCallInstruction.class, new FunctionCallEvaluator(){

            @Override
            protected boolean allowInlining(FunctionCallInstruction functionCallInstruction, Function function2, BindingEnvironment bindingEnvironment) {
                LetInstruction letInstruction;
                Instruction instruction2;
                if (PartialEvaluationOptimizer.this.m_functionsIfStaticArg.contains(function2.getName())) {
                    return functionCallInstruction.getOperands()[0].isStatic(bindingEnvironment);
                }
                Instruction instruction3 = function2.getBody();
                while (instruction3 instanceof LetInstruction && ((instruction2 = (letInstruction = (LetInstruction)instruction3).getValue()) instanceof LiteralInstruction || instruction2 instanceof IdentifierInstruction)) {
                    instruction3 = letInstruction.getBody();
                }
                if (instruction3 instanceof FunctionCallInstruction) {
                    FunctionCallInstruction functionCallInstruction2 = (FunctionCallInstruction)instruction3;
                    Function function3 = function2.getTypeEnvironment().getModule().getFunction(functionCallInstruction2.getFunction());
                    if (!function2.getMemoizeResult() || function3.getMemoizeResult()) {
                        return true;
                    }
                } else if (instruction3 instanceof MatchInstruction) {
                    MatchInstruction matchInstruction = (MatchInstruction)instruction3;
                    if (matchInstruction.getDefault() == null && matchInstruction.getMatches().length == 1) {
                        NotInstruction notInstruction;
                        Instruction instruction4 = matchInstruction.getMatches()[0].getHandler();
                        if (instruction4 instanceof IdentifierInstruction) {
                            return true;
                        }
                        if (instruction4 instanceof NotInstruction && (notInstruction = (NotInstruction)instruction4).getOperand() instanceof IdentifierInstruction) {
                            return true;
                        }
                    }
                } else if (instruction3 instanceof ConstructorInstantiationInstruction) {
                    return true;
                }
                if (function2.getInlineHint()) {
                    return true;
                }
                if (function2.getBody().isStatic(function2.getBindingEnvironment())) {
                    return true;
                }
                return PartialEvaluationOptimizer.this.m_functions.contains(function2.getName());
            }
        });
    }
}

