/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LetChainManager {
    private static final Logger s_logger = LoggerUtil.getLogger(LetChainManager.class);
    private static final String s_className = LetChainManager.class.getName();
    protected Instruction m_baseInstruction;
    protected Instruction m_targetInstruction;
    protected LetInstruction m_outerLet;
    protected LetInstruction m_innerLet;
    protected Type m_baseType;
    protected LiteralInstruction m_baseNull;
    protected LetChainManager m_parent;
    protected Function m_currentFunction;
    protected Instruction m_parentInstruction;
    protected int m_parentIndex;

    public LetChainManager(Instruction instruction2, Function function2) {
        this(instruction2, null, function2, null, -1);
    }

    public LetChainManager(Instruction instruction2, LetChainManager letChainManager, Function function2, Instruction instruction3, int n2) {
        this.m_baseInstruction = instruction2;
        try {
            this.m_baseType = instruction2.getType(function2.getTypeEnvironment(), function2.getBindingEnvironment()).resolveType(function2.getTypeEnvironment());
        }
        catch (Exception exception) {
            throw new XylemError("ERR_SYSTEM", "error getting type for " + instruction2 + ": " + exception);
        }
        this.m_baseNull = new LiteralInstruction(this.m_baseType, null);
        this.m_parent = letChainManager;
        this.m_currentFunction = function2;
        this.m_parentInstruction = instruction3;
        this.m_parentIndex = n2;
        this.m_targetInstruction = instruction2;
        LetInstruction letInstruction = null;
        while (this.m_targetInstruction instanceof LetInstruction) {
            LetInstruction letInstruction2 = (LetInstruction)this.m_targetInstruction;
            if (letInstruction != null) {
                letInstruction2.m_parent = letInstruction;
            }
            letInstruction2.m_lcm = this;
            this.m_innerLet = letInstruction2;
            if (this.m_outerLet == null) {
                this.m_outerLet = this.m_innerLet;
            }
            this.m_targetInstruction = this.m_innerLet.getBody();
            letInstruction = this.m_innerLet;
        }
    }

    protected void addAndTypeCheckLet(LetInstruction letInstruction, LetInstruction letInstruction2, Set set2) throws TypeCheckException {
        if (letInstruction2 != null && letInstruction2.m_lcm != this) {
            letInstruction2.m_lcm.addAndTypeCheckLet(letInstruction, letInstruction2, set2);
            return;
        }
        LetInstruction letInstruction3 = this.getLetParent(letInstruction2);
        if (letInstruction.hasBeenTypeChecked()) {
            throw new IllegalArgumentException();
        }
        if (letInstruction.getValue() == null) {
            throw new XylemError("ERR_SYSTEM", "xx" + letInstruction);
        }
        BindingEnvironment bindingEnvironment = this.getCurrentFunction().getBindingEnvironment();
        letInstruction.setBody(this.m_baseNull);
        letInstruction.m_lcm = this;
        if (letInstruction2 == null) {
            if (this.m_outerLet == null) {
                this.m_outerLet = letInstruction;
                if (this.m_parentInstruction != null) {
                    this.m_parentInstruction.setChildInstruction(this.m_parentIndex, this.m_outerLet);
                } else {
                    this.m_currentFunction.setBody(this.m_outerLet);
                }
            }
            Instruction instruction2 = null;
            if (this.m_innerLet != null) {
                instruction2 = this.m_innerLet.getBody();
                this.m_innerLet.setBody(letInstruction);
                letInstruction.m_parent = this.m_innerLet;
                letInstruction.typeCheckReduced(this.m_currentFunction.getTypeEnvironment(), bindingEnvironment, new LinkedList());
            } else {
                letInstruction.typeCheckReduced(this.m_currentFunction.getTypeEnvironment(), bindingEnvironment, new LinkedList());
                instruction2 = this.m_targetInstruction;
            }
            this.m_innerLet = letInstruction;
            letInstruction.setBody(instruction2);
            if (instruction2 instanceof LetInstruction) {
                LetInstruction letInstruction4 = (LetInstruction)instruction2;
                letInstruction4.m_parent = letInstruction;
                letInstruction4.m_lcm = this;
            }
        } else {
            if (letInstruction2 == this.m_outerLet) {
                this.m_outerLet = letInstruction;
                if (this.m_parentInstruction != null) {
                    this.m_parentInstruction.setChildInstruction(this.m_parentIndex, this.m_outerLet);
                } else {
                    this.m_currentFunction.setBody(this.m_outerLet);
                }
            }
            letInstruction.typeCheckReduced(this.m_currentFunction.getTypeEnvironment(), bindingEnvironment, new LinkedList());
            if (letInstruction3 != null) {
                letInstruction3.setBody(letInstruction);
                letInstruction.m_parent = letInstruction3;
            }
            letInstruction.setBody(letInstruction2);
            letInstruction2.m_parent = letInstruction;
        }
    }

    public Instruction insertBody2(Instruction instruction2, LetInstruction letInstruction) {
        Comparable<Object> comparable;
        while (instruction2 instanceof LetInstruction) {
            comparable = (LetInstruction)instruction2.cloneShallow();
            try {
                this.addAndTypeCheckLet((LetInstruction)comparable, letInstruction, null);
            }
            catch (TypeCheckException typeCheckException) {
                FFDCUtil.log(typeCheckException, this);
                String string2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Type error transferring let " + comparable});
                s_logger.logp(Level.WARNING, s_className, "insertBody2", string2, typeCheckException);
                return null;
            }
            instruction2 = ((LetInstruction)instruction2).getBody();
        }
        if (instruction2 instanceof IdentifierInstruction) {
            return instruction2;
        }
        if (instruction2 instanceof LiteralInstruction) {
            return instruction2;
        }
        comparable = ReductionHelper.generateIntermediateIdentifier2();
        try {
            this.addAndTypeCheckLet(new LetInstruction(comparable, instruction2, null), letInstruction, null);
        }
        catch (TypeCheckException typeCheckException) {
            FFDCUtil.log(typeCheckException, this);
            String string3 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Type error"});
            s_logger.logp(Level.WARNING, s_className, "insertBody2", string3, typeCheckException);
            return null;
        }
        return new IdentifierInstruction(comparable);
    }

    public Instruction insertBodyWithoutClone(Instruction instruction2, LetInstruction letInstruction) {
        Comparable<Object> comparable;
        while (instruction2 instanceof LetInstruction) {
            comparable = (LetInstruction)instruction2;
            Instruction instruction3 = comparable.getBody();
            try {
                this.addAndTypeCheckLet((LetInstruction)comparable, letInstruction, null);
            }
            catch (TypeCheckException typeCheckException) {
                FFDCUtil.log(typeCheckException, this);
                String string2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Type error transferring let " + comparable});
                s_logger.logp(Level.WARNING, s_className, "insertBodyWithoutClone", string2, typeCheckException);
                return null;
            }
            instruction2 = instruction3;
        }
        if (instruction2 instanceof IdentifierInstruction) {
            return instruction2;
        }
        if (instruction2 instanceof LiteralInstruction) {
            return instruction2;
        }
        comparable = ReductionHelper.generateIntermediateIdentifier2();
        try {
            this.addAndTypeCheckLet(new LetInstruction(comparable, instruction2, null), letInstruction, null);
        }
        catch (TypeCheckException typeCheckException) {
            FFDCUtil.log(typeCheckException, this);
            String string3 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Type error"});
            s_logger.logp(Level.WARNING, s_className, "insertBodyWithoutClone", string3, typeCheckException);
            return null;
        }
        return new IdentifierInstruction(comparable);
    }

    public IdentifierInstruction insertBody(Instruction instruction2, LetInstruction letInstruction) {
        return this.insertBodyWithNameHelper(ReductionHelper.generateIntermediateIdentifier2(), instruction2, letInstruction, false);
    }

    public IdentifierInstruction insertBodyWithNameForced(Object object2, Instruction instruction2, LetInstruction letInstruction) {
        return this.insertBodyWithNameHelper(object2, instruction2, letInstruction, true);
    }

    public IdentifierInstruction insertBodyWithNameHelper(Object object2, Instruction instruction2, LetInstruction letInstruction, boolean bl) {
        Instruction instruction3;
        Set set2 = null;
        while (instruction2 instanceof LetInstruction) {
            instruction3 = (LetInstruction)instruction2.cloneShallow();
            try {
                this.addAndTypeCheckLet((LetInstruction)instruction3, letInstruction, set2);
            }
            catch (TypeCheckException typeCheckException) {
                FFDCUtil.log(typeCheckException, this);
                String string2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Type error transferring let " + instruction3});
                s_logger.logp(Level.WARNING, s_className, "insertBodyWithNameHelper", string2, typeCheckException);
                return null;
            }
            instruction2 = ((LetInstruction)instruction2).getBody();
        }
        if (!bl && instruction2 instanceof IdentifierInstruction) {
            return (IdentifierInstruction)instruction2;
        }
        try {
            this.addAndTypeCheckLet(new LetInstruction(object2, instruction2, null), letInstruction, set2);
        }
        catch (TypeCheckException typeCheckException) {
            FFDCUtil.log(typeCheckException, this);
            String string3 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Type error"});
            s_logger.logp(Level.WARNING, s_className, "insertBodyWithNameHelper", string3, typeCheckException);
            return null;
        }
        instruction3 = new IdentifierInstruction(object2);
        Instruction.propagateInfo(instruction2, instruction3);
        return instruction3;
    }

    public Instruction lookupBinding(Object object2) {
        IBinding iBinding = this.findBinding(object2);
        if (iBinding == null) {
            return null;
        }
        if (iBinding.getLet() == null) {
            return null;
        }
        Instruction instruction2 = iBinding.getLet().getValue();
        if (instruction2 instanceof IdentifierInstruction) {
            return this.lookupBinding(instruction2);
        }
        return instruction2;
    }

    public IBinding findBinding(Object object2) {
        BindingEnvironment bindingEnvironment = this.m_currentFunction.getBindingEnvironment();
        if (bindingEnvironment == null) {
            throw new RuntimeException();
        }
        IBinding iBinding = bindingEnvironment.getVariableBinding(object2);
        if (iBinding != null || this.m_parent == null) {
            return iBinding;
        }
        return this.m_parent.findBinding(object2);
    }

    public Instruction lookupBinding(Instruction instruction2) {
        if (instruction2 instanceof IdentifierInstruction) {
            return this.lookupBinding(((IdentifierInstruction)instruction2).getVariable());
        }
        if (instruction2 instanceof LiteralInstruction) {
            return instruction2;
        }
        throw new IllegalArgumentException();
    }

    public Instruction graftFinalBody(Instruction instruction2) {
        LetInstruction letInstruction = this.m_outerLet;
        if (letInstruction != null) {
            while (true) {
                letInstruction.m_lcm = null;
                letInstruction.m_parent = null;
                Instruction instruction3 = letInstruction.getBody();
                if (!(instruction3 instanceof LetInstruction)) break;
                letInstruction = (LetInstruction)instruction3;
            }
        }
        if (instruction2 == null) {
            return this.m_outerLet == null ? this.m_baseInstruction : this.m_outerLet;
        }
        if (this.m_innerLet != null) {
            this.m_innerLet.setBody(instruction2);
            return this.m_outerLet;
        }
        return instruction2;
    }

    protected LetInstruction getLetParent(LetInstruction letInstruction) {
        if (letInstruction == null) {
            return null;
        }
        return letInstruction.m_parent;
    }

    public Function getCurrentFunction() {
        return this.m_currentFunction;
    }

    public Instruction getTargetInstruction() {
        return this.m_targetInstruction;
    }
}

