/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.HashMap;

public class FunctionCallEvaluator
extends PartialEvaluator {
    protected int m_depth = 0;
    private static final int m_maxDepth = 2;

    protected boolean allowInlining(FunctionCallInstruction functionCallInstruction, Function function2, BindingEnvironment bindingEnvironment) {
        return function2.getBody().isStatic(function2.getBindingEnvironment());
    }

    @Override
    public Class[] getSupportedInstructionClasses() {
        return new Class[]{FunctionCallInstruction.class};
    }

    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction instruction2, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
        Instruction[] instructionArray = new Instruction[functionCallInstruction.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            partialInformationCollector.partiallyEvaluate(functionCallInstruction.m_parameters[i], letChainManager);
        }
        if (this.m_depth == 2) {
            return PartialEvaluationResult.s_emptyResult;
        }
        ++this.m_depth;
        Function function2 = letChainManager.getCurrentFunction().getTypeEnvironment().getModule().getFunction(functionCallInstruction.getFunction());
        if (!this.allowInlining(functionCallInstruction, function2, partialInformationCollector.getCurrentBindingEnvironment())) {
            --this.m_depth;
            if (function2 == letChainManager.m_currentFunction) {
                return PartialEvaluationResult.s_emptyResult;
            }
            Module module = function2.getTypeEnvironment().getModule();
            return new PartialEvaluationResult(null, false, module.getPartialInformation(function2.getName()));
        }
        Instruction instruction3 = function2.getBody();
        HashMap hashMap = PartialInformationCollector.setupDeconstructionBindingReplacement(functionCallInstruction.m_parameters, function2.m_parameters, instruction3, letChainManager, letInstruction);
        instruction3 = instruction3.assignNewNames(hashMap);
        IdentifierInstruction identifierInstruction = letChainManager.insertBody(instruction3, letInstruction);
        --this.m_depth;
        return new PartialEvaluationResult((Instruction)identifierInstruction, true);
    }
}

