/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ForEachEvaluator
extends PartialEvaluator {
    public static final int s_loopUnrollThreshold = 10;

    protected static boolean checkInstruction(PartialInformationCollector partialInformationCollector, Instruction instruction2) {
        if (instruction2 instanceof ChooseInstruction) {
            return ForEachEvaluator.checkChooseInstruction(partialInformationCollector, (ChooseInstruction)instruction2);
        }
        if (instruction2 instanceof MatchInstruction) {
            return ForEachEvaluator.checkMatchInstruction(partialInformationCollector, (MatchInstruction)instruction2);
        }
        if (instruction2 instanceof StreamInstruction) {
            return ForEachEvaluator.checkStreamInstruction(partialInformationCollector, (StreamInstruction)instruction2);
        }
        return false;
    }

    protected static boolean checkStreamInstruction(PartialInformationCollector partialInformationCollector, StreamInstruction streamInstruction) {
        int n2 = streamInstruction.getChildInstructionCount();
        for (int i = 0; i < n2; ++i) {
            Instruction instruction2 = streamInstruction.getChildInstruction(i);
            if (!(partialInformationCollector.resolveType(instruction2) instanceof StreamType)) continue;
            return false;
        }
        return true;
    }

    protected static boolean checkChooseInstruction(PartialInformationCollector partialInformationCollector, ChooseInstruction chooseInstruction) {
        BindingEnvironment bindingEnvironment = partialInformationCollector.getCurrentBindingEnvironment();
        for (ChooseInstruction.Case object2 : chooseInstruction.m_cases) {
            Instruction instruction2 = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(object2.getHandler()), bindingEnvironment);
            if (ForEachEvaluator.checkInstruction(partialInformationCollector, instruction2)) continue;
            return false;
        }
        Instruction instruction3 = chooseInstruction.getDefaultHandler();
        if (instruction3 != null) {
            Instruction instruction4 = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(instruction3), bindingEnvironment);
            return ForEachEvaluator.checkInstruction(partialInformationCollector, instruction4);
        }
        return true;
    }

    protected static boolean checkMatchInstruction(PartialInformationCollector partialInformationCollector, MatchInstruction matchInstruction) {
        Object object2;
        BindingEnvironment bindingEnvironment = partialInformationCollector.getCurrentBindingEnvironment();
        int n2 = matchInstruction.getMatches().length;
        for (int i = 0; i < n2; ++i) {
            object2 = matchInstruction.getMatches()[i];
            Instruction instruction2 = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(((MatchInstruction.Match)object2).getHandler()), bindingEnvironment);
            if (ForEachEvaluator.checkInstruction(partialInformationCollector, instruction2)) continue;
            return false;
        }
        Instruction instruction3 = matchInstruction.getDefault();
        if (instruction3 != null) {
            object2 = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(instruction3), bindingEnvironment);
            return ForEachEvaluator.checkInstruction(partialInformationCollector, (Instruction)object2);
        }
        return true;
    }

    protected static void implantForEach(ForEachInstruction forEachInstruction, Instruction instruction2, int n2, HashMap hashMap) {
        Instruction instruction3 = instruction2.getChildInstruction(n2);
        if (instruction3 instanceof LetInstruction) {
            LetInstruction letInstruction = (LetInstruction)instruction3;
            hashMap.put(letInstruction.getVariable(), letInstruction);
            ForEachEvaluator.implantForEach(forEachInstruction, instruction3, 1, hashMap);
        } else if (instruction3 instanceof IdentifierInstruction) {
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction3;
            LetInstruction letInstruction = (LetInstruction)hashMap.get(identifierInstruction.getVariable());
            if (letInstruction != null) {
                instruction2.setChildInstruction(n2, letInstruction.getValue().cloneReduced());
                ForEachEvaluator.implantForEach(forEachInstruction, instruction2, n2, hashMap);
            } else {
                ForEachInstruction forEachInstruction2 = (ForEachInstruction)forEachInstruction.cloneWithNewNames();
                Object object2 = forEachInstruction2.getVarName();
                instruction2.setChildInstruction(n2, new LetInstruction(object2, identifierInstruction, forEachInstruction2.getBody()));
            }
        } else if (instruction3 instanceof ChooseInstruction) {
            ChooseInstruction chooseInstruction = (ChooseInstruction)instruction3;
            int n3 = chooseInstruction.m_cases.length;
            Instruction instruction4 = chooseInstruction.getDefaultHandler();
            int n4 = 1;
            if (instruction4 != null) {
                ++n4;
                ForEachEvaluator.implantForEach(forEachInstruction, chooseInstruction, 0, hashMap);
            }
            for (int i = 0; i < n3; ++i) {
                ForEachEvaluator.implantForEach(forEachInstruction, chooseInstruction, n4, hashMap);
                n4 += 2;
            }
        } else if (instruction3 instanceof MatchInstruction) {
            MatchInstruction matchInstruction = (MatchInstruction)instruction3;
            int n5 = matchInstruction.getMatches().length;
            Instruction instruction5 = matchInstruction.getDefault();
            int n6 = 1;
            if (instruction5 != null) {
                ++n6;
                ForEachEvaluator.implantForEach(forEachInstruction, matchInstruction, 0, hashMap);
            }
            for (int i = 0; i < n5; ++i) {
                ForEachEvaluator.implantForEach(forEachInstruction, matchInstruction, n6, hashMap);
                ++n6;
            }
        } else if (instruction3 instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction3;
            ForEachInstruction forEachInstruction3 = (ForEachInstruction)forEachInstruction.cloneWithNewNames();
            Integer n7 = ReductionHelper.generateIntermediateIdentifier2();
            forEachInstruction3.setSource(new IdentifierInstruction(n7));
            instruction2.setChildInstruction(n2, new LetInstruction(n7, streamInstruction, forEachInstruction3));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected static void unrollLoop(PartialInformationCollector partialInformationCollector, Instruction instruction2, String string2, StreamInstruction streamInstruction, LetInstruction letInstruction, LetChainManager letChainManager, ArrayList arrayList) {
        int n2 = streamInstruction.getChildInstructionCount();
        for (int i = 0; i < n2; ++i) {
            Instruction instruction3 = streamInstruction.getChildInstruction(i);
            if (partialInformationCollector.resolveType(instruction3) instanceof StreamType) {
                ForEachEvaluator.unrollLoop(partialInformationCollector, instruction2, string2, (StreamInstruction)letChainManager.lookupBinding(instruction3), letInstruction, letChainManager, arrayList);
                continue;
            }
            HashMap<String, IdentifierInstruction> hashMap = new HashMap<String, IdentifierInstruction>();
            IdentifierInstruction identifierInstruction = letChainManager.insertBody(instruction3.cloneWithNewNames(), letInstruction);
            hashMap.put(string2, identifierInstruction);
            Instruction instruction4 = instruction2.assignNewNames(hashMap);
            arrayList.add(letChainManager.insertBody(instruction4, letInstruction));
        }
    }

    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction instruction2, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        HashSet hashSet;
        ForEachInstruction forEachInstruction;
        block9: {
            TypeEnvironment typeEnvironment;
            Object object2;
            Instruction instruction3;
            block10: {
                forEachInstruction = (ForEachInstruction)instruction2;
                partialInformationCollector.partiallyEvaluate(forEachInstruction.getSource(), letChainManager);
                instruction3 = letChainManager.lookupBinding(forEachInstruction.getSource());
                if (forEachInstruction.getIndexVar() != null && !(object2 = forEachInstruction.getBody().accumulateFreeBindingsInOrder(partialInformationCollector.getCurrentBindingEnvironment())).contains(forEachInstruction.getIndexBinding())) {
                    forEachInstruction.setIndexVar(null);
                }
                object2 = partialInformationCollector.getCurrentBindingEnvironment();
                typeEnvironment = partialInformationCollector.getCurrentTypeEnvironment();
                if (!(instruction3 instanceof StreamInstruction) || instruction3.getChildInstructionCount() >= 10 || !(instruction3.getType(typeEnvironment, (BindingEnvironment)object2).resolveType(typeEnvironment) instanceof StreamType)) break block9;
                if (forEachInstruction.getIndexVar() == null) break block10;
                hashSet = new HashSet();
                forEachInstruction.getBody().accumulateFreeBindings(hashSet, (BindingEnvironment)object2);
                if (hashSet.contains(forEachInstruction.getIndexBinding())) break block9;
            }
            hashSet = (StreamInstruction)instruction3;
            ArrayList<IdentifierInstruction> arrayList = new ArrayList<IdentifierInstruction>();
            ArrayList arrayList2 = new ArrayList();
            ForEachEvaluator.accumulateStream(hashSet, arrayList2, partialInformationCollector, letChainManager);
            Type type2 = ((StreamType)forEachInstruction.getType(typeEnvironment, (BindingEnvironment)object2).resolveType(typeEnvironment)).getElementType();
            if (arrayList2.size() == 0) {
                return new PartialEvaluationResult(new StreamInstruction(type2));
            }
            for (Instruction instruction4 : arrayList2) {
                Instruction instruction5;
                if (instruction4.getType(typeEnvironment, (BindingEnvironment)object2).resolveType(typeEnvironment) instanceof StreamType) {
                    if (arrayList2.size() == 1) {
                        forEachInstruction.setSource(instruction4);
                        return new PartialEvaluationResult(null, true);
                    }
                    instruction5 = (ForEachInstruction)forEachInstruction.cloneWithNewNames();
                    ((ForEachInstruction)instruction5).setBody(((ForEachInstruction)instruction5).getBody().cloneReduced());
                    ((ForEachInstruction)instruction5).setSource(instruction4);
                    arrayList.add(letChainManager.insertBody(instruction5, letInstruction));
                    continue;
                }
                instruction5 = forEachInstruction.getBody();
                HashMap<Object, Instruction> hashMap = new HashMap<Object, Instruction>();
                hashMap.put(forEachInstruction.getVarName(), instruction4);
                arrayList.add(letChainManager.insertBody(instruction5.assignNewNames(hashMap), letInstruction));
            }
            return new PartialEvaluationResult((Instruction)new StreamInstruction(type2, arrayList), true);
        }
        if (((PartialEvaluationResult)((Object)(hashSet = partialInformationCollector.partiallyEvaluateBody(forEachInstruction.getBody(), forEachInstruction, 1, letChainManager)))).getReplacement() != null) {
            forEachInstruction.setBody(((PartialEvaluationResult)((Object)hashSet)).getReplacement());
        }
        return PartialEvaluationResult.s_emptyResult;
    }
}

