/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.HashMap;

public class ApplyEvaluator
extends PartialEvaluator {
    public static LambdaInstruction extractLambda(PartialInformationCollector partialInformationCollector, Instruction instruction2, LetChainManager letChainManager) {
        if (instruction2 == null) {
            return null;
        }
        if (instruction2 instanceof LambdaInstruction) {
            return (LambdaInstruction)instruction2;
        }
        if (instruction2 instanceof IdentifierInstruction) {
            return ApplyEvaluator.extractLambda(partialInformationCollector, letChainManager.lookupBinding(instruction2), letChainManager);
        }
        if (instruction2 instanceof FunctionCallInstruction) {
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
            if (0 != functionCallInstruction.m_parameters.length) {
                return null;
            }
            Function function2 = letChainManager.getCurrentFunction().getTypeEnvironment().getModule().getFunction(functionCallInstruction.getFunction());
            if (!(function2.getBody() instanceof LambdaInstruction)) {
                return null;
            }
            return (LambdaInstruction)function2.getBody();
        }
        return null;
    }

    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction instruction2, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        ApplyInstruction applyInstruction = (ApplyInstruction)instruction2;
        partialInformationCollector.partiallyEvaluate(applyInstruction.getLambda(), letChainManager);
        LambdaInstruction lambdaInstruction = ApplyEvaluator.extractLambda(partialInformationCollector, applyInstruction.getLambda(), letChainManager);
        if (lambdaInstruction == null) {
            return PartialEvaluationResult.s_emptyResult;
        }
        IBinding[] iBindingArray = lambdaInstruction.getChildInstructionBindings(0);
        Instruction instruction3 = lambdaInstruction.getBody();
        HashMap hashMap = PartialInformationCollector.setupDeconstructionBindingReplacement(applyInstruction.m_parameters, iBindingArray, instruction3, letChainManager, letInstruction);
        instruction3 = instruction3.assignNewNames(hashMap);
        IdentifierInstruction identifierInstruction = letChainManager.insertBody(instruction3, letInstruction);
        return new PartialEvaluationResult((Instruction)identifierInstruction, true);
    }
}

