/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.PostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetBaseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.CompoundType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.VirtualDataTypeMap;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VDTMapOptimizer
extends PostOrderOptimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(VDTMapOptimizer.class);
    private static final String s_className = VDTMapOptimizer.class.getName();
    private VirtualDataTypeMap m_vdtmap = null;
    private Set m_functionsToUpdate = new HashSet();
    List deltas = new ArrayList();
    Map m_map;

    private VDTMapOptimizer() {
    }

    public VDTMapOptimizer(VirtualDataTypeMap virtualDataTypeMap) {
        this.m_vdtmap = virtualDataTypeMap;
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction2) {
        if (instruction2 instanceof MatchInstruction) {
            Object object2;
            Object object3;
            Object object4;
            Object[] objectArray;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            MatchInstruction matchInstruction = (MatchInstruction)instruction2;
            MatchInstruction.Match match = matchInstruction.getMatches()[0];
            if (!(match instanceof MatchInstruction.DeconstructionMatch)) {
                return instruction2;
            }
            Instruction instruction3 = matchInstruction.getToMatch();
            AbstractDataType abstractDataType = ((MatchInstruction.DeconstructionMatch)match).getConstructor().getAbstractDataType();
            if (abstractDataType == null || !this.m_vdtmap.hasVDTMapping(abstractDataType.getName())) {
                return instruction2;
            }
            VirtualDataTypeMap.ADTMapping aDTMapping = this.m_vdtmap.getVDTMapping(abstractDataType.getName());
            MatchInstruction.Match[] matchArray = matchInstruction.getMatches();
            MatchInstruction.Match[] matchArray2 = new MatchInstruction.Match[matchArray.length];
            for (int i = 0; i < matchArray.length; ++i) {
                int n2;
                LetInstruction letInstruction;
                Object object9;
                if (matchArray[i] instanceof MatchInstruction.DeconstructionMatch) {
                    Instruction[] instructionArray;
                    Instruction instruction4;
                    object8 = (MatchInstruction.DeconstructionMatch)matchArray[i];
                    object7 = ((MatchInstruction.Match)object8).getHandler();
                    object6 = ((MatchInstruction.DeconstructionMatch)object8).getConstructor().getName();
                    object5 = ((MatchInstruction.DeconstructionMatch)object8).getConstructor().getParameterNames();
                    objectArray = ((MatchInstruction.DeconstructionMatch)object8).getBindings();
                    if (!aDTMapping.m_constructors.containsKey(object6)) {
                        throw new XylemError("ERR_SYSTEM", "VDTMap for type:" + abstractDataType.getName() + " doesn't specify mapping for constructor:" + (String)object6);
                    }
                    object4 = (VirtualDataTypeMap.ConstructorMapping)aDTMapping.m_constructors.get(object6);
                    object3 = new HashMap<Object, IdentifierInstruction>();
                    object2 = ReductionHelper.generateIntermediateIdentifier2();
                    ((HashMap)object3).put(((VirtualDataTypeMap.ConstructorMapping)object4).m_deconstructVariable.getName(), new IdentifierInstruction(object2));
                    Instruction instruction5 = instruction4 = ((VirtualDataTypeMap.ConstructorMapping)object4).m_deconstructCode.assignNewNames((Map)object3);
                    Instruction[] instructionArray2 = null;
                    while (instruction5 instanceof LetInstruction) {
                        instructionArray = (Instruction[])instruction5;
                        instruction5 = instructionArray.getBody();
                        instructionArray2 = instructionArray;
                    }
                    if (!(instruction5 instanceof TupleInstruction)) {
                        throw new XylemError("ERR_SYSTEM", "VDTMap match code should bottom out into a tuple instruction");
                    }
                    instructionArray = ((TupleInstruction)instruction5).getOperands();
                    if (((Object)object5).length != instructionArray.length) {
                        throw new XylemError("ERR_SYSTEM", "VDTMap for type:" + abstractDataType.getName() + " constructor:" + (String)object6 + " specifies " + ((Object)object5).length + " parameters, but the ADT map requires " + instructionArray.length);
                    }
                    object9 = object7;
                    for (int j = 0; j < instructionArray.length; ++j) {
                        LetInstruction letInstruction2 = new LetInstruction(((Binding)objectArray[j]).getName(), instructionArray[j], (Instruction)object9);
                        object9 = letInstruction2;
                    }
                    if (instructionArray2 != null) {
                        instructionArray2.setBody((Instruction)object9);
                        letInstruction = new LetInstruction(object2, instruction3, instruction4);
                    } else {
                        letInstruction = new LetInstruction(object2, instruction3, (Instruction)object9);
                    }
                    n2 = -1;
                    for (int j = 0; j < abstractDataType.m_constructors.length; ++j) {
                        if (!abstractDataType.m_constructors[j].getName().equals(object6)) continue;
                        n2 = j;
                        break;
                    }
                    if (n2 == -1) {
                        throw new XylemError("ERR_SYSTEM", "could not find variant " + (String)object6);
                    }
                } else {
                    throw new XylemError("ERR_SYSTEM", "VDTMap for type:" + abstractDataType.getName() + " must be a deconstruction match!");
                }
                object9 = letInstruction;
                matchArray2[i] = new MatchInstruction.LiteralMatch(LiteralInstruction.integerLiteral(n2), ((Instruction)object9).cloneWithNewNames());
            }
            HashMap<Object, Instruction> hashMap = new HashMap<Object, Instruction>();
            hashMap.put(aDTMapping.m_matchVariable.getName(), instruction3);
            object7 = object8 = aDTMapping.m_matchCode.assignNewNames(hashMap);
            object6 = null;
            while (object7 instanceof LetInstruction) {
                object5 = (LetInstruction)object7;
                object7 = ((LetBaseInstruction)object5).getBody();
                object6 = object5;
            }
            if (!(object7 instanceof TupleInstruction)) {
                throw new XylemError("ERR_SYSTEM", "VDTMap match instruction should bottom out into a tuple instruction");
            }
            int n3 = ((TupleInstruction)object7).getOperandCount();
            objectArray = ((TupleInstruction)object7).getOperands();
            if (n3 != 1) {
                throw new XylemError("ERR_SYSTEM", "VDTMap toMatch should have a single returned identifier. Buh?");
            }
            if (!(objectArray[0] instanceof IdentifierInstruction)) {
                throw new XylemError("ERR_SYSTEM", "VDTMap toMatch must be an identifier :" + objectArray[0] + ":");
            }
            object4 = (IdentifierInstruction)objectArray[0];
            object3 = new MatchInstruction((Instruction)object4, matchArray2, matchInstruction.getDefault(), matchInstruction.canAssumeComplete());
            ((LetBaseInstruction)object6).setBody((Instruction)object3);
            object2 = new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), (Instruction)object8, null);
            this.m_functionsToUpdate.add(this.m_currentFunction);
            return ((Instruction)object2).cloneWithNewNames();
        }
        if (instruction2 instanceof ConstructorInstantiationInstruction) {
            ConstructorInstantiationInstruction constructorInstantiationInstruction = (ConstructorInstantiationInstruction)instruction2;
            AbstractDataType abstractDataType = constructorInstantiationInstruction.getConstructor().getAbstractDataType();
            if (abstractDataType == null || !this.m_vdtmap.hasVDTMapping(abstractDataType.getName())) {
                return instruction2;
            }
            VirtualDataTypeMap.ADTMapping aDTMapping = this.m_vdtmap.getVDTMapping(abstractDataType.getName());
            if (!aDTMapping.m_constructors.containsKey(constructorInstantiationInstruction.getConstructorName())) {
                throw new XylemError("ERR_SYSTEM", "VDTMap for type:" + abstractDataType.getName() + " doesn't specify mapping for constructor:" + constructorInstantiationInstruction.getConstructorName());
            }
            VirtualDataTypeMap.ConstructorMapping constructorMapping = (VirtualDataTypeMap.ConstructorMapping)aDTMapping.m_constructors.get(constructorInstantiationInstruction.getConstructorName());
            Binding[] bindingArray = constructorMapping.m_constructParameters;
            Instruction[] instructionArray = constructorInstantiationInstruction.getOperands();
            if (bindingArray.length != instructionArray.length) {
                throw new XylemError("ERR_SYSTEM", "VDTMap for type:" + abstractDataType.getName() + " constructor:" + constructorInstantiationInstruction.getConstructorName() + " specifies " + bindingArray.length + " parameters, but the ADT map requires " + instructionArray.length);
            }
            Instruction instruction6 = constructorMapping.m_constructCode;
            for (int i = 0; i < bindingArray.length; ++i) {
                LetInstruction letInstruction = new LetInstruction(bindingArray[i].getName(), instructionArray[i], instruction6);
                instruction6 = letInstruction;
            }
            ChooseInstruction chooseInstruction = new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), instruction6, null);
            instruction6 = chooseInstruction;
            this.m_functionsToUpdate.add(this.m_currentFunction);
            return instruction6.cloneWithNewNames();
        }
        int n4 = instruction2.getTypeParameterCount();
        for (int i = 0; i < n4; ++i) {
            if (instruction2.getTypeParameter(i) == null) {
                System.out.println("Instruction " + instruction2 + " parameter " + i + " (" + instruction2.getChildInstruction(i) + ") is null");
                throw new RuntimeException();
            }
            instruction2.setTypeParameter(i, this.convertType(instruction2.getTypeParameter(i)));
        }
        return instruction2;
    }

    public void doUpdate(Module module) {
        Object object2;
        Object object322;
        Object object4;
        Iterator iterator = this.m_vdtmap.vdtMappingNames().iterator();
        this.m_map = new HashMap();
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            CompoundType compoundType = module.lookupCompoundType((String)object4);
            if (compoundType == null) continue;
            object322 = compoundType.getNamedType();
            this.m_map.put(object322, this.m_vdtmap.getTargetType((String)object4));
        }
        module.optimize(this);
        object4 = module.m_signature;
        if (this.m_functionsToUpdate.isEmpty() && this.deltas.isEmpty()) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "doUpdate", "Skipping update for module :" + module.getName() + ":");
            }
            return;
        }
        for (Object object322 : this.deltas) {
            if (((Delta)object322).enclosingFunction != null) {
                ((Delta)object322).enclosingFunction.setBody(((Delta)object322).replacement.cloneWithNewNames());
                continue;
            }
            ((Delta)object322).parent.setChildInstruction(((Delta)object322).index, ((Delta)object322).replacement.cloneWithNewNames());
        }
        this.deltas.clear();
        for (Object object322 : this.m_functionsToUpdate) {
            object2 = ((Function)object322).getParameters();
            Type serializable = ((Function)object322).getReturnType();
            iterator = this.m_vdtmap.vdtMappingNames().iterator();
            TypeEnvironment typeEnvironment = ((Function)object322).getTypeEnvironment();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                CompoundType compoundType = ((Function)object322).getTypeEnvironment().getModule().lookupCompoundType(string2);
                Type type2 = compoundType.getNamedType().resolveType(typeEnvironment);
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    Type type3 = ((Binding)object2[i]).getBindingType().resolveType(typeEnvironment);
                    if (type3 == null || !type3.refersToType(type2, typeEnvironment.getModule())) continue;
                    HashMap<Type, Type> hashMap = new HashMap<Type, Type>();
                    hashMap.put(type2, this.m_vdtmap.getTargetType(string2));
                    ((Binding)object2[i]).setType(((Binding)object2[i]).getBindingType().resolveType(typeEnvironment).replaceType(hashMap));
                }
            }
        }
        object322 = this.m_vdtmap.getTypeMap();
        object2 = new Optimizer((HashMap)object322){
            final /* synthetic */ HashMap val$typeMap;
            {
                this.val$typeMap = hashMap;
            }

            @Override
            protected Instruction optimizeStep(Instruction instruction2) {
                for (int i = 0; i < instruction2.getTypeParameterCount(); ++i) {
                    Type type2 = instruction2.getTypeParameter(i).resolveType(this.m_currentFunction.getTypeEnvironment());
                    instruction2.setTypeParameter(i, type2.replaceType(this.val$typeMap));
                }
                return instruction2;
            }
        };
        for (Function function2 : module.getFunctions()) {
            ((Optimizer)object2).optimizeFunction(function2);
        }
        this.convertADTs(module);
        this.convertADTs((ITypeStore)object4);
        this.convertFunctionSignatures(module);
        for (Function function3 : this.m_functionsToUpdate) {
            if (((ModuleSignature)object4).getFunctionSignature(function3.getName()) != null) {
                ((ModuleSignature)object4).addFunctionSignature(new FunctionSignature(function3));
            }
            function3.clearReducedTypeInformation();
            try {
                function3.typeCheckReduced(module, new LinkedList());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new Error(throwable.getMessage());
            }
        }
        this.m_functionsToUpdate.clear();
    }

    @Override
    public void optimizeFunction(Function function2) {
        Binding[] bindingArray = function2.getParameters();
        Type type2 = function2.getReturnType();
        Iterator iterator = this.m_vdtmap.vdtMappingNames().iterator();
        TypeEnvironment typeEnvironment = function2.getTypeEnvironment();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            CompoundType compoundType = function2.getTypeEnvironment().getModule().lookupCompoundType(string2);
            Type type3 = compoundType != null ? compoundType.getNamedType() : function2.getTypeEnvironment().getModule().lookupTypeAlias(string2);
            if (type3 == null) continue;
            type3 = type3.resolveType(typeEnvironment);
            if (type2 != null && type2.resolveType(typeEnvironment).refersToType(type3, typeEnvironment.getModule())) {
                this.m_functionsToUpdate.add(function2);
            }
            for (int i = 0; i < bindingArray.length; ++i) {
                Type type4 = bindingArray[i].getBindingType().resolveType(typeEnvironment);
                if (type4 == null || !type4.refersToType(type3, typeEnvironment.getModule())) continue;
                this.m_functionsToUpdate.add(function2);
            }
        }
        super.optimizeFunction(function2);
    }

    protected void convertADTs(ITypeStore iTypeStore) {
        boolean bl;
        HashSet<AbstractDataType> hashSet = new HashSet<AbstractDataType>();
        do {
            Iterator iterator = iTypeStore.getAbstractDataTypesIterator();
            bl = false;
            while (iterator.hasNext()) {
                AbstractDataType abstractDataType = (AbstractDataType)iterator.next();
                if (hashSet.contains(abstractDataType)) continue;
                for (int i = 0; i < abstractDataType.m_constructors.length; ++i) {
                    AbstractDataType.Constructor constructor = abstractDataType.m_constructors[i];
                    for (int j = 0; j < constructor.m_parameters.length; ++j) {
                        Binding binding = constructor.m_parameters[j];
                        binding.setType(this.convertType(binding.getBindingType()));
                    }
                }
                hashSet.add(abstractDataType);
                bl = true;
            }
        } while (bl);
    }

    protected void convertFunctionSignatures(Module module) {
        Iterator<Function> iterator = module.getFunctions().iterator();
        while (iterator.hasNext()) {
            Function function2;
            this.m_currentFunction = function2 = iterator.next();
            for (int i = 0; i < function2.m_parameters.length; ++i) {
                Binding binding = function2.m_parameters[i];
                binding.setType(this.convertType(binding.getBindingType()));
            }
            function2.setReturnType(this.convertType(function2.getReturnType()));
            FunctionSignature functionSignature = module.getFunctionSignature(this.m_currentFunction.getName());
            if (functionSignature != null) {
                functionSignature.setReturnType(function2.getReturnType());
            }
            this.m_currentFunction = null;
        }
    }

    public Type convertType(Type type2) {
        if (type2 == null) {
            throw new RuntimeException();
        }
        if (this.getCurrentFunction() != null) {
            type2 = type2.resolveType(this.getCurrentFunction().getTypeEnvironment());
        }
        if (type2 instanceof NamedType) {
            NamedType namedType = (NamedType)type2;
            Type type3 = this.m_map == null ? null : this.m_map.get(namedType);
            if (type3 != null) {
                return type3;
            }
            return namedType;
        }
        int n2 = type2.getChildTypeCount();
        for (int i = 0; i < n2; ++i) {
            type2.setChildType(i, this.convertType(type2.getChildType(i)));
        }
        return type2;
    }

    private class Delta {
        Instruction parent;
        int index;
        Instruction replacement;
        TypeEnvironment tenv;
        BindingEnvironment benv;
        Function enclosingFunction;

        public Delta(Instruction instruction2, int n2, Instruction instruction3, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, Function function2) {
            this.parent = instruction2;
            this.index = n2;
            this.replacement = instruction3;
            this.tenv = typeEnvironment;
            this.benv = bindingEnvironment;
            this.enclosingFunction = function2;
        }
    }
}

