/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.DataDependencyDrivenOptimizer;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ParallelForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ProcessStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.optimizers.ParallelForEachOptimizer;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TupleOptimizer
extends Optimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(TupleOptimizer.class);
    private static final String s_className = TupleOptimizer.class.getName();
    private HashMap m_tupleUseInfo = new HashMap();
    private int m_reductions = 0;
    private int m_totalCTors = 0;
    private int m_removedCTors = 0;
    private int m_totalMatches = 0;
    private int m_removedMatches = 0;
    private int m_totalPFEIs = 0;
    private int m_reducedPFEIs = 0;

    public void optimize(Module module) {
        try {
            InformationCollector informationCollector = new InformationCollector(module);
            TupleReducer tupleReducer = new TupleReducer();
            TupleRemover tupleRemover = new TupleRemover();
            ParallelForEachOptimizer parallelForEachOptimizer = new ParallelForEachOptimizer();
            do {
                DeadLetEliminatorOptimizer.eliminateDeadLets(module);
                module.optimize(parallelForEachOptimizer);
                this.m_reductions = 0;
                this.m_tupleUseInfo.clear();
                module.optimize(informationCollector);
                module.optimize(tupleReducer);
                module.clearTypeInformation(true);
                module.typeCheck();
                if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
                s_logger.logp(Level.FINER, s_className, "optimize", "Removed " + this.m_reductions + " tuple or tuple-match arguments.");
            } while (this.m_reductions > 0);
            module.optimize(tupleRemover);
            module.clearTypeInformation(true);
            module.typeCheck();
            module.reduce();
            module.typeCheck();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "optimize", "Removed " + this.m_removedCTors + "/" + this.m_totalCTors + " tuple instructions.\n" + "Removed " + this.m_removedMatches + "/" + this.m_totalMatches + " tuple-match instructions.\n" + "Simplified " + this.m_reducedPFEIs + "/" + this.m_totalPFEIs + " parallel-foreach instructions.");
            }
        }
        catch (Throwable throwable) {
            FFDCUtil.log(throwable, this);
            String string2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{""});
            s_logger.logp(Level.SEVERE, s_className, "optimize", string2, throwable);
            throw new XylemError(string2);
        }
    }

    private static String getInstanceKey(Type type2) {
        return "tuple" + System.identityHashCode(type2);
    }

    private TupleUseInfo registerTuple(TupleType tupleType) {
        TupleUseInfo tupleUseInfo;
        String string2 = TupleOptimizer.getInstanceKey(tupleType);
        Object v = this.m_tupleUseInfo.get(string2);
        if (v == null) {
            tupleUseInfo = new TupleUseInfo(tupleType);
            this.m_tupleUseInfo.put(string2, tupleUseInfo);
        } else {
            while (v instanceof String) {
                v = this.m_tupleUseInfo.get(v);
            }
            tupleUseInfo = (TupleUseInfo)v;
        }
        return tupleUseInfo;
    }

    private void registerTuple(TupleType tupleType, TupleUseInfo tupleUseInfo) {
        String string2 = TupleOptimizer.getInstanceKey(tupleType);
    }

    private TupleUseInfo getInfo(Instruction instruction2, TypeEnvironment typeEnvironment) {
        Type type2 = instruction2.getCachedType();
        String string2 = TupleOptimizer.getInstanceKey(type2);
        Object v = this.m_tupleUseInfo.get(string2);
        while (v instanceof String) {
            v = this.m_tupleUseInfo.get(v);
        }
        TupleUseInfo tupleUseInfo = (TupleUseInfo)v;
        if (tupleUseInfo == null && type2 instanceof TupleType && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "getInfo", "missing entry for tuple " + string2 + " at " + instruction2);
        }
        return tupleUseInfo;
    }

    private static class TupleUseInfo {
        private TupleType m_type;
        private boolean[] m_used;
        private String m_name;

        private TupleUseInfo(TupleType tupleType) {
            this.m_type = tupleType;
            this.m_used = new boolean[tupleType.getChildTypeCount()];
            this.m_name = TupleOptimizer.getInstanceKey(tupleType);
        }

        private void mergeInfo(TupleUseInfo tupleUseInfo) {
            for (int i = 0; i < tupleUseInfo.m_used.length; ++i) {
                if (!tupleUseInfo.m_used[i]) continue;
                this.setUsed(i);
            }
        }

        private void setUsed(int n2) {
            this.m_used[n2] = true;
        }

        private void setAllUsed() {
            for (int i = 0; i < this.m_used.length; ++i) {
                this.m_used[i] = true;
            }
        }

        private String getName() {
            return this.m_name;
        }

        public String toString() {
            return this.getName();
        }

        private boolean isFullyUsed() {
            for (int i = 0; i < this.m_used.length; ++i) {
                if (this.m_used[i]) continue;
                return false;
            }
            return true;
        }
    }

    private class TupleRemover
    extends Optimizer {
        private TupleRemover() {
        }

        @Override
        protected Instruction optimizeStep(Instruction instruction2) {
            TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
            if (instruction2 instanceof TupleInstruction) {
                TupleOptimizer.this.m_totalCTors++;
                TupleInstruction tupleInstruction = (TupleInstruction)instruction2;
                if (tupleInstruction.getChildInstructionCount() == 1) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                        s_logger.logp(Level.FINEST, s_className, "optimizeStep", "removed " + tupleInstruction);
                    }
                    TupleOptimizer.this.m_removedCTors++;
                    Instruction instruction3 = tupleInstruction.getChildInstruction(0);
                    this.optimizeChildren(instruction3);
                    return instruction3;
                }
            } else if (instruction2 instanceof TupleMatchInstruction) {
                TupleOptimizer.this.m_totalMatches++;
                TupleMatchInstruction tupleMatchInstruction = (TupleMatchInstruction)instruction2;
                if (tupleMatchInstruction.getVariableNames().length == 1) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                        s_logger.logp(Level.FINEST, s_className, "optimizeStep", "removed " + tupleMatchInstruction);
                    }
                    TupleOptimizer.this.m_removedMatches++;
                    LetInstruction letInstruction = new LetInstruction(tupleMatchInstruction.getVariableNames()[0], tupleMatchInstruction.getToMatch(), tupleMatchInstruction.getBody());
                    this.optimizeChildren(letInstruction);
                    return letInstruction;
                }
            } else if (instruction2 instanceof ParallelForEachInstruction) {
                TupleType tupleType;
                TupleOptimizer.this.m_totalPFEIs++;
                ParallelForEachInstruction parallelForEachInstruction = (ParallelForEachInstruction)instruction2;
                Type type2 = parallelForEachInstruction.getCachedType();
                if (type2 instanceof TupleType && (tupleType = (TupleType)type2).getChildTypeCount() == 1) {
                    Instruction instruction4;
                    Instruction instruction5;
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                        s_logger.logp(Level.FINEST, s_className, "optimizeStep", "removed " + parallelForEachInstruction);
                    }
                    TupleOptimizer.this.m_reducedPFEIs++;
                    Object object2 = parallelForEachInstruction.getIndexVar();
                    Instruction instruction6 = parallelForEachInstruction.getBody();
                    if (parallelForEachInstruction.getElementVars().length > 1) {
                        if (object2 == null) {
                            object2 = OptimizerUtilities.generateIntermediateIdentifier("index");
                        }
                        for (int i = 1; i < parallelForEachInstruction.getElementVars().length; ++i) {
                            instruction5 = new IdentifierInstruction(object2);
                            instruction4 = new StreamElementInstruction(parallelForEachInstruction.getSources()[i], instruction5);
                            instruction6 = new LetInstruction(parallelForEachInstruction.getElementVars()[i], instruction4, instruction6);
                        }
                    }
                    Object object3 = parallelForEachInstruction.getElementVars()[0];
                    instruction5 = parallelForEachInstruction.getSources()[0];
                    instruction4 = new ForEachInstruction(instruction5, object3, object2, instruction6);
                    this.optimizeChildren(instruction4);
                    return instruction4;
                }
            }
            return instruction2;
        }
    }

    private class InformationCollector
    extends DataDependencyDrivenOptimizer {
        private Module m_module;
        private HashMap m_tupleCopyMap = new HashMap();

        private InformationCollector(Module module) {
            this.m_module = module;
        }

        @Override
        public void optimizeFunction(Function function2) {
            this.clearTupleCopyMap();
            if (function2.getReturnType() instanceof TupleType && this.m_module.getPublicFunction(function2.getName()) != null) {
                TupleType tupleType = (TupleType)function2.getReturnType();
                TupleOptimizer.this.registerTuple(tupleType).setAllUsed();
            }
            super.optimizeFunction(function2);
        }

        @Override
        protected Instruction optimizeStep(Instruction instruction2) {
            TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
            BindingEnvironment bindingEnvironment = this.getCurrentFunction().getBindingEnvironment();
            this.clearTupleCopyMap();
            if (instruction2 instanceof TupleMatchInstruction) {
                TupleMatchInstruction tupleMatchInstruction = (TupleMatchInstruction)instruction2;
                Binding[] bindingArray = tupleMatchInstruction.getBindings();
                TupleType tupleType = (TupleType)tupleMatchInstruction.getToMatch().getType(typeEnvironment, bindingEnvironment);
                for (int i = 0; i < bindingArray.length; ++i) {
                    Binding binding = bindingArray[i];
                    if (binding == null) {
                        throw new XylemError("ERR_SYSTEM", "tuple match binding (" + i + ") " + "has null binding (or no dependancy info) " + tupleMatchInstruction);
                    }
                    if (!this.isBindingUsed(bindingArray[i])) continue;
                    TupleOptimizer.this.registerTuple(tupleType).setUsed(i);
                }
            } else {
                Instruction instruction3;
                if (instruction2 instanceof ProcessStreamInstruction) {
                    instruction3 = (ProcessStreamInstruction)instruction2;
                    TupleUseInfo tupleUseInfo = TupleOptimizer.this.registerTuple((TupleType)instruction3.getChildInstruction(2).getType(typeEnvironment, bindingEnvironment));
                    tupleUseInfo.setAllUsed();
                }
                if (instruction2.getCachedType() instanceof TupleType) {
                    this.registerTupleInstruction(instruction2, typeEnvironment);
                    if (instruction2 instanceof IdentifierInstruction) {
                        instruction3 = NavigationUtilities.resolveReducedIdentifier(instruction2, bindingEnvironment);
                        this.registerTupleInstruction(instruction3, typeEnvironment);
                    }
                }
                for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
                    if (!(instruction2.getChildInstruction(i).getCachedType() instanceof TupleType)) continue;
                    this.registerTupleInstruction(instruction2.getChildInstruction(i), typeEnvironment);
                }
            }
            return instruction2;
        }

        private void clearTupleCopyMap() {
            this.m_tupleCopyMap.clear();
        }

        private void registerTupleInstruction(Instruction instruction2, TypeEnvironment typeEnvironment) {
            TupleType tupleType = (TupleType)instruction2.getCachedType();
            String string2 = TupleOptimizer.getInstanceKey(tupleType);
            String string3 = this.getTypeKey(instruction2, typeEnvironment);
            TupleUseInfo tupleUseInfo = TupleOptimizer.this.registerTuple(tupleType);
            TupleUseInfo tupleUseInfo2 = (TupleUseInfo)this.m_tupleCopyMap.get(string3);
            if (tupleUseInfo2 != null && tupleUseInfo2 != tupleUseInfo) {
                tupleUseInfo2.mergeInfo(tupleUseInfo);
                TupleOptimizer.this.m_tupleUseInfo.put(string2, tupleUseInfo2.getName());
            } else {
                this.m_tupleCopyMap.put(string3, tupleUseInfo);
            }
        }

        private String getTypeKey(Instruction instruction2, TypeEnvironment typeEnvironment) {
            TupleType tupleType = (TupleType)instruction2.getCachedType();
            StringBuffer stringBuffer = new StringBuffer("tuple");
            for (int i = 0; i < tupleType.getChildTypeCount(); ++i) {
                stringBuffer.append("_");
                Type type2 = tupleType.getChildType(i).resolveType(this.m_currentFunction.getTypeEnvironment());
                if (type2 instanceof TypeVariable) {
                    throw new Error("!");
                }
                stringBuffer.append(type2);
            }
            return stringBuffer.toString();
        }
    }

    private class TupleReducer
    extends Optimizer {
        private TupleReducer() {
        }

        @Override
        protected Instruction optimizeStep(Instruction instruction2) {
            TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
            if (instruction2 instanceof TupleInstruction) {
                TupleUseInfo tupleUseInfo = TupleOptimizer.this.getInfo(instruction2, typeEnvironment);
                if (tupleUseInfo == null || tupleUseInfo.isFullyUsed()) {
                    return instruction2;
                }
                TupleInstruction tupleInstruction = (TupleInstruction)instruction2;
                ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
                for (int i = 0; i < tupleInstruction.getChildInstructionCount(); ++i) {
                    if (!tupleUseInfo.m_used[i]) continue;
                    arrayList.add(tupleInstruction.getChildInstruction(i).cloneWithoutTypeInformation());
                }
                TupleInstruction tupleInstruction2 = new TupleInstruction(arrayList.toArray(new Instruction[0]));
                this.optimizeChildren(tupleInstruction2);
                String string2 = tupleUseInfo.getName();
                TupleOptimizer.this.m_reductions += tupleInstruction.getChildInstructionCount() - ((Instruction)tupleInstruction2).getChildInstructionCount();
                return tupleInstruction2;
            }
            if (instruction2 instanceof TupleMatchInstruction) {
                TupleMatchInstruction tupleMatchInstruction = (TupleMatchInstruction)instruction2;
                Instruction instruction3 = tupleMatchInstruction.getToMatch();
                TupleUseInfo tupleUseInfo = TupleOptimizer.this.getInfo(instruction3, typeEnvironment);
                if (tupleUseInfo == null || tupleUseInfo.isFullyUsed()) {
                    return instruction2;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < tupleMatchInstruction.getVariableNames().length; ++i) {
                    if (!tupleUseInfo.m_used[i]) continue;
                    arrayList.add(tupleMatchInstruction.getVariableNames()[i]);
                }
                TupleMatchInstruction tupleMatchInstruction2 = new TupleMatchInstruction(instruction3.cloneWithoutTypeInformation(), arrayList.toArray(), tupleMatchInstruction.getBody());
                this.optimizeChildren(tupleMatchInstruction2);
                String string3 = tupleUseInfo.getName();
                TupleOptimizer.this.m_reductions += tupleMatchInstruction.getVariableNames().length - arrayList.size();
                return tupleMatchInstruction2;
            }
            return instruction2;
        }
    }
}

