/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.PedanticAnormalForm;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.BeginInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.FindFreeVariables;
import com.ibm.xltxe.rnm1.xylem.optimizers.LetChainClusterizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.optimizers.OrderLetChains;
import com.ibm.xltxe.rnm1.xylem.optimizers.ReducedForm;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SplitFunctions
extends FindFreeVariables {
    private static final Logger s_logger = LoggerUtil.getLogger(SplitFunctions.class);
    private static final String s_className = SplitFunctions.class.getName();
    private Candidate m_best = new Candidate();
    private int m_total;
    private InformationCollector m_info = new InformationCollector();
    private Module m_program;
    private int m_splitSize;
    private boolean m_orderSafeSplit = false;
    public static final int DEFAULT_SPLIT_SIZE = 7500;
    public static final int MAX_PARAMS = 200;
    private static final boolean FORBID_PSES = false;
    private PedanticAnormalForm m_pedantic = new PedanticAnormalForm();
    private int s_suspiciouslyBadCandidates = 0;

    public SplitFunctions(Module module, boolean bl) {
        this(module, 7500);
        this.m_orderSafeSplit = bl;
    }

    public SplitFunctions(Module module, int n2) {
        this.m_program = module;
        this.m_splitSize = n2;
    }

    public void splitOnce(Function function2) {
        this.prepareFunction(function2);
        this.collectInfo(function2);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "splitOnce", "forcing split of " + function2.getName() + " at " + this.m_total);
        }
        this.findCandidate(function2);
        if (this.m_best.score < 5.0) {
            String string2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Failed to find a split candidate for " + function2.getName() + "; best was score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total});
            s_logger.logp(Level.SEVERE, s_className, "splitOnce", string2);
            Program.dumpXylemFunctions(new Function[]{function2}, null, "badsplit");
            throw new XylemError(string2);
        }
        if (this.m_best.score < 30.0 && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "splitOnce", "suspiciously bad split candidate for " + function2.getName() + " score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total);
        }
        this.split(function2);
        SplitFunctions.cleanUp(function2);
    }

    @Override
    public void optimizeFunction(Function function2) {
        this.prepareFunction(function2);
        while (true) {
            this.collectInfo(function2);
            this.findCandidate(function2);
            if (this.m_total < this.m_splitSize) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINE, s_className, "optimizeFunction", "function " + function2.getName() + " OK at " + this.m_total);
                }
                SplitFunctions.cleanUp(function2);
                return;
            }
            if (this.m_best.score < 5.0) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "optimizeFunction", "no split candidate for " + function2.getName() + " best was score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total);
                }
                SplitFunctions.cleanUp(function2);
                return;
            }
            if (this.m_best.score < 30.0 && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "optimizeFunction", "suspiciously bad split candidate for " + function2.getName() + " score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total);
            }
            this.split(function2);
        }
    }

    private void prepareFunction(Function function2) {
        new PreSplitter().optimizeFunction(function2);
        this.m_pedantic.optimizeFunction(function2);
        if (this.m_orderSafeSplit) {
            new OrderLetChains().orderFunction(function2);
        } else {
            new LetChainClusterizer().optimizeFunction(function2);
        }
    }

    private static void cleanUp(Function function2) {
    }

    private void collectInfo(Function function2) {
        this.m_best.clear();
        this.m_total = this.m_info.collectInfo(function2);
    }

    private void findCandidate(Function function2) {
        super.optimizeFunction(function2);
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction2, Instruction instruction3, int n2) {
        boolean bl;
        Object object2;
        int n3;
        double d;
        this.addVars(instruction2, instruction3, n2);
        if (instruction3 instanceof LetInstruction && this.isSplitCandidate(instruction3, instruction2, this.getCurrentFunction(), this.getFreeVars()) && this.m_best.compare(d = this.score(instruction2, n3 = this.m_info.getSizeInfo(object2 = ((LetInstruction)instruction3).getVariable(), bl = n2 == 0), this.m_total, this.getFreeVars()))) {
            this.m_best.set(instruction2, (LetInstruction)instruction3, n2, this.getFreeVars(), bl, d, n3);
        }
        this.removeVars(instruction2, instruction3, n2);
        return instruction2;
    }

    protected double score(Instruction instruction2, int n2, int n3, Set set2) {
        double d = 1.0 * (double)n2 / (double)(++n3);
        double d2 = (double)set2.size() / 200.0;
        return (4.0 * d - 4.0 * d * d - d2 * d2) * 100.0;
    }

    protected int size(Instruction instruction2, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (instruction2 instanceof LiteralInstruction || instruction2 instanceof IdentifierInstruction || instruction2 instanceof StreamInstruction && ((StreamInstruction)instruction2).isString()) {
            return -1;
        }
        if (instruction2 instanceof StreamInstruction) {
            int n2 = 4;
            for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
                Instruction instruction3 = instruction2.getChildInstruction(i);
                if (instruction3 instanceof LiteralInstruction) {
                    ++n2;
                }
                if (instruction3.getType(typeEnvironment, bindingEnvironment) instanceof StreamType) {
                    n2 += 4;
                    continue;
                }
                n2 += 2;
            }
            return -n2;
        }
        if (instruction2 instanceof ConstructorInstantiationInstruction) {
            return -(4 + 4 * instruction2.getChildInstructionCount());
        }
        int n3 = 2;
        if (instruction2 instanceof LambdaInstruction) {
            n3 += 2 * SplitFunctions.findFreeVariables(instruction2).size();
        }
        if (instruction2 instanceof MatchInstruction || instruction2 instanceof ChooseInstruction) {
            n3 += 4;
        }
        if (instruction2 instanceof MatchInstruction) {
            n3 += 2 * ((MatchInstruction)instruction2).getMatches().length;
        }
        if (instruction2 instanceof ISpecialForm) {
            ISpecialForm iSpecialForm = (ISpecialForm)((Object)instruction2);
            for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
                IBinding[] iBindingArray = iSpecialForm.getChildInstructionBindings(i);
                if (iBindingArray == null) continue;
                n3 += 2 * iBindingArray.length;
            }
        }
        return n3;
    }

    protected boolean isSplitCandidate(Instruction instruction2, Instruction instruction3, Function function2, Set set2) {
        if (instruction3 instanceof FunctionCallInstruction) {
            return false;
        }
        if (instruction3 instanceof LetInstruction && ((LetInstruction)instruction3).getBody() instanceof IdentifierInstruction && ((LetInstruction)instruction3).getValue() instanceof FunctionCallInstruction) {
            return false;
        }
        for (Object e : set2) {
            Type type2 = new IdentifierInstruction(e).getType(function2.getTypeEnvironment(), function2.getBindingEnvironment());
            if (!((type2 = StreamType.makeAtomicType(type2)) instanceof NamedType)) continue;
            AbstractDataType abstractDataType = ((NamedType)type2).resolveNameToADT(function2.getTypeEnvironment());
        }
        return true;
    }

    private void split(Function function2) {
        if (this.m_best.n == null) {
            throw new XylemError("ERR_SYSTEM", "corrupt!");
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "split", "splitting " + (this.m_best.isValue ? "value" : "body") + " score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total + "\n   " + function2.getName());
        }
        if (this.m_orderSafeSplit) {
            ArrayList arrayList = OrderLetChains.OrderedFreeVariables.findFreeVariables(this.m_best.n);
            SplitFunctions.split(this.m_best.n, arrayList, this.m_best.parent, this.m_best.parentIndex, function2, this.m_program);
        } else {
            SplitFunctions.split(this.m_best.n, this.m_best.freeVars, this.m_best.parent, this.m_best.parentIndex, function2, this.m_program);
        }
    }

    private static void split(Instruction instruction2, Collection collection2, Instruction instruction3, int n2, Function function2, Module module) {
        Object object2;
        Object object3;
        Object object4;
        ReducedForm.Check.check(function2);
        Object[] objectArray = collection2.toArray();
        ArrayList<IdentifierInstruction> arrayList = new ArrayList<IdentifierInstruction>(objectArray.length);
        ArrayList<Binding> arrayList2 = new ArrayList<Binding>(objectArray.length);
        HashMap hashMap = new HashMap();
        INewNameGenerator iNewNameGenerator = new INewNameGenerator(){
            private int m_count;

            @Override
            public Object getNewName() {
                return new Integer(this.m_count++);
            }
        };
        HashMap<Object, IdentifierInstruction> hashMap2 = new HashMap<Object, IdentifierInstruction>();
        Type type2 = instruction2.getType(function2.getTypeEnvironment(), function2.getBindingEnvironment());
        for (int i = 0; i < objectArray.length; ++i) {
            object4 = iNewNameGenerator.getNewName();
            hashMap2.put(objectArray[i], new IdentifierInstruction(object4));
            object3 = new IdentifierInstruction(objectArray[i]);
            arrayList.add((IdentifierInstruction)object3);
            Type type3 = ((Instruction)object3).getType(function2.getTypeEnvironment(), function2.getBindingEnvironment());
            object2 = StreamType.makeAtomicType(type3);
            if (type3 == null) {
                throw new XylemError("ERR_SYSTEM", "?" + objectArray[i]);
            }
            arrayList2.add(new Binding(object4, type3));
        }
        String string2 = function2.getName() + "$split$" + ReductionHelper.generateIntermediateIdentifier2();
        object4 = new FunctionCallInstruction(string2, arrayList);
        instruction2 = instruction2.cloneWithoutTypeInformation().assignNewNames(hashMap2, iNewNameGenerator);
        object3 = new Function(string2, arrayList2.toArray(new Binding[0]), instruction2);
        module.addFunction((Function)object3);
        SplitFunctions.cleanUp((Function)object3);
        instruction3.setChildInstruction(n2, (Instruction)object4);
        try {
            ((Function)object3).typeCheckReduced(module, new LinkedList());
        }
        catch (Exception exception) {
            FFDCUtil.log(exception, SplitFunctions.class);
            object2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"TCE in new function " + object3});
            s_logger.logp(Level.SEVERE, s_className, "split", (String)object2, exception);
            throw new RuntimeException((String)object2);
        }
        try {
            function2.typeCheckReduced(module, new LinkedList());
        }
        catch (Exception exception) {
            FFDCUtil.log(exception, SplitFunctions.class);
            object2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"TCE in modified enclosing function " + function2});
            s_logger.logp(Level.SEVERE, s_className, "split", (String)object2, exception);
            throw new RuntimeException((String)object2);
        }
        ReducedForm.Check.check(function2);
        ReducedForm.Check.check((Function)object3);
    }

    private static class PreSplitter
    extends Optimizer {
        final int CHUNK = 500;

        private PreSplitter() {
        }

        Instruction preSplitBegin(Instruction instruction2, Instruction instruction3, int n2) {
            if (instruction2.getChildInstructionCount() > 500) {
                LinkedList<Instruction> linkedList = new LinkedList<Instruction>(Arrays.asList(((BeginInstruction)instruction2).getOperands()));
                Instruction instruction4 = linkedList.removeLast();
                while (!linkedList.isEmpty()) {
                    int n3 = linkedList.size() - 500;
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    List list = linkedList.subList(n3, linkedList.size());
                    ArrayList<Instruction> arrayList = new ArrayList<Instruction>(list);
                    arrayList.add(instruction4);
                    instruction4 = new BeginInstruction(arrayList.toArray(new Instruction[0]));
                    list.clear();
                }
                instruction4.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
                return instruction4;
            }
            return instruction2;
        }

        Instruction preSplitMatch(Instruction instruction2, Instruction instruction3, int n2) {
            if (instruction2.getChildInstructionCount() > 1000) {
                MatchInstruction matchInstruction = (MatchInstruction)instruction2;
                Instruction instruction4 = ((MatchInstruction)instruction2).getDefault();
                ArrayList<MatchInstruction.Match> arrayList = new ArrayList<MatchInstruction.Match>(Arrays.asList(((MatchInstruction)instruction2).getMatches()));
                while (!arrayList.isEmpty()) {
                    int n3 = arrayList.size() - 500;
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    List list = arrayList.subList(n3, arrayList.size());
                    instruction4 = new MatchInstruction(matchInstruction.getToMatch(), list, instruction4);
                    list.clear();
                }
                instruction4.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
                return instruction4;
            }
            return instruction2;
        }

        Instruction preSplitLetStream(Instruction instruction2, Instruction instruction3, int n2) {
            StreamInstruction streamInstruction = (StreamInstruction)((LetInstruction)instruction2).getValue();
            if (streamInstruction instanceof StreamInstruction && !streamInstruction.isString() && streamInstruction.getChildInstructionCount() > 501) {
                StreamInstruction streamInstruction2 = streamInstruction;
                LetChainBuilder letChainBuilder = new LetChainBuilder();
                while (streamInstruction2.getChildInstructionCount() > 500) {
                    List<Instruction> list = Arrays.asList(streamInstruction2.getElements());
                    ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
                    for (int i = 0; i < list.size(); i += 500) {
                        int n3 = i + 500;
                        n3 = n3 > list.size() ? list.size() : n3;
                        ArrayList<Instruction> arrayList2 = new ArrayList<Instruction>(list.subList(i, n3));
                        arrayList.add(letChainBuilder.bind(new StreamInstruction(streamInstruction2.getElementType(), arrayList2)));
                    }
                    streamInstruction2 = new StreamInstruction(streamInstruction2.getElementType(), arrayList);
                }
                ((LetInstruction)instruction2).setValue(streamInstruction2);
                instruction2 = letChainBuilder.packageUp(instruction2);
                instruction2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
            }
            return instruction2;
        }

        @Override
        protected Instruction optimizeStep(Instruction instruction2, Instruction instruction3, int n2) {
            if (instruction2 instanceof BeginInstruction) {
                return this.preSplitBegin(instruction2, instruction3, n2);
            }
            if (instruction2 instanceof LetInstruction && ((LetInstruction)instruction2).getValue() instanceof StreamInstruction) {
                return this.preSplitLetStream(instruction2, instruction3, n2);
            }
            return instruction2;
        }
    }

    private static class Candidate {
        private Instruction n = null;
        private LetInstruction parent = null;
        private int parentIndex = -1;
        private Set freeVars = new HashSet();
        private boolean isValue = false;
        private double score = 0.0;
        private int size = 0;

        private Candidate() {
        }

        public boolean compare(double d) {
            return this.score < d;
        }

        public void clear() {
            this.n = null;
            this.parent = null;
            this.parentIndex = -1;
            this.freeVars = new HashSet();
            this.isValue = false;
            this.score = 0.0;
            this.size = 0;
        }

        public void set(Instruction instruction2, LetInstruction letInstruction, int n2, Set set2, boolean bl, double d, int n3) {
            this.n = instruction2;
            this.parent = letInstruction;
            this.parentIndex = n2;
            this.freeVars.clear();
            this.freeVars.addAll(set2);
            this.isValue = bl;
            this.score = d;
            this.size = n3;
        }
    }

    private class InformationCollector {
        private HashMap m_valueSizes = new HashMap();
        private HashMap m_bodySizes = new HashMap();
        private HashMap m_beginSizes = new HashMap();

        private InformationCollector() {
        }

        public int collectInfo(Function function2) {
            this.m_bodySizes.clear();
            this.m_valueSizes.clear();
            return this.collectSize(function2.getBody(), function2.getTypeEnvironment(), function2.getBindingEnvironment());
        }

        public int collectSize(Instruction instruction2, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
            if (!(instruction2 instanceof LetInstruction)) {
                int n2 = SplitFunctions.this.size(instruction2, typeEnvironment, bindingEnvironment);
                if (n2 < 0) {
                    n2 = -n2;
                } else {
                    for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
                        n2 += this.collectSize(instruction2.getChildInstruction(i), typeEnvironment, bindingEnvironment);
                    }
                }
                return n2;
            }
            Instruction instruction3 = instruction2;
            LinkedList linkedList = new LinkedList();
            int n3 = this.collectSize(OptimizerUtilities.skipLets(instruction2, linkedList), typeEnvironment, bindingEnvironment);
            LetInstruction[] letInstructionArray = linkedList.toArray(new LetInstruction[0]);
            for (int i = letInstructionArray.length - 1; i >= 0; --i) {
                int n4 = this.collectSize(letInstructionArray[i].getValue(), typeEnvironment, bindingEnvironment);
                this.m_valueSizes.put(letInstructionArray[i].getVariable(), new Integer(n4));
                this.m_bodySizes.put(letInstructionArray[i].getVariable(), new Integer(n3));
                n3 += n4;
            }
            return n3;
        }

        public int getSizeInfo(Object object2, boolean bl) {
            if (bl) {
                return (Integer)this.m_valueSizes.get(object2);
            }
            return (Integer)this.m_bodySizes.get(object2);
        }
    }
}

