/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;

public class SimpleUnflattenStreamOptimizer
extends Optimizer {
    protected int m_limit;

    public SimpleUnflattenStreamOptimizer(int n2) {
        this.m_limit = n2;
    }

    @Override
    public void optimizeFunction(Function function2) {
        if (function2.getName().indexOf("xdm-") == -1) {
            super.optimizeFunction(function2);
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction2) {
        if (instruction2 instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction2;
            if (streamInstruction.isStoredAsString()) {
                return null;
            }
            int n2 = instruction2.accumulateByteCodeSize();
            int n3 = streamInstruction.getChildInstructionCount();
            if (this.m_limit > 0 && n2 > this.m_limit && n3 > 4) {
                StreamInstruction streamInstruction2 = (StreamInstruction)streamInstruction.cloneWithoutTypeInformation();
                streamInstruction2.split();
                instruction2 = this.doTypeCheck(instruction2, streamInstruction2, instruction2.getBindingEnvironment());
            }
        }
        return instruction2;
    }
}

