/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.DataDependencyDrivenPostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReverseInliningOptimizer
extends DataDependencyDrivenPostOrderOptimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(ReverseInliningOptimizer.class);
    private static final String s_className = ReverseInliningOptimizer.class.getName();
    private int m_limit;
    public Object[] m_necessaryParameters = new Object[0];

    public ReverseInliningOptimizer(int n2) {
        this.m_limit = n2;
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction2) {
        int n2 = instruction2.accumulateByteCodeSize();
        if (this.m_limit > 0 && n2 > this.m_limit && this.m_currentFunction.getBody() != instruction2) {
            Instruction instruction3 = instruction2;
            if (instruction2 instanceof ChooseInstruction) {
                instruction3 = this.handleChoose((ChooseInstruction)instruction2);
            } else if (instruction2 instanceof LetInstruction) {
                instruction3 = this.handleLet((LetInstruction)instruction2);
            } else if (instruction2 instanceof MatchInstruction) {
                instruction3 = this.handleMatch((MatchInstruction)instruction2);
            } else if (instruction2 instanceof StreamInstruction) {
                instruction3 = this.handleStream((StreamInstruction)instruction2);
            }
            if (instruction2 == instruction3) {
                return instruction2;
            }
            int n3 = instruction3.accumulateByteCodeSize();
            if (n3 < n2) {
                return this.optimizeStep(this.doTypeCheck(instruction2, instruction3, instruction2.getBindingEnvironment()));
            }
            return instruction2;
        }
        return instruction2;
    }

    private boolean isSafeToCut(Instruction instruction2) {
        HashSet hashSet = new HashSet();
        instruction2.accumulateFreeBindings(hashSet, null);
        for (IBinding iBinding : hashSet) {
            if (iBinding == null) continue;
            TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
            Type type2 = iBinding.getBindingType().resolveType(typeEnvironment);
            if (type2 instanceof NamedType) {
                return false;
            }
            if (!(type2 instanceof StreamType) || iBinding.getLet() == null || this.getBindingUseCount(iBinding) != 1 || iBinding.getLet().isStatic(null)) continue;
            return false;
        }
        return true;
    }

    private Instruction handleMatch(MatchInstruction matchInstruction) {
        Instruction instruction2;
        FunctionCallInstruction functionCallInstruction;
        int n2;
        if (!this.isSafeToCut(matchInstruction)) {
            return matchInstruction;
        }
        Instruction instruction3 = matchInstruction.getDefault();
        MatchInstruction.Match[] matchArray = matchInstruction.getMatches();
        Instruction instruction4 = matchInstruction.getToMatch();
        LinkedList<MatchInstruction.Match> linkedList = new LinkedList<MatchInstruction.Match>();
        LinkedList<MatchInstruction.Match> linkedList2 = new LinkedList<MatchInstruction.Match>();
        for (n2 = matchArray.length - 1; n2 > 1 && n2 > matchArray.length / 2; --n2) {
            linkedList2.addFirst(matchArray[n2]);
        }
        while (n2 >= 0) {
            linkedList.addFirst(matchArray[n2]);
            --n2;
        }
        MatchInstruction.Match[] matchArray2 = new MatchInstruction.Match[linkedList.size()];
        MatchInstruction.Match[] matchArray3 = new MatchInstruction.Match[linkedList2.size()];
        linkedList.toArray(matchArray2);
        linkedList2.toArray(matchArray3);
        if (linkedList2.size() == 0) {
            if (null == instruction3) {
                return matchInstruction;
            }
            functionCallInstruction = this.buildFunction(matchInstruction, instruction3, "match-default");
        } else {
            instruction2 = new MatchInstruction(instruction4, matchArray3, instruction3);
            functionCallInstruction = this.buildFunction(matchInstruction, instruction2, "match");
        }
        instruction2 = new MatchInstruction(instruction4, matchArray2, (Instruction)functionCallInstruction).cloneWithoutTypeInformation();
        return instruction2;
    }

    private Instruction handleChoose(ChooseInstruction chooseInstruction) {
        Instruction instruction2;
        Instruction instruction3;
        int n2;
        if (!this.isSafeToCut(chooseInstruction)) {
            return chooseInstruction;
        }
        Instruction instruction4 = chooseInstruction.getDefaultHandler();
        int n3 = 0;
        if (instruction4 != null) {
            n3 += instruction4.accumulateByteCodeSize();
        }
        LinkedList<ChooseInstruction.Case> linkedList = new LinkedList<ChooseInstruction.Case>();
        LinkedList<ChooseInstruction.Case> linkedList2 = new LinkedList<ChooseInstruction.Case>();
        for (n2 = chooseInstruction.m_cases.length - 1; n2 >= 1; --n2) {
            instruction3 = chooseInstruction.m_cases[n2].getHandler();
            instruction2 = chooseInstruction.m_cases[n2].getTest();
            n3 += instruction3.accumulateByteCodeSize();
            if (this.m_limit > 0 && (n3 += instruction2.accumulateByteCodeSize()) >= this.m_limit) break;
            linkedList2.addFirst(new ChooseInstruction.Case(instruction2, instruction3));
        }
        while (n2 >= 0) {
            instruction3 = chooseInstruction.m_cases[n2].getHandler();
            instruction2 = chooseInstruction.m_cases[n2].getTest();
            linkedList.addFirst(new ChooseInstruction.Case(instruction2, instruction3));
            --n2;
        }
        if (linkedList2.size() == 0) {
            if (instruction4 == null) {
                throw new XylemError("ERR_SYSTEM", "inconsistency in RIO at " + chooseInstruction);
            }
            instruction3 = this.buildFunction(chooseInstruction, instruction4, "choose-default");
        } else {
            instruction2 = new ChooseInstruction(linkedList2.toArray(new ChooseInstruction.Case[0]), instruction4);
            instruction3 = this.buildFunction(chooseInstruction, instruction2, "choose");
        }
        if (linkedList.size() == 0) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "handleChoose", "inconsistency 1 in RIO at " + chooseInstruction);
            }
            return instruction3;
        }
        instruction2 = new ChooseInstruction(linkedList.toArray(new ChooseInstruction.Case[0]), instruction3);
        return instruction2.cloneWithoutTypeInformation();
    }

    private Instruction handleLet(LetInstruction letInstruction) {
        LetInstruction letInstruction2 = (LetInstruction)letInstruction.cloneShallow();
        Instruction instruction2 = letInstruction.getBody();
        Instruction instruction3 = letInstruction.getValue();
        if (instruction2.accumulateByteCodeSize() >= instruction3.accumulateByteCodeSize()) {
            if (!this.isSafeToCut(instruction2)) {
                return letInstruction;
            }
            FunctionCallInstruction functionCallInstruction = this.buildFunction(letInstruction, instruction2, "let-body");
            letInstruction2.setBody(functionCallInstruction);
        } else {
            if (!this.isSafeToCut(instruction3)) {
                return letInstruction;
            }
            FunctionCallInstruction functionCallInstruction = this.buildFunction(letInstruction, instruction3, "let-value");
            letInstruction2.setValue(functionCallInstruction);
        }
        return letInstruction2.cloneWithoutTypeInformation();
    }

    private Instruction handleStream(StreamInstruction streamInstruction) {
        return this.buildFunction(streamInstruction, streamInstruction, "stream");
    }

    private FunctionCallInstruction buildFunction(Instruction instruction2, Instruction instruction3, String string2) {
        Instruction[] instructionArray;
        if (instruction3 instanceof FunctionCallInstruction) {
            return (FunctionCallInstruction)instruction3.cloneWithoutTypeInformation();
        }
        TreeSet<Instruction[]> treeSet = new TreeSet<Instruction[]>(new Comparator(){

            public int compare(Object object2, Object object3) {
                Comparable comparable;
                IBinding iBinding = (IBinding)object2;
                IBinding iBinding2 = (IBinding)object3;
                if (iBinding == iBinding2) {
                    return 0;
                }
                Comparable comparable2 = (Comparable)iBinding.getName();
                if (comparable2.equals(comparable = (Comparable)iBinding2.getName())) {
                    int n2 = System.identityHashCode(iBinding) - System.identityHashCode(iBinding2);
                    if (n2 == 0) {
                        int n3;
                        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                            s_logger.logp(Level.FINE, s_className, "compare", "two objects with the same identity hash code");
                        }
                        if ((n3 = System.identityHashCode(comparable2) - System.identityHashCode(comparable)) == 0) {
                            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                                s_logger.logp(Level.FINE, s_className, "compare", "two objects who have names that have the same identity hash code");
                            }
                            return -1;
                        }
                        return n3;
                    }
                    return n2;
                }
                int n4 = comparable.getClass().hashCode() - comparable2.getClass().hashCode();
                if (n4 != 0) {
                    return n4;
                }
                return comparable2.compareTo(comparable);
            }
        });
        instruction3.accumulateFreeBindings(treeSet, null);
        for (int i = 0; i < this.m_necessaryParameters.length; ++i) {
            instructionArray = instruction2.getBindingEnvironment().getVariableBinding(this.m_necessaryParameters[i]);
            if (instructionArray == null) continue;
            treeSet.add(instructionArray);
        }
        IBinding[] iBindingArray = Binding.cloneBindings(treeSet.toArray(new IBinding[0]));
        instructionArray = Binding.getIdentifiers(iBindingArray);
        if (instructionArray.length > 0) {
            Instruction.propagateInfo(instruction3, instructionArray[0]);
        }
        String string3 = this.m_currentFunction != null ? "outlinedFunction" + this.m_currentFunction.getName() : "outlinedFunction";
        String string4 = OptimizerUtilities.generateIntermediateIdentifier(string2 + "-" + string3);
        Function function2 = new Function(string4, (Binding[])iBindingArray, instruction3.cloneWithoutTypeInformation());
        if (!this.m_currentFunction.m_resolvedConstraintTypes.isEmpty()) {
            for (Type type2 : this.m_currentFunction.m_resolvedConstraintTypes.keySet()) {
                function2.m_resolvedConstraintTypes.put(type2, this.m_currentFunction.m_resolvedConstraintTypes.get(type2));
            }
        }
        this.getCurrentModule().addFunction(function2);
        FunctionCallInstruction functionCallInstruction = new FunctionCallInstruction(string4, instructionArray);
        if (0 < instructionArray.length) {
            Instruction.propagateInfo(instructionArray[0], functionCallInstruction);
        }
        return functionCallInstruction;
    }
}

