/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xml.ras.LoggerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RepeatedExpressionOptimizer
extends Optimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(RepeatedExpressionOptimizer.class);
    private static final String s_className = RepeatedExpressionOptimizer.class.getName();
    HashSet<String> imperativeFunctions = new HashSet();

    public void prescan(Module module) {
        ScanForImperativeFunctions scanForImperativeFunctions = new ScanForImperativeFunctions();
        module.optimize(scanForImperativeFunctions);
        scanForImperativeFunctions.propigateImperativity();
    }

    @Override
    public void optimizeFunction(Function function2) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "optimizeFunction", "optimizing " + function2.getName());
        }
        Instruction instruction2 = this.go(function2.getBody(), new HashMap(), new PendingRenameOptimizer());
        function2.setBody(instruction2);
    }

    public Instruction go(Instruction instruction2, Map hashMap, PendingRenameOptimizer pendingRenameOptimizer) {
        if (!(instruction2 instanceof ISpecialForm)) {
            return pendingRenameOptimizer.optimize(instruction2);
        }
        if (!(instruction2 instanceof LetInstruction)) {
            for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
                instruction2.setChildInstruction(i, this.go(instruction2.getChildInstruction(i), hashMap, pendingRenameOptimizer));
            }
            return instruction2;
        }
        hashMap = new HashMap<ExpressionInfo, ExpressionInfo>(hashMap);
        LinkedList linkedList = new LinkedList();
        Instruction instruction3 = OptimizerUtilities.skipLets(instruction2, linkedList);
        LetInstruction letInstruction = null;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ExpressionInfo expressionInfo;
            ExpressionInfo expressionInfo2;
            LetInstruction letInstruction2 = (LetInstruction)iterator.next();
            letInstruction2.setValue(this.go(letInstruction2.getValue(), hashMap, pendingRenameOptimizer));
            if (letInstruction2.getValue() instanceof ISpecialForm) {
                letInstruction2.setValue(pendingRenameOptimizer.optimize(letInstruction2.getValue()));
            }
            if ((expressionInfo2 = hashMap.put(expressionInfo = new ExpressionInfo(letInstruction2.getVariable(), letInstruction2.getValue()), expressionInfo)) != null) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                    s_logger.logp(Level.FINEST, s_className, "go", "replacing '" + expressionInfo.getIdentifier() + " with " + expressionInfo2.getIdentifier());
                }
                pendingRenameOptimizer.put(expressionInfo.getIdentifier(), expressionInfo2.getIdentifier());
                if (letInstruction != null) {
                    letInstruction.setBody(letInstruction2.getBody());
                }
                hashMap.put(expressionInfo2, expressionInfo2);
                iterator.remove();
                continue;
            }
            letInstruction = letInstruction2;
        }
        instruction3 = this.go(instruction3, hashMap, pendingRenameOptimizer);
        if (linkedList.size() == 0) {
            return instruction3;
        }
        ((LetInstruction)linkedList.getLast()).setBody(instruction3);
        return (Instruction)linkedList.getFirst();
    }

    private static class IdentifierCanonicalizer
    implements INewNameGenerator {
        private int m_id = 0;

        private IdentifierCanonicalizer() {
        }

        public void reset() {
            this.m_id = 0;
        }

        @Override
        public Object getNewName() {
            return new Integer(++this.m_id);
        }
    }

    private static class PendingRenameOptimizer
    extends Optimizer {
        private Map m_map;

        public PendingRenameOptimizer() {
            this.m_skipStringStreams = true;
            this.m_map = new TransitiveMap();
        }

        public void put(Object object2, Object object3) {
            this.m_map.put(object2, object3);
        }

        @Override
        protected Instruction optimizeStep(Instruction instruction2) {
            IdentifierInstruction identifierInstruction;
            if (instruction2 instanceof IdentifierInstruction && this.m_map.containsKey((identifierInstruction = (IdentifierInstruction)instruction2).getVariable())) {
                return new IdentifierInstruction(this.m_map.get(identifierInstruction.getVariable()));
            }
            return super.optimizeStep(instruction2);
        }
    }

    private static class TransitiveMap
    extends HashMap {
        private static final long serialVersionUID = 7758861528196050459L;

        private TransitiveMap() {
        }

        @Override
        public Collection values() {
            return super.values();
        }

        @Override
        public Set entrySet() {
            return super.entrySet();
        }

        @Override
        public Object get(Object object2) {
            Object v = super.get(object2);
            while (super.containsKey(v)) {
                v = super.get(v);
            }
            if (v != null) {
                this.put(object2, v);
            }
            return v;
        }
    }

    private class ExpressionInfo {
        private Instruction m_expr;
        private String m_key;
        private String m_canonical;
        private Object m_identifier;

        public ExpressionInfo(Object object2, Instruction instruction2) {
            this.m_identifier = object2;
            this.m_expr = instruction2;
        }

        public Object getIdentifier() {
            return this.m_identifier;
        }

        public int hashCode() {
            if (this.m_key == null) {
                this.calcKey();
            }
            return this.m_key.hashCode();
        }

        public boolean equals(Object object2) {
            if (this.m_expr instanceof IImperativeInstruction) {
                return false;
            }
            if (this.m_expr instanceof FunctionCallInstruction && RepeatedExpressionOptimizer.this.imperativeFunctions.contains(((FunctionCallInstruction)this.m_expr).getFunction())) {
                return false;
            }
            ExpressionInfo expressionInfo = (ExpressionInfo)object2;
            if (this.hashCode() != expressionInfo.hashCode()) {
                return false;
            }
            if (this.m_canonical == null) {
                this.calcCanonical();
            }
            if (expressionInfo.m_canonical == null) {
                expressionInfo.calcCanonical();
            }
            return this.m_canonical.equals(expressionInfo.m_canonical);
        }

        private void calcKey() {
            if (!(this.m_expr instanceof ISpecialForm)) {
                this.m_canonical = this.m_key = this.m_expr.toString();
            } else {
                ISpecialForm iSpecialForm = (ISpecialForm)((Object)this.m_expr);
                StringBuffer stringBuffer = new StringBuffer(this.m_expr.getClass().getName());
                for (int i = 0; i < this.m_expr.getChildInstructionCount(); ++i) {
                    if (iSpecialForm.isChildInstructionBody(i)) continue;
                    stringBuffer.append(' ');
                    stringBuffer.append(this.m_expr.getChildInstruction(i).toString());
                }
                this.m_key = stringBuffer.toString();
            }
        }

        private void calcCanonical() {
            this.m_canonical = this.m_expr.assignNewNames(new HashMap(), new IdentifierCanonicalizer()).toString();
        }
    }

    public class ScanForImperativeFunctions
    extends Optimizer {
        HashMap<String, Set<String>> dependencies = new HashMap();

        @Override
        public Instruction optimizeStep(Instruction instruction2) {
            if (instruction2 instanceof IImperativeInstruction) {
                RepeatedExpressionOptimizer.this.imperativeFunctions.add(this.getCurrentFunction().getName());
            } else if (instruction2 instanceof FunctionCallInstruction) {
                Set<String> set2;
                FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
                Function function2 = this.getCurrentFunction();
                String string2 = functionCallInstruction.getFunction();
                boolean bl = RepeatedExpressionOptimizer.this.imperativeFunctions.contains(string2);
                if (bl) {
                    RepeatedExpressionOptimizer.this.imperativeFunctions.add(function2.getName());
                }
                if ((set2 = this.dependencies.get(string2)) == null) {
                    set2 = new HashSet<String>();
                    this.dependencies.put(string2, set2);
                }
                set2.add(function2.getName());
            } else if (instruction2 instanceof ModuleFunctionCallInstruction) {
                return instruction2;
            }
            return instruction2;
        }

        public void propigateImperativity() {
            boolean bl;
            do {
                bl = false;
                for (String string2 : this.dependencies.keySet()) {
                    if (!RepeatedExpressionOptimizer.this.imperativeFunctions.contains(string2)) continue;
                    for (String string3 : this.dependencies.get(string2)) {
                        if (RepeatedExpressionOptimizer.this.imperativeFunctions.contains(string3)) continue;
                        bl = true;
                        RepeatedExpressionOptimizer.this.imperativeFunctions.add(string3);
                    }
                }
            } while (bl);
        }
    }
}

