/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReducedForm {
    private static boolean s_enabled = false;
    private static final Logger s_logger = LoggerUtil.getLogger(ReducedForm.class);
    private static final String s_className = ReducedForm.class.getName();

    public static void reduceModule(Module module) {
        for (Function function2 : module.getFunctions()) {
            Instruction instruction2 = function2.getBody();
            try {
                ReducedForm.reduceFunction(function2);
                function2.typeCheckReduced(module, new LinkedList());
            }
            catch (Exception exception) {
                FFDCUtil.log(exception, ReducedForm.class);
                function2.setComment(function2.getComment() + "\n" + exception);
                String string2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"converted code did not reduce"});
                s_logger.logp(Level.SEVERE, s_className, "reduceModule", string2, exception);
                Program.dumpXylemFunctions(new Function[]{function2}, new File("."), "function");
                throw new XylemError(string2);
            }
        }
    }

    public static void reduceFunction(Function function2) {
        new Form().optimizeFunction(function2);
        new Form2().optimizeFunction(function2);
        new Variables().optimizeFunction(function2);
    }

    public static Instruction reduceFragment(Instruction instruction2) {
        instruction2 = new Form().optimize(instruction2);
        instruction2 = new Form2().optimize(instruction2);
        instruction2 = new Variables().optimizeFragment(instruction2);
        return instruction2;
    }

    private static class Variables
    extends Optimizer {
        private HashMap m_names;
        private static final Object BOUND = "";
        private boolean m_checkUnboundVars = true;

        private Variables() {
        }

        @Override
        protected Instruction optimizeStep(Instruction instruction2) {
            if (instruction2 instanceof LetInstruction) {
                LetInstruction letInstruction;
                Instruction instruction3 = instruction2;
                do {
                    boolean bl;
                    letInstruction = (LetInstruction)instruction2;
                    Object object2 = letInstruction.getVariable();
                    Object v = this.m_names.get(object2);
                    if (this.m_names.get(object2) == null) {
                        bl = false;
                    } else {
                        bl = true;
                        Integer n2 = ReductionHelper.generateIntermediateIdentifier2();
                        letInstruction.setVariable(n2);
                    }
                    this.m_names.put(letInstruction.getVariable(), BOUND);
                    instruction2.setChildInstruction(0, this.optimize(letInstruction.getValue()));
                    if (!bl) continue;
                    this.m_names.put(object2, letInstruction.getVariable());
                    letInstruction.setBody(this.optimize(letInstruction.getBody()));
                    this.m_names.put(object2, v);
                    return null;
                } while ((instruction2 = letInstruction.getBody()) instanceof LetInstruction);
                letInstruction.setBody(this.optimize(instruction2));
                return null;
            }
            if (instruction2 instanceof IdentifierInstruction) {
                IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction2;
                Object v = this.m_names.get(identifierInstruction.getVariable());
                if (v == null) {
                    if (this.m_checkUnboundVars) {
                        throw new XylemError("ERR_SYSTEM", "unbound variable:" + identifierInstruction + " in: " + this.getCurrentFunction());
                    }
                    return null;
                }
                if (v == BOUND) {
                    return null;
                }
                return new IdentifierInstruction(v);
            }
            if (instruction2 instanceof ISpecialForm) {
                for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
                    IBinding[] iBindingArray = ((ISpecialForm)((Object)instruction2)).getChildInstructionBindings(i);
                    if (iBindingArray != null) {
                        HashMap<Object, Integer> hashMap = null;
                        HashMap<Object, Object> hashMap2 = null;
                        for (int j = 0; j < iBindingArray.length; ++j) {
                            Object object3 = this.m_names.put(iBindingArray[j].getName(), BOUND);
                            if (object3 == null) continue;
                            if (hashMap == null) {
                                hashMap = new HashMap<Object, Integer>();
                                hashMap2 = new HashMap<Object, Object>();
                            }
                            Integer n3 = ReductionHelper.generateIntermediateIdentifier2();
                            hashMap.put(iBindingArray[j].getName(), n3);
                            hashMap2.put(iBindingArray[j].getName(), object3);
                            iBindingArray[j].setName(n3);
                        }
                        if (hashMap != null) {
                            this.m_names.putAll(hashMap);
                            instruction2.setChildInstruction(i, this.optimize(instruction2.getChildInstruction(i)));
                            this.m_names.putAll(hashMap2);
                            continue;
                        }
                    }
                    instruction2.setChildInstruction(i, this.optimize(instruction2.getChildInstruction(i)));
                }
                return null;
            }
            return instruction2;
        }

        @Override
        public void optimizeFunction(Function function2) {
            this.m_names = new HashMap();
            for (int i = 0; i < function2.m_parameters.length; ++i) {
                this.m_names.put(function2.m_parameters[i].getName(), BOUND);
            }
            super.optimizeFunction(function2);
            this.m_names = null;
        }

        public Instruction optimizeFragment(Instruction instruction2) {
            this.m_checkUnboundVars = false;
            this.m_names = new HashMap();
            instruction2 = this.optimize(instruction2);
            this.m_names = null;
            this.m_checkUnboundVars = true;
            return instruction2;
        }
    }

    private static class Form
    extends Optimizer {
        private Form() {
        }

        @Override
        protected Instruction optimizeStep(Instruction instruction2) {
            if (instruction2 instanceof LetInstruction) {
                LetInstruction letInstruction;
                Instruction instruction3 = instruction2;
                do {
                    letInstruction = (LetInstruction)instruction2;
                    Instruction instruction4 = this.optimize(letInstruction.getValue());
                    letInstruction.setValue(instruction4);
                } while ((instruction2 = letInstruction.getBody()) instanceof LetInstruction);
                letInstruction.setBody(this.optimize(instruction2));
                return null;
            }
            if (instruction2 instanceof LiteralInstruction) {
                return instruction2;
            }
            boolean bl = instruction2 instanceof ISpecialForm;
            int n2 = instruction2.getChildInstructionCount();
            Instruction instruction5 = instruction2;
            for (int i = 0; i < n2; ++i) {
                if (bl && ((ISpecialForm)((Object)instruction2)).isChildInstructionBody(i)) {
                    instruction2.setChildInstruction(i, this.optimize(instruction2.getChildInstruction(i)));
                    continue;
                }
                Instruction instruction6 = instruction2.getChildInstruction(i);
                if (instruction6 instanceof IdentifierInstruction || instruction6 instanceof LiteralInstruction) continue;
                Integer n3 = ReductionHelper.generateIntermediateIdentifier2();
                instruction2.setChildInstruction(i, new IdentifierInstruction(n3));
                Instruction instruction7 = this.optimize(instruction6);
                ArrayList arrayList = new ArrayList();
                Instruction instruction8 = OptimizerUtilities.skipLets(instruction7, arrayList);
                Instruction instruction9 = new LetInstruction(n3, instruction8, instruction5);
                if (arrayList.size() > 0) {
                    LetInstruction letInstruction = (LetInstruction)arrayList.get(arrayList.size() - 1);
                    letInstruction.setBody(instruction9);
                    instruction9 = instruction7;
                }
                instruction5 = instruction9;
            }
            return instruction5.cloneShallow();
        }
    }

    private static class Form2
    extends Optimizer {
        private Form2() {
        }

        @Override
        protected Instruction optimizeStep(Instruction instruction2) {
            if (instruction2 instanceof LetInstruction) {
                LetInstruction letInstruction;
                LetInstruction letInstruction2 = null;
                do {
                    if ((letInstruction = (LetInstruction)instruction2).getValue() instanceof LetInstruction) {
                        LinkedList linkedList = new LinkedList();
                        Instruction instruction3 = OptimizerUtilities.skipLets(letInstruction.getValue(), linkedList);
                        letInstruction.setValue(this.optimize(instruction3));
                        LetInstruction letInstruction3 = (LetInstruction)linkedList.get(linkedList.size() - 1);
                        letInstruction3.setBody(letInstruction);
                        Instruction instruction4 = (Instruction)linkedList.get(0);
                        instruction4 = this.optimize(instruction4);
                        if (letInstruction2 != null) {
                            letInstruction2.setBody(instruction4);
                            return null;
                        }
                        return instruction4;
                    }
                    letInstruction.setValue(this.optimize(letInstruction.getValue()));
                    instruction2 = letInstruction.getBody();
                    letInstruction2 = letInstruction;
                } while (instruction2 instanceof LetInstruction);
                letInstruction.setBody(this.optimize(instruction2));
                return null;
            }
            if (instruction2 instanceof ChooseInstruction && ((ChooseInstruction)instruction2).m_cases.length > 1) {
                ChooseInstruction chooseInstruction = (ChooseInstruction)instruction2;
                ChooseInstruction.Case[] caseArray = chooseInstruction.m_cases;
                Instruction instruction5 = chooseInstruction.getDefaultHandler();
                if (instruction5 != null) {
                    instruction5 = this.optimize(instruction5);
                }
                for (int i = caseArray.length - 1; i >= 0; --i) {
                    instruction5 = new ChooseInstruction(caseArray[i].getTest(), this.optimize(caseArray[i].getHandler()), instruction5);
                }
                return instruction5;
            }
            return instruction2;
        }
    }

    public static class Check
    extends Optimizer {
        private Instruction m_fragment;
        private HashSet m_names = new HashSet();

        public static void check(Module module) {
            if (!s_enabled) {
                return;
            }
            Check check2 = new Check();
            for (Function function2 : module.getFunctions()) {
                check2.optimizeFunction(function2);
            }
        }

        public static void check(Function function2) {
            if (!s_enabled) {
                return;
            }
            new Check().optimizeFunction(function2);
        }

        public static void check(Instruction instruction2) {
            if (!s_enabled) {
                return;
            }
            new Check().optimize(instruction2);
        }

        @Override
        protected Instruction optimizeStep(Instruction instruction2, Instruction instruction3, int n2) {
            if (instruction2 == null) {
                throw new XylemError("ERR_SYSTEM", "null instruction!");
            }
            if (instruction2 instanceof LetInstruction) {
                if (((LetInstruction)instruction2).getValue() instanceof LetInstruction) {
                    throw new XylemError("ERR_SYSTEM", "let value cannot be let in '" + instruction2 + "'");
                }
                if (!this.m_names.add(((LetInstruction)instruction2).getVariable())) {
                    throw new XylemError("ERR_SYSTEM", "let variable '" + ((LetInstruction)instruction2).getVariable() + "'" + " reused in " + this.getCurrentFunction());
                }
            } else {
                boolean bl = instruction2 instanceof ISpecialForm;
                int n3 = instruction2.getChildInstructionCount();
                for (int i = 0; i < n3; ++i) {
                    Instruction instruction4;
                    if (bl && ((ISpecialForm)((Object)instruction2)).isChildInstructionBody(i) || (instruction4 = instruction2.getChildInstruction(i)) instanceof IdentifierInstruction || instruction4 instanceof LiteralInstruction) continue;
                    throw new XylemError("ERR_SYSTEM", "child " + i + " not reduced: " + instruction4 + "\n in: " + instruction2);
                }
                if (instruction2 instanceof ChooseInstruction) {
                    ChooseInstruction chooseInstruction = (ChooseInstruction)instruction2;
                    if (chooseInstruction.m_cases.length > 1) {
                        throw new XylemError("ERR_SYSTEM", "ChooseInstruction not reduced (too many cases):\n" + instruction2);
                    }
                } else if (this.getCurrentFunction() != null && instruction2 instanceof IdentifierInstruction && ((IdentifierInstruction)instruction2).getBinding(this.getCurrentFunction().getBindingEnvironment()) == null) {
                    throw new XylemError("ERR_SYSTEM", "identifier " + instruction2 + " is not bound");
                }
            }
            return instruction2;
        }

        @Override
        public Instruction optimize(Instruction instruction2) {
            this.m_names.clear();
            this.m_fragment = instruction2;
            super.optimize(instruction2);
            this.m_fragment = null;
            this.m_names.clear();
            return instruction2;
        }

        @Override
        public void optimizeFunction(Function function2) {
            if (function2.getBindingEnvironment() == null) {
                throw new XylemError("ERR_SYSTEM", "function " + function2.getName() + " has no binding environment.");
            }
            this.m_names = new HashSet();
            for (int i = 0; i < function2.m_parameters.length; ++i) {
                this.m_names.add(function2.m_parameters[i].getName());
            }
            try {
                super.optimizeFunction(function2);
            }
            catch (Exception exception) {
                FFDCUtil.log(exception, this);
                String string2 = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"error encountered in " + function2.getName() + " [" + exception + "]\n" + function2});
                s_logger.logp(Level.SEVERE, s_className, "optimizeFunction", string2, exception);
                throw new XylemError(string2);
            }
            this.m_names = null;
        }
    }
}

