/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.DataDependencyDrivenPostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ParallelForEachInstruction;
import com.ibm.xml.ras.LoggerUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParallelForEachOptimizer
extends DataDependencyDrivenPostOrderOptimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(ParallelForEachOptimizer.class);
    private static final String s_className = ParallelForEachOptimizer.class.getName();

    @Override
    protected Instruction optimizeStep(Instruction instruction2) {
        if (instruction2 instanceof ParallelForEachInstruction) {
            Object[] objectArray;
            Instruction[] instructionArray;
            ParallelForEachInstruction parallelForEachInstruction = (ParallelForEachInstruction)instruction2;
            Binding[] bindingArray = parallelForEachInstruction.getElementBindings();
            int n2 = 0;
            for (int i = 0; i < bindingArray.length; ++i) {
                if (!this.isBindingUsed(bindingArray[i])) continue;
                ++n2;
            }
            if (n2 == bindingArray.length) {
                return instruction2;
            }
            if (n2 == 0) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "optimizeStep", "No bindings used in PFEI");
                }
                instructionArray = new Instruction[]{parallelForEachInstruction.getSources()[0].cloneWithoutTypeInformation()};
                objectArray = new Object[]{parallelForEachInstruction.getElementVars()[0]};
            } else {
                instructionArray = new Instruction[n2];
                objectArray = new Object[n2];
                int n3 = 0;
                for (int i = 0; i < bindingArray.length; ++i) {
                    if (!this.isBindingUsed(bindingArray[i])) continue;
                    instructionArray[n3] = parallelForEachInstruction.getSources()[i].cloneWithoutTypeInformation();
                    objectArray[n3++] = parallelForEachInstruction.getElementVars()[i];
                }
            }
            ParallelForEachInstruction parallelForEachInstruction2 = new ParallelForEachInstruction(instructionArray, objectArray, parallelForEachInstruction.getBody().cloneWithoutTypeInformation());
            parallelForEachInstruction2.setIndexVar(parallelForEachInstruction.getIndexVar());
            this.doTypeCheck(instruction2, parallelForEachInstruction2, instruction2.getBindingEnvironment());
            return parallelForEachInstruction2;
        }
        return instruction2;
    }
}

