/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ScopedPostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetBaseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class OrderLetChains {
    private static final boolean m_debug = true;
    private HashMap variableToLetHash = new HashMap();
    Function m_currentFunction;

    public void orderFunction(Function function2) {
        this.m_currentFunction = function2;
        this.orderInstruction(function2.getBody(), null, -1);
    }

    private void orderInstruction(Instruction instruction2, Instruction instruction3, int n2) {
        if (instruction2 instanceof LetInstruction) {
            this.orderLetChain(instruction2, instruction3, n2);
        } else {
            this.orderChildren(instruction2);
        }
    }

    private void orderChildren(Instruction instruction2) {
        for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
            Instruction instruction3 = instruction2.getChildInstruction(i);
            this.orderInstruction(instruction3, instruction2, i);
        }
    }

    private void orderLetChain(Instruction instruction2, Instruction instruction3, int n2) {
        LinkedList<ArrayList> linkedList;
        Instruction instruction4;
        int n3 = 0;
        while (instruction2 instanceof LetInstruction) {
            ++n3;
            instruction4 = (LetInstruction)instruction2;
            this.orderInstruction(((LetBaseInstruction)instruction4).getValue(), instruction4, 0);
            linkedList = ((LetInstruction)instruction2).getVariable();
            this.variableToLetHash.put(linkedList, instruction4);
            instruction2 = ((LetBaseInstruction)instruction4).getBody();
        }
        this.orderInstruction(instruction2, instruction3, n2);
        if (n3 <= 1) {
            return;
        }
        instruction4 = instruction2;
        linkedList = new LinkedList<ArrayList>();
        ArrayList arrayList = OrderedFreeVariables.findFreeVariables(instruction4);
        LetBaseInstruction letBaseInstruction = null;
        LetInstruction letInstruction = null;
        ArrayList arrayList2 = new ArrayList(this.variableToLetHash.size());
        while (!arrayList.isEmpty()) {
            Object e = arrayList.get(0);
            LetInstruction letInstruction2 = (LetInstruction)this.variableToLetHash.get(e);
            if (letInstruction2 != null) {
                ArrayList arrayList3 = OrderedFreeVariables.findFreeVariables(letInstruction2.getValue());
                if (arrayList3.isEmpty()) {
                    arrayList.remove(0);
                    this.variableToLetHash.remove(e);
                    if (letBaseInstruction != null) {
                        letBaseInstruction.setBody(letInstruction2);
                    } else {
                        letInstruction = letInstruction2;
                    }
                    letBaseInstruction = letInstruction2;
                    arrayList2.add(e);
                } else {
                    linkedList.add(arrayList);
                    arrayList = arrayList3;
                }
            } else {
                arrayList.remove(0);
            }
            while (arrayList.isEmpty() && !linkedList.isEmpty()) {
                arrayList = (ArrayList)linkedList.removeLast();
                e = arrayList.remove(0);
                letInstruction2 = (LetInstruction)this.variableToLetHash.remove(e);
                if (letBaseInstruction != null) {
                    letBaseInstruction.setBody(letInstruction2);
                } else {
                    letInstruction = letInstruction2;
                }
                letBaseInstruction = letInstruction2;
                arrayList2.add(e);
            }
        }
        if (letInstruction != null) {
            if (instruction3 == null) {
                this.m_currentFunction.setBody(letInstruction);
            } else {
                instruction3.setChildInstruction(n2, letInstruction);
            }
        }
        if (letBaseInstruction != null) {
            letBaseInstruction.setBody(instruction4);
        }
    }

    public static class OrderedFreeVariables
    extends ScopedPostOrderOptimizer {
        private ArrayList m_freeVars = new ArrayList();
        private LinkedList m_freeVarsStack = new LinkedList();

        public static ArrayList findFreeVariables(Instruction instruction2) {
            OrderedFreeVariables orderedFreeVariables = new OrderedFreeVariables();
            orderedFreeVariables.optimize(instruction2);
            return orderedFreeVariables.getFreeVars();
        }

        public ArrayList getFreeVars() {
            return this.m_freeVars;
        }

        @Override
        protected void preOrderStep(Instruction instruction2, Instruction instruction3, int n2) {
            if (instruction3 instanceof ISpecialForm && ((ISpecialForm)((Object)instruction3)).isChildInstructionBody(n2)) {
                this.m_freeVarsStack.add(this.m_freeVars);
                this.m_freeVars = new ArrayList();
            }
        }

        @Override
        protected Instruction optimizeStep(Instruction instruction2, Instruction instruction3, int n2) {
            this.addVars(instruction2, instruction3, n2);
            this.removeVars(instruction2, instruction3, n2);
            return instruction2;
        }

        @Override
        protected void endOptimize(Instruction instruction2) {
            if (this.m_freeVarsStack.size() != 0) {
                throw new XylemError("ERR_SYSTEM", "!!!" + this.m_freeVarsStack.size());
            }
        }

        @Override
        protected void beginOptimize(Instruction instruction2) {
            this.m_freeVars.clear();
            this.m_freeVarsStack.clear();
        }

        protected void addVars(Instruction instruction2, Instruction instruction3, int n2) {
            Object object2;
            if (instruction2 instanceof IdentifierInstruction && !this.m_freeVars.contains(object2 = ((IdentifierInstruction)instruction2).getVariable())) {
                this.m_freeVars.add(((IdentifierInstruction)instruction2).getVariable());
            }
        }

        protected void removeVars(Instruction instruction2, Instruction instruction3, int n2) {
            if (instruction3 instanceof ISpecialForm && ((ISpecialForm)((Object)instruction3)).isChildInstructionBody(n2)) {
                IBinding[] iBindingArray = ((ISpecialForm)((Object)instruction3)).getChildInstructionBindings(n2);
                if (iBindingArray == null) {
                    throw new XylemError("ERR_SYSTEM", "!" + n2 + " " + instruction2);
                }
                this.m_freeVars.removeAll(Arrays.asList(Binding.getNames(iBindingArray)));
                ArrayList arrayList = (ArrayList)this.m_freeVarsStack.removeLast();
                for (int i = 0; i < this.m_freeVars.size(); ++i) {
                    Object e = this.m_freeVars.get(i);
                    if (arrayList.contains(e)) continue;
                    arrayList.add(e);
                }
                this.m_freeVars = arrayList;
            }
        }
    }
}

