/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xml.ras.LoggerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LetLetOptimizer
extends Optimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(LetLetOptimizer.class);
    private static final String s_className = LetLetOptimizer.class.getName();
    HashSet<String> imperativeFunctions = new HashSet();

    public void prescan(Module module) {
    }

    @Override
    public void optimizeFunction(Function function2) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "optimizeFunction", "optimizing " + function2.getName());
        }
        Instruction instruction2 = this.go(function2.getBody(), new HashMap(), new PendingRenameOptimizer());
        function2.setBody(instruction2);
    }

    public Instruction go(Instruction instruction2, Map hashMap, PendingRenameOptimizer pendingRenameOptimizer) {
        if (!(instruction2 instanceof ISpecialForm)) {
            return pendingRenameOptimizer.optimize(instruction2);
        }
        if (!(instruction2 instanceof LetInstruction)) {
            for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
                instruction2.setChildInstruction(i, this.go(instruction2.getChildInstruction(i), hashMap, pendingRenameOptimizer));
            }
            return instruction2;
        }
        hashMap = new HashMap(hashMap);
        LinkedList linkedList = new LinkedList();
        Instruction instruction3 = OptimizerUtilities.skipLets(instruction2, linkedList);
        LetInstruction letInstruction = null;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            LetInstruction letInstruction2 = (LetInstruction)iterator.next();
            letInstruction2.setValue(this.go(letInstruction2.getValue(), hashMap, pendingRenameOptimizer));
            if (letInstruction2.getValue() instanceof ISpecialForm) {
                letInstruction2.setValue(pendingRenameOptimizer.optimize(letInstruction2.getValue()));
            }
            if (letInstruction2.getValue() instanceof IdentifierInstruction) {
                pendingRenameOptimizer.put(letInstruction2.getVariable(), ((IdentifierInstruction)letInstruction2.getValue()).getVariable());
                if (letInstruction != null) {
                    letInstruction.setBody(letInstruction2.getBody());
                }
                iterator.remove();
                continue;
            }
            letInstruction = letInstruction2;
        }
        instruction3 = this.go(instruction3, hashMap, pendingRenameOptimizer);
        if (linkedList.size() == 0) {
            return instruction3;
        }
        ((LetInstruction)linkedList.getLast()).setBody(instruction3);
        return (Instruction)linkedList.getFirst();
    }

    private static class IdentifierCanonicalizer
    implements INewNameGenerator {
        private int m_id = 0;

        private IdentifierCanonicalizer() {
        }

        public void reset() {
            this.m_id = 0;
        }

        @Override
        public Object getNewName() {
            return new Integer(++this.m_id);
        }
    }

    private static class PendingRenameOptimizer
    extends Optimizer {
        private Map m_map;

        public PendingRenameOptimizer() {
            this.m_skipStringStreams = true;
            this.m_map = new TransitiveMap();
        }

        public void put(Object object2, Object object3) {
            this.m_map.put(object2, object3);
        }

        @Override
        protected Instruction optimizeStep(Instruction instruction2) {
            IdentifierInstruction identifierInstruction;
            if (instruction2 instanceof IdentifierInstruction && this.m_map.containsKey((identifierInstruction = (IdentifierInstruction)instruction2).getVariable())) {
                return new IdentifierInstruction(this.m_map.get(identifierInstruction.getVariable()));
            }
            return super.optimizeStep(instruction2);
        }
    }

    private static class TransitiveMap
    extends HashMap {
        private static final long serialVersionUID = 7758861528196050459L;

        private TransitiveMap() {
        }

        @Override
        public Collection values() {
            return super.values();
        }

        @Override
        public Set entrySet() {
            return super.entrySet();
        }

        @Override
        public Object get(Object object2) {
            Object v = super.get(object2);
            while (super.containsKey(v)) {
                v = super.get(v);
            }
            if (v != null) {
                this.put(object2, v);
            }
            return v;
        }
    }
}

