/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.BindingDependencyInfo;
import com.ibm.xltxe.rnm1.xylem.DataDependencyDrivenOptimizer;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xml.ras.LoggerUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LetChainClusterizer
extends DataDependencyDrivenOptimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(LetChainClusterizer.class);
    private static final String s_className = LetChainClusterizer.class.getName();
    HashMap m_toConsolidate = new HashMap();
    HashMap m_triples = new HashMap();
    private final int MIN_CHAIN = 5;

    @Override
    protected Instruction optimizeStep(Instruction instruction2, Instruction instruction3, int n2) {
        if (instruction2 instanceof LetInstruction) {
            Object object2;
            boolean bl;
            Instruction instruction4;
            int n3 = this.getBindingUseCount((IBinding)((Object)instruction2));
            if (n3 > 1) {
                return instruction2;
            }
            if (n3 == 0) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "optimizeStep", "dead let or untypechecked code?");
                }
                return instruction2;
            }
            BindingDependencyInfo bindingDependencyInfo = (BindingDependencyInfo)this.getBindingDependencyInfo((IBinding)((Object)instruction2)).next();
            if (!this.shouldConsolidate(bindingDependencyInfo)) {
                return instruction2;
            }
            LinkedList linkedList = (LinkedList)this.m_toConsolidate.get(bindingDependencyInfo.m_parent);
            if (linkedList == null) {
                linkedList = new LinkedList();
                this.m_toConsolidate.put(bindingDependencyInfo.m_parent, linkedList);
            }
            Object[] objectArray = new Object[]{instruction2, instruction3, new Integer(n2)};
            this.m_triples.put(instruction2, objectArray);
            linkedList.add(objectArray);
            Instruction instruction5 = ((LetInstruction)instruction2).getValue();
            linkedList = (LinkedList)this.m_toConsolidate.get(instruction5);
            if (linkedList == null) {
                return instruction2;
            }
            if (linkedList.size() < 5) {
                instruction4 = instruction2;
                bl = false;
            } else {
                instruction4 = instruction5;
                bl = true;
            }
            while (!linkedList.isEmpty()) {
                object2 = (Object[])linkedList.removeLast();
                LetInstruction letInstruction = (LetInstruction)object2[0];
                Instruction instruction6 = (Instruction)object2[1];
                int n4 = (Integer)object2[2];
                if (letInstruction == instruction3) {
                    instruction3 = instruction6;
                    n2 = n4;
                }
                this.setChild(instruction6, letInstruction.getBody(), n4);
                this.setChild(letInstruction, instruction4, 1);
                instruction4 = letInstruction;
            }
            if (bl) {
                object2 = new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), instruction4, null);
                this.setChild((Instruction)object2, instruction4, 1);
                this.setChild(instruction2, (Instruction)object2, 0);
            } else {
                this.setChild(instruction3, instruction4, n2);
            }
            this.m_toConsolidate.remove(instruction5);
            return instruction2;
        }
        return instruction2;
    }

    private void setChild(Instruction instruction2, Instruction instruction3, int n2) {
        if (instruction2 != null) {
            instruction2.setChildInstruction(n2, instruction3);
        } else {
            this.getCurrentFunction().setBody(instruction2);
        }
        Object[] objectArray = (Object[])this.m_triples.get(instruction3);
        if (objectArray != null) {
            objectArray[1] = instruction2;
            objectArray[2] = new Integer(n2);
        }
    }

    private boolean shouldConsolidate(BindingDependencyInfo bindingDependencyInfo) {
        return bindingDependencyInfo.m_parent instanceof StreamInstruction;
    }
}

