/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.PostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.optimizers.ReducedForm;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LambdaOptimizer
extends PostOrderOptimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(LambdaOptimizer.class);
    private static final String s_className = LambdaOptimizer.class.getName();
    protected HashMap m_cache = new HashMap();
    protected boolean m_doLoopInvariantOptimization = true;

    public void disableLoopInvariantOptimization() {
        this.m_doLoopInvariantOptimization = false;
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction2) {
        if (instruction2 instanceof LambdaInstruction) {
            Instruction instruction3;
            Object object2;
            LambdaInstruction lambdaInstruction = (LambdaInstruction)instruction2;
            BindingEnvironment bindingEnvironment = this.getCurrentFunction().getBindingEnvironment();
            TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
            Instruction instruction4 = lambdaInstruction;
            if (this.m_doLoopInvariantOptimization) {
                object2 = lambdaInstruction.getBody();
                instruction3 = object2;
                boolean bl = true;
                ArrayList<LetInstruction> arrayList = new ArrayList<LetInstruction>();
                ArrayList<LetInstruction> arrayList2 = new ArrayList<LetInstruction>();
                while (object2 instanceof LetInstruction) {
                    LetInstruction letInstruction = (LetInstruction)object2;
                    if (letInstruction.getValue().isStatic(bindingEnvironment)) {
                        arrayList.add(letInstruction);
                        arrayList2.add(letInstruction);
                        bl = false;
                    } else {
                        Set set2 = NavigationUtilities.resolveFreeBindingsForReducedExpression(letInstruction.getValue(), instruction3, bindingEnvironment);
                        List list = lambdaInstruction.getBindings();
                        int n2 = list.size();
                        list.removeAll(set2);
                        if (list.size() == n2) {
                            arrayList2.add(letInstruction);
                        } else {
                            arrayList.add(letInstruction);
                        }
                    }
                    object2 = letInstruction.getBody();
                }
                lambdaInstruction.setBody(OptimizerUtilities.reconstructLets((Instruction)object2, arrayList, false));
                if (!bl) {
                    lambdaInstruction = (LambdaInstruction)lambdaInstruction.cloneWithoutTypeInformation();
                }
                instruction4 = OptimizerUtilities.reconstructLets(lambdaInstruction, arrayList2, !bl);
                if (!bl) {
                    instruction4 = ReducedForm.reduceFragment(instruction4);
                    instruction4.typeCheckReduced(typeEnvironment, bindingEnvironment, new LinkedList());
                }
            }
            object2 = new ArrayList();
            instruction3 = (LambdaInstruction)OptimizerUtilities.skipLets(instruction4, (List)object2);
            Instruction instruction5 = LambdaOptimizer.generateFunctionCallBody(((LambdaInstruction)instruction3).getChildInstruction(0), ((LambdaInstruction)instruction3).getBindings(), this.getCurrentFunction(), this.m_cache);
            ((LambdaInstruction)instruction3).setBody(instruction5);
            instruction5.typeCheckReduced(typeEnvironment, bindingEnvironment, new LinkedList());
            if (this.m_doLoopInvariantOptimization && instruction4 instanceof LetInstruction) {
                return new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), instruction4, null);
            }
            return instruction4;
        }
        return super.optimizeStep(instruction2);
    }

    public static Instruction generateFunctionCallBody(Instruction instruction2, List list, Function function2, Map map2) {
        Object object2;
        Object object32;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.entering(s_className, "generateFunctionCallBody");
        }
        if (instruction2 instanceof FunctionCallInstruction) {
            return instruction2;
        }
        BindingEnvironment bindingEnvironment = function2.getBindingEnvironment();
        Instruction instruction3 = instruction2.generateCanonicalForm(bindingEnvironment);
        String string2 = instruction3.toString();
        String string3 = "";
        Set set2 = instruction2.accumulateFreeBindingsInOrder(bindingEnvironment);
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object32 = (IBinding)iterator.next();
            if (set2.contains(object32)) {
                string2 = string2 + "_" + n2;
            }
            ++n2;
        }
        for (Object object32 : set2) {
            object2 = object32.getBindingType();
            if (object2 == null) {
                object2 = object32.getLet().getValue().getType(function2.getTypeEnvironment(), bindingEnvironment);
            }
            string2 = string2 + "_" + object2.toString();
        }
        if (!map2.containsKey(string2)) {
            object32 = function2.getTypeEnvironment();
            string3 = OptimizerUtilities.generateIntermediateIdentifier("repeatedFunction");
            object2 = new Binding[set2.size()];
            int n3 = 0;
            for (IBinding iBinding : set2) {
                Type type2 = iBinding.getBindingType();
                if (type2 == null) {
                    type2 = iBinding.getLet().getValue().getType(function2.getTypeEnvironment(), bindingEnvironment);
                }
                object2[n3] = new Binding(iBinding.getName(), type2);
                ++n3;
            }
            Function function3 = function2.cloneFunctionForFixup(null, false, false, false);
            function3.setBody(instruction2.cloneWithNewNames());
            function3.m_parameters = object2;
            function3.setName(string3);
            ((TypeEnvironment)object32).getModule().addFunction(function3);
            map2.put(string2, string3);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "generateFunctionCallBody", "Cache Add");
            }
        } else {
            string3 = (String)map2.get(string2);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "generateFunctionCallBody", "Cache hit! on " + string3 + " in " + function2.getName());
            }
        }
        object32 = new LinkedList<IdentifierInstruction>();
        object2 = set2.iterator();
        while (object2.hasNext()) {
            IdentifierInstruction identifierInstruction = new IdentifierInstruction(((IBinding)object2.next()).getName());
            ((LinkedList)object32).add(identifierInstruction);
        }
        return new FunctionCallInstruction(string3, (List)object32);
    }
}

