/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.AutomatonInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import java.util.HashSet;

public class InliningOptimizer
extends Optimizer {
    @Override
    protected Instruction optimizeStep(Instruction instruction2) {
        if (instruction2 instanceof FunctionCallInstruction) {
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
            Function function2 = functionCallInstruction.getInstantiation().m_function;
            if (InliningOptimizer.isCandidateForInline(function2)) {
                Instruction instruction3 = OptimizerUtilities.replaceDeconstructionBindings(functionCallInstruction.m_parameters, function2.m_parameters, function2.getBody());
                return this.doTypeCheck(instruction2, instruction3.cloneWithoutTypeInformation(), instruction2.getBindingEnvironment());
            }
        }
        return instruction2;
    }

    public static boolean isCandidateForInline(Function function2) {
        if (!(function2.getBody() instanceof AutomatonInstruction)) {
            if (function2.m_parameters.length == 1) {
                return true;
            }
            HashSet hashSet = new HashSet();
            function2.getBody().accumulateFunctionsCalled(hashSet);
            hashSet.remove(function2.getName());
            if (hashSet.isEmpty()) {
                return true;
            }
        }
        return false;
    }
}

