/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xml.ras.LoggerUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class InlineFunctions
extends Optimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(InlineFunctions.class);
    private static final String s_className = InlineFunctions.class.getName();
    private LinkedList m_inlineStack = new LinkedList();
    private Module m_module;

    protected InlineFunctions(Module module) {
        this.m_module = module;
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction2) {
        FunctionCallInstruction functionCallInstruction;
        Function function2;
        if (instruction2 instanceof FunctionCallInstruction && (function2 = this.getFunction(functionCallInstruction = (FunctionCallInstruction)instruction2)) != null && this.shouldInline(function2, this.m_inlineStack)) {
            Object object2;
            this.m_inlineStack.addLast(function2);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                object2 = new StringBuffer();
                for (int i = 0; i < this.m_inlineStack.size(); ++i) {
                    ((StringBuffer)object2).append(' ');
                }
                ((StringBuffer)object2).append("inlining call to ");
                ((StringBuffer)object2).append(function2.getName());
                s_logger.logp(Level.FINEST, s_className, "optimizeStep", ((StringBuffer)object2).toString());
            }
            object2 = LetChainBuilder.inlinebody(functionCallInstruction.m_parameters, function2.m_parameters, function2.getBody());
            object2 = this.optimize((Instruction)object2);
            this.m_inlineStack.removeLast();
            return new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), (Instruction)object2, null);
        }
        return instruction2;
    }

    private Function getFunction(FunctionCallInstruction functionCallInstruction) {
        String string2 = functionCallInstruction.getFunction();
        return this.m_module.getFunction(string2);
    }

    protected abstract boolean shouldInline(Function var1, List var2);

    public static class ByParamType
    extends InlineFunctions {
        private Type m_type;
        private int m_limit;

        public ByParamType(Type type2, int n2, Module module) {
            super(module);
            this.m_type = type2;
            this.m_limit = n2;
            if (this.m_type == null) {
                throw new RuntimeException();
            }
        }

        @Override
        protected boolean shouldInline(Function function2, List list) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "shouldInline", "inlining call to " + function2.getName() + " ?");
            }
            if (list.size() > this.m_limit) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                    s_logger.logp(Level.FINEST, s_className, "shouldInline", " no -- too deep.");
                }
                return false;
            }
            for (int i = 0; i < function2.m_parameters.length; ++i) {
                if (!this.m_type.equals(function2.m_parameters[i].getBindingType())) continue;
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                    s_logger.logp(Level.FINEST, s_className, "shouldInline", "yes");
                }
                return true;
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "shouldInline", "no -- no params of type " + this.m_type);
            }
            return false;
        }
    }
}

