/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.PureInstruction;
import java.util.HashSet;

public class ImperitivityOptimizer
extends Optimizer {
    private HashSet m_impureFunctions = new HashSet();
    private HashSet m_inProcessFunctions = new HashSet();

    @Override
    public Instruction optimize(Instruction instruction2) {
        return instruction2;
    }

    private boolean isProvablyPure(Function function2) {
        if (!function2.isImpure()) {
            return true;
        }
        if (this.m_impureFunctions.contains(function2)) {
            return false;
        }
        if (this.m_inProcessFunctions.contains(function2)) {
            return false;
        }
        Instruction instruction2 = function2.getBody();
        this.m_inProcessFunctions.add(function2);
        boolean bl = this.isProvablyPure(instruction2);
        if (bl) {
            function2.setImpurity(false);
        } else {
            this.m_impureFunctions.add(function2);
        }
        this.m_inProcessFunctions.remove(function2);
        return bl;
    }

    private boolean isProvablyPure(Instruction instruction2) {
        if (instruction2 instanceof PureInstruction) {
            return true;
        }
        if (instruction2 instanceof IImperativeInstruction) {
            return false;
        }
        int n2 = instruction2.getChildInstructionCount();
        for (int i = 0; i < n2; ++i) {
            Instruction instruction3 = instruction2.getChildInstruction(i);
            if (this.isProvablyPure(instruction3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void optimizeFunction(Function function2) {
        this.isProvablyPure(function2);
    }
}

