/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xml.ras.LoggerUtil;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FunctionInfo
extends Optimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(FunctionInfo.class);
    private static final String s_className = FunctionInfo.class.getName();
    private Map m_info = new TreeMap(new Comparator(){

        public int compare(Object object2, Object object3) {
            if (object2 instanceof Class) {
                Class clazz = (Class)object2;
                if (object3 instanceof Class) {
                    Class clazz2 = (Class)object3;
                    return clazz.getName().compareTo(clazz2.getName());
                }
            }
            return 0;
        }
    });
    private int m_bindings = 0;

    @Override
    public void optimizeFunction(Function function2) {
        this.m_info.clear();
        this.m_bindings = 0;
        super.optimizeFunction(function2);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "optimizeFunction", "FUNCTION: " + function2.getName() + "\nbindings=" + this.m_bindings);
            for (Class clazz : this.m_info.keySet()) {
                s_logger.logp(Level.FINEST, s_className, "optimizeFunction", " " + this.m_info.get(clazz) + " " + clazz.getName().substring(clazz.getName().lastIndexOf(46)));
            }
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction2) {
        Object object2;
        if (instruction2 instanceof ISpecialForm) {
            object2 = (ISpecialForm)((Object)instruction2);
            for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
                IBinding[] iBindingArray = object2.getChildInstructionBindings(i);
                if (iBindingArray == null) continue;
                this.m_bindings += iBindingArray.length;
            }
        }
        object2 = (object2 = (Integer)this.m_info.get(instruction2.getClass())) != null ? new Integer((Integer)object2 + 1) : new Integer(1);
        this.m_info.put(instruction2.getClass(), object2);
        return instruction2;
    }
}

